/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.InputConnector;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.simulator.Assignable;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.simulator.WakeupEvent;
import hades.symbols.ColoredCircle;
import hades.symbols.Symbol;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;

public class Ipin
extends GenericGate
implements InputConnector,
Assignable,
Wakeable {
    protected int state = 0;
    protected PortStdLogic1164 port_Y = new PortStdLogic1164(this, "Y", 1, null);
    protected PortStdLogic1164 port_toplevel = new PortStdLogic1164(this, this.name, 6, null);
    protected StdLogic1164 output_1;
    protected StdLogic1164 output_0;
    protected StdLogic1164 output_Z;
    protected StdLogic1164 output_X;
    protected StdLogic1164 output_U;
    protected StdLogic1164 startValue;
    protected double delay = 0.0;
    protected ColoredCircle showOnOff;
    protected String bindkey = null;

    public Ipin() {
        this.ports = new Port[2];
        this.ports[0] = this.port_Y;
        this.ports[1] = this.port_toplevel;
        this.startValue = new StdLogic1164();
        this.output_U = Const1164.__U;
        this.output_X = Const1164.__X;
        this.output_0 = Const1164.__0;
        this.output_1 = Const1164.__1;
        this.output_Z = Const1164.__Z;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = Double.valueOf(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal delay value '" + s + "', using 0.0 sec...");
            this.delay = 0.0;
        }
    }

    public String getStartValue() {
        return "" + this.startValue.getChar();
    }

    public void setStartValue(String s) {
        if (s != null && s.length() > 0) {
            this.startValue = new StdLogic1164(s.charAt(0));
        }
    }

    public boolean initialize(String s) {
        block6: {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            try {
                if (n_tokens == 0) {
                    this.versionId = 1001L;
                    break block6;
                }
                if (n_tokens == 1) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.startValue = this.output_U;
                    break block6;
                }
                if (n_tokens == 2) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    char c = st.nextToken().charAt(0);
                    this.startValue = new StdLogic1164(c);
                    this.setStartState();
                    break block6;
                }
                if (n_tokens == 3) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.setBindkey(st.nextToken());
                    char c = st.nextToken().charAt(0);
                    this.startValue = new StdLogic1164(c);
                    this.setStartState();
                    break block6;
                }
                throw new Exception("invalid number of arguments");
            }
            catch (Exception e) {
                this.message("-E- Ipin.initialize(): " + e + " " + s);
                e.printStackTrace();
            }
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.getBindkey() + " " + this.startValue.getChar());
    }

    public String getBindkey() {
        return this.bindkey;
    }

    public void setBindkey(String s) {
        this.bindkey = NameMangler.getBindkey(this, s);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    public void setName(String name) {
        super.setName(name);
        this.ports[1].setName(name);
    }

    protected void initDisplay() {
        try {
            FigObject tmp = null;
            if (this.symbol == null) {
                return;
            }
            Enumeration e = this.symbol.elements();
            while (e.hasMoreElements()) {
                tmp = (FigObject)e.nextElement();
                if (!(tmp instanceof ColoredCircle)) continue;
                this.showOnOff = (ColoredCircle)tmp;
            }
            this.setStartState();
            this.showState();
        }
        catch (Exception e) {
            this.message("-E- Ipin.initDisplay(): " + e);
            e.printStackTrace();
        }
    }

    public void setStartState() {
        this.state = this.startValue.intValue();
    }

    public void showState() {
        if (!this.visible) {
            return;
        }
        FigAttribs attr = this.showOnOff.getAttributes();
        attr.fillStyle = 2;
        if (this.state == 2) {
            attr.fillColor = this.output_0.getColor();
            attr.fig_fill_color = 0;
            attr.fig_area_fill = 5;
        } else if (this.state == 3) {
            attr.fillColor = this.output_1.getColor();
            attr.fig_fill_color = 4;
            attr.fig_area_fill = 20;
        } else if (this.state == 4) {
            attr.fillColor = this.output_Z.getColor();
            attr.fig_fill_color = 6;
            attr.fig_area_fill = 20;
        } else if (this.state == 1) {
            attr.fillColor = this.output_X.getColor();
            attr.fig_fill_color = 3;
            attr.fig_area_fill = 20;
        } else if (this.state == 0) {
            attr.fillColor = this.output_U.getColor();
            attr.fig_fill_color = 3;
            attr.fig_area_fill = 20;
        } else {
            this.message("-E- Ipin.showState(): unsupported state=" + this.state + " " + this.getFullName());
            attr.fillColor = this.output_U.getColor();
        }
        this.showOnOff.setAttributes(attr);
        if (this.showOnOff.painter != null) {
            this.showOnOff.painter.paint(this.showOnOff);
        }
    }

    public void mousePressed(MouseEvent me) {
        this.mouseOrKeyEvent(me.isShiftDown());
    }

    public void mouseOrKeyEvent(boolean shiftDown) {
        this.state = shiftDown ? (this.state == 2 ? 3 : (this.state == 3 ? 4 : (this.state == 4 ? 0 : 2))) : (this.state == 2 ? 3 : 2);
        this.showState();
        this.schedule(this.state, 5.0E-9, true);
    }

    public void keyPressed(KeyEvent evt) {
        String tmp;
        if (SimObject.debug) {
            System.out.println("-#- Ipin.keyPressed: " + evt);
        }
        if ((tmp = "" + evt.getKeyChar()).toLowerCase().equals(this.bindkey)) {
            this.mouseOrKeyEvent(evt.isShiftDown());
        } else {
            System.out.println("-#- Ipin.keyPressed: mismatch: " + tmp + " vs. " + this.getBindkey());
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.setStartState();
        this.schedule(this.state, 0.0, false);
        this.showState();
    }

    protected void schedule(int state, double delay, boolean interactive) {
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        StdLogic1164 output = state == 2 ? this.output_0 : (state == 3 ? this.output_1 : (state == 4 ? this.output_Z : this.output_U));
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime() + delay;
        SimEvent1164 se = SimEvent1164.createNewSimEvent((Simulatable)signal_Y, time, output, (Object)this.port_Y);
        if (interactive) {
            this.simulator.scheduleInteractiveEvent(se);
        } else {
            this.simulator.scheduleEvent(se);
        }
    }

    public void setValueAtTime(StdLogic1164 value, double time) {
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        if (this.simulator == null) {
            return;
        }
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Y, time, value, (Object)this.port_Y));
    }

    public void assign(String value, double time) {
        try {
            StdLogic1164 tmp = new StdLogic1164(value.charAt(0));
            this.scheduleOutputValue(this.port_Y, tmp, time);
            if (this.visible) {
                this.simulator.scheduleWakeup(this, time, tmp);
            }
        }
        catch (Exception e) {
            System.err.println("-E- internal in Ipin.assign: " + e);
        }
    }

    public void evaluate(Object arg) {
        StdLogic1164 value_Y = this.port_toplevel.getValueOrU();
        this.scheduleOutputValueAfter(this.port_Y, value_Y, this.delay);
    }

    public void wakeup(Object arg) {
        try {
            WakeupEvent we = (WakeupEvent)arg;
            StdLogic1164 sl = (StdLogic1164)we.getArg();
            this.state = sl.intValue();
            this.showState();
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".wakeup: " + e);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "start value  [U,0,1,Z]:", "startValue", "output delay [sec]:", "delay", "bindkey [a-z0-9]:", "bindkey"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, start value, and delay:");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        String s = this.getBindkey();
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "delay= " + this.delay + " [sec]\n" + "bindkey= " + (s == null ? "None" : s);
    }
}

