/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Assignable;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.simulator.WakeupEvent;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import hades.utils.NameMangler;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigAttribs;

public class HexSwitch
extends SimObject
implements Wakeable,
Assignable {
    protected int index;
    protected int startIndex = 0;
    protected StdLogic1164 value_0;
    protected StdLogic1164 value_1;
    protected StdLogic1164 value_U;
    protected Rectangle rect;
    protected String bindkey;
    public static final int FIELD_SIZE = 600;
    public static final Point offset = new Point(300, 300);

    public HexSwitch() {
        this.name = "HexSwitch";
        this.ports = new Port[4];
        this.ports[0] = new Port(this, "Y0", 1, null);
        this.ports[1] = new Port(this, "Y1", 1, null);
        this.ports[2] = new Port(this, "Y2", 1, null);
        this.ports[3] = new Port(this, "Y3", 1, null);
        this.value_U = Const1164.__U;
        this.value_0 = Const1164.__0;
        this.value_1 = Const1164.__1;
        this.index = 0;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.getName());
        this.initGraphics();
    }

    public void initGraphics() {
        this.rect = new Rectangle();
        this.rect.initialize("40 40 560 560");
        this.rect.move(HexSwitch.offset.x, HexSwitch.offset.y);
        FigAttribs attribs = this.rect.getAttributes();
        attribs.currentLayer = 350;
        attribs.fillStyle = 2;
        attribs.lineColor = attribs.fillColor = new Color(200, 200, 200);
        attribs.fig_line_color = 7;
        attribs.fig_fill_color = 0;
        attribs.fig_area_fill = 5;
        this.rect.setAttributes(attribs);
        this.getSymbol().fastAddMember(this.rect);
        this.getSymbol().update_bbox();
        this.getSymbol().build_sc_bbox();
    }

    public void mousePressed(MouseEvent evt) {
        Symbol symbol;
        if (SimObject.debug) {
            System.err.println("HexSwitch.mousePressed(): " + evt);
        }
        if ((symbol = this.getSymbol()) == null) {
            this.message("-E- HADES internal error in HexSwitch: got a MouseEvent without having a Symbol...");
            return;
        }
        if (!(evt instanceof FigCanvasEvent)) {
            this.message("-E- HADES internal error in HexSwitch: got a MouseEvent that is not a FigCanvasEvent...");
            return;
        }
        Point pos = symbol.getPos();
        Point mousepos = ((FigCanvasEvent)evt).getWorldCoordinatePoint();
        int index_x = (mousepos.x - pos.x - HexSwitch.offset.x) / 600;
        int index_y = (mousepos.y - pos.y - HexSwitch.offset.y) / 600;
        if (index_x < 0) {
            index_x = 0;
        }
        if (index_x > 3) {
            index_x = 3;
        }
        if (index_y < 0) {
            index_y = 0;
        }
        if (index_y > 4) {
            index_y = 3;
        } else if (index_y == 4) {
            if (index_x < 2) {
                --this.index;
                this.index &= 0xF;
                index_x = this.index & 3;
                index_y = (this.index & 0xC) >> 2;
            } else {
                ++this.index;
                this.index &= 0xF;
                index_x = this.index & 3;
                index_y = (this.index & 0xC) >> 2;
            }
        }
        this.setIndex((index_y << 2) + index_x);
        this.scheduleOutputs(this.index, this.simulator.getSimTime());
        this.updateDisplay();
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.isShiftDown()) {
            this.setIndex(--this.index & 0xF);
        } else {
            this.setIndex(++this.index & 0xF);
        }
        this.scheduleOutputs(this.index, this.simulator.getSimTime());
        this.updateDisplay();
    }

    public void updateDisplay() {
        if (this.symbol == null) {
            return;
        }
        int old_x = this.rect.getBbox().getXl();
        int old_y = this.rect.getBbox().getYt();
        int new_x = this.symbol.getBbox().getXl() + HexSwitch.offset.x + (this.index & 3) * 600;
        int new_y = this.symbol.getBbox().getYt() + HexSwitch.offset.y + (this.index >>> 2) * 600;
        this.rect.move(new_x - old_x, new_y - old_y);
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "start index [0..15]:", "startIndex", "bindkey [a-z0-9]:", "bindkey"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, start value, and delay:");
        this.propertySheet.setVisible(true);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index < 0 ? 0 : (index > 15 ? 15 : index);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int i) {
        this.startIndex = 0xF & i;
    }

    public void setStartIndex(String s) {
        try {
            this.setStartIndex(Integer.parseInt(s));
        }
        catch (Exception e) {
            this.startIndex = 0;
        }
    }

    public String getBindkey() {
        return this.bindkey;
    }

    public void setBindkey(String s) {
        this.bindkey = NameMangler.getBindkey(this, s);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.setIndex(this.startIndex);
        this.updateDisplay();
        this.scheduleOutputs(this.startIndex, 0.0);
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime();
        this.scheduleOutputs(this.index, time);
    }

    public void scheduleOutputs(int index, double time) {
        int i = 0;
        while (i < 4) {
            StdLogic1164 next_Y = (index & 1 << i) > 0 ? this.value_1 : this.value_0;
            Signal signal = this.ports[i].getSignal();
            if (signal != null) {
                this.simulator.scheduleInteractiveEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, next_Y, (Object)this.ports[i]));
            }
            ++i;
        }
    }

    public void wakeup(Object arg) {
        try {
            WakeupEvent evt = (WakeupEvent)arg;
            Integer tmp = (Integer)evt.getArg();
            this.setIndex(tmp);
            this.updateDisplay();
        }
        catch (Exception e) {}
    }

    public void assign(String hex, double simTime) {
        try {
            this.index = Integer.parseInt(hex.trim(), 16);
            this.scheduleOutputs(this.index, simTime);
            if (this.visible) {
                this.simulator.scheduleWakeup(this, simTime, new Integer(this.index));
            }
        }
        catch (Exception e) {
            System.err.println("-#- " + this.toString() + ".assign: " + hex);
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.startIndex + " " + this.getBindkey());
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            if (st.hasMoreTokens()) {
                this.versionId = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.startIndex = 0xF & Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.setBindkey(st.nextToken());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public String getToolTip(Point position, long millis) {
        String s = this.getBindkey();
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "bindkey= " + (s == null ? "None" : s);
    }

    public String toString() {
        return "HexSwitch: " + this.getFullName() + " [value=" + this.index + "]";
    }
}

