/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.simulator.Port;
import hades.simulator.Simulatable;
import hades.symbols.ColoredPolyline;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class GalFuse
extends GenericGate
implements Simulatable {
    protected static final int PASSIVE = 0;
    protected static final int ACTIVE = 1;
    protected int state = 0;
    protected ColoredPolyline fuse = null;
    protected PortStdLogic1164 port_A = new PortStdLogic1164(this, "A", 0, null);
    protected PortStdLogic1164 port_Y = new PortStdLogic1164(this, "Y", 1, null);
    protected StdLogic1164 next_Y;
    static final int[] _active = new int[]{1, 1, 2, 4, 4, 4, 2, 4, 1};

    public GalFuse() {
        this.ports = new Port[2];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_Y;
        this.next_Y = new StdLogic1164();
        this.t_delay = 5.0E-9;
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        this.showState();
    }

    public void evaluate(Object arg) {
        if (this.port_Y.getSignal() == null) {
            return;
        }
        int tmp = this.port_A.getValueOrU().intValue();
        if (this.state == 1) {
            this.next_Y.setIntValue(_active[tmp]);
        } else {
            this.next_Y.setIntValue(7);
        }
        this.scheduleOutputValueAfter(this.port_Y, this.next_Y, this.t_delay);
    }

    public void mousePressed(MouseEvent evt) {
        this.state = this.state == 1 ? 0 : 1;
        this.showState();
        this.evaluate(null);
    }

    public void write(PrintWriter pw) {
        pw.print(" " + this.versionId + " " + this.t_delay + " " + this.state);
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
            this.t_delay = Double.valueOf(st.nextToken());
            this.state = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- GalFuse.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void showState() {
        if (this.symbol == null) {
            return;
        }
        if (this.fuse == null) {
            Enumeration e = this.symbol.elements();
            while (e.hasMoreElements()) {
                Object tmp = e.nextElement();
                if (!(tmp instanceof ColoredPolyline)) continue;
                this.fuse = (ColoredPolyline)tmp;
            }
        }
        if (this.fuse == null) {
            return;
        }
        if (this.state == 1) {
            this.fuse.setLineColor(Color.blue);
            this.fuse.setLineWidth(10);
        } else {
            this.fuse.setLineColor(Color.white);
            this.fuse.setLineWidth(0);
        }
        this.fuse.rebuild();
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol);
        }
    }
}

