/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.symbols.Circle;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.Serializable;
import jfig.objects.FigAttribs;

public class ClockGenWithAutoStop
extends GenericGate
implements Simulatable,
Wakeable,
Serializable {
    private PortStdLogic1164 port_Y = new PortStdLogic1164(this, "clk", 1, null);
    private StdLogic1164 output_U;
    private StdLogic1164 output_0;
    private StdLogic1164 output_1;
    private double period = 1.0;
    private double dutycycle = 0.5;
    private double offset = 0.0;
    private int n_cycles = 0;
    private int autoStopCycles = 1000;
    private boolean running = true;
    private Circle circleOnOff;
    private boolean debug = false;

    public ClockGenWithAutoStop() {
        this.ports = new Port[1];
        this.ports[0] = this.port_Y;
        this.output_U = Const1164.__U;
        this.output_0 = Const1164.__0;
        this.output_1 = Const1164.__1;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    public double getPeriod() {
        return this.period;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getDutycycle() {
        return this.dutycycle;
    }

    public int getAutoStopCycles() {
        return this.autoStopCycles;
    }

    public void setPeriod(double d) {
        this.period = d;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public void setDutycycle(double d) {
        this.dutycycle = d;
        if (this.dutycycle < 0.0 || this.dutycycle > 1.0) {
            this.message("-W- ClockGenWithAutoStop: illegal value for 'dutycycle': " + this.dutycycle);
            this.message("-W- must be between 0.0 (0%) and 1.0 (100%), using 0.5!");
            this.dutycycle = 0.5;
        }
    }

    public void setAutoStopCycles(int n) {
        this.autoStopCycles = n;
    }

    public void setPeriod(String s) {
        this.period = this.parse(s);
    }

    public void setOffset(String s) {
        this.offset = this.parse(s);
    }

    public void setDutycycle(String s) {
        this.setDutycycle(this.parse(s));
    }

    public void setAutoStopCycles(String s) {
        try {
            this.setAutoStopCycles(Integer.parseInt(s.trim()));
        }
        catch (Exception e) {
            this.message("-E- ClockGenWithAutoStop: illegal number format." + s);
            this.message("-W- setting default (1000 cycles) instead.");
            this.setAutoStopCycles(1000);
        }
    }

    public double parse(String s) {
        double d = 0.0;
        try {
            d = Double.valueOf(s);
        }
        catch (Exception e) {
            d = 0.0;
        }
        return d;
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.period = Double.valueOf(st.nextToken());
            this.dutycycle = Double.valueOf(st.nextToken());
            this.offset = Double.valueOf(st.nextToken());
            this.autoStopCycles = Integer.parseInt(st.nextToken());
            if (this.debug) {
                this.message("ClockGenWithAutoStop.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            this.message("-E- ClockGenWithAutoStop.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.period + " " + this.dutycycle + " " + this.offset + " " + this.autoStopCycles);
    }

    public void configure() {
        String[] fields = new String[]{"instance name:", "name", "period [sec]:", "period", "duty cycle [e.g. 0.5]:", "dutycycle", "offset [sec]:", "offset", "autostop after cycles:", "autoStopCycles"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("ClockGenWithAutoStoperator timing parameters:\n_________-----_____-----_____-- ...\n^        ^    ^    ^    ^     ^         \n|offset  | period  | period  | period ... \n         | d.c|    | d.c.|   | d.c.| ... \nall times are given in seconds ");
        this.propertySheet.setVisible(true);
    }

    public void mousePressed(MouseEvent me) {
        if (this.debug) {
            this.message(this.toString() + ".mousePressed()");
        }
        SimKernel simulator = this.parent.getSimulator();
        if (this.running) {
            if (this.debug) {
                this.message("...stopping " + this.toString());
            }
            this.running = false;
            if (simulator != null) {
                simulator.deleteAllEventsFromSource(this);
            }
        } else {
            if (this.debug) {
                this.message("...restarting " + this.toString());
            }
            this.running = true;
            this.elaborate(null);
        }
        this.showState();
    }

    private void initDisplay() {
        this.circleOnOff = new Circle();
        this.circleOnOff.initialize("600 1200 300 300");
        this.getSymbol().addMember(this.circleOnOff);
        this.showState();
    }

    private void showState() {
        if (this.getSymbol() == null) {
            return;
        }
        FigAttribs attr = this.circleOnOff.getAttributes();
        attr.fillStyle = 2;
        attr.fillColor = this.running ? this.output_1.getColor() : this.output_0.getColor();
        this.circleOnOff.setAttributes(attr);
        if (this.circleOnOff.painter != null) {
            this.circleOnOff.painter.paint(this.circleOnOff);
        }
    }

    public void elaborate(Object arg) {
        if (this.debug) {
            this.message(this.toString() + ".elaborate()" + arg);
        }
        this.n_cycles = 0;
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            if (this.debug) {
                this.message(this.toString() + "elaborate(): SIMULATOR IS NULL!");
            }
        } else {
            double time = this.simulator.getSimTime();
            this.simulator.scheduleWakeup(this, time + this.offset, this);
            if (this.offset > 0.0) {
                this.schedule(this.output_U, time);
            }
            this.schedule(this.output_0, time + this.offset);
            this.schedule(this.output_1, time + this.offset + this.dutycycle * this.period);
        }
    }

    public void evaluate(Object arg) {
        this.message("-E- " + this.toString() + ".evaluate()");
        this.message("-E- Don't call evaluate() on a ClockGenWithAutoStop");
    }

    public void wakeup(Object arg) {
        if (this.debug) {
            System.err.println(this.toString() + ".wakeup()");
        }
        if (this.running) {
            ++this.n_cycles;
            if (this.n_cycles <= this.autoStopCycles) {
                double time = this.simulator.getSimTime();
                this.schedule(this.output_0, time + this.period);
                this.schedule(this.output_1, time + this.dutycycle * this.period);
                this.simulator.scheduleWakeup(this, time + this.period, this);
            }
        }
    }

    private void schedule(StdLogic1164 value, double time) {
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            if (this.debug) {
                this.message("ClockGenWithAutoStop.evaluate: signal is null...");
            }
            return;
        }
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Y, time, value, (Object)this.port_Y));
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "period= " + this.period + " [sec] " + "dutycycle= " + 100.0 * this.dutycycle + " [%]\n" + "offset= " + this.offset + " [sec] " + "n_cycles= " + this.n_cycles + "/" + this.autoStopCycles;
    }

    public String toString() {
        return "ClockGenWithAutoStop: " + this.getFullName() + "[timing: " + this.period + "," + this.dutycycle + "," + this.offset + "]" + "[" + this.n_cycles + "/" + this.autoStopCycles + "cycles]";
    }
}

