/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ThresholdFilter
extends ParametrizedFilter {
    public Image filter(Image image) {
        if (image == null) {
            return null;
        }
        long t1 = System.currentTimeMillis();
        BufferedImage BI = this.getBufferedImage(image);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        int r_threshold = (this.getP0() & 0xFF) << 16;
        int g_threshold = (this.getP1() & 0xFF) << 8;
        int b_threshold = this.getP2() & 0xFF;
        BufferedImage BO = new BufferedImage(w, h, 1);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                int tmp = BI.getRGB(i, j);
                boolean b = (tmp & 0xFF0000) >= r_threshold && (tmp & 0xFF00) >= g_threshold && (tmp & 0xFF) >= b_threshold;
                BO.setRGB(i, j, b ? -1 : -16777216);
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- ThresholdFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "r limit:", "p0", "g limit:", "p1", "b limit:", "p2"};
    }
}

