/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class SaturationFilter
extends ParametrizedFilter {
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;
    private double g;
    private double h;
    private double i;

    public SaturationFilter() {
        this.setD0(1.0);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        BufferedImage BI = this.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        BufferedImage BO = new BufferedImage(w, h, 2);
        this._prepare_parameters();
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int rgb = BI.getRGB(x, y);
                int red = (rgb & 0xFF0000) >>> 16;
                int green = (rgb & 0xFF00) >>> 8;
                int blue = rgb & 0xFF;
                int result = this._saturated_pixel(red, green, blue);
                BO.setRGB(x, y, result);
                ++x;
            }
            ++y;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- SaturationFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    private final void _prepare_parameters() {
        double s = Math.min(2.0, Math.max(0.0, this.getD0()));
        double RW = 0.3086;
        double RG = 0.6084;
        double RB = 0.082;
        this.a = (1.0 - s) * RW + s;
        this.b = (1.0 - s) * RW;
        this.c = (1.0 - s) * RW;
        this.d = (1.0 - s) * RG;
        this.e = (1.0 - s) * RG + s;
        this.f = (1.0 - s) * RG;
        this.g = (1.0 - s) * RB;
        this.h = (1.0 - s) * RB;
        this.i = (1.0 - s) * RB + s;
    }

    private final int _saturated_pixel(int red, int green, int blue) {
        double rr = this.a * (double)red + this.d * (double)green + this.g * (double)blue;
        double gg = this.b * (double)red + this.e * (double)green + this.h * (double)blue;
        double bb = this.c * (double)red + this.f * (double)green + this.i * (double)blue;
        int ir = this._clip(0, 255, (int)rr);
        int ig = this._clip(0, 255, (int)gg);
        int ib = this._clip(0, 255, (int)bb);
        return 0xFF000000 | ir << 16 | ig << 8 | ib;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "saturation s:", "d0"};
    }
}

