/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class ResizeFilter
extends ParametrizedFilter {
    public ResizeFilter() {
        this.setP0(100);
        this.setP1(100);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        BufferedImage BI = this.getBufferedImage(inputImage);
        int w = BI.getWidth(null);
        int h = BI.getHeight(null);
        double scale_x = 1.0 * (double)this.getP0() / (double)w;
        double scale_y = 1.0 * (double)this.getP1() / (double)h;
        AffineTransform trafo = AffineTransform.getScaleInstance(scale_x, scale_y);
        AffineTransformOp atop = new AffineTransformOp(trafo, 2);
        BufferedImage BO = atop.filter(BI, null);
        long t2 = System.currentTimeMillis();
        this.msg("-#- ResizeFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "width:", "p0", "height:", "p1"};
    }
}

