/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ImageFileFilter;
import hades.models.imaging.ImageSignal;
import hades.models.imaging.SimpleFilter;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.HexFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class ImageViewer
extends SimObject
implements Simulatable,
Serializable,
ActionListener {
    protected Port port_A = new Port(this, "A", 0, null, class$hades$models$imaging$ImageSignal == null ? (class$hades$models$imaging$ImageSignal = ImageViewer.class$("hades.models.imaging.ImageSignal")) : class$hades$models$imaging$ImageSignal);
    protected Image image;
    protected JFrame frame;
    protected JComponent canvas;
    protected JLabel statusLabel;
    protected JScrollPane scroller;
    protected JFileChooser fileChooser;
    private static final String S_OPEN = "Open...";
    private static final String S_SAVE_AS = "Save image as...";
    private static final String S_CLOSE = "Close...";
    private static final String S_PRINT = "Print...";
    private static final String S_ZOOM_11 = "Zoom 100%";
    private static final String S_ZOOM_21 = "Zoom 200%";
    private static final String S_ZOOM_41 = "Zoom 400%";
    private static final String S_ZOOM_IN = "Zoom In";
    private static final String S_ZOOM_OUT = "Zoom Out";
    private static final String S_ZOOM_FIT = "Zoom Fit";
    private static final String S_RESIZE_200 = "Resize 200x200";
    private static final String S_RESIZE_FIT = "Resize to fit image";
    private static final String S_NAME = "Instance name...";
    private static final String S_ABOUT = "About...";
    private static final String S_USAGE = "Usage...";
    private static final String S_SEPARATOR = "---";
    static /* synthetic */ Class class$hades$models$imaging$ImageSignal;

    public ImageViewer() {
        this.ports = new Port[1];
        this.ports[0] = this.port_A;
        this.image = null;
    }

    public void evaluate(Object arg) {
        Signal signal;
        if (SimObject.debug) {
            this.message("-I- ImageViewer.evaluate: " + arg);
        }
        if ((signal = this.port_A.getSignal()) == null) {
            return;
        }
        if (signal instanceof ImageSignal) {
            this.updateImage((Image)signal.getValue());
        }
    }

    public void updateImage(Image tmp) {
        try {
            if (tmp == null) {
                return;
            }
            this.image = tmp;
            if (this.frame != null && this.frame.isVisible()) {
                this.canvas.setPreferredSize(this.canvas.getPreferredSize());
                this.frame.repaint();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void showImage() {
        if (this.frame == null) {
            this.createFrame();
        }
        this.frame.setVisible(true);
    }

    private JMenuItem cmi(JMenu parent, String text, String shortcut) {
        if (S_SEPARATOR.equals(text)) {
            parent.addSeparator();
            return null;
        }
        JMenuItem mi = new JMenuItem(text);
        mi.addActionListener(this);
        try {
            mi.setAccelerator(KeyStroke.getKeyStroke(shortcut));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        parent.add(mi);
        return mi;
    }

    public void resizeToPreferredSize() {
        int w = 200;
        int h = 200;
        if (this.image != null) {
            w = this.image.getWidth(this.canvas);
            h = this.image.getHeight(this.canvas);
        }
        if (w < 0) {
            w = 10;
        }
        if (h < 0) {
            h = 10;
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int margin = 50;
        if (w > dim.width) {
            w = dim.width - margin;
        }
        if (h > dim.height) {
            h = dim.height - margin;
        }
        int ww = this.scroller.getVerticalScrollBar().getPreferredSize().width;
        int hh = this.scroller.getHorizontalScrollBar().getPreferredSize().height;
        int delta = 4;
        this.scroller.setPreferredSize(new Dimension(w + ww + delta, h + hh + delta));
        this.frame.pack();
        this.frame.validate();
        this.frame.repaint();
    }

    public void resizeToSize200x200() {
        this.frame.setSize(new Dimension(200, 200));
        this.frame.validate();
        this.frame.repaint();
    }

    public void createFrame() {
        this.frame = new JFrame(this.getName());
        this.frame.setDefaultCloseOperation(1);
        JMenu fileMenu = new JMenu("File");
        this.cmi(fileMenu, S_OPEN, "control O").setEnabled(false);
        this.cmi(fileMenu, S_SAVE_AS, "control S");
        this.cmi(fileMenu, S_SEPARATOR, null);
        this.cmi(fileMenu, S_PRINT, "control P").setEnabled(false);
        this.cmi(fileMenu, S_SEPARATOR, null);
        this.cmi(fileMenu, S_CLOSE, "control W");
        JMenu viewMenu = new JMenu("View");
        this.cmi(viewMenu, S_ZOOM_11, "control 1").setEnabled(false);
        this.cmi(viewMenu, S_ZOOM_21, "control 2").setEnabled(false);
        this.cmi(viewMenu, S_ZOOM_IN, "shift Z").setEnabled(false);
        this.cmi(viewMenu, S_ZOOM_OUT, "Z").setEnabled(false);
        this.cmi(viewMenu, S_ZOOM_FIT, "F").setEnabled(false);
        this.cmi(viewMenu, S_SEPARATOR, "");
        this.cmi(viewMenu, S_RESIZE_200, "shift R").setEnabled(false);
        this.cmi(viewMenu, S_RESIZE_FIT, "control R").setEnabled(false);
        JMenu optionsMenu = new JMenu("Options");
        this.cmi(optionsMenu, S_NAME, "");
        JMenu helpMenu = new JMenu("Help");
        this.cmi(helpMenu, S_ABOUT, null);
        this.cmi(helpMenu, S_USAGE, null);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(viewMenu);
        menubar.add(optionsMenu);
        menubar.add(helpMenu);
        this.frame.setJMenuBar(menubar);
        this.statusLabel = new JLabel("(0,0) RGB=[00 00 00 00]");
        this.canvas = new JImageCanvas();
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.isShiftDown()) {
                    ImageViewer.this.frame.setVisible(false);
                } else if (evt.isAltDown()) {
                    ImageViewer.this.resizeToPreferredSize();
                }
                evt.consume();
            }
        });
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                int x = evt.getX();
                int y = evt.getY();
                String pos = "(" + x + "," + y + ") ";
                String hex = "";
                String rgb = "";
                try {
                    BufferedImage tmp = (BufferedImage)ImageViewer.this.image;
                    long pixel = (long)tmp.getRGB(x, y) & 0xFFFFFFFFL;
                    long alpha = (pixel & 0xFFFFFFFFFF000000L) >>> 24;
                    long red = (pixel & 0xFF0000L) >>> 16;
                    long green = (pixel & 0xFF00L) >>> 8;
                    long blue = pixel & 0xFFL;
                    hex = "RGB=[" + HexFormat.getHexString(alpha, 2) + " " + HexFormat.getHexString(red, 2) + " " + HexFormat.getHexString(green, 2) + " " + HexFormat.getHexString(blue, 2) + "]";
                    rgb = "RGB=(" + alpha + " " + red + " " + green + " " + blue + ")";
                }
                catch (Exception e) {
                    // empty catch block
                }
                ImageViewer.this.statusLabel.setText(pos + "  " + hex + "  " + rgb);
            }
        });
        this.scroller = new JScrollPane(this.canvas);
        this.scroller.setHorizontalScrollBarPolicy(32);
        this.scroller.setVerticalScrollBarPolicy(22);
        this.frame.getContentPane().add("Center", this.scroller);
        this.frame.getContentPane().add("South", this.statusLabel);
        this.frame.pack();
    }

    private void checkCreateFileChooser() {
        try {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setFileFilter(new ImageFileFilter());
            }
            this.fileChooser.setDialogTitle("Select new image directory:");
            this.fileChooser.setFileSelectionMode(1);
        }
        catch (Throwable t) {
            System.err.println("-E- Could not create the FileChooser dialog.!");
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (S_OPEN.equals(cmd)) {
            this.doOpenImage();
        } else if (S_SAVE_AS.equals(cmd)) {
            this.doSaveAs();
        } else if (S_PRINT.equals(cmd)) {
            this.doPrint();
        } else if (S_CLOSE.equals(cmd)) {
            this.doClose();
        } else if (S_ZOOM_11.equals(cmd)) {
            this.doZoom11();
        } else if (S_ZOOM_21.equals(cmd)) {
            this.doZoom21();
        } else if (S_ZOOM_41.equals(cmd)) {
            this.doZoom41();
        } else if (S_NAME.equals(cmd)) {
            this.doChangeName();
        } else if (S_ABOUT.equals(cmd)) {
            this.doShowAbout();
        } else if (S_USAGE.equals(cmd)) {
            this.doShowUsage();
        } else {
            System.err.println("-E- ImageViewer.actionPerformed: unknown " + evt);
        }
    }

    public void doOpenImage() {
        this.NOTYET();
    }

    public void doPrint() {
        this.NOTYET();
    }

    public void doClose() {
        this.frame.setVisible(false);
    }

    public void doZoom11() {
        this.NOTYET();
    }

    public void doZoom21() {
        this.NOTYET();
    }

    public void doZoom41() {
        this.NOTYET();
    }

    public void NOTYET() {
        Thread.dumpStack();
        JOptionPane.showMessageDialog(this.frame, "Sorry, this function is not yet implemented.", "Warning", 2);
    }

    public void doChangeName() {
        String val = JOptionPane.showInputDialog(null, "Select instance name", this.getName());
        if (val == null) {
            return;
        }
        this.setName(val);
    }

    public void doSaveAs() {
        System.out.println("-#- ImageViewer.doSaveAs...");
        try {
            this.checkCreateFileChooser();
            if (this.fileChooser == null) {
                throw new Exception("Could not create the file-chooser dialog.");
            }
            this.fileChooser.setDialogTitle(S_SAVE_AS);
            this.fileChooser.setFileSelectionMode(2);
            int returnVal = this.fileChooser.showSaveDialog(this.frame);
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                String format = "PNG";
                if (file.getName().toLowerCase().endsWith(".jpg")) {
                    format = "JPG";
                }
                if (file.getName().toLowerCase().endsWith(".jpeg")) {
                    format = "JPG";
                }
                System.out.println("-#- ImageViewer.doSaveAs: '" + file + " " + format);
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
                BufferedImage bimage = SimpleFilter.getBufferedImage(this.image);
                ImageIO.write((RenderedImage)bimage, format, fos);
                ((OutputStream)fos).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "Got an exception: " + e, "Error", 0);
        }
    }

    public void doShowAbout() {
        JOptionPane.showMessageDialog(this.frame, "hades.models.imaging.ImageViewer\n(C) 1997-2005 N.Hendrich\n\nUniversity of Hamburg, Computer Science\nVogt-Koelln-Str. 30, D-22527 Hamburg.\n", "Information", 1);
    }

    public void doShowUsage() {
        JOptionPane.showMessageDialog(this.frame, "ImageViewer displays an RGB/ARGB image.\n\nSee the status panel for pixel coordinates and the\ncorresponding ARGB values in both hex and decimal format.\n\nSelect view->zoom to change the zoom factor.\nSelect file->save as to save the image to a file.\n\nNote that a transparent image (alpha=00) will only show\nthe background color. Printing is not yet implemented.\n", "Information", 1);
    }

    public void mousePressed(MouseEvent me) {
        this.showImage();
    }

    public void configure() {
        if (this.frame == null) {
            this.createFrame();
        }
        this.frame.setVisible(true);
    }

    public Component getPropertySheet() {
        return this.frame;
    }

    public boolean initialize(String s) {
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId);
    }

    public String toString() {
        return "ImageViewer: " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class JImageCanvas
    extends JComponent {
        public void paintComponent(Graphics g) {
            if (ImageViewer.this.image != null) {
                g.drawImage(ImageViewer.this.image, 0, 0, null);
            } else {
                Dimension dim = this.getSize();
                g.setColor(Color.lightGray);
                g.fillRect(0, 0, dim.width, dim.height);
                g.setColor(Color.black);
                g.drawString("null image", 10, 20);
            }
        }

        public Dimension getPreferredSize() {
            try {
                int w = Math.max(1, ImageViewer.this.image.getWidth(null));
                int h = Math.max(1, ImageViewer.this.image.getHeight(null));
                return new Dimension(w, h);
            }
            catch (Exception e) {
                return new Dimension(100, 100);
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

