/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.gui.PropertySheet;
import hades.manager.DesignManager;
import hades.models.imaging.SimpleFilter;
import hades.signals.Signal;
import hades.simulator.Assignable;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.swing.JOptionPane;
import jfig.gui.ImageHelper;

public class ImageSource
extends SimObject
implements Simulatable,
Assignable,
Serializable {
    private static boolean appletRestrictionWarningFlag = false;
    protected Port port_Y;
    protected Image image;
    protected String imageResourceName;
    protected double t_delay = 1.0E-9;
    static /* synthetic */ Class class$hades$models$imaging$ImageSignal;

    public ImageSource() {
        this.ports = new Port[1];
        this.ports[0] = new Port(this, "Y", 1, null, class$hades$models$imaging$ImageSignal == null ? (class$hades$models$imaging$ImageSignal = ImageSource.class$("hades.models.imaging.ImageSignal")) : class$hades$models$imaging$ImageSignal);
        this.port_Y = this.ports[0];
        try {
            this.image = ImageHelper.loadResourceImage("/jfig/images/icon.gif");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Image getImage() {
        return this.image;
    }

    public String getImageResourceName() {
        return this.imageResourceName;
    }

    public void setImageResourceName(String s) {
        this.imageResourceName = s;
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.imageResourceName};
        return externals;
    }

    public void elaborate(Object arg) {
        this.simulator = this.parent.getSimulator();
        if (arg instanceof Image) {
            this.image = (Image)arg;
        }
        if (this.image != null) {
            this.scheduleImage();
        } else {
            System.out.println("-#- ImageSource.elaborate: image is null!");
        }
    }

    public void evaluate(Object arg) {
        this.message("-I- ImageSource.evaluate: " + arg);
        Thread.dumpStack();
    }

    public void selectFile() {
        String name = null;
        try {
            DesignManager DM = DesignManager.getDesignManager();
            name = DM.selectFileOrURLName("Select the image file:", this.imageResourceName, new String[]{".gif", ".jpg", ".png"}, 0);
        }
        catch (SecurityException se) {
            if (!appletRestrictionWarningFlag) {
                this.showAppletRestrictionWarning();
            }
            this.selectDemoImage();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (name == null) {
            return;
        }
        this.imageResourceName = name;
        this.image = this.loadImage(name);
        this.scheduleImage();
    }

    private void selectDemoImage() {
        Object[] demoImages = new Object[]{"lena", "mandrill", "peppers", "f16"};
        Object selectedValue = JOptionPane.showInputDialog(null, "Choose demo image", "Input", 1, null, demoImages, demoImages[0]);
        if (selectedValue == null) {
            return;
        }
        this.imageResourceName = "/hades/models/imaging/256_" + selectedValue + ".jpg";
        System.out.println("-#- imageResourceName: '" + this.imageResourceName + "'");
        this.image = ImageHelper.loadResourceImage(this.imageResourceName);
        this.image = SimpleFilter.getBufferedImage(this.image);
        System.out.println("-F- " + this.image);
        this.scheduleImage();
    }

    private void showAppletRestrictionWarning() {
        appletRestrictionWarningFlag = true;
        JOptionPane.showMessageDialog(null, "Sorry! Could not open a file selection dialog due\nto security restrictions. Please read the Usage and FAQ\ndocs for details about how to edit your .java.policy\nfile and add the required PropertyPermission and\nFilePermissions settings.\n", "Warning", 2);
    }

    public void assign(String name, double simTime) {
        Thread.dumpStack();
        this.imageResourceName = name;
        this.image = this.loadImage(name);
        this.scheduleImage(simTime);
    }

    public void scheduleImage() {
        this.scheduleImage(this.simulator.getSimTime() + this.t_delay);
    }

    public void scheduleImage(double time) {
        if (this.simulator == null) {
            return;
        }
        if (this.image == null) {
            return;
        }
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        this.simulator.scheduleEvent(new SimEvent(signal_Y, time, this.image, this.port_Y));
    }

    public void mousePressed(MouseEvent me) {
        this.selectFile();
    }

    public void configure() {
        String[] fields = this.getPropertySheetFieldNames();
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify image filename:");
        this.propertySheet.setVisible(true);
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "image file/URL:", "imageResourceName"};
    }

    public void applyValuesHook() {
        System.out.println("-#- ImageSource.applyValuesHook: re-loading image.");
        this.loadImage(this.imageResourceName);
        this.scheduleImage();
    }

    public boolean initialize(String s) {
        try {
            this.imageResourceName = "/hades/gui/images/iconEditor.gif";
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            if (n_tokens == 1) {
                this.versionId = Integer.parseInt(st.nextToken());
            } else if (n_tokens == 2) {
                this.versionId = Integer.parseInt(st.nextToken());
                this.imageResourceName = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else {
                throw new Exception("Unknown number of init parameters...");
            }
            this.image = this.loadImage(this.imageResourceName);
            System.out.println("-#- ImageSource.initialize: '" + this.imageResourceName + "' " + this.image);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.message("-E- " + e);
            this.message("-E- ImageSource: failed to initalize: " + s);
        }
        return true;
    }

    public Image loadImage(String name) {
        Image tmp = null;
        try {
            tmp = DesignManager.getDesignManager().getImage(this, name);
            if (tmp != null) {
                tmp = SimpleFilter.getBufferedImage(tmp);
            }
        }
        catch (Throwable t) {
            System.err.println("-E- ImageSource.loadImage: " + t);
            t.printStackTrace();
        }
        if (tmp != null) {
            this.image = tmp;
        }
        return tmp;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.imageResourceName));
    }

    public String toString() {
        return "ImageSource: " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

