/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import java.awt.Image;
import java.awt.Point;
import jfig.utils.ExceptionTracer;

public class ImageSignal
extends Signal {
    public ImageSignal() {
        this("n0");
    }

    public ImageSignal(String name) {
        this.value = null;
    }

    public ImageSignal(String name, Port[] senders, Port[] receivers) {
        this(name);
        this.senders = senders;
        this.receivers = receivers;
        this.driverValues = new Object[senders.length];
    }

    public static Signal getDefaultValue() {
        return new ImageSignal();
    }

    public void evaluate(Object arg) {
        if (Signal.debug) {
            System.err.println("ImageSignal<" + this.getName() + ">.evaluate()");
            System.err.println("    argument: " + arg);
        }
        if (arg == null) {
            return;
        }
        SimEvent event = null;
        try {
            event = (SimEvent)arg;
            if (this.senders.length == 1) {
                this.lastValue = this.value;
                this.value = (Image)event.getArg();
            } else {
                this.message("-E- Multiple drivers on this ImageSignal, ignored.");
            }
            this.lastChangeTime = event.getTime();
            int i = 0;
            while (i < this.receivers.length) {
                this.receivers[i].getHandler().evaluate(event);
                ++i;
            }
            if (this.hasProbe()) {
                this.probe.addValue(this.value, this.lastChangeTime);
            }
        }
        catch (Exception e) {
            ExceptionTracer.message("ImageSignal.evaluate: Exception " + e);
            ExceptionTracer.trace(e);
            return;
        }
    }

    public void handleGlowMode() {
    }

    public String getToolTip(Point position, long millis) {
        String s = this.getName() + "\n" + this.getClass().getName();
        Image tmp = (Image)this.getValue();
        s = tmp == null ? s + "\nvalue= null" : s + "\nvalue= " + tmp.getClass().getName() + "\n" + tmp.getWidth(null) + "x" + tmp.getHeight(null);
        return s;
    }
}

