/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ParametrizedFilter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class GridFilter
extends ParametrizedFilter {
    public GridFilter() {
        this.setP0(50);
        this.setP1(255);
        this.setP2(255);
        this.setP3(255);
        this.setP4(170);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        BufferedImage BO = this.getClone(inputImage);
        int w = BO.getWidth(null);
        int h = BO.getHeight(null);
        int dx = Math.abs(this.getP0());
        int r = this._clip(0, 255, this.getP1());
        int g = this._clip(0, 255, this.getP2());
        int b = this._clip(0, 255, this.getP3());
        int a = this._clip(0, 255, this.getP4());
        Graphics gr = BO.getGraphics();
        gr.setColor(new Color(r, g, b, a));
        int i = 0;
        while (i < w) {
            gr.drawLine(i, 0, i, h);
            i += dx;
        }
        int i2 = 0;
        while (i2 < h) {
            gr.drawLine(0, i2, w, i2);
            i2 += dx;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- GridFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "grid spacing [10..50]:", "p0", "grid red    [0..255]:", "p1", "grid green  [0..255]:", "p2", "grid blue   [0..255]:", "p3", "grid alpha  [0..255]:", "p4"};
    }
}

