/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ImageSignal;
import hades.models.imaging.ParametrizedFilter;
import hades.signals.Signal;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class GradientColorFilter
extends ParametrizedFilter {
    public GradientColorFilter() {
        this.setP0(200);
        this.setP1(200);
        this.setD0(255.0);
        this.setD1(0.0);
        this.setD2(0.0);
        this.setD3(0.0);
        this.setD4(255.0);
        this.setD5(0.0);
        this.setD6(0.0);
        this.setD7(0.0);
        this.setD8(255.0);
        this.setP2(255);
        this.setP3(255);
        this.setP4(255);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        int w = this.getP0();
        int h = this.getP1();
        if (inputImage != null) {
            BufferedImage BI = this.getBufferedImage(inputImage);
            w = BI.getWidth(null);
            h = BI.getHeight(null);
        }
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage BO = new BufferedImage(w, h, 2);
        double r_tl = this._dclip(0.0, 255.0, this.getD0());
        double g_tl = this._dclip(0.0, 255.0, this.getD1());
        double b_tl = this._dclip(0.0, 255.0, this.getD2());
        double r_tr = this._dclip(0.0, 255.0, this.getD3());
        double g_tr = this._dclip(0.0, 255.0, this.getD4());
        double b_tr = this._dclip(0.0, 255.0, this.getD5());
        double r_bl = this._dclip(0.0, 255.0, this.getD6());
        double g_bl = this._dclip(0.0, 255.0, this.getD7());
        double b_bl = this._dclip(0.0, 255.0, this.getD8());
        double r_br = this._dclip(0.0, 255.0, this.getP2());
        double g_br = this._dclip(0.0, 255.0, this.getP3());
        double b_br = this._dclip(0.0, 255.0, this.getP4());
        int r = 0;
        int g = 0;
        int b = 0;
        int rgb = 0;
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < w) {
            x = w == 1 ? 1.0 : 1.0 * (double)i / (double)(w - 1);
            int j = 0;
            while (j < h) {
                y = h == 1 ? 1.0 : 1.0 * (double)j / (double)(h - 1);
                r = (int)this._2D(r_tl, r_tr, r_bl, r_br, x, y);
                g = (int)this._2D(g_tl, g_tr, g_bl, g_br, x, y);
                b = (int)this._2D(b_tl, b_tr, b_bl, b_br, x, y);
                rgb = 0xFF000000 | r << 16 | g << 8 | b;
                BO.setRGB(i, j, rgb);
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- GradientColorFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public double _2D(double tl, double tr, double bl, double br, double x, double y) {
        double v1 = tl + x * (tr - tl);
        double v2 = bl + x * (br - bl);
        return (1.0 - y) * v1 + y * v2;
    }

    public void evaluate(Object arg) {
        SimKernel simulator;
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate: " + arg);
        }
        if ((simulator = this.parent.getSimulator()) == null) {
            return;
        }
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        Signal signal_A = this.port_A.getSignal();
        if (signal_A != null && signal_A instanceof ImageSignal) {
            this.inputImage = (Image)signal_A.getValue();
        }
        try {
            this.outputImage = this.filter(this.inputImage);
            simulator.scheduleEvent(new SimEvent(signal_Y, simulator.getSimTime() + this.t_delay, this.outputImage, this.port_Y));
        }
        catch (Throwable t) {
            System.out.println("-E- evaluate: " + this.toString());
            t.printStackTrace();
        }
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        if (this.port_A.getSignal() == null) {
            if (SimObject.debug) {
                this.msg("-#- GradientColorFilter.elaborate: no input, scheduling myself.");
            }
            this.evaluate(null);
        }
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "width: ", "p0", "height: ", "p1", "R top-left [0..255]: ", "d0", "G top-left [0..255]: ", "d1", "B top-left [0..255]: ", "d2", "R top-right [0..255]: ", "d3", "G top-right [0..255]: ", "d4", "B top-right [0..255]: ", "d5", "R bottom-left [0..255]: ", "d6", "G bottom-left [0..255]: ", "d7", "B bottom-left [0..255]: ", "d8", "R bottom-right [0..255]: ", "p2", "G bottom-right [0..255]: ", "p3", "B bottom-right [0..255]: ", "p4"};
    }
}

