/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.TwoInputFilter;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class EqualsFilter
extends TwoInputFilter {
    public Image filter(Image image_A, Image image_B) {
        long t1 = System.currentTimeMillis();
        BufferedImage A = this.getBufferedImage(image_A);
        BufferedImage B = this.getBufferedImage(image_B);
        if (A == null || B == null) {
            return null;
        }
        int w = Math.min(A.getWidth(null), B.getWidth(null));
        int h = Math.min(A.getHeight(null), B.getHeight(null));
        BufferedImage R = new BufferedImage(w, h, 1);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                int pixb;
                int pixa = A.getRGB(i, j);
                if (pixa == (pixb = B.getRGB(i, j))) {
                    R.setRGB(i, j, -1);
                } else {
                    R.setRGB(i, j, -16777216);
                }
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- EqualsFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return R;
    }
}

