/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.gui.PropertySheet;
import hades.models.imaging.ImageSignal;
import hades.models.imaging.SimpleFilter;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jfig.gui.ImageHelper;

public class DifferenceFilter
extends SimpleFilter {
    Port port_A;
    Port port_B;
    Port port_Y;
    Image image_A;
    Image image_B;
    int w_A;
    int h_A;
    int w_B;
    int h_B;
    int w_Y;
    int h_Y;
    int[] pixels_Y;
    int[] pixels_A;
    int[] pixels_B;
    static /* synthetic */ Class class$hades$models$imaging$ImageSignal;

    public DifferenceFilter() {
        this.ports = new Port[3];
        this.ports[0] = new Port(this, "A", 0, null, class$hades$models$imaging$ImageSignal == null ? (class$hades$models$imaging$ImageSignal = DifferenceFilter.class$("hades.models.imaging.ImageSignal")) : class$hades$models$imaging$ImageSignal);
        this.ports[1] = new Port(this, "B", 0, null, class$hades$models$imaging$ImageSignal == null ? (class$hades$models$imaging$ImageSignal = DifferenceFilter.class$("hades.models.imaging.ImageSignal")) : class$hades$models$imaging$ImageSignal);
        this.ports[2] = new Port(this, "Y", 1, null, class$hades$models$imaging$ImageSignal == null ? (class$hades$models$imaging$ImageSignal = DifferenceFilter.class$("hades.models.imaging.ImageSignal")) : class$hades$models$imaging$ImageSignal);
        this.port_A = this.ports[0];
        this.port_B = this.ports[1];
        this.port_Y = this.ports[2];
    }

    public Image filter(Image image_A, Image image_B) {
        this.pixels_A = this.getPixels(image_A);
        this.w_A = image_A.getWidth(null);
        this.h_A = image_A.getHeight(null);
        if (this.w_A < 0 || this.h_A < 0) {
            return null;
        }
        this.pixels_B = this.getPixels(image_B);
        this.w_B = image_B.getWidth(null);
        this.h_B = image_B.getHeight(null);
        if (this.w_B < 0 || this.h_B < 0) {
            return null;
        }
        this.pixels_Y = this.calculateDifference(this.pixels_A, this.w_A, this.h_A, this.pixels_B, this.w_B, this.h_B);
        return this.createImageFromPixels(this.pixels_Y, this.w_Y, this.h_Y);
    }

    public int[] getPixels(Image image) {
        this.dbg("-#- getPixels...");
        int x = 0;
        int y = 0;
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(image, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        this.dbg("-#- getPixels ok.");
        return pixels;
    }

    public int[] calculateDifference(int[] pixels_A, int w_A, int h_A, int[] pixels_B, int w_B, int h_B) {
        this.dbg("-#- calculateDiff...");
        this.w_Y = Math.max(w_A, w_B);
        this.h_Y = Math.max(h_A, h_B);
        int[] pixels_Y = new int[this.w_Y * this.h_Y];
        int npixels = this.w_Y * this.h_Y;
        int i = 0;
        while (i < npixels) {
            int red_A = pixels_A[i] >> 16 & 0xFF;
            int red_B = pixels_B[i] >> 16 & 0xFF;
            int green_A = pixels_A[i] >> 8 & 0xFF;
            int green_B = pixels_B[i] >> 8 & 0xFF;
            int blue_A = pixels_A[i] & 0xFF;
            int blue_B = pixels_B[i] & 0xFF;
            int red = Math.abs(red_A - red_B);
            int green = Math.abs(green_A - green_B);
            int blue = Math.abs(blue_A - blue_B);
            pixels_Y[i] = 0xFF000000 | red << 16 | green << 8 | blue;
            ++i;
        }
        return pixels_Y;
    }

    public Image createImageFromPixels(int[] pixels_Y, int w, int h) {
        this.dbg("-#- createImageFromPixels1...");
        Image img = ImageHelper.createImage(new MemoryImageSource(w, h, pixels_Y, 0, w));
        this.dbg("-#- createImageFromPixels2...");
        return img;
    }

    public void evaluate(Object arg) {
        SimKernel simulator;
        if (SimObject.debug) {
            this.message("-I- DifferenceFilter.evaluate: " + arg);
        }
        if ((simulator = this.parent.getSimulator()) == null) {
            return;
        }
        Signal signal_A = this.port_A.getSignal();
        Signal signal_B = this.port_B.getSignal();
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        if (signal_A instanceof ImageSignal) {
            this.image_A = (Image)signal_A.getValue();
            if (this.image_A == null) {
                return;
            }
        }
        if (signal_B instanceof ImageSignal) {
            this.image_B = (Image)signal_B.getValue();
            if (this.image_B == null) {
                return;
            }
        }
        this.outputImage = this.filter(this.image_A, this.image_B);
        simulator.scheduleEvent(new SimEvent(signal_Y, simulator.getSimTime() + this.t_delay, this.outputImage, this.port_Y));
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify filter name and radius:");
        this.propertySheet.setVisible(true);
    }

    public void dbg(String msg) {
        this.message(msg);
    }

    public String toString() {
        return "DifferenceFilter: " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

