/*
 * Decompiled with CFR 0.152.
 */
package hades.models.imaging;

import hades.models.imaging.ImageSignal;
import hades.models.imaging.ParametrizedFilter;
import hades.signals.Signal;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ConstantColorFilter
extends ParametrizedFilter {
    public ConstantColorFilter() {
        this.setP0(200);
        this.setP1(200);
        this.setP2(200);
        this.setP3(0);
        this.setP4(0);
    }

    public Image filter(Image inputImage) {
        long t1 = System.currentTimeMillis();
        int w = this.getP3();
        int h = this.getP4();
        if (w <= 0 || h <= 0) {
            if (inputImage == null) {
                return null;
            }
            BufferedImage BI = this.getBufferedImage(inputImage);
            w = BI.getWidth(null);
            h = BI.getHeight(null);
        }
        BufferedImage BO = new BufferedImage(w, h, 2);
        int r = this.getP0() & 0xFF;
        int g = this.getP1() & 0xFF;
        int b = this.getP2() & 0xFF;
        int rgb = 0xFF000000 | r << 16 | g << 8 | b;
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                BO.setRGB(i, j, rgb);
                ++j;
            }
            ++i;
        }
        long t2 = System.currentTimeMillis();
        this.msg("-#- ConstantColorFilter: " + w + "x" + h + " (" + (t2 - t1) + " ms)");
        return BO;
    }

    public void evaluate(Object arg) {
        SimKernel simulator;
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate: " + arg);
        }
        if ((simulator = this.parent.getSimulator()) == null) {
            return;
        }
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        Signal signal_A = this.port_A.getSignal();
        if (signal_A != null && signal_A instanceof ImageSignal) {
            this.inputImage = (Image)signal_A.getValue();
        }
        try {
            this.outputImage = this.filter(this.inputImage);
            simulator.scheduleEvent(new SimEvent(signal_Y, simulator.getSimTime() + this.t_delay, this.outputImage, this.port_Y));
        }
        catch (Throwable t) {
            System.out.println("-E- evaluate: " + this.toString());
            t.printStackTrace();
        }
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        if (this.port_A.getSignal() == null) {
            if (SimObject.debug) {
                this.msg("-#- ConstantColorFilter.elaborate: no input, scheduling myself.");
            }
            this.evaluate(null);
        }
    }

    public String[] getPropertySheetFieldNames() {
        return new String[]{"instance name:", "name", "red   [0..255]: ", "p0", "green [0..255]: ", "p1", "blue  [0..255]: ", "p2", "width (or 0):", "p3", "height (or 0):", "p4"};
    }
}

