/*
 * Decompiled with CFR 0.152.
 */
package hades.models.i8048;

import java.util.Hashtable;

public class OpcodeTable {
    Hashtable mnemoTable;
    Hashtable descrTable;
    public static String[][] I8048_OPCODES = new String[][]{{"00", "NOP", "No Operation"}, {"02", "OUTL BUS,A", "Output Accumulator to BUS"}, {"03", "ADD A,#data", "Add Immediate Data to Accumulator"}, {"04", "JMP address", "Jump absolute address (within 2K block)"}, {"05", "EN I", "Enable External Interrupt"}, {"07", "DEC A", "Decrement Accumulator"}, {"08", "INS A,BUS", "Strobed Input of BUS Data to Accumulator"}, {"09", "IN A,P1", "Input Port1 Data to Accumulator"}, {"0A", "IN A,P2", "Input Port2 Data to Accumulator"}, {"0C", "MOVD A,P4", "Move Port 4 Data to Accumulator"}, {"0D", "MOVD A,P5", "Move Port 5 Data to Accumulator"}, {"0E", "MOVD A,P6", "Move Port 6 Data to Accumulator"}, {"0F", "MOVD A,P7", "Move Port 7 Data to Accumulator"}, {"10", "INC @R0", "Increment Memory(R0)"}, {"11", "INC @R1", "Increment Memory(R1)"}, {"12", "JB0", "Jump if Accumulator Bit 0 is Set"}, {"13", "ADDC A,#data", "Add Carry and Immediate Data to Accumulator"}, {"14", "CALL address", "Subroutine CALL"}, {"15", "DIS I", "Disable External Interrupt"}, {"16", "JTF address", "Jump if Timer Flag is Set"}, {"17", "INC A", "Increment Accumulator"}, {"18", "INC R0", "Increment Register 0"}, {"19", "INC R1", "Increment Register 1"}, {"1A", "INC R2", "Increment Register 2"}, {"1B", "INC R3", "Increment Register 3"}, {"1C", "INC R4", "Increment Register 4"}, {"1D", "INC R5", "Increment Register 5"}, {"1E", "INC R6", "Increment Register 6"}, {"1F", "INC R7", "Increment Register 7"}, {"20", "XCH A,@R0", "Exchange Accumulaotr and Data Memory (R0)"}, {"21", "XCH A,@R1", "Exchange Accumulaotr and Data Memory (R1)"}, {"23", "MOV A,#data", "Move Immediate Data to Accumulator"}, {"24", "JMP address", "Jump absolute address (within 2K block)"}, {"25", "EN TCNTI", "Enable Timer/Counter Interrupt"}, {"26", "JNT0 address", "Jump if Test 0 is Low"}, {"27", "CLR A", "Clear Accumulator"}, {"28", "XCH A,R0", "Exchange Accumulator with R0"}, {"29", "XCH A,R1", "Exchange Accumulator with R1"}, {"2A", "XCH A,R2", "Exchange Accumulator with R2"}, {"2B", "XCH A,R3", "Exchange Accumulator with R3"}, {"2C", "XCH A,R4", "Exchange Accumulator with R4"}, {"2D", "XCH A,R5", "Exchange Accumulator with R5"}, {"2E", "XCH A,R6", "Exchange Accumulator with R6"}, {"2F", "XCH A,R7", "Exchange Accumulator with R7"}, {"30", "XCHD A,@R0", "Exchange Accumulator and Memory (R0), Bit 0..3"}, {"31", "XCHD A,@R1", "Exchange Accumulator and Memory (R1), Bit 0..3"}, {"32", "JB1", "Jump if Accumulator Bit 1 is Set"}, {"34", "CALL address", "Subroutine CALL"}, {"35", "DIS TCNTI", "Disable Timer/CounterInterrupt"}, {"36", "JT0 address", "Jump if Test 0 is High"}, {"37", "CPL A", "Complement Accumulator"}, {"39", "OUTL P1,A", "Output Accumulator to Port 1"}, {"3A", "OUTL P2,A", "Output Accumulator to Port 2"}, {"3C", "MOVD P4,A", "Move Accumulator to Port 4"}, {"3D", "MOVD P5,A", "Move Accumulator to Port 5"}, {"3E", "MOVD P6,A", "Move Accumulator to Port 6"}, {"3F", "MOVD P7,A", "Move Accumulator to Port 7"}, {"40", "ORL A,@R0", "Logical OR Accu with Memory (R0)"}, {"41", "ORL A,@R1", "Logical OR Accu with Memory (R1)"}, {"42", "MOV A,T", "Move Timer/Counter Contents to Accumulator"}, {"43", "ORL A,#data", "Logical OR Accu with Immediate Data"}, {"44", "JMP address", "Jump absolute address (within 2K block)"}, {"45", "STRT CNT", "Start Event Counter"}, {"46", "JNT1 address", "Jump if Test 1 is Low"}, {"47", "SWAP A", "Swap Nibbles Within Accumulator"}, {"48", "ORL A,R0", "Logical OR Accu with Register Mask R0"}, {"49", "ORL A,R1", "Logical OR Accu with Register Mask R1"}, {"4A", "ORL A,R2", "Logical OR Accu with Register Mask R2"}, {"4B", "ORL A,R3", "Logical OR Accu with Register Mask R3"}, {"4C", "ORL A,R4", "Logical OR Accu with Register Mask R4"}, {"4D", "ORL A,R5", "Logical OR Accu with Register Mask R5"}, {"4E", "ORL A,R6", "Logical OR Accu with Register Mask R6"}, {"4F", "ORL A,R7", "Logical OR Accu with Register Mask R7"}, {"50", "ANL A,@R0", "Logical AND Accu with Memory (R0)"}, {"51", "ANL A,@R1", "Logical AND Accu with Memory (R1)"}, {"52", "JB2", "Jump if Accumulator Bit 2 is Set"}, {"53", "ANL A,#data", "Logical AND Accu with Immediate Mask"}, {"54", "CALL address", "Subroutine CALL"}, {"55", "STRT T", "Start Timer"}, {"56", "JT1 address", "Jump if Test 1 is High"}, {"57", "DA A", "Decimal Adjust Accumulator"}, {"58", "ANL A,R0", "Logical AND Accu with Register 0"}, {"59", "ANL A,R1", "Logical AND Accu with Register 1"}, {"5A", "ANL A,R2", "Logical AND Accu with Register 2"}, {"5B", "ANL A,R3", "Logical AND Accu with Register 3"}, {"5C", "ANL A,R4", "Logical AND Accu with Register 4"}, {"5D", "ANL A,R5", "Logical AND Accu with Register 5"}, {"5E", "ANL A,R6", "Logical AND Accu with Register 6"}, {"5F", "ANL A,R7", "Logical AND Accu with Register 7"}, {"60", "ADD A,@R0", "Add Data Memory (R0) to Accumulator"}, {"61", "ADD A,@R1", "Add Data Memory (R1) to Accumulator"}, {"62", "MOV T,A", "Move Accumulator to Timer/Counter"}, {"64", "JMP address", "Jump absolute address (within 2K block)"}, {"65", "STOP TCNT", "Stop Timer/Event Counter"}, {"67", "RRC A", "Rotate Right Through Carry"}, {"68", "ADD A,R0", "Add Register 0 Contents to Accumulator"}, {"69", "ADD A,R1", "Add Register 1 Contents to Accumulator"}, {"6A", "ADD A,R2", "Add Register 2 Contents to Accumulator"}, {"6B", "ADD A,R3", "Add Register 3 Contents to Accumulator"}, {"6C", "ADD A,R4", "Add Register 4 Contents to Accumulator"}, {"6D", "ADD A,R5", "Add Register 5 Contents to Accumulator"}, {"6E", "ADD A,R6", "Add Register 6 Contents to Accumulator"}, {"6F", "ADD A,R7", "Add Register 7 Contents to Accumulator"}, {"70", "ADDC A,@R0", "Add Carry and Data Memory (R0) Contents to Accu"}, {"71", "ADDC A,@R1", "Add Carry and Data Memory (R1) Contents to Accu"}, {"72", "JB3", "Jump if Accumulator Bit 3 is Set"}, {"74", "CALL address", "Subroutine CALL"}, {"75", "ENT0 CLK", "Enable Clock Output"}, {"76", "JF1 address", "Jump if Flag1 is Set"}, {"77", "RR A", "Rotate Right Without Carry"}, {"78", "ADDC A,R0", "Add Carry and Register 0 to Accumulator"}, {"79", "ADDC A,R1", "Add Carry and Register 1 to Accumulator"}, {"7A", "ADDC A,R2", "Add Carry and Register 2 to Accumulator"}, {"7B", "ADDC A,R3", "Add Carry and Register 3 to Accumulator"}, {"7C", "ADDC A,R4", "Add Carry and Register 4 to Accumulator"}, {"7D", "ADDC A,R5", "Add Carry and Register 5 to Accumulator"}, {"7E", "ADDC A,R6", "Add Carry and Register 6 to Accumulator"}, {"7F", "ADDC A,R7", "Add Carry and Register 7 to Accumulator"}, {"80", "MOVX A,@R0", "Move XMEM Contents (R0) to Accumulator"}, {"81", "MOVX A,@R1", "Move XMEM Contents (R1) to Accumulator"}, {"83", "RET", "Return Without PSW Restore"}, {"84", "JMP address", "Jump absolute address (within 2K block)"}, {"85", "CLR F0", "Clear Flag 0"}, {"86", "JNI address", "Jump if Interrupt Input is Low"}, {"88", "ORL Bus,#data", "Logical OR BUS with immediate Data"}, {"89", "ORL P1,#data", "Logical OR P1 with immediate Data"}, {"8A", "ORL P2,#data", "Logical OR P2 with immediate Data"}, {"8C", "ORLD P4,A", "Logical OR P4 with Accumulator Bits 0..3"}, {"8D", "ORLD P5,A", "Logical OR P5 with Accumulator Bits 0..3"}, {"8E", "ORLD P6,A", "Logical OR P6 with Accumulator Bits 0..3"}, {"8F", "ORLD P7,A", "Logical OR P7 with Accumulator Bits 0..3"}, {"90", "MOVX @R0,A", "Move Accumulator Contents to XMEM (R0)"}, {"91", "MOVX @R1,A", "Move Accumulator Contents to XMEM (R1)"}, {"92", "JB4", "Jump if Accumulator Bit 4 is Set"}, {"93", "RETR", "Return With PSW Restore"}, {"94", "CALL address", "Subroutine CALL"}, {"95", "CPL F0", "Complement Flag 0"}, {"96", "JNZ address", "Jump if Accumulator is Not Zero"}, {"97", "CLR C", "Clear Carry Bit"}, {"98", "ANL BUS,#data", "Logical AND Bus with Immediate Mask"}, {"99", "ANL P1,#data", "Logical AND Port1 with Immediate Mask"}, {"9A", "ANL P2,#data", "Logical AND Port2 with Immediate Mask"}, {"9C", "ANL P4,#data", "Logical AND Port4 with Immediate Mask"}, {"9D", "ANL P5,#data", "Logical AND Port5 with Immediate Mask"}, {"9E", "ANL P6,#data", "Logical AND Port6 with Immediate Mask"}, {"9F", "ANL P7,#data", "Logical AND Port7 with Immediate Mask"}, {"A0", "MOV @R0,A", "Move Accumulator Contents to Memory (R0)"}, {"A1", "MOV @R1,A", "Move Accumulator Contents to Memory (R1)"}, {"A3", "MOVP A,@A", "Move Current Page Data To Accumulator"}, {"A4", "JMP address", "Jump absolute address (within 2K block)"}, {"A5", "CLR F1", "Clear Flag 1"}, {"A7", "CPL C", "Complement Carry Bit"}, {"A8", "MOV R0,A", "Move Accumulator Contents to R0"}, {"A9", "MOV R1,A", "Move Accumulator Contents to R1"}, {"AA", "MOV R2,A", "Move Accumulator Contents to R2"}, {"AB", "MOV R3,A", "Move Accumulator Contents to R3"}, {"AC", "MOV R4,A", "Move Accumulator Contents to R4"}, {"AD", "MOV R5,A", "Move Accumulator Contents to R5"}, {"AE", "MOV R6,A", "Move Accumulator Contents to R6"}, {"AF", "MOV R7,A", "Move Accumulator Contents to R7"}, {"B0", "MOV @R0,#data", "Move Immediate Data to Memory (R0)"}, {"B1", "MOV @R1,#data", "Move Immediate Data to Memory (R1)"}, {"B2", "JB5", "Jump if Accumulator Bit 5 is Set"}, {"B3", "JMPP @A", "Jump Indirect within Page"}, {"B4", "CALL address", "Subroutine CALL"}, {"B5", "CPL F1", "Complement Flag 1"}, {"B6", "JF0 address", "Jump if Flag0 is Set"}, {"B8", "MOV R0,#data", "Move Immediate Data to R0"}, {"B9", "MOV R1,#data", "Move Immediate Data to R1"}, {"BA", "MOV R2,#data", "Move Immediate Data to R2"}, {"BB", "MOV R3,#data", "Move Immediate Data to R3"}, {"BC", "MOV R4,#data", "Move Immediate Data to R4"}, {"BD", "MOV R5,#data", "Move Immediate Data to R5"}, {"BE", "MOV R6,#data", "Move Immediate Data to R6"}, {"BF", "MOV R7,#data", "Move Immediate Data to R7"}, {"C4", "JMP address", "Jump absolute address (within 2K block)"}, {"C5", "SEL RB0", "Select Register Bank 0"}, {"C6", "JZ address", "Jump if Accumulator is Zero"}, {"C7", "MOV A,PSW", "Move PSW Contents to Accumulator"}, {"C8", "DEC R0", "Decrement Register R0"}, {"C9", "DEC R1", "Decrement Register R1"}, {"CA", "DEC R2", "Decrement Register R2"}, {"CB", "DEC R3", "Decrement Register R3"}, {"CC", "DEC R4", "Decrement Register R4"}, {"CD", "DEC R5", "Decrement Register R5"}, {"CE", "DEC R6", "Decrement Register R6"}, {"CF", "DEC R7", "Decrement Register R7"}, {"D0", "XRL A,@R0", "Logical XOR Accumulator with Memory (R0)"}, {"D1", "XRL A,@R1", "Logical XOR Accumulator with Memory (R1)"}, {"D2", "JB6", "Jump if Accumulator Bit 6 is Set"}, {"D3", "XRL A,#data", "Logical XOR Accumulator with Immediate Data"}, {"D4", "CALL address", "Subroutine CALL"}, {"D5", "SEL RB1", "Select Register Bank 1"}, {"D7", "MOV PSW,A", "Move Accumulator Contents to PSW"}, {"D8", "XRL A,R0", "Logical XOR Accumulator with R0"}, {"D9", "XRL A,R1", "Logical XOR Accumulator with R1"}, {"DA", "XRL A,R2", "Logical XOR Accumulator with R2"}, {"DB", "XRL A,R3", "Logical XOR Accumulator with R3"}, {"DC", "XRL A,R4", "Logical XOR Accumulator with R4"}, {"DD", "XRL A,R5", "Logical XOR Accumulator with R5"}, {"DE", "XRL A,R6", "Logical XOR Accumulator with R6"}, {"DF", "XRL A,R7", "Logical XOR Accumulator with R7"}, {"E3", "MOVP3 A,@A", "Move Page 3 Data To Accumulator"}, {"E4", "JMP address", "Jump absolute address (within 2K block)"}, {"E5", "SEL MB0", "Select Memory Bank 0"}, {"E6", "JNC address", "Jump if Carry is Not Set"}, {"E7", "RL A", "Rotate Left Without Carry"}, {"E8", "DJNZ R0,address", "Decrement R0 and Test"}, {"E9", "DJNZ R1,address", "Decrement R1 and Test"}, {"EA", "DJNZ R2,address", "Decrement R2 and Test"}, {"EB", "DJNZ R3,address", "Decrement R3 and Test"}, {"EC", "DJNZ R4,address", "Decrement R4 and Test"}, {"ED", "DJNZ R5,address", "Decrement R5 and Test"}, {"EE", "DJNZ R6,address", "Decrement R6 and Test"}, {"EF", "DJNZ R7,address", "Decrement R7 and Test"}, {"F0", "MOV A,@R0", "Move Memory (R0) to Accumulator"}, {"F1", "MOV A,@R1", "Move Memory (R1) to Accumulator"}, {"F2", "JB7", "Jump if Accumulator Bit 7 is Set"}, {"F4", "CALL address", "Subroutine CALL"}, {"F5", "SEL MB1", "Select Memory Bank 1"}, {"F6", "JC address", "Jump if Carry is Set"}, {"F7", "RLC A", "Rotate Left Through Carry"}, {"F8", "MOV A,R0", "Move R0 contents to Accumulator"}, {"F9", "MOV A,R1", "Move R1 contents to Accumulator"}, {"FA", "MOV A,R2", "Move R2 contents to Accumulator"}, {"FB", "MOV A,R3", "Move R3 contents to Accumulator"}, {"FC", "MOV A,R4", "Move R4 contents to Accumulator"}, {"FD", "MOV A,R5", "Move R5 contents to Accumulator"}, {"FE", "MOV A,R6", "Move R6 contents to Accumulator"}, {"FF", "MOV A,R7", "Move R7 contents to Accumulator"}};

    public OpcodeTable() {
        this.dbg("OpcodeTable: constructing...");
        this.mnemoTable = new Hashtable();
        this.descrTable = new Hashtable();
        int i = 0;
        while (i < I8048_OPCODES.length) {
            String opcode = I8048_OPCODES[i][0];
            String mnemo = I8048_OPCODES[i][1];
            String descr = I8048_OPCODES[i][2];
            Integer key = new Integer(Integer.parseInt(opcode, 16));
            this.mnemoTable.put(key, mnemo);
            this.descrTable.put(key, descr);
            this.dbg("using " + key + " " + mnemo + " " + descr);
            ++i;
        }
    }

    public String getMnemo(int opcode) {
        String mnemo = (String)this.mnemoTable.get(new Integer(opcode));
        if (mnemo == null) {
            mnemo = "###ILLEGAL###";
        }
        return mnemo;
    }

    public String getDescription(int opcode) {
        String description = (String)this.descrTable.get(new Integer(opcode));
        if (description == null) {
            description = "###Illegal Opcode###";
        }
        return description;
    }

    public void dbg(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] argv) {
        OpcodeTable OT = new OpcodeTable();
        int i = 0;
        while (i < 256) {
            System.out.println("I8048 opcode: " + i + " " + OT.getMnemo(i));
            ++i;
        }
    }
}

