/*
 * Decompiled with CFR 0.152.
 */
package hades.models.i8048;

import hades.gui.PropertySheet;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import java.io.Serializable;

public class I8048
extends SimObject
implements Simulatable,
Serializable {
    public int debugLevel = 1;
    public static final int UNDEFINED = -1;
    public static final int ALU_ADD = 100;
    public static final int ALU_ADD_CARRY = 101;
    public static final int ALU_AND = 102;
    public static final int ALU_OR = 103;
    public static final int ALU_XOR = 104;
    public static final int ALU_INCR = 105;
    public static final int ALU_DECR = 106;
    public static final int ALU_NOT = 107;
    public static final int ALU_ROTATE_LEFT = 108;
    public static final int ALU_ROTETE_RIGHT = 109;
    public static final int ALU_SWAP_NIBBLES = 110;
    public static final int ALU_BCD_ADJUST = 111;
    public static final int ADDR_RESET_VECTOR = 0;
    public static final int ADDR_IRQ_VECTOR = 3;
    public static final int ADDR_TIMER_VECTOR = 7;
    private int state;
    public static final int STATE_S1_C0 = 10;
    public static final int STATE_S1_C1 = 11;
    public static final int STATE_S1_C2 = 12;
    public static final int STATE_S2_C0 = 20;
    public static final int STATE_S2_C1 = 21;
    public static final int STATE_S2_C2 = 22;
    public static final int STATE_S3_C0 = 30;
    public static final int STATE_S3_C1 = 31;
    public static final int STATE_S3_C2 = 32;
    public static final int STATE_S4_C0 = 40;
    public static final int STATE_S4_C1 = 41;
    public static final int STATE_S4_C2 = 42;
    public static final int STATE_S5_C0 = 50;
    public static final int STATE_S5_C1 = 51;
    public static final int STATE_S5_C2 = 52;
    public static final int FETCH_CYCLE = 81;
    public static final int READ_CYCLE = 82;
    public static final int WRITE_CYCLE = 83;
    public static final int OPC_NOP = 0;
    public static final double t_ale = 1.5E-8;
    protected int accu;
    protected int psw;
    protected int pc;
    protected int ireg;
    protected int stackpointer;
    protected int port1;
    protected int port2;
    protected int tmp_alu1;
    protected int tmp_alu2;
    protected int tmp_mar;
    protected int tmp_dec;
    protected int addressReg = -1;
    protected int xmem_flag;
    protected int rb_select_flag;
    protected int mb_select_flag;
    protected int f0_flag;
    protected int f1_flag;
    protected int t0_is_output_flag;
    protected int enable_timer_flag;
    protected int enable_interrupt_flag;
    protected int interrupt_handler_flag;
    protected int timer;
    protected int prescaler;
    protected int current_cycle = 81;
    public static final int N_WORDS_RAM = 64;
    public static final int N_WORDS_ROM = 1024;
    protected int[] data_ram;
    protected int[] program_rom;
    public StdLogic1164 value_U;
    public StdLogic1164 value_X;
    public StdLogic1164 value_Z;
    public StdLogic1164 value_0;
    public StdLogic1164 value_1;
    public StdLogic1164 value_H;
    protected Port port_VCC;
    protected Port port_GND;
    protected Port port_ROM_PROG1;
    protected Port port_ROM_PROG2;
    protected Port port_XTAL1;
    protected Port port_XTAL2;
    protected Port port_nRESET;
    protected Port port_nSSTEP;
    protected Port port_XMEM;
    protected Port port_TEST0;
    protected Port port_TEST1;
    protected Port port_nIRQ;
    protected Port port_nRD;
    protected Port port_nWR;
    protected Port port_nPSEN;
    protected Port port_ALE;
    protected Port port_Bus_0;
    protected Port port_Bus_1;
    protected Port port_Bus_2;
    protected Port port_Bus_3;
    protected Port port_Bus_4;
    protected Port port_Bus_5;
    protected Port port_Bus_6;
    protected Port port_Bus_7;
    protected Port port_P1_0;
    protected Port port_P1_1;
    protected Port port_P1_2;
    protected Port port_P1_3;
    protected Port port_P1_4;
    protected Port port_P1_5;
    protected Port port_P1_6;
    protected Port port_P1_7;
    protected Port port_P2_0;
    protected Port port_P2_1;
    protected Port port_P2_2;
    protected Port port_P2_3;
    protected Port port_P2_4;
    protected Port port_P2_5;
    protected Port port_P2_6;
    protected Port port_P2_7;
    SignalStdLogic1164 signal_XTAL1;
    SignalStdLogic1164 signal_XTAL2;
    SignalStdLogic1164 signal_nRESET;
    SignalStdLogic1164 signal_nSSTEP;
    SignalStdLogic1164 signal_XMEM;
    SignalStdLogic1164 signal_TEST0;
    SignalStdLogic1164 signal_TEST1;
    SignalStdLogic1164 signal_nIRQ;
    SignalStdLogic1164 signal_nRD;
    SignalStdLogic1164 signal_nWR;
    SignalStdLogic1164 signal_nPSE;
    SignalStdLogic1164 signal_ALE;
    protected int index_Bus_0;
    protected int index_P1_0;
    protected int index_P2_0;
    protected String resourcename = "/hades/models/i048/I8048.rom";

    public I8048() {
        this.dbg("-#- I8048 constructor, building ports... ");
        this.ports = new Port[40];
        this.buildPorts();
        this.dbg("-#- buildPorts ok, memory...");
        this.data_ram = new int[64];
        this.program_rom = new int[1024];
        this.dbg("-#- memory ok, constants and utilities...");
        this.value_U = new StdLogic1164(0);
        this.value_X = new StdLogic1164(1);
        this.value_Z = new StdLogic1164(4);
        this.value_0 = new StdLogic1164(2);
        this.value_1 = new StdLogic1164(3);
        this.value_H = new StdLogic1164(7);
    }

    public String getResourceName() {
        return this.resourcename;
    }

    public void setResourcename(String s) {
        this.resourcename = s;
        this.initialize("" + this.versionId + " " + s);
    }

    private void buildPorts() {
        int n = 0;
        this.ports[n] = new Port(this, "VCC", 0, null);
        this.port_VCC = this.ports[n];
        this.ports[++n] = new Port(this, "GND", 0, null);
        this.port_GND = this.ports[n];
        this.ports[++n] = new Port(this, "PROG1", 3, null);
        this.port_ROM_PROG1 = this.ports[n];
        this.ports[++n] = new Port(this, "PROG2", 3, null);
        this.port_ROM_PROG2 = this.ports[n];
        this.ports[++n] = new Port(this, "XTAL1", 0, null);
        this.port_XTAL1 = this.ports[n];
        this.ports[++n] = new Port(this, "XTAL2", 3, null);
        this.port_XTAL2 = this.ports[n];
        this.ports[++n] = new Port(this, "nRESET", 0, null);
        this.port_nRESET = this.ports[n];
        this.ports[++n] = new Port(this, "nSSTEP", 3, null);
        this.port_nSSTEP = this.ports[n];
        this.ports[++n] = new Port(this, "XMEM", 3, null);
        this.port_XMEM = this.ports[n];
        this.ports[++n] = new Port(this, "TEST0", 3, null);
        this.port_TEST0 = this.ports[n];
        this.ports[++n] = new Port(this, "TEST1", 3, null);
        this.port_TEST1 = this.ports[n];
        this.ports[++n] = new Port(this, "nIRQ", 3, null);
        this.port_nIRQ = this.ports[n];
        this.ports[++n] = new Port(this, "nRD", 1, null);
        this.port_nRD = this.ports[n];
        this.ports[++n] = new Port(this, "nWR", 1, null);
        this.port_nWR = this.ports[n];
        this.ports[++n] = new Port(this, "nPSEN", 1, null);
        this.port_nPSEN = this.ports[n];
        this.ports[++n] = new Port(this, "ALE", 1, null);
        this.port_ALE = this.ports[n];
        this.ports[++n] = new Port(this, "BUS_0", 2, null);
        this.index_Bus_0 = n;
        this.port_Bus_0 = this.ports[n];
        this.ports[++n] = new Port(this, "BUS_1", 2, null);
        this.port_Bus_1 = this.ports[n];
        this.ports[++n] = new Port(this, "BUS_2", 2, null);
        this.port_Bus_2 = this.ports[n];
        this.ports[++n] = new Port(this, "BUS_3", 2, null);
        this.port_Bus_3 = this.ports[n];
        this.ports[++n] = new Port(this, "BUS_4", 2, null);
        this.port_Bus_4 = this.ports[n];
        this.ports[++n] = new Port(this, "BUS_5", 2, null);
        this.port_Bus_5 = this.ports[n];
        this.ports[++n] = new Port(this, "BUS_6", 2, null);
        this.port_Bus_6 = this.ports[n];
        this.ports[++n] = new Port(this, "BUS_7", 2, null);
        this.port_Bus_7 = this.ports[n];
        this.ports[++n] = new Port(this, "P1_0", 2, null);
        this.index_P1_0 = n;
        this.port_P1_0 = this.ports[n];
        this.ports[++n] = new Port(this, "P1_1", 2, null);
        this.port_P1_1 = this.ports[n];
        this.ports[++n] = new Port(this, "P1_2", 2, null);
        this.port_P1_2 = this.ports[n];
        this.ports[++n] = new Port(this, "P1_3", 2, null);
        this.port_P1_3 = this.ports[n];
        this.ports[++n] = new Port(this, "P1_4", 2, null);
        this.port_P1_4 = this.ports[n];
        this.ports[++n] = new Port(this, "P1_5", 2, null);
        this.port_P1_5 = this.ports[n];
        this.ports[++n] = new Port(this, "P1_6", 2, null);
        this.port_P1_6 = this.ports[n];
        this.ports[++n] = new Port(this, "P1_7", 2, null);
        this.port_P1_7 = this.ports[n];
        this.ports[++n] = new Port(this, "P2_0", 2, null);
        this.index_P2_0 = n;
        this.port_P2_0 = this.ports[n];
        this.ports[++n] = new Port(this, "P2_1", 2, null);
        this.port_P2_1 = this.ports[n];
        this.ports[++n] = new Port(this, "P2_2", 2, null);
        this.port_P2_2 = this.ports[n];
        this.ports[++n] = new Port(this, "P2_3", 2, null);
        this.port_P2_3 = this.ports[n];
        this.ports[++n] = new Port(this, "P2_4", 2, null);
        this.port_P2_4 = this.ports[n];
        this.ports[++n] = new Port(this, "P2_5", 2, null);
        this.port_P2_5 = this.ports[n];
        this.ports[++n] = new Port(this, "P2_6", 2, null);
        this.port_P2_6 = this.ports[n];
        this.ports[++n] = new Port(this, "P2_7", 2, null);
        this.port_P2_7 = this.ports[n];
        ++n;
    }

    private StdLogic1164 getValue(Signal signal, StdLogic1164 defaultValue) {
        StdLogic1164 value = null;
        if (signal == null) {
            value = defaultValue;
        } else {
            value = (StdLogic1164)signal.getValue();
            if (value == null) {
                value = defaultValue;
            }
        }
        return value;
    }

    public void elaborate(Object arg) {
        this.dbg("I8048.elaborate: " + arg);
        this.dbg("...initializing to default (all X) state...");
        this.simulator = this.parent.getSimulator();
        this.initializeProcessor();
        this.initializeRAM();
    }

    public void evaluate(Object arg) {
        SignalStdLogic1164 signal_XTAL1 = (SignalStdLogic1164)this.port_XTAL1.getSignal();
        if (signal_XTAL1 == null) {
            return;
        }
        if (signal_XTAL1.hasRisingEdge()) {
            this.clock();
        }
    }

    void clock() {
        this.checkReset();
        this.nextState();
    }

    void nextState() {
        int next;
        switch (this.state) {
            case 10: {
                next = 11;
                break;
            }
            case 11: {
                next = 12;
                break;
            }
            case 12: {
                next = 20;
                break;
            }
            case 20: {
                next = 21;
                if (this.xmem_flag == 1) {
                    this.set(this.port_nPSEN, this.value_1, 1.5E-8);
                    this.getInstructionFromBus();
                    break;
                }
                this.getInstructionFromProgramMemory();
                break;
            }
            case 21: {
                next = 22;
                break;
            }
            case 22: {
                next = 30;
                this.incrementPC();
                break;
            }
            case 30: {
                next = 31;
                break;
            }
            case 31: {
                next = 32;
                break;
            }
            case 32: {
                next = 40;
                this.set(this.port_ALE, this.value_1, 1.5E-8);
                break;
            }
            case 40: {
                next = 41;
                if (this.xmem_flag != 1) break;
                if (this.isFetchCycle()) {
                    this.setBus(this.pc, 1.5E-8);
                    break;
                }
                this.setBus(this.addressReg, 1.5E-8);
                break;
            }
            case 41: {
                next = 42;
                break;
            }
            case 42: {
                next = 50;
                this.set(this.port_ALE, this.value_0, 1.5E-8);
                break;
            }
            case 50: {
                next = 51;
                if (this.xmem_flag != 1) break;
                this.set(this.port_nPSEN, this.value_0, 1.5E-8);
                this.setBus(this.value_Z, 1.5E-8);
                if (this.isReadCycle()) {
                    this.set(this.port_nRD, this.value_0, 1.5E-8);
                    break;
                }
                if (!this.isWriteCycle()) break;
                this.set(this.port_nWR, this.value_0, 1.5E-8);
                break;
            }
            case 51: {
                next = 52;
                break;
            }
            case 52: {
                next = 10;
                this.checkXmemInput();
                break;
            }
            case -1: {
                next = -1;
                break;
            }
            default: {
                next = -1;
            }
        }
        this.dbg("machine states: current=" + this.state + " next=" + next);
        this.state = next;
    }

    void checkReset() {
        this.signal_nRESET = (SignalStdLogic1164)this.port_nRESET.getSignal();
        if (this.getValue(this.signal_nRESET, this.value_X).is_0()) {
            this.reset();
        }
    }

    void checkXmemInput() {
        this.signal_XMEM = (SignalStdLogic1164)this.port_XMEM.getSignal();
        this.xmem_flag = this.getValue(this.signal_XMEM, this.value_X).is_1() ? 1 : 0;
        this.dbg("checkXmemInput: XMEM is " + this.xmem_flag);
    }

    void getInstructionFromBus() {
        this.dbg("WARNING: getInstructionFromBus not implemented!");
        this.ireg = 0;
    }

    void getInstructionFromProgramMemory() {
        this.dbg("WARNING: getInstructionFromProgramMemory not implemented!");
        this.ireg = 0;
    }

    boolean isFetchCycle() {
        return this.current_cycle == 81;
    }

    boolean isReadCycle() {
        return this.current_cycle == 82;
    }

    boolean isWriteCycle() {
        return this.current_cycle == 83;
    }

    void reset() {
        this.dbg("reset: resetting the processor...");
        this.state = 10;
        this.pc = 0;
        this.stackpointer = 0;
        this.accu = 0;
        this.rb_select_flag = 0;
        this.mb_select_flag = 0;
        this.f0_flag = 0;
        this.f1_flag = 0;
        this.enable_timer_flag = 0;
        this.t0_is_output_flag = 0;
        this.enable_interrupt_flag = 0;
        this.interrupt_handler_flag = 0;
        this.setP1Input(1.5E-8);
        this.setP2Input(1.5E-8);
        this.setBus(this.value_Z, 1.5E-8);
        this.set(this.port_ALE, this.value_0, 1.5E-8);
    }

    void initializeProcessor() {
        this.state = -1;
        this.pc = -1;
        this.psw = -1;
        this.accu = -1;
        this.set(this.port_ALE, this.value_X, 1.5E-8);
    }

    void initializeRAM() {
        this.dbg2("initializeRAM started...");
        int i = 0;
        while (i < 64) {
            this.data_ram[i] = -1;
            ++i;
        }
    }

    void set(Port port, StdLogic1164 value, double delay) {
        this.dbg3("   set: port= " + port + " value= " + value + " delay= " + delay);
        Signal signal = port.getSignal();
        if (signal != null) {
            double time = this.simulator.getSimTime() + delay;
            this.simulator.scheduleEvent(new SimEvent(signal, time, value, signal));
        }
    }

    void setBus(StdLogic1164 value, double t_delay) {
        this.dbg3("setBus: value= " + value);
        int i = 0;
        while (i < 8) {
            Port port = this.ports[this.index_Bus_0 + i];
            this.set(port, value, t_delay);
            ++i;
        }
    }

    void setBus(int index, double t_delay) {
        this.dbg3("setBus: index= " + index);
        int mask = 1;
        int i = 0;
        while (i < 8) {
            Port port = this.ports[this.index_Bus_0 + i];
            if (index == -1) {
                this.set(port, this.value_X, t_delay);
            } else if ((index & mask) > 0) {
                this.set(port, this.value_1, t_delay);
            } else {
                this.set(port, this.value_0, t_delay);
            }
            mask += mask;
            ++i;
        }
    }

    void setP1Input(double t_delay) {
        this.dbg3("setP1Input...");
        this.port1 = 255;
        this.setPort(this.index_P1_0, this.port1, t_delay);
    }

    void setP2Input(double t_delay) {
        this.dbg3("setP2Input...");
        this.port2 = 255;
        this.setPort(this.index_P2_0, this.port2, t_delay);
    }

    void setPort(int port_index, int contents, double t_delay) {
        int mask = 1;
        int i = 0;
        while (i < 8) {
            Port port = this.ports[port_index + i];
            if (contents == -1) {
                this.set(port, this.value_X, t_delay);
            } else if ((contents & mask) > 0) {
                this.set(port, this.value_H, t_delay);
            } else {
                this.set(port, this.value_0, t_delay);
            }
            mask += mask;
            ++i;
        }
    }

    void incrementPC() {
        this.dbg3("incrementPC: current=" + this.pc);
        this.pc &= 0x7FF;
        this.pc = this.pc + 1 & 0x7FF;
        if (this.interrupt_handler_flag != 1 && this.mb_select_flag == 1) {
            this.pc |= 0x800;
        }
        this.dbg3("incremented: " + this.pc);
    }

    public void dbg(String msg) {
        if (this.debugLevel >= 1) {
            System.out.println(msg);
        }
    }

    public void dbg2(String msg) {
        if (this.debugLevel >= 2) {
            System.out.println(msg);
        }
    }

    public void dbg3(String msg) {
        if (this.debugLevel >= 3) {
            System.out.println(msg);
        }
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(String s) {
        this.setDebugLevel(Integer.parseInt(s));
    }

    public void setDebugLevel(int i) {
        this.debugLevel = i;
    }

    public void configure() {
        String[] fields = new String[]{"instance name:", "name", "message level: [0..3]", "debugLevel"};
        PropertySheet propertySheet = PropertySheet.getPropertySheet(this, fields);
        propertySheet.setVisible(true);
    }

    public String toString() {
        return "I8048 microcontroller'" + this.getFullName() + "' [pc=" + this.pc + ",psw=" + this.psw + ",accu=" + this.accu + "]";
    }
}

