/*
 * Decompiled with CFR 0.152.
 */
package hades.models.fsm;

import hades.models.fsm.BadExpressionException;
import hades.models.fsm.Signal;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Vector;

public class Parser {
    protected int curr_token;
    public static final int END = 0;
    public static final int NAME = 1;
    public static final int NUMBER = 2;
    public static final int AND = 3;
    public static final int OR = 4;
    public static final int NOT = 5;
    public static final int LP = 6;
    public static final int RP = 7;
    protected int number_value;
    protected String name_value;
    protected String expression;
    protected PushbackReader cin;
    protected Vector Inputs;

    public boolean parse(String arg, Vector in) throws BadExpressionException {
        if (arg != null & in != null) {
            this.Inputs = in;
            this.expression = arg.trim();
            this.cin = new PushbackReader(new StringReader(this.expression + '\n'));
            this.get_token();
            return this.expr();
        }
        throw new BadExpressionException("fehlerhafte Parameter");
    }

    private int get_token() throws BadExpressionException {
        try {
            char ch;
            do {
                if ((ch = (char)this.cin.read()) != '\n') continue;
                this.curr_token = 0;
                return 0;
            } while (ch == ' ');
            switch (ch) {
                case '|': {
                    this.curr_token = 4;
                    return 4;
                }
                case '&': {
                    this.curr_token = 3;
                    return 3;
                }
                case '!': {
                    this.curr_token = 5;
                    return 5;
                }
                case '(': {
                    this.curr_token = 6;
                    return 6;
                }
                case ')': {
                    this.curr_token = 7;
                    return 7;
                }
                case '0': {
                    this.number_value = 0;
                    this.curr_token = 2;
                    return 2;
                }
                case '1': {
                    this.number_value = 1;
                    this.curr_token = 2;
                    return 2;
                }
            }
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_' || ch == '_') {
                this.name_value = "" + ch;
                while ((ch = (char)this.cin.read()) != '\n' && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '_')) {
                    this.name_value = this.name_value + ch;
                }
                this.cin.unread(ch);
                this.curr_token = 1;
                return 1;
            }
            throw new BadExpressionException(this.expression);
        }
        catch (IOException e) {
            System.out.println("Programmfehler: Parser Exception");
            this.curr_token = 0;
            return 0;
        }
    }

    private boolean expr() throws BadExpressionException {
        boolean left = this.term();
        while (this.curr_token == 4) {
            this.get_token();
            left |= this.term();
        }
        return left;
    }

    private boolean term() throws BadExpressionException {
        boolean left = this.prim();
        while (this.curr_token == 3) {
            this.get_token();
            left &= this.prim();
        }
        return left;
    }

    private boolean prim() throws BadExpressionException {
        switch (this.curr_token) {
            case 2: {
                this.get_token();
                return this.number_value == 1;
            }
            case 1: {
                this.get_token();
                return this.look();
            }
            case 5: {
                this.get_token();
                return !this.prim();
            }
            case 6: {
                this.get_token();
                boolean e = this.expr();
                if (this.curr_token != 7) {
                    throw new BadExpressionException(this.expression);
                }
                this.get_token();
                return e;
            }
        }
        throw new BadExpressionException(this.expression);
    }

    private boolean look() throws BadExpressionException {
        int i = 0;
        while (i < this.Inputs.size()) {
            if (((Signal)this.Inputs.elementAt((int)i)).name.equals(this.name_value)) {
                return ((Signal)this.Inputs.elementAt((int)i)).value == 1;
            }
            ++i;
        }
        throw new BadExpressionException(this.expression, this.name_value);
    }
}

