/*
 * Decompiled with CFR 0.152.
 */
package hades.models.fsm;

import hades.manager.DesignManager;
import hades.models.Const1164;
import hades.models.StdLogic1164;
import hades.models.fsm.FSM;
import hades.models.fsm.FsmRenderer;
import hades.models.fsm.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.BboxRectangle;
import hades.symbols.Circle;
import hades.symbols.ClassLabel;
import hades.symbols.InstanceLabel;
import hades.symbols.Polyline;
import hades.symbols.PortLabel;
import hades.symbols.PortSymbol;
import hades.symbols.Symbol;
import hades.symbols.WireSegment;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.awt.Point;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import jfig.utils.ExceptionTracer;

public class FsmWrapper
extends SimObject
implements Serializable {
    protected FSM fsm = FSM.getDefaultFSM();
    protected String fsmResourceName = "/hades/models/fsm/default.fsm";
    int n_inputs = this.fsm.getInputSize();
    int n_outputs = this.fsm.getOutputSize();
    public static final String DEFAULT_FSM_NAME = "/hades/models/fsm/default.fsm";
    public static final int WIDTH = 4800;
    protected double t_delay = 5.0E-8;
    protected Port port_NR;
    protected Port port_CLK;
    protected Port port_STATE;
    protected StdLogic1164 value_U;
    protected StdLogic1164 value_X;
    protected StdLogic1164 value_0;
    protected StdLogic1164 value_1;
    protected FsmRenderer fsmRenderer;
    protected boolean debug = false;
    private Hashtable portToSignalHT;
    private Hashtable portToPosHT;
    private int n_repaints = 0;
    static /* synthetic */ Class class$hades$models$string$StringSignal;

    public FsmWrapper() {
        this.ports = this.buildPorts(this.fsm);
        this.value_U = Const1164.__U;
        this.value_X = Const1164.__X;
        this.value_0 = Const1164.__0;
        this.value_1 = Const1164.__1;
    }

    public boolean needsDynamicSymbol() {
        return true;
    }

    public void constructDynamicSymbol() {
        if (this.debug) {
            this.message("-I- " + this.toString() + ".constructDynamicSymbol...");
        }
        this.symbol = new Symbol();
        this.symbol.setParent(this);
        this.buildSymbol();
        this.symbol.setLayer(3);
        if (this.debug) {
            this.message("-I- symbol is: " + this.symbol);
        }
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.fsmResourceName};
        return externals;
    }

    public boolean initialize(String s) {
        String errorString = null;
        StringTokenizer st = new StringTokenizer(s);
        try {
            if (st.countTokens() == 1) {
                this.versionId = 1001L;
                this.fsmResourceName = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else if (st.countTokens() == 2) {
                this.versionId = Integer.parseInt(st.nextToken());
                this.fsmResourceName = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else {
                throw new Exception();
            }
            InputStreamReader ISR = new InputStreamReader(DesignManager.getDesignManager().getInputStream(this, this.fsmResourceName));
            this.fsm = new FSM();
            errorString = this.fsm.loadFSM(ISR);
            if (errorString != null) {
                throw new Exception(errorString);
            }
        }
        catch (Exception e) {
            this.message("-E- Exception in " + this.toString() + ".initialize: " + e);
            ExceptionTracer.trace(e);
            this.fsmResourceName = DEFAULT_FSM_NAME;
            this.fsm = new FSM();
        }
        this.ports = this.buildPorts(this.fsm);
        this.buildSymbol();
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.getFsmResourceName()));
    }

    public String getFsmResourceName() {
        return this.fsmResourceName;
    }

    public void setFsmResourceName(String s) {
        this.fsmResourceName = s;
        this.message("setFsmResourceName(): " + s);
    }

    public FSM getFSM() {
        return this.fsm;
    }

    public void setFSM(FSM fsm) {
        if (this.debug) {
            this.message("-W- FsmWrapper.setFSM: " + fsm);
        }
        if (fsm != null) {
            this.rebuildFSM(fsm);
        }
    }

    public boolean mayChangeIO() {
        boolean connected = false;
        int i = 0;
        while (i < this.ports.length) {
            if (this.ports[i].getSignal() != null) {
                connected = true;
                break;
            }
            ++i;
        }
        return !connected;
    }

    public void rebuildFSM(FSM fsm) {
        Port[] ports_old = this.ports;
        Port[] ports_new = this.buildPorts(fsm);
        if (this.areSamePorts(this.ports, ports_new)) {
            if (this.debug) {
                this.message("-W- new FSM still has the same ports...");
            }
            this.switchPorts(this.ports, ports_new, fsm);
            this.repaintFSM();
        } else {
            hades.signals.Signal signal;
            this.initPortTables(ports_old);
            Symbol symbol = this.getSymbol();
            Point pos = symbol.getPos();
            symbol.move(-pos.x, -pos.y);
            int i = 0;
            while (i < ports_old.length) {
                signal = ports_old[i].getSignal();
                if (signal != null) {
                    signal.disconnect(ports_old[i]);
                }
                ++i;
            }
            this.ports = ports_new;
            this.buildSymbol();
            symbol.move(pos.x, pos.y);
            int i2 = 0;
            while (i2 < this.ports.length) {
                String portname = this.ports[i2].getName();
                Point newpos = symbol.getPortPosition(this.ports[i2]);
                Object o = this.portToSignalHT.get(portname);
                if (o instanceof hades.signals.Signal) {
                    signal = (hades.signals.Signal)o;
                    signal.connect(this.ports[i2]);
                    Point oldpos = (Point)this.portToPosHT.get(portname);
                    if (newpos != oldpos) {
                        this.moveSignalVertex(signal, oldpos, newpos);
                    }
                }
                ++i2;
            }
            this.repaintFSM();
        }
        this.fsm = fsm;
        this.setFsmResourceName(fsm.getResourceName());
        if (this.fsmRenderer != null) {
            this.fsmRenderer.setFSM(fsm);
        }
        try {
            this.getEditor().doFullRedraw();
            if (this.debug) {
                this.message("-I- FsmWrapper: redraw() successful!");
            }
        }
        catch (Exception e) {
            this.message("-E- FsmWrapper internal error while redrawing.");
            ExceptionTracer.trace(e);
        }
    }

    private void moveSignalVertex(hades.signals.Signal signal, Point oldPos, Point newPos) {
        WireSegment[] segments = (WireSegment[])signal.getSegments();
        int i = 0;
        while (i < segments.length) {
            Point[] points = segments[i].getPoints();
            int j = 0;
            while (j < points.length) {
                if (oldPos.equals(points[j])) {
                    points[j] = new Point(newPos);
                }
                ++j;
            }
            segments[i].setPoints(points);
            ++i;
        }
    }

    private boolean areSamePorts(Port[] p1, Port[] p2) {
        if (p1.length != p2.length) {
            return false;
        }
        int i = 0;
        while (i < p1.length) {
            if (p1[i].getName() != p2[i].getName()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void switchPorts(Port[] p_old, Port[] p_new, FSM fsm) {
        int i = 0;
        while (i < p_old.length) {
            hades.signals.Signal signal = p_old[i].getSignal();
            if (signal != null) {
                signal.disconnect(p_old[i]);
                signal.connect(p_new[i]);
            }
            ++i;
        }
        this.ports = p_new;
        if (this.debug) {
            this.message("-W- FsmWrapper.switchPorts ok.");
        }
    }

    private void initPortTables(Port[] ports) {
        this.portToSignalHT = new Hashtable();
        this.portToPosHT = new Hashtable();
        Symbol symbol = this.getSymbol();
        int i = 0;
        while (i < ports.length) {
            Object o;
            if (this.debug) {
                this.message("-W- initPortTables: " + i + " " + ports[i] + " " + " " + ports[i].getName() + " " + ports[i].getSignal());
            }
            if ((o = ports[i].getSignal()) == null) {
                o = "cannot put null into Hashtables";
            }
            this.portToSignalHT.put(ports[i].getName(), o);
            Point pos = symbol.getPortPosition(ports[i]);
            this.portToPosHT.put(ports[i].getName(), pos);
            ++i;
        }
        if (this.debug) {
            this.message("-I- FsmWrapper.initPortTables ok.");
        }
    }

    private Port[] buildPorts(FSM fsm) {
        this.port_NR = new Port(this, "nreset", 0, null);
        this.port_CLK = new Port(this, "clk", 0, null);
        this.port_STATE = new Port(this, "state", 1, null, class$hades$models$string$StringSignal == null ? (class$hades$models$string$StringSignal = FsmWrapper.class$("hades.models.string.StringSignal")) : class$hades$models$string$StringSignal);
        if (fsm == null) {
            fsm = FSM.getDefaultFSM();
        }
        this.n_inputs = fsm.getInputSize();
        this.n_outputs = fsm.getOutputSize();
        if (this.debug) {
            System.out.println("buildPorts: " + this.n_inputs + " " + this.n_outputs);
        }
        Port[] ports = new Port[3 + this.n_inputs + this.n_outputs];
        ports[0] = this.port_NR;
        ports[1] = this.port_CLK;
        ports[2] = this.port_STATE;
        Signal s_fsm = null;
        Vector inputs = fsm.inputs;
        int i = 0;
        while (i < this.n_inputs) {
            s_fsm = (Signal)inputs.elementAt(i);
            ports[i + 3] = new Port(this, s_fsm.name, 0, null);
            ++i;
        }
        Vector outputs = fsm.outputs;
        int i2 = 0;
        while (i2 < this.n_outputs) {
            s_fsm = (Signal)outputs.elementAt(i2);
            ports[i2 + 3 + this.n_inputs] = new Port(this, s_fsm.name, 1, null);
            ++i2;
        }
        return ports;
    }

    private void buildSymbol() {
        String name;
        if (this.debug) {
            this.message("-I- buildSymbol() started...");
        }
        if (this.symbol == null) {
            if (this.debug) {
                this.message("-W- no Symbol: FsmWrapper/FSM not visible!?");
            }
            return;
        }
        this.symbol.deleteAllMembers();
        int width = 4800;
        int height = 1800 + Math.max(4800, Math.max(this.n_inputs, this.n_outputs) * 600 + 1200);
        BboxRectangle bb = new BboxRectangle();
        bb.initialize("0 0 " + width + " " + height);
        Polyline topBorder = new Polyline();
        topBorder.initialize("8 600 1800 600 1500 0 1500 0 0 " + width + " 0 " + width + " 1500 " + (width - 600) + " 1500 " + (width - 600) + " 1800");
        Polyline bottomBorder = new Polyline();
        bottomBorder.initialize("5 0 1800 " + width + " 1800 " + width + " " + height + " 0 " + height + " 0 1800");
        ClassLabel classlabel = new ClassLabel();
        classlabel.initialize("2400 450 2 " + this.fsm.getName().replace(' ', '_'));
        InstanceLabel ilabel = new InstanceLabel();
        ilabel.initialize("2400 " + (height - 150) + " 2 " + this.getName());
        this.symbol.fastAddMember(bb);
        this.symbol.fastAddMember(topBorder);
        this.symbol.fastAddMember(bottomBorder);
        this.symbol.fastAddMember(classlabel);
        this.symbol.fastAddMember(ilabel);
        PortSymbol portsymbol = new PortSymbol();
        portsymbol.initialize("0 600 nreset");
        PortLabel portlabel = new PortLabel();
        portlabel.initialize("600 700 nreset");
        Circle resetcircle = new Circle();
        resetcircle.initialize("250 600 150 150");
        this.symbol.fastAddMember(portsymbol);
        this.symbol.fastAddMember(portlabel);
        this.symbol.fastAddMember(resetcircle);
        portsymbol = new PortSymbol();
        portsymbol.initialize("0 1200 clk");
        portlabel = new PortLabel();
        portlabel.initialize("600 1300 clk");
        Polyline clockline = new Polyline();
        clockline.initialize("3 0 1050 450 1200 0 1350");
        this.symbol.fastAddMember(portsymbol);
        this.symbol.fastAddMember(portlabel);
        this.symbol.fastAddMember(clockline);
        portsymbol = new PortSymbol();
        portsymbol.initialize("" + width + " 1200 state");
        portlabel = new PortLabel();
        portlabel.initialize("" + (width - 150) + " 1300 3 state");
        this.symbol.fastAddMember(portsymbol);
        this.symbol.fastAddMember(portlabel);
        int i = 0;
        while (i < this.n_inputs) {
            name = this.ports[i + 3].getName();
            portsymbol = new PortSymbol();
            portsymbol.initialize("0 " + (2400 + 600 * i) + " " + name);
            portlabel = new PortLabel();
            portlabel.initialize("150 " + (2500 + 600 * i) + " " + name);
            this.symbol.fastAddMember(portsymbol);
            this.symbol.fastAddMember(portlabel);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.n_outputs) {
            name = this.ports[i2 + 3 + this.n_inputs].getName();
            portsymbol = new PortSymbol();
            portsymbol.initialize("" + width + " " + (2400 + 600 * i2) + " " + name);
            portlabel = new PortLabel();
            portlabel.initialize("" + (width - 150) + " " + (2500 + 600 * i2) + " 3 " + name);
            this.symbol.fastAddMember(portsymbol);
            this.symbol.fastAddMember(portlabel);
            ++i2;
        }
        this.fsmRenderer = new FsmRenderer();
        this.fsmRenderer.initialize("600 2400 " + (width - 600) + " " + (height - 600));
        this.fsmRenderer.setFSM(this.fsm);
        this.symbol.fastAddMember(this.fsmRenderer);
        this.symbol.update_bbox();
        this.symbol.build_sc_bbox();
        this.symbol.setTrafo(this.symbol.getTrafo());
        this.symbol.setObjectPainter(this.symbol.painter);
        if (this.debug) {
            this.message("-I- FsmWrapper.buildSymbol(): symbol= " + this.symbol);
        }
    }

    public void elaborate(Object arg) {
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            if (this.debug) {
                this.message("-E- Internal error: simulator is null in " + this.toString() + ".elaborate()!");
            }
            return;
        }
    }

    public void evaluate(Object arg) {
        hades.signals.Signal signal_NR = this.port_NR.getSignal();
        hades.signals.Signal signal_CLK = this.port_CLK.getSignal();
        try {
            if (signal_NR == null) {
                this.invalidateFSM();
                return;
            }
            StdLogic1164 value_NR = this.getValue(this.port_NR);
            if (value_NR.isLow_0L()) {
                this.resetFSM();
                return;
            }
            if (!value_NR.isHigh_1H()) {
                this.invalidateFSM();
                return;
            }
            if (signal_CLK == null) {
                this.invalidateFSM();
                return;
            }
            if (((SignalStdLogic1164)signal_CLK).hasRisingEdge()) {
                this.taktFSM();
                return;
            }
            if (this.fsm.getMachineType() == 0) {
                this.updateMooreFSM();
                return;
            }
            this.updateMealyFSM();
            return;
        }
        catch (Exception e) {
            this.message("-W- Cannot calculate FSM outputs: did you initialize it?");
            ExceptionTracer.trace(e);
            this.invalidateFSM();
            return;
        }
    }

    public void resetFSM() {
        if (this.debug) {
            this.message("-I- FsmWrapper.resetFSM()...");
        }
        this.fsm.reset();
        this.setInputsFSM();
        this.fsm.zwischentakt();
        this.fsm.calculateTransition();
        this.scheduleOutputs(this.simulator.getSimTime() + this.t_delay);
        this.repaintFSM();
    }

    public void invalidateFSM() {
        if (this.debug) {
            this.message("-I- FsmWrapper.invalidateFSM()...");
        }
        double time = this.simulator.getSimTime() + this.t_delay;
        int i = 0;
        while (i < this.n_outputs) {
            this.setValue(this.ports[3 + this.n_inputs + i], this.value_U, time);
            ++i;
        }
    }

    public void taktFSM() {
        if (this.debug) {
            this.message("-I- FsmWrapper.taktFSM()...");
        }
        this.setInputsFSM();
        this.fsm.takt();
        this.fsm.calculateTransition();
        this.scheduleOutputs(this.simulator.getSimTime() + this.t_delay);
        this.repaintFSM();
    }

    public void updateMooreFSM() {
        this.setInputsFSM();
        this.fsm.calculateTransition();
        this.repaintFSM();
    }

    public void updateMealyFSM() {
        this.setInputsFSM();
        this.fsm.calculateTransition();
        this.fsm.zwischentakt();
        this.scheduleOutputs(this.simulator.getSimTime() + this.t_delay);
        this.repaintFSM();
    }

    private void setInputsFSM() {
        int i = 0;
        while (i < this.n_inputs) {
            StdLogic1164 tmp = this.getValue(this.ports[i + 3]);
            Signal s = (Signal)this.fsm.inputs.elementAt(i);
            s.value = tmp.isLow_0L() ? 0 : (tmp.isHigh_1H() ? 1 : 2);
            ++i;
        }
    }

    private void scheduleOutputs(double time) {
        int i = 0;
        while (i < this.n_outputs) {
            Signal s = (Signal)this.fsm.outputs.elementAt(i);
            StdLogic1164 tmp = s.value == 0 ? this.value_0 : (s.value == 1 ? this.value_1 : this.value_X);
            this.setValue(this.ports[i + 3 + this.n_inputs], tmp, time);
            ++i;
        }
        this.scheduleStateOutput(time);
    }

    private StdLogic1164 getValue(Port p) {
        hades.signals.Signal s = p.getSignal();
        if (s == null) {
            return this.value_U;
        }
        return (StdLogic1164)s.getValue();
    }

    public void setValue(Port port, StdLogic1164 value, double time) {
        hades.signals.Signal s = port.getSignal();
        if (s == null) {
            return;
        }
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)s, time, value, (Object)port));
    }

    public void scheduleStateOutput(double time) {
        hades.signals.Signal s_STATE = this.port_STATE.getSignal();
        if (s_STATE != null) {
            this.simulator.scheduleEvent(new SimEvent(s_STATE, time, this.fsm.currentState.name, this.port_STATE));
        }
    }

    private void repaintFSM() {
        if (this.debug) {
            System.out.println("-I- repaintFSM()..." + this.n_repaints);
        }
        try {
            ++this.n_repaints;
            if (this.fsmRenderer != null) {
                this.fsmRenderer.painter.paint(this.fsmRenderer);
            }
        }
        catch (Exception e) {
            this.message("-E- FsmWrapper.repaintFSM: " + e);
            ExceptionTracer.trace(e);
        }
    }

    public void configure() {
        if (this.debug) {
            this.message("-I- FsmWrapper.configure()...");
        }
        this.fsm.edit(this);
    }

    public Component getPropertySheet() {
        return this.fsm.getEditFrame();
    }

    public SimObject copy() {
        FsmWrapper tmp = null;
        try {
            tmp = (FsmWrapper)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            tmp.initialize("" + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.getFsmResourceName()));
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimObject.copy(): " + e);
            return null;
        }
    }

    public String toString() {
        return "FsmWrapper[" + this.fsmResourceName + "] " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

