/*
 * Decompiled with CFR 0.152.
 */
package hades.models.flipflops;

import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.flipflops.GenericFlipflop;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import java.io.Serializable;

public class Latchr
extends GenericFlipflop
implements Simulatable,
Serializable {
    private PortStdLogic1164 port_D;
    private PortStdLogic1164 port_C;
    private PortStdLogic1164 port_NR;
    private StdLogic1164 next_Q;
    private StdLogic1164 next_NQ;

    public Latchr() {
        this.port_Q = new PortStdLogic1164(this, "Q", 1, null);
        this.port_NQ = new PortStdLogic1164(this, "NQ", 1, null);
        this.port_D = new PortStdLogic1164(this, "D", 0, null);
        this.port_C = new PortStdLogic1164(this, "C", 0, null);
        this.port_NR = new PortStdLogic1164(this, "NR", 0, null);
        this.ports = new Port[5];
        this.ports[0] = this.port_Q;
        this.ports[1] = this.port_NQ;
        this.ports[2] = this.port_D;
        this.ports[3] = this.port_C;
        this.ports[4] = this.port_NR;
        this.next_Q = new StdLogic1164(0);
        this.next_NQ = new StdLogic1164(0);
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()...");
        }
        int tmp = 0;
        StdLogic1164 value_D = this.port_D.getValueOrU();
        StdLogic1164 value_C = this.port_C.getValueOrU();
        StdLogic1164 value_NR = this.port_NR.getValueOrU();
        Signal signal_C = this.port_C.getSignal();
        Signal signal_D = this.port_D.getSignal();
        if (value_NR.isLow_0L()) {
            tmp = 2;
        } else if (!value_NR.isHigh_1H()) {
            tmp = 1;
        } else if (signal_C == null) {
            tmp = 1;
        } else if (signal_D == null) {
            tmp = 1;
        } else if (value_C.is_UXZ()) {
            tmp = 1;
        } else if (value_C.isHigh_1H()) {
            if (signal_C.hasEvent() && !signal_D.isStable(this.t_setup)) {
                this.message("-W- Setup-time violation on " + this.toString());
                this.message("    clk event at " + this.simulator.getSimTime());
                this.message("    d   event at " + signal_D.getLastChangeTime());
                this.message("    required setup is " + this.t_setup + " sec.");
                this.message("    actual setup was " + (this.simulator.getSimTime() - signal_D.getLastChangeTime()) + "sec.");
                tmp = 1;
            } else {
                tmp = value_D.isLow_0L() ? 2 : (value_D.isHigh_1H() ? 3 : 1);
            }
        } else if (signal_D.hasEvent()) {
            if (signal_C.isStable(this.t_hold)) {
                return;
            }
            this.message("-W- Hold-time violation on " + this.toString());
            this.message("    clk event at " + this.simulator.getSimTime());
            this.message("    d   event at " + signal_D.getLastChangeTime());
            this.message("    required hold is " + this.t_hold + " sec.");
            this.message("    actual hold was " + (signal_C.getLastChangeTime() - this.simulator.getSimTime()) + "sec.");
            tmp = 1;
        } else {
            return;
        }
        this.next_Q.setIntValue(tmp);
        this.next_NQ.setToInvert(this.next_Q);
        Signal signal_Q = this.port_Q.getSignal();
        Signal signal_NQ = this.port_NQ.getSignal();
        if (signal_Q != null) {
            super.scheduleEventAfter(signal_Q, this.t_pass, this.next_Q, this.port_Q);
        }
        if (signal_NQ != null) {
            super.scheduleEventAfter(signal_NQ, this.t_pass, this.next_NQ, this.port_NQ);
        }
    }
}

