/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dsp;

import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.dsp.GenericDspOperator;
import hades.signals.PortDouble;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import java.awt.Point;

public class LevelTrigger
extends GenericDspOperator {
    protected PortStdLogic1164 port_Y;
    protected PortDouble port_A;
    protected Double lastInputValue;
    protected StdLogic1164 value_Y;

    public void constructPorts() {
        this.port_A = new PortDouble(this, "A", 0, null);
        this.port_Y = new PortStdLogic1164(this, "Y", 1, null);
        this.ports = new Port[]{this.port_A, this.port_Y};
        this.inputPorts = new PortDouble[]{this.port_A};
        this.inputValues = new double[]{Double.NaN};
        this.outputPorts = new PortDouble[0];
        this.outputValues = new double[0];
        this.value_Y = new StdLogic1164(0);
    }

    public double getLevel() {
        return this.getD0();
    }

    public void evaluate(Object arg) {
        double v;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        this.inputValues[0] = v = this.port_A.getValueOrNaN().doubleValue();
        this.value_Y = Double.isNaN(v) ? new StdLogic1164(1) : (v >= this.getLevel() ? new StdLogic1164(3) : new StdLogic1164(2));
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        if (this.port_Y.getSignal() != null) {
            simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)this.port_Y.getSignal(), time, this.value_Y, (Object)this.port_Y));
        }
    }

    public String[] getPropertySheetFieldNames() {
        String[] fields = new String[]{"instance name:", "name", "output delay     [sec]:", "delay", "trigger level (voltage) [5.0]:", "d0"};
        return fields;
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "input value= " + this.inputValues[0] + "\n" + "trigger level= " + this.getD0() + "\n" + "output value= " + this.value_Y;
    }
}

