/*
 * Decompiled with CFR 0.152.
 */
package hades.models.dsp;

import hades.gui.PropertySheet;
import hades.models.PortStdLogicVector;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.PortDouble;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;

public class DoubleToStdLogicVector
extends GenericRtlibObject {
    private static final long serialVersionUID = 4224757982801781264L;
    protected PortStdLogicVector port_Y;
    protected PortDouble port_A;
    protected StdLogicVector value_Y;
    protected double factor = 1.0;
    protected double offset = 0.0;

    public void constructPorts() {
        this.port_A = new PortDouble(this, "A", 0, null);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, this.n_bits);
        this.ports = new Port[]{this.port_A, this.port_Y};
        this.value_Y = new StdLogicVector(this.n_bits);
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double d) {
        this.offset = d;
    }

    public void setOffset(String s) {
        try {
            this.setOffset(Double.parseDouble(s));
        }
        catch (Exception e) {
            this.setOffset(0.0);
        }
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double d) {
        this.factor = d;
    }

    public void setFactor(String s) {
        try {
            this.setFactor(Double.parseDouble(s));
        }
        catch (Exception e) {
            this.setFactor(0.0);
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double raw = this.port_A.getValueOrNaN();
        double v = this.offset + raw * this.factor;
        long l = 0L;
        this.value_Y = Double.isNaN(v) ? new StdLogicVector(this.n_bits, 1L) : (v >= 9.223372036854776E18 || v <= -9.223372036854776E18 ? new StdLogicVector(this.n_bits, 1L) : new StdLogicVector(this.n_bits, Math.round(v)));
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        if (this.port_Y.getSignal() != null) {
            simulator.scheduleEvent(SimEvent.createNewSimEvent(this.port_Y.getSignal(), time, this.value_Y, this.port_Y));
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.delay + " " + this.offset + " " + this.factor);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.setDelay(st.nextToken());
            this.setOffset(st.nextToken());
            this.setFactor(st.nextToken());
            this.constructPorts();
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 32]:", "width", "output delay           [sec]:", "delay", "scaling offset              :", "offset", "scaling factor              :", "factor"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay,\nand the scaling offset and factor\n");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "input value<" + (this.n_bits - 1) + ":0>= " + this.vector.toHexString() + "\n" + "offset= " + this.getOffset() + "\n" + "factor= " + this.getFactor() + "\n" + "output value= " + this.value_Y;
    }
}

