/*
 * Decompiled with CFR 0.152.
 */
package hades.models;

import hades.models.StdLogic1164;
import java.io.Serializable;

public class StdLogicVector
implements Serializable {
    public static final boolean debug = true;
    public static final long INVALID_XXX = -1L;
    public static final long UNDEFINED_UUU = -2L;
    public static final long TRISTATE_ZZZ = -3L;
    public static final long MAX_BITS = 62L;
    private int n_bits;
    private long _length_mask = 0L;
    private long _U_mask;
    private long _X_mask;
    private long _0_mask;
    private long _1_mask;
    private long _Z_mask;
    private long _W_mask;
    private long _L_mask;
    private long _H_mask;
    private long _D_mask;
    private static long[] bit_mask = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};

    public StdLogicVector(int n_bits) {
        if (n_bits < 0 || (long)n_bits > 62L) {
            throw new Error("Invalid number of bits in a StdLogicVector: " + n_bits);
        }
        this.n_bits = n_bits;
        this.setLengthMask(n_bits);
        this._U_mask = this._length_mask;
        this._X_mask = 0L;
        this._0_mask = 0L;
        this._1_mask = 0L;
        this._Z_mask = 0L;
        this._W_mask = 0L;
        this._L_mask = 0L;
        this._H_mask = 0L;
        this._D_mask = 0L;
    }

    public StdLogicVector(int n_bits, long value) {
        this(n_bits);
        this.setValue(value);
    }

    public StdLogicVector(int n_bits, String bitString) {
        this(n_bits);
        this._U_mask = 0L;
        StdLogic1164 tmp = new StdLogic1164();
        char c = 'U';
        long _bit = 1L;
        int i = 0;
        while (i < n_bits) {
            try {
                c = bitString.charAt(n_bits - 1 - i);
            }
            catch (Exception e) {
                c = 'U';
            }
            tmp.setValue(c);
            switch (tmp.intValue()) {
                case 0: {
                    this._U_mask |= _bit;
                    break;
                }
                case 1: {
                    this._X_mask |= _bit;
                    break;
                }
                case 2: {
                    this._0_mask |= _bit;
                    break;
                }
                case 3: {
                    this._1_mask |= _bit;
                    break;
                }
                case 4: {
                    this._Z_mask |= _bit;
                    break;
                }
                case 5: {
                    this._W_mask |= _bit;
                    break;
                }
                case 6: {
                    this._L_mask |= _bit;
                    break;
                }
                case 7: {
                    this._H_mask |= _bit;
                    break;
                }
                case 8: {
                    this._D_mask |= _bit;
                }
            }
            _bit += _bit;
            ++i;
        }
    }

    public StdLogicVector(int n_bits, StdLogic1164 defaultValue) {
        this(n_bits);
        this._U_mask = 0L;
        switch (defaultValue.intValue()) {
            case 0: {
                this._U_mask = this._length_mask;
                break;
            }
            case 1: {
                this._X_mask = this._length_mask;
                break;
            }
            case 2: {
                this._0_mask = this._length_mask;
                break;
            }
            case 3: {
                this._1_mask = this._length_mask;
                break;
            }
            case 4: {
                this._Z_mask = this._length_mask;
                break;
            }
            case 5: {
                this._W_mask = this._length_mask;
                break;
            }
            case 6: {
                this._L_mask = this._length_mask;
                break;
            }
            case 7: {
                this._H_mask = this._length_mask;
                break;
            }
            case 8: {
                this._D_mask = this._length_mask;
                break;
            }
            default: {
                StdLogicVector.msg("-E- " + this.toString() + ".init<>:" + " illegal default value: " + defaultValue);
                this._U_mask = this._length_mask;
            }
        }
    }

    public StdLogicVector copy() {
        StdLogicVector clone = new StdLogicVector(this.n_bits);
        clone._U_mask = this._U_mask;
        clone._X_mask = this._X_mask;
        clone._0_mask = this._0_mask;
        clone._1_mask = this._1_mask;
        clone._Z_mask = this._Z_mask;
        clone._W_mask = this._W_mask;
        clone._L_mask = this._L_mask;
        clone._H_mask = this._H_mask;
        clone._D_mask = this._D_mask;
        return clone;
    }

    public static StdLogicVector toStdLogicVector(int value, int n_bits) {
        return new StdLogicVector(value, n_bits);
    }

    public int getWidth() {
        return this.n_bits;
    }

    private final void setLengthMask(int n_bits) {
        this._length_mask = bit_mask[n_bits];
    }

    public final long getBitMask() {
        return bit_mask[this.getWidth()];
    }

    public int getBitIntValueAt(int index) {
        int intValue;
        if (index < 0 || index > this.getWidth()) {
            StdLogicVector.msg("-W- StdLogicVector.getBitIntValueAt: index out of range" + index);
            return 0;
        }
        long _bit = 1L << index;
        if ((this._U_mask & _bit) > 0L) {
            intValue = 0;
        } else if ((this._X_mask & _bit) > 0L) {
            intValue = 1;
        } else if ((this._0_mask & _bit) > 0L) {
            intValue = 2;
        } else if ((this._1_mask & _bit) > 0L) {
            intValue = 3;
        } else if ((this._Z_mask & _bit) > 0L) {
            intValue = 4;
        } else if ((this._W_mask & _bit) > 0L) {
            intValue = 5;
        } else if ((this._L_mask & _bit) > 0L) {
            intValue = 6;
        } else if ((this._H_mask & _bit) > 0L) {
            intValue = 7;
        } else if ((this._D_mask & _bit) > 0L) {
            intValue = 8;
        } else {
            StdLogicVector.msg("-E- internal error in StdLogicVector.getBitIntValueAt(" + index + ")" + ": all bit masks are zero?! ");
            StdLogicVector.msg("-E- returning _U");
            intValue = 0;
        }
        return intValue;
    }

    public StdLogic1164 getBitAt(int index) {
        return new StdLogic1164(this.getBitIntValueAt(index));
    }

    public void setBitAt(int index, StdLogic1164 value) {
        this.setBitAt(index, value.intValue());
    }

    public void setBitAt(int index, int value) {
        if (index < 0 || index > this.getWidth()) {
            StdLogicVector.msg("-W- StdLogicVector.setBitAt: index out of range" + index);
            return;
        }
        long _bit = 1L << index;
        long _inverse = _bit ^ 0xFFFFFFFFFFFFFFFFL;
        this._U_mask &= _inverse;
        this._X_mask &= _inverse;
        this._0_mask &= _inverse;
        this._1_mask &= _inverse;
        this._Z_mask &= _inverse;
        this._W_mask &= _inverse;
        this._L_mask &= _inverse;
        this._H_mask &= _inverse;
        this._D_mask &= _inverse;
        switch (value) {
            case 0: {
                this._U_mask |= _bit;
                break;
            }
            case 1: {
                this._X_mask |= _bit;
                break;
            }
            case 2: {
                this._0_mask |= _bit;
                break;
            }
            case 3: {
                this._1_mask |= _bit;
                break;
            }
            case 4: {
                this._Z_mask |= _bit;
                break;
            }
            case 5: {
                this._W_mask |= _bit;
                break;
            }
            case 6: {
                this._L_mask |= _bit;
                break;
            }
            case 7: {
                this._H_mask |= _bit;
                break;
            }
            case 8: {
                this._D_mask |= _bit;
                break;
            }
            default: {
                StdLogicVector.msg("-E- " + this.toString() + ".setBitAt " + index + " illegal value: " + value);
                this.clearAllMasks();
                this._U_mask = this._length_mask;
            }
        }
    }

    private final void clearAllMasks() {
        this._U_mask = 0L;
        this._X_mask = 0L;
        this._0_mask = 0L;
        this._1_mask = 0L;
        this._Z_mask = 0L;
        this._W_mask = 0L;
        this._L_mask = 0L;
        this._H_mask = 0L;
        this._D_mask = 0L;
    }

    public void setValue(long value) {
        if (value == -2L) {
            this.clearAllMasks();
            this._U_mask = this._length_mask;
            return;
        }
        if (value == -1L) {
            this.clearAllMasks();
            this._X_mask = this._length_mask;
            return;
        }
        if (value == -3L) {
            this.clearAllMasks();
            this._Z_mask = this._length_mask;
            return;
        }
        this.clearAllMasks();
        this._1_mask = value & this._length_mask;
        this._0_mask = (value ^ 0xFFFFFFFFFFFFFFFFL) & this._length_mask;
    }

    public long getValue() {
        if (this._U_mask != 0L) {
            return -2L;
        }
        if (this._X_mask != 0L) {
            return -1L;
        }
        if (this._L_mask != 0L) {
            return -1L;
        }
        if (this._H_mask != 0L) {
            return -1L;
        }
        if (this._W_mask != 0L) {
            return -1L;
        }
        if (this._D_mask != 0L) {
            return -1L;
        }
        if (this._Z_mask != 0L) {
            if (this._Z_mask == this._length_mask) {
                return -3L;
            }
            return -1L;
        }
        return this._1_mask;
    }

    public long getSignedValue() {
        if (this._U_mask != 0L) {
            return -2L;
        }
        if (this._X_mask != 0L) {
            return -1L;
        }
        if (this._L_mask != 0L) {
            return -1L;
        }
        if (this._H_mask != 0L) {
            return -1L;
        }
        if (this._W_mask != 0L) {
            return -1L;
        }
        if (this._D_mask != 0L) {
            return -1L;
        }
        if (this._Z_mask != 0L) {
            if (this._Z_mask == this._length_mask) {
                return -3L;
            }
            return -1L;
        }
        long _sign = this._1_mask & 1L << this.n_bits - 1;
        if (_sign > 0L) {
            return this._1_mask | this._length_mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this._1_mask;
    }

    public StdLogicVector incr() {
        if (this.has_UXZ()) {
            return new StdLogicVector(this.n_bits);
        }
        long value = this._1_mask + 1L & this._length_mask;
        return new StdLogicVector(this.n_bits, value);
    }

    public StdLogicVector decr() {
        if (this.has_UXZ()) {
            return new StdLogicVector(this.n_bits);
        }
        long value = this._1_mask - 1L & this._length_mask;
        return new StdLogicVector(this.n_bits, value);
    }

    public static void checkWidth(StdLogicVector L, StdLogicVector R) {
        if (L.getWidth() != R.getWidth()) {
            throw new Error("Width mismatch in StdLogicVector.add: " + L.getWidth() + " vs. " + R.getWidth());
        }
    }

    public StdLogicVector add(StdLogicVector R) {
        return StdLogicVector.add(this, R);
    }

    public static StdLogicVector add(StdLogicVector L, StdLogicVector R) {
        StdLogicVector.checkWidth(L, R);
        StdLogicVector result = new StdLogicVector(L.getWidth());
        if (L.has_UXZ() || R.has_UXZ()) {
            return result;
        }
        result.setValue(L._1_mask + R._1_mask & result._length_mask);
        return result;
    }

    public static StdLogic1164 get2ComplementAddOverflow(StdLogicVector L, StdLogicVector R) {
        StdLogicVector.checkWidth(L, R);
        int signbit = L.getWidth() - 1;
        if (L.getBitAt(signbit).equals(R.getBitAt(signbit))) {
            return StdLogic1164.xor(L.getBitAt(signbit), StdLogicVector.add(L, R).getBitAt(signbit));
        }
        return new StdLogic1164(2);
    }

    public StdLogicVector sub(StdLogicVector R) {
        return StdLogicVector.sub(this, R);
    }

    public static StdLogicVector sub(StdLogicVector L, StdLogicVector R) {
        StdLogicVector.checkWidth(L, R);
        StdLogicVector result = new StdLogicVector(L.getWidth());
        if (L.has_UXZ() || R.has_UXZ()) {
            return result;
        }
        result.setValue(L._1_mask - R._1_mask & result._length_mask);
        return result;
    }

    public StdLogicVector shr_arithmetical(int count) throws Exception {
        int n_bits = this.getWidth();
        if (count < 0 || count > n_bits) {
            throw new Exception("-E- Shift count out of range: " + count);
        }
        StdLogicVector clone = new StdLogicVector(n_bits);
        clone._U_mask = this._shrl(this._U_mask, count);
        clone._X_mask = this._shrl(this._X_mask, count);
        clone._0_mask = this._shrl(this._0_mask, count);
        clone._1_mask = this._shrl(this._1_mask, count);
        clone._Z_mask = this._shrl(this._Z_mask, count);
        clone._W_mask = this._shrl(this._W_mask, count);
        clone._L_mask = this._shrl(this._L_mask, count);
        clone._H_mask = this._shrl(this._H_mask, count);
        clone._D_mask = this._shrl(this._D_mask, count);
        return clone;
    }

    private final long _shrl(long value, int count) {
        long signbit = value & 1L << this.n_bits - 1;
        long lower = value >> count;
        long upper = 0L;
        if (signbit == 0L) {
            return lower;
        }
        upper = this._length_mask ^ bit_mask[this.n_bits - count];
        return upper | lower;
    }

    public StdLogicVector shr_logical(int count) throws Exception {
        if (count < 0 || count > this.n_bits) {
            throw new Exception("-E- Shift count out of range: " + count);
        }
        StdLogicVector clone = new StdLogicVector(this.n_bits);
        clone._U_mask = this._U_mask >>> count;
        clone._X_mask = this._X_mask >>> count;
        clone._0_mask = this._0_mask >>> count;
        clone._1_mask = this._1_mask >>> count;
        clone._Z_mask = this._Z_mask >>> count;
        clone._L_mask = this._L_mask >>> count;
        clone._W_mask = this._W_mask >>> count;
        clone._H_mask = this._H_mask >>> count;
        clone._D_mask = this._D_mask >>> count;
        clone._0_mask |= this._length_mask ^ bit_mask[this.n_bits - count];
        return clone;
    }

    public StdLogicVector ror(int count) throws Exception {
        if (count < 0 || count > this.n_bits) {
            throw new Exception("-E- Rotate count out of range: " + count);
        }
        StdLogicVector clone = new StdLogicVector(this.n_bits);
        clone._U_mask = this._ror(this._U_mask, count);
        clone._X_mask = this._ror(this._X_mask, count);
        clone._0_mask = this._ror(this._0_mask, count);
        clone._1_mask = this._ror(this._1_mask, count);
        clone._Z_mask = this._ror(this._Z_mask, count);
        clone._W_mask = this._ror(this._W_mask, count);
        clone._L_mask = this._ror(this._L_mask, count);
        clone._H_mask = this._ror(this._H_mask, count);
        clone._D_mask = this._ror(this._D_mask, count);
        return clone;
    }

    private final long _ror(long value, int count) {
        long result = value >>> count & this._length_mask >>> count;
        result |= value << this.n_bits - count;
        return result &= this._length_mask;
    }

    public StdLogicVector shl(int count) throws Exception {
        if (count < 0 || count > this.n_bits) {
            throw new Exception("-E- Shift count out of range: " + count);
        }
        StdLogicVector clone = new StdLogicVector(this.n_bits);
        clone._U_mask = this._shl(this._U_mask, count);
        clone._X_mask = this._shl(this._X_mask, count);
        clone._0_mask = this._shl(this._0_mask, count);
        clone._1_mask = this._shl(this._1_mask, count);
        clone._Z_mask = this._shl(this._Z_mask, count);
        clone._W_mask = this._shl(this._W_mask, count);
        clone._L_mask = this._shl(this._L_mask, count);
        clone._H_mask = this._shl(this._H_mask, count);
        clone._D_mask = this._shl(this._D_mask, count);
        clone._0_mask |= bit_mask[count];
        return clone;
    }

    private final long _shl(long value, int count) {
        return value << count & this._length_mask;
    }

    public StdLogicVector rol(int count) throws Exception {
        if (count < 0 || count > this.n_bits) {
            throw new Exception("-E- Rotate count out of range: " + count);
        }
        StdLogicVector clone = new StdLogicVector(this.n_bits);
        clone._U_mask = this._rol(this._U_mask, count);
        clone._X_mask = this._rol(this._X_mask, count);
        clone._0_mask = this._rol(this._0_mask, count);
        clone._1_mask = this._rol(this._1_mask, count);
        clone._Z_mask = this._rol(this._Z_mask, count);
        clone._W_mask = this._rol(this._W_mask, count);
        clone._L_mask = this._rol(this._L_mask, count);
        clone._H_mask = this._rol(this._H_mask, count);
        clone._D_mask = this._rol(this._D_mask, count);
        return clone;
    }

    private final long _rol(long value, int count) {
        long upper = value << count & this._length_mask;
        long lower = value >>> this.n_bits - count & this._length_mask >>> this.n_bits - count;
        return (upper | lower) & this._length_mask;
    }

    public StdLogicVector invert_bitwise() {
        int n_bits = this.getWidth();
        StdLogicVector result = new StdLogicVector(n_bits);
        result._U_mask = this._U_mask;
        result._X_mask = this._X_mask;
        result._0_mask = this._1_mask;
        result._1_mask = this._0_mask;
        result._X_mask |= this._Z_mask;
        result._X_mask |= this._W_mask;
        result._1_mask |= this._L_mask;
        result._0_mask |= this._H_mask;
        result._X_mask |= this._D_mask;
        return result;
    }

    public StdLogicVector and_bitwise(StdLogicVector B) {
        StdLogicVector.checkWidth(this, B);
        StdLogicVector result = new StdLogicVector(this.n_bits);
        if (this.has_UXZ() || B.has_UXZ()) {
            int i = 0;
            while (i < this.n_bits) {
                int this_i = this.getBitIntValueAt(i);
                int B_i = B.getBitIntValueAt(i);
                result.setBitAt(i, StdLogic1164.AND_TABLE[this_i][B_i]);
                ++i;
            }
        } else {
            result._U_mask = 0L;
            result._1_mask = this._1_mask & B._1_mask;
            result._0_mask = (result._1_mask ^ 0xFFFFFFFFFFFFFFFFL) & this._length_mask;
        }
        return result;
    }

    public StdLogicVector or_bitwise(StdLogicVector B) {
        StdLogicVector.checkWidth(this, B);
        StdLogicVector result = new StdLogicVector(this.n_bits);
        if (this.has_UXZ() || B.has_UXZ()) {
            int i = 0;
            while (i < this.n_bits) {
                int this_i = this.getBitIntValueAt(i);
                int B_i = B.getBitIntValueAt(i);
                result.setBitAt(i, StdLogic1164.OR_TABLE[this_i][B_i]);
                ++i;
            }
        } else {
            result._U_mask = 0L;
            result._1_mask = this._1_mask | B._1_mask;
            result._0_mask = (result._1_mask ^ 0xFFFFFFFFFFFFFFFFL) & this._length_mask;
        }
        return result;
    }

    public StdLogicVector xor_bitwise(StdLogicVector B) {
        StdLogicVector.checkWidth(this, B);
        StdLogicVector result = new StdLogicVector(this.n_bits);
        if (this.has_UXZ() || B.has_UXZ()) {
            int i = 0;
            while (i < this.n_bits) {
                int this_i = this.getBitIntValueAt(i);
                int B_i = B.getBitIntValueAt(i);
                result.setBitAt(i, StdLogic1164.XOR_TABLE[this_i][B_i]);
                ++i;
            }
        } else {
            result._U_mask = 0L;
            result._1_mask = this._1_mask ^ B._1_mask;
            result._0_mask = (result._1_mask ^ 0xFFFFFFFFFFFFFFFFL) & this._length_mask;
        }
        return result;
    }

    public static final StdLogicVector resolve(StdLogicVector[] inputs) throws Exception {
        int width = inputs[0].getWidth();
        int i = 1;
        while (i < inputs.length) {
            if (inputs[i].getWidth() != width) {
                throw new Exception("Bus width mismatch in StdLogicVector.resolve!");
            }
            ++i;
        }
        int n_ZZZ = 0;
        int index_not_ZZZ = -1;
        int i2 = 0;
        while (i2 < inputs.length) {
            if (inputs[i2].is_ZZZ()) {
                ++n_ZZZ;
            } else {
                index_not_ZZZ = i2;
            }
            ++i2;
        }
        if (n_ZZZ == inputs.length) {
            return new StdLogicVector(width, new StdLogic1164(4));
        }
        if (n_ZZZ == inputs.length - 1) {
            return inputs[index_not_ZZZ].copy();
        }
        StdLogicVector result = new StdLogicVector(width);
        StdLogic1164[] bits = new StdLogic1164[inputs.length];
        int j = 0;
        while (j < width) {
            int i3 = 0;
            while (i3 < inputs.length) {
                bits[i3] = inputs[i3].getBitAt(j);
                ++i3;
            }
            result.setBitAt(j, StdLogic1164.resolve(bits));
            ++j;
        }
        return result;
    }

    public StdLogic1164 and_onebit() {
        int tmp = this._U_mask != 0L ? 0 : ((this._1_mask | this._0_mask) != this._length_mask ? 1 : (this._1_mask == this._length_mask ? 3 : 2));
        return new StdLogic1164(tmp);
    }

    public StdLogic1164 or_onebit() {
        int tmp = this._U_mask != 0L ? 0 : ((this._1_mask | this._0_mask) != this._length_mask ? 1 : (this._0_mask == this._length_mask ? 2 : 3));
        return new StdLogic1164(tmp);
    }

    public StdLogic1164 xor_onebit() {
        int tmp;
        if (this._U_mask != 0L) {
            tmp = 0;
        } else if ((this._1_mask | this._0_mask) != this._length_mask) {
            tmp = 1;
        } else {
            boolean even = true;
            long _tmp = this._1_mask;
            int i = 0;
            while (i < this.n_bits) {
                if ((_tmp & 1L) == 1L) {
                    even = !even;
                }
                _tmp >>= 1;
                ++i;
            }
            tmp = even ? 2 : 3;
        }
        return new StdLogic1164(tmp);
    }

    public StdLogic1164 nand_onebit() {
        return StdLogic1164.not(this.and_onebit());
    }

    public StdLogic1164 nor_onebit() {
        return StdLogic1164.not(this.or_onebit());
    }

    public StdLogic1164 xnor_onebit() {
        return StdLogic1164.not(this.xor_onebit());
    }

    public StdLogicVector append(StdLogicVector tail) {
        if (tail == null) {
            StdLogicVector.msg("-E- no use to append a null argument, returning a clone instead!");
            return this.copy();
        }
        int n_this = this.getWidth();
        int n_tail = tail.getWidth();
        int n_big = n_this + n_tail;
        StdLogicVector big = new StdLogicVector(n_big);
        big._U_mask = this._U_mask << n_tail | tail._U_mask;
        big._X_mask = this._X_mask << n_tail | tail._X_mask;
        big._0_mask = this._0_mask << n_tail | tail._0_mask;
        big._1_mask = this._1_mask << n_tail | tail._1_mask;
        big._Z_mask = this._Z_mask << n_tail | tail._Z_mask;
        big._W_mask = this._W_mask << n_tail | tail._W_mask;
        big._L_mask = this._L_mask << n_tail | tail._L_mask;
        big._H_mask = this._H_mask << n_tail | tail._H_mask;
        big._D_mask = this._D_mask << n_tail | tail._D_mask;
        return big;
    }

    public StdLogicVector append(StdLogic1164 tail) {
        if (tail == null) {
            StdLogicVector.msg("-E- no use to append a null argument, returning a clone instead!");
            return this.copy();
        }
        StdLogicVector big = new StdLogicVector(this.n_bits + 1);
        int m = tail.intValue();
        big._U_mask = this._U_mask << 1 | (long)(m == 0 ? 1 : 0);
        big._X_mask = this._X_mask << 1 | (long)(m == 1 ? 1 : 0);
        big._0_mask = this._0_mask << 1 | (long)(m == 2 ? 1 : 0);
        big._1_mask = this._1_mask << 1 | (long)(m == 3 ? 1 : 0);
        big._Z_mask = this._Z_mask << 1 | (long)(m == 4 ? 1 : 0);
        big._W_mask = this._W_mask << 1 | (long)(m == 5 ? 1 : 0);
        big._L_mask = this._L_mask << 1 | (long)(m == 6 ? 1 : 0);
        big._H_mask = this._H_mask << 1 | (long)(m == 7 ? 1 : 0);
        big._D_mask = this._D_mask << 1 | (long)(m == 8 ? 1 : 0);
        return big;
    }

    public static StdLogicVector concat(StdLogicVector head, StdLogicVector tail) {
        return head.append(tail);
    }

    public StdLogicVector subset(int upper, int lower) {
        if (lower < 0) {
            lower = 0;
        }
        if (lower >= this.getWidth()) {
            lower = this.getWidth() - 1;
        }
        if (upper < lower) {
            upper = lower;
        }
        if (upper >= this.getWidth()) {
            upper = this.getWidth() - 1;
        }
        StdLogicVector result = new StdLogicVector(upper - lower + 1);
        int i = 0;
        while (i < result.getWidth()) {
            result.setBitAt(i, this.getBitIntValueAt(i + lower));
            ++i;
        }
        return result;
    }

    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        StdLogicVector L = (StdLogicVector)arg;
        if (L == null) {
            return false;
        }
        if (this.getWidth() != L.getWidth()) {
            return false;
        }
        if (this._U_mask != L._U_mask) {
            return false;
        }
        if (this._X_mask != L._X_mask) {
            return false;
        }
        if (this._0_mask != L._0_mask) {
            return false;
        }
        if (this._1_mask != L._1_mask) {
            return false;
        }
        if (this._Z_mask != L._Z_mask) {
            return false;
        }
        if (this._W_mask != L._W_mask) {
            return false;
        }
        if (this._L_mask != L._L_mask) {
            return false;
        }
        if (this._H_mask != L._H_mask) {
            return false;
        }
        return this._D_mask == L._D_mask;
    }

    public static boolean isEqual(StdLogicVector L, StdLogicVector R) {
        if (L == null) {
            return false;
        }
        return L.equals(R);
    }

    public boolean has_UXZ() {
        return (this._0_mask | this._1_mask) != this._length_mask;
    }

    public boolean has_U() {
        return this._U_mask != 0L;
    }

    public boolean has_X() {
        return this._X_mask != 0L;
    }

    public boolean has_0() {
        return this._0_mask != 0L;
    }

    public boolean has_1() {
        return this._1_mask != 0L;
    }

    public boolean has_Z() {
        return this._Z_mask != 0L;
    }

    public boolean has_L() {
        return this._L_mask != 0L;
    }

    public boolean has_H() {
        return this._H_mask != 0L;
    }

    public boolean has_W() {
        return this._W_mask != 0L;
    }

    public boolean has_D() {
        return this._D_mask != 0L;
    }

    public boolean is_000() {
        return this._0_mask == this._length_mask;
    }

    public boolean is_111() {
        return this._1_mask == this._length_mask;
    }

    public boolean is_ZZZ() {
        return this._Z_mask == this._length_mask;
    }

    public static boolean check(StdLogicVector L, StdLogicVector R) throws Exception {
        if (L == null) {
            throw new Exception("StdLogicVector.check: L is null");
        }
        if (R == null) {
            throw new Exception("StdLogicVector.check: R is null");
        }
        if (L.getWidth() != R.getWidth()) {
            throw new Exception("StdLogicVector.check: width mismatch " + L.getWidth() + " " + R.getWidth());
        }
        if (L.has_UXZ()) {
            return false;
        }
        return !R.has_UXZ();
    }

    public static boolean isLessThan(StdLogicVector L, StdLogicVector R) throws Exception {
        StdLogicVector.check(L, R);
        return L.getValue() < R.getValue();
    }

    public static boolean isLessEqual(StdLogicVector L, StdLogicVector R) throws Exception {
        StdLogicVector.check(L, R);
        return L.getValue() <= R.getValue();
    }

    public static boolean isGreaterThan(StdLogicVector L, StdLogicVector R) throws Exception {
        StdLogicVector.check(L, R);
        return L.getValue() > R.getValue();
    }

    public static boolean isGreaterEqual(StdLogicVector L, StdLogicVector R) throws Exception {
        StdLogicVector.check(L, R);
        return L.getValue() <= R.getValue();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StdLogicVector[");
        sb.append(this.n_bits);
        sb.append(":");
        int i = this.n_bits - 1;
        while (i >= 0) {
            sb.append(StdLogic1164.chars[this.getBitIntValueAt(i)]);
            --i;
        }
        sb.append("]");
        return sb.toString();
    }

    public void parse(String s) throws NumberFormatException {
        String ss = s.trim().toLowerCase();
        int n_chars = this.getNumberOfHexChars();
        if (ss.equals("uuu")) {
            this.setValue(-2L);
        } else if (ss.equals("xxx")) {
            this.setValue(-1L);
        } else if (ss.equals("zzz")) {
            this.setValue(-3L);
        } else if (ss.endsWith("_b")) {
            if (ss.length() < this.n_bits + 2) {
                throw new NumberFormatException("-E- Too few bits in '" + ss + "', expected " + this.n_bits + " bits");
            }
            try {
                int lsb_pos = ss.length() - 3;
                int i = 0;
                while (i < this.n_bits) {
                    char c = ss.charAt(lsb_pos - i);
                    this.setBitAt(i, new StdLogic1164(c));
                    ++i;
                }
            }
            catch (Exception e) {
                throw new NumberFormatException("-E- Not in binary format '" + ss + "', expected " + this.n_bits);
            }
        } else if (ss.endsWith("_h")) {
            if (ss.length() < n_chars + 2) {
                throw new NumberFormatException("-E- Too few chars in '" + ss + "', expected " + n_chars + " chars");
            }
            try {
                int lsb_pos = ss.length() - 3;
                int i = 0;
                while (i < this.getNumberOfHexChars()) {
                    char c = ss.charAt(lsb_pos - i);
                    this.decodeHex(4 * i, c);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new NumberFormatException("-E- Not in hex format '" + ss + "', expected " + this.n_bits);
            }
        } else if (ss.startsWith("0x")) {
            if (ss.length() < n_chars + 2) {
                throw new NumberFormatException("-E- Too few chars in '" + ss + "', expected " + n_chars + " chars");
            }
            try {
                int lsb_pos = ss.length() - 1;
                int i = 0;
                while (i < this.getNumberOfHexChars()) {
                    char c = ss.charAt(lsb_pos - i);
                    this.decodeHex(4 * i, c);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new NumberFormatException("-E- Not in hex format '" + ss + "', expected " + this.n_bits);
            }
        } else {
            this.setValue(Long.parseLong(s));
        }
    }

    private void decodeHex(int index, char c) {
        switch (c) {
            case '0': {
                this.setFourBits(index, '0', '0', '0', '0');
                break;
            }
            case '1': {
                this.setFourBits(index, '0', '0', '0', '1');
                break;
            }
            case '2': {
                this.setFourBits(index, '0', '0', '1', '0');
                break;
            }
            case '3': {
                this.setFourBits(index, '0', '0', '1', '1');
                break;
            }
            case '4': {
                this.setFourBits(index, '0', '1', '0', '0');
                break;
            }
            case '5': {
                this.setFourBits(index, '0', '1', '0', '1');
                break;
            }
            case '6': {
                this.setFourBits(index, '0', '1', '1', '0');
                break;
            }
            case '7': {
                this.setFourBits(index, '0', '1', '1', '1');
                break;
            }
            case '8': {
                this.setFourBits(index, '1', '0', '0', '0');
                break;
            }
            case '9': {
                this.setFourBits(index, '1', '0', '0', '1');
                break;
            }
            case 'a': {
                this.setFourBits(index, '1', '0', '1', '0');
                break;
            }
            case 'b': {
                this.setFourBits(index, '1', '0', '1', '1');
                break;
            }
            case 'c': {
                this.setFourBits(index, '1', '1', '0', '0');
                break;
            }
            case 'd': {
                this.setFourBits(index, '1', '1', '0', '1');
                break;
            }
            case 'e': {
                this.setFourBits(index, '1', '1', '1', '0');
                break;
            }
            case 'f': {
                this.setFourBits(index, '1', '1', '1', '1');
                break;
            }
            case 'h': {
                this.setFourBits(index, 'h', 'h', 'h', 'h');
                break;
            }
            case 'l': {
                this.setFourBits(index, 'l', 'l', 'l', 'l');
                break;
            }
            case 'w': {
                this.setFourBits(index, 'w', 'w', 'w', 'w');
                break;
            }
            case 'x': {
                this.setFourBits(index, 'x', 'x', 'x', 'x');
                break;
            }
            case 'z': {
                this.setFourBits(index, 'z', 'z', 'z', 'z');
                break;
            }
            case '-': {
                this.setFourBits(index, 'd', 'd', 'd', 'd');
            }
        }
    }

    private void setFourBits(int index, char c3, char c2, char c1, char c0) {
        int i = index;
        if (i < this.n_bits) {
            this.setBitAt(i++, new StdLogic1164(c0));
        }
        if (i < this.n_bits) {
            this.setBitAt(i++, new StdLogic1164(c1));
        }
        if (i < this.n_bits) {
            this.setBitAt(i++, new StdLogic1164(c2));
        }
        if (i < this.n_bits) {
            this.setBitAt(i++, new StdLogic1164(c3));
        }
    }

    private int getNumberOfHexChars() {
        return (this.n_bits + 3) / 4;
    }

    private String fillWithChar(char c) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.getNumberOfHexChars()) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public String toHexString() {
        long value = this.getValue();
        String raw = null;
        raw = value == -1L ? this.fillWithChar('X') : (value == -2L ? this.fillWithChar('U') : (value == -3L ? this.fillWithChar('Z') : Long.toHexString(value)));
        return this.addLeadingZeroes(raw, this.getNumberOfHexChars()) + "_H";
    }

    public String toHexString(int minWidth) {
        return this.rightAlign(this.toHexString(), minWidth);
    }

    public String toDecString() {
        long value = this.getValue();
        String raw = null;
        raw = value == -1L ? "XXX" : (value == -2L ? "UUU" : (value == -3L ? "ZZZ" : Long.toString(value)));
        return raw;
    }

    public String toDecString(int minWidth) {
        return this.rightAlign(this.toDecString(), minWidth);
    }

    public String toDecStringPadded() {
        int width = (int)Math.ceil((double)this.n_bits * 0.30103);
        long value = this.getValue();
        String raw = null;
        raw = value == -1L ? "XXX" : (value == -2L ? "UUU" : (value == -3L ? "ZZZ" : Long.toString(value)));
        return this.addLeadingZeroes(raw, width);
    }

    public String toDecStringPadded(int minWidth) {
        return this.rightAlign(this.toDecStringPadded(), minWidth);
    }

    public String toBinString() {
        StringBuffer sb = new StringBuffer();
        int i = this.n_bits - 1;
        while (i >= 0) {
            sb.append(StdLogic1164.chars[this.getBitIntValueAt(i)]);
            --i;
        }
        return this.addLeadingZeroes(sb.toString(), this.n_bits) + "_B";
    }

    public String toBinString(int minWidth) {
        return this.rightAlign(this.toBinString(), minWidth);
    }

    public String addLeadingZeroes(String s, int width) {
        StringBuffer sb = new StringBuffer();
        int n_zeroes = width - s.length();
        int i = 0;
        while (i < n_zeroes) {
            sb.append('0');
            ++i;
        }
        sb.append(s);
        return sb.toString();
    }

    public String rightAlign(String s, int minWidth) {
        int n_spaces = minWidth - s.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < n_spaces) {
            sb.append(' ');
            ++i;
        }
        sb.append(s);
        return sb.toString();
    }

    public String getWidthString() {
        return "<" + (this.n_bits - 1) + ":0>";
    }

    public static void msg(String msg) {
        System.out.println(msg);
    }

    public static void demonstrateHotspot101Bug(int n_bits) {
        StdLogicVector.msg("-I- HotSpot 1.0.1 crash started..., n_bits=" + n_bits);
        StdLogicVector vector_0 = new StdLogicVector(n_bits, 0L);
        StdLogicVector vector_1 = new StdLogicVector(n_bits, 1L);
        StdLogicVector.msg("... got vector for '0': " + vector_0);
        StdLogicVector.msg("... got vector for '1': " + vector_1);
        long t = 0L;
        StdLogicVector vector_t = vector_0.copy();
        int MAX = (int)Math.min(1000000L, bit_mask[n_bits] - 1L);
        int i = 0;
        while (i < MAX) {
            if (++t != (vector_t = vector_t.incr()).getValue()) {
                StdLogicVector.msg("-E- vector_t increment failed for t= " + t);
                StdLogicVector.msg("-E- vector_t value is= " + vector_t);
                return;
            }
            if ((t & 0xFFFFL) == 65535L) {
                StdLogicVector.msg("-I- increment ok up to t= " + t);
            }
            ++i;
        }
        StdLogicVector.msg("-I- HotSpot 1.0.1 crash test finished OK for n_bits= " + n_bits);
    }

    public static void selftest() {
        StdLogicVector.msg("StdLogicVector selftest...");
        StdLogicVector V = new StdLogicVector(8);
        StdLogicVector W = new StdLogicVector(8, 63L);
        StdLogicVector X = new StdLogicVector(16, "00001010111011Z1");
        StdLogicVector Y = W.copy();
        StdLogicVector.msg("V= " + V.toString());
        StdLogicVector.msg("W= " + W.toString() + "\nhex: " + W.toHexString(10) + "\ndec: " + W.toDecString(10) + "\nbin: " + W.toBinString(10));
        StdLogicVector.msg("X= " + X.toString() + "dec= " + X.toDecStringPadded(15) + "hex= " + X.toHexString(10) + "bin= " + X.toBinString(20));
        StdLogicVector.msg("Y= " + Y.toString());
        StdLogicVector.msg("VWXY.has_UXZ: " + V.has_UXZ() + " " + W.has_UXZ() + " " + X.has_UXZ() + " " + Y.has_UXZ());
        int i = 0;
        while (i < 260) {
            Y = new StdLogicVector(8, i);
            StdLogicVector.msg("Y= " + Y.toHexString(6) + Y.toDecString(6) + Y.toBinString(14));
            i += 7;
        }
        try {
            StdLogicVector.msg("testing SHR (1)...");
            X = new StdLogicVector(16, "0U001010111011Z1");
            int i2 = 0;
            while (i2 <= X.getWidth()) {
                StdLogicVector.msg("SHR: " + X.toBinString(20) + X.shr_logical(i2).toBinString(20));
                ++i2;
            }
            StdLogicVector.msg("testing SHR (2)...");
            X = new StdLogicVector(16, "1U001010111011Z1");
            int i3 = 0;
            while (i3 <= X.getWidth()) {
                StdLogicVector.msg("SHR: " + X.toBinString(20) + X.shr_logical(i3).toBinString(20));
                ++i3;
            }
            StdLogicVector.msg("testing SHR (3)...");
            X = new StdLogicVector(16, "X000Z000W000H011");
            int i4 = 0;
            while (i4 <= X.getWidth()) {
                StdLogicVector.msg("SHR: " + X.toBinString(20) + X.shr_logical(i4).toBinString(20));
                ++i4;
            }
            StdLogicVector.msg("");
            StdLogicVector.msg("testing SHRA...");
            X = new StdLogicVector(16, "10001010111011Z1");
            int i5 = 0;
            while (i5 <= X.getWidth()) {
                StdLogicVector.msg("SHR: " + X.toBinString(20) + X.shr_arithmetical(i5).toBinString(20));
                ++i5;
            }
            StdLogicVector.msg("");
            StdLogicVector.msg("testing SHL...");
            X = new StdLogicVector(16, "10001010111011Z1");
            int i6 = 0;
            while (i6 <= X.getWidth()) {
                StdLogicVector.msg("SHL: " + X.toBinString(20) + X.shl(i6).toBinString(20));
                ++i6;
            }
            StdLogicVector.msg("");
            StdLogicVector.msg("testing ROR...");
            X = new StdLogicVector(16, "10001010111011Z1");
            int i7 = 0;
            while (i7 <= X.getWidth()) {
                StdLogicVector.msg("ROR: " + X.toBinString(20) + X.ror(i7).toBinString(20));
                ++i7;
            }
            StdLogicVector.msg("");
            StdLogicVector.msg("testing ROL...");
            X = new StdLogicVector(16, "10001010111011Z1");
            int i8 = 0;
            while (i8 <= X.getWidth()) {
                StdLogicVector.msg("ROL: " + X.toBinString(20) + X.rol(i8).toBinString(20));
                ++i8;
            }
            StdLogicVector.msg("");
            StdLogicVector.msg("testing APPEND... (ROLLLED copies)");
            X = new StdLogicVector(4, "100U");
            Y = X.copy();
            Y = Y.append(X.rol(1));
            Y = Y.append(X.rol(2));
            Y = Y.append(X.rol(3));
            StdLogicVector.msg("Append: " + X.toBinString(10) + Y.toBinString(20));
            StdLogicVector.msg("");
            StdLogicVector.msg("testing INC/DEC...");
            String[] demo = new String[]{"0000", "0001", "1111", "0100", "0U00", "0ZZ0", "001L"};
            int i9 = 0;
            while (i9 < demo.length) {
                X = new StdLogicVector(4, demo[i9]);
                StdLogicVector.msg("X: " + X.toBinString(10) + "  INC: " + X.incr().toBinString() + "  DEC: " + X.decr().toBinString());
                ++i9;
            }
            StdLogicVector.msg("");
            StdLogicVector.msg("Parsing: ");
            X = new StdLogicVector(15);
            String[] trip = new String[]{"01uxwdzUXWDZhH00_b", "0xABCD", "0xABCD_H", "4711"};
            int i10 = 0;
            while (i10 < trip.length) {
                X.parse(trip[i10]);
                StdLogicVector.msg("s=" + trip[i10] + X.toBinString(20));
                ++i10;
            }
            X = new StdLogicVector(16, "01uxwdzuX01001110_b");
            StdLogicVector.msg("X = " + X.toBinString(20));
            StdLogicVector.msg("X.subset(15,13)= " + X.subset(15, 13).toBinString(20));
            StdLogicVector.msg("X.subset(20,-5)= " + X.subset(20, -5).toBinString(20));
            StdLogicVector.msg("X.subset(10,15)= " + X.subset(10, 15).toBinString(20));
        }
        catch (Exception e) {
            StdLogicVector.msg("-E- got an exception: " + e);
            e.printStackTrace();
        }
        StdLogicVector.msg("StdLogicVector selftest ok.");
    }

    public static void testShiftRight() {
        long[] values = new long[]{0L, 255L, 65280L};
        StdLogicVector X = null;
        try {
            StdLogicVector.msg("testing SHR (3)...");
            int i = 0;
            while (i < values.length) {
                X = new StdLogicVector(16, values[i]);
                StdLogicVector.msg(X.toBinString());
                StdLogicVector.msg(X.shr_logical(1).toBinString());
                StdLogicVector.msg(X.shr_logical(2).toBinString());
                StdLogicVector.msg(X.shr_logical(3).toBinString());
                StdLogicVector.msg(X.shr_logical(4).toBinString());
                StdLogicVector.msg(X.shr_logical(15).toBinString());
                ++i;
            }
            StdLogicVector.msg("\ntesting SHRA...");
            int i2 = 0;
            while (i2 < values.length) {
                X = new StdLogicVector(16, values[i2]);
                StdLogicVector.msg(X.toBinString());
                StdLogicVector.msg(X.shr_arithmetical(1).toBinString());
                StdLogicVector.msg(X.shr_arithmetical(2).toBinString());
                StdLogicVector.msg(X.shr_arithmetical(3).toBinString());
                StdLogicVector.msg(X.shr_arithmetical(4).toBinString());
                StdLogicVector.msg(X.shr_arithmetical(15).toBinString());
                ++i2;
            }
        }
        catch (Exception e) {
            StdLogicVector.msg(e.toString());
        }
    }

    public static void testGetSignedValue() {
        long[] values = new long[]{0L, 1L, 2L, 3L, 65535L, 65534L, 65533L, 65532L};
        int i = 0;
        while (i < values.length) {
            StdLogicVector u = new StdLogicVector(16, values[i]);
            System.out.println(u.toBinString() + " " + values[i] + " signed value: " + u.getSignedValue());
            ++i;
        }
    }

    public static void main(String[] argv) {
        StdLogicVector.testGetSignedValue();
        StdLogicVector.testShiftRight();
    }
}

