/*
 * Decompiled with CFR 0.152.
 */
package hades.models;

import hades.gui.PropertySheet;
import hades.simulator.SimObject;
import hades.symbols.FigWrapper;
import hades.symbols.Symbol;
import hades.utils.NameMangler;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.objects.FigAttribs;
import jfig.utils.ExceptionTracer;

public class FigObject
extends SimObject
implements Serializable {
    private static final long serialVersionUID = -8980702007182221000L;
    FigWrapper figwrapper = null;
    String figresourcename = "/hades/models/FigObject.fig";

    public String getFigresourcename() {
        return this.figresourcename;
    }

    public void setFigresourcename(String s) {
        this.figresourcename = s;
        this.initialize(s);
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.figresourcename};
        return externals;
    }

    public boolean needsDynamicSymbol() {
        return true;
    }

    public void constructDynamicSymbol() {
        this.symbol = new Symbol();
        this.symbol.setParent(this);
        if (this.figwrapper != null) {
            this.symbol.addMember(this.figwrapper);
        }
        FigAttribs attribs = this.symbol.getAttributes();
        attribs.currentLayer = 85;
        this.symbol.changeLayerRecursively(attribs);
        if (SimObject.debug) {
            this.message("-I- FigObject: constructDynamicSymbol ok, Symbol is:");
            this.message("  " + this.symbol);
        }
    }

    public boolean initialize(String s) {
        this.figresourcename = "";
        try {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            if (n_tokens == 1) {
                this.figresourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else if (n_tokens == 2) {
                this.versionId = Integer.parseInt(st.nextToken());
                this.figresourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else {
                throw new Exception(s);
            }
            this.figwrapper = new FigWrapper();
            this.figwrapper.setSimObject(this);
            this.figwrapper.initialize(" 0 0 " + this.figresourcename);
        }
        catch (Exception e) {
            this.message("-E- FigObject.initialize(): " + e);
            this.message("-E- offending input is '" + s + "'");
            ExceptionTracer.message("-E- FigObject.inialize: " + s);
            ExceptionTracer.trace(e);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.figresourcename));
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this FigObject...");
        }
        String[] fields = new String[]{"instance name:", "name", "FIG file/resource name:", "figresourcename"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("FigObject parameters:\nspecify the Java resource name of the FIG file, \ne.g. '/hades/examples/tutorial/figs/welcome.fig' \n");
        this.propertySheet.setVisible(true);
    }

    public FigWrapper getFigWrapper() {
        return this.figwrapper;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".elaborate()...ignored.");
        }
    }

    public String toString() {
        return "FigObject_" + this.getFullName();
    }
}

