/*
 * Decompiled with CFR 0.152.
 */
package hades.models;

import hades.gui.Console;
import hades.gui.Editor;
import hades.manager.DesignManager;
import hades.models.InputConnector;
import hades.models.OutputConnector;
import hades.models.gates.Inv;
import hades.models.io.Ipin;
import hades.models.io.Opin;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.symbols.BboxRectangle;
import hades.symbols.ClassLabel;
import hades.symbols.InstanceLabel;
import hades.symbols.PortLabel;
import hades.symbols.PortSymbol;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import hades.utils.NameMangler;
import hades.utils.Parser;
import hades.utils.ShellSort;
import java.awt.Point;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class Design
extends SimObject
implements Serializable {
    private static final long serialVersionUID = -941297811379266157L;
    private Design parent = null;
    private Hashtable componentTable;
    private Hashtable signalTable;
    private String resourcename;
    private long versionId;

    public Design(Design parent, SimKernel simulator, String name) {
        this();
        this.name = name;
        this.parent = parent;
        this.simulator = parent == null ? simulator : parent.getSimulator();
    }

    public Design() {
        this.name = "unnamed";
        this.parent = null;
        this.simulator = null;
        this.versionId = 420815L;
        this.componentTable = new Hashtable(23);
        this.signalTable = new Hashtable(23);
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.resourcename};
        return externals;
    }

    public InputStream getResourceAsStream(String s) {
        String qualifiedname = null;
        qualifiedname = s.startsWith("/") ? s : s;
        InputStream IS = DesignManager.getDesignManager().getResourceAsStream(qualifiedname);
        if (IS == null) {
            System.err.println("-E- Design.getResourceAsStream failed for " + qualifiedname);
        }
        return IS;
    }

    public boolean initialize(String s) {
        int xpos = 0;
        int ypos = 0;
        InputStream inputstream = null;
        try {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            if (n_tokens == 5) {
                this.setName(NameMangler.decodeUnicodeEscapes(st.nextToken()));
                xpos = Integer.parseInt(st.nextToken());
                ypos = Integer.parseInt(st.nextToken());
                this.versionId = Integer.parseInt(st.nextToken());
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else if (n_tokens == 2) {
                xpos = 0;
                ypos = 0;
                this.versionId = Integer.parseInt(st.nextToken());
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else if (n_tokens == 1) {
                xpos = 0;
                ypos = 0;
                this.versionId = 1001L;
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else {
                this.message("-E- Design.initialize: unexpected number of tokens: " + n_tokens + "in String: " + s);
                return true;
            }
            if (SimObject.debug) {
                this.message("-#- Design.initialize: " + this.name + " " + xpos + " " + ypos + " " + this.versionId + " " + this.resourcename + " parent=" + this.parent);
            }
            if ((inputstream = DesignManager.getDesignManager().getInputStream(this, this.resourcename)) != null) {
                Parser.parseDesign(this, inputstream);
            } else {
                this.message("-E- (Sub)Design not found: " + this.resourcename + "\n" + "    Please check that the design and symbol file are available,\n" + "    Also check your CLASSPATH and DesignManager settings.");
            }
            if (SimObject.debug) {
                this.printComponents();
            }
        }
        catch (Exception e) {
            this.message("-W- Design.initialize: " + e);
            ExceptionTracer.trace(e);
        }
        return true;
    }

    public void configure() {
        this.message("Design.configure: constructing new Editor, please wait...");
        try {
            Editor editor = new Editor();
            Design newDesign = new Design();
            newDesign.setEditor(editor);
            newDesign.setVisible(true);
            InputStream inputStream = DesignManager.getDesignManager().getInputStream(this, this.resourcename);
            Parser.parseDesign(newDesign, inputStream);
            newDesign.setVisible(true);
            editor.setDesign(newDesign);
            editor.rebuildObjectList(newDesign);
            editor.updateWindowTitle();
            editor.createNewSimulator();
            if (SetupManager.getBoolean("Hades.Editor.AutoZoomFit", false)) {
                editor.doZoomFit();
            }
            editor.doFullRedraw();
            editor.getSimulator().runForever();
            editor.statusMessage("...ready! Please select a command.");
        }
        catch (Exception e) {
            this.message("-E- Design.configure(): " + e);
            ExceptionTracer.trace(e);
        }
    }

    public void setDesign(Design parent) {
        this.parent = parent;
        this.simulator = parent.getSimulator();
    }

    public void setSimulator(SimKernel simulator) {
        if (SimObject.debug) {
            this.message("-#- Design<" + this.getName() + ">.setSimulator()... ");
        }
        this.simulator = simulator;
        Enumeration e = this.getComponents();
        while (e.hasMoreElements()) {
            SimObject tmp = (SimObject)e.nextElement();
            tmp.setSimulator(this.simulator);
            if (!SimObject.debug) continue;
            this.message("-#- setting simulator for : " + tmp.getName());
        }
        Enumeration e2 = this.getSignals();
        while (e2.hasMoreElements()) {
            Signal stmp = (Signal)e2.nextElement();
            stmp.setSimulator(this.simulator);
            if (!SimObject.debug) continue;
            this.message("-#- setting simulator for signal: " + stmp.getName());
        }
    }

    public void setEditor(Editor editor) {
        if (SimObject.debug) {
            this.message("-#- Design<" + this.getName() + ">.setEditor()... ");
        }
        this.editor = editor;
        Enumeration e = this.getComponents();
        while (e.hasMoreElements()) {
            SimObject tmp = (SimObject)e.nextElement();
            tmp.setEditor(this.editor);
            if (!SimObject.debug) continue;
            this.message("-#- setting editor for : " + tmp.getName());
        }
    }

    public void setDesignName(String name) {
        this.name = name;
    }

    public String getSymbolResourceName() {
        String s = this.resourcename;
        if (SimObject.debug) {
            this.message("-#- Design.gSRN(): " + s);
        }
        if (s.endsWith(".hds")) {
            s = s.substring(0, s.lastIndexOf(".hds"));
            s = s + ".sym";
        } else {
            this.message("-W- design name does not end with '.hds': " + s);
            s = s.substring(0, s.lastIndexOf("."));
            s = s + ".sym";
            this.message("-W- trying to load symbol from: " + s);
        }
        if (SimObject.debug) {
            this.message("-#- Design.gSRN(): " + s);
        }
        return s;
    }

    public String getResourceName() {
        return this.resourcename;
    }

    public void setResourceName(String _name) {
        this.resourcename = _name;
    }

    public String getEscapedResourceName() {
        return NameMangler.encodeWithUnicodeEscapes(this.resourcename);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-#- Design: " + this.getFullName() + " elaborate...");
        }
        Enumeration e = this.getComponents();
        while (e.hasMoreElements()) {
            SimObject tmp = (SimObject)e.nextElement();
            tmp.elaborate(arg);
            if (!SimObject.debug) continue;
            this.message("-#- Design.elaborating: " + tmp.getFullName());
        }
        Enumeration e2 = this.getSignals();
        while (e2.hasMoreElements()) {
            Signal stmp = (Signal)e2.nextElement();
            stmp.elaborate(arg);
            if (!SimObject.debug) continue;
            this.message("-#- Design.elaborating: " + stmp.getFullName());
        }
        if (SimObject.debug) {
            this.message("Design: " + this.getFullName() + " elaborate ok.");
        }
    }

    public void addComponent(SimObject simobj) {
        if (simobj == null) {
            return;
        }
        this.addComponent(simobj, simobj.getName());
    }

    public void addComponent(SimObject simobj, String name) {
        if (simobj == null) {
            return;
        }
        if (this.componentTable.containsKey(name)) {
            name = this.constructUniqueComponentName(name);
        }
        name = name.intern();
        simobj.setName(name);
        this.componentTable.put(name, simobj);
        simobj.setParent(this);
        simobj.setSimulator(this.simulator);
    }

    public String constructUniqueComponentName(String name) {
        if (SimObject.debug) {
            ExceptionTracer.message("constructUniqueComponentName from '" + name + "'... ");
        }
        if (name.length() < 1) {
            this.constructUniqueComponentName("i0");
        }
        int idx = name.length() - 1;
        while (idx > 0 && Character.isDigit(name.charAt(idx))) {
            --idx;
        }
        String base = name.substring(0, idx + 1);
        int n = idx + 1 < name.length() ? Integer.parseInt(name.substring(idx + 1, name.length())) : 0;
        while (this.componentTable.containsKey(base + ++n)) {
        }
        return base + n;
    }

    public String changeComponentName(SimObject obj, String newName) {
        if (this.componentTable.contains(obj)) {
            if (!this.componentTable.containsKey(obj.getName())) {
                this.message("-E- internal: cannot find component '" + obj.getName() + "'");
            }
            this.componentTable.remove(obj.getName());
        }
        if (this.componentTable.containsKey(newName)) {
            newName = this.constructUniqueComponentName(newName);
        }
        newName = newName.intern();
        this.componentTable.put(newName, obj);
        return newName;
    }

    public void deleteComponent(String name) {
        if (this.componentTable.containsKey(name)) {
            SimObject component = (SimObject)this.componentTable.get(name);
            Port[] ports = component.getPorts();
            Signal signal = null;
            try {
                int i = 0;
                while (i < ports.length) {
                    signal = ports[i].getSignal();
                    if (signal != null) {
                        signal.disconnect(ports[i]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ExceptionTracer.message("-W- Port length mismatch on component: " + component);
                ExceptionTracer.trace(e);
            }
            this.componentTable.remove(name);
        }
    }

    public void deleteComponent(SimObject tmp) {
        if (this.componentTable.contains(tmp)) {
            Enumeration e = this.componentTable.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (this.componentTable.get(name) != tmp) continue;
                this.deleteComponent(name);
                return;
            }
        }
    }

    public SimObject getComponent(String name) {
        return (SimObject)this.componentTable.get(name);
    }

    public Enumeration getComponents() {
        return this.componentTable.elements();
    }

    public void addSignal(Signal signal) {
        this.addSignal(signal, signal.getName());
    }

    public void addSignal(Signal signal, String name) {
        if (this.signalTable.containsKey(name)) {
            name = this.constructUniqueSignalName(name);
        }
        name = name.intern();
        signal.setName(name);
        signal.setDesign(this);
        signal.setSimulator(this.simulator);
        this.signalTable.put(name, signal);
    }

    public String constructUniqueSignalName(String name) {
        if (name.length() < 1) {
            this.constructUniqueSignalName("n0");
        }
        int idx = name.length() - 1;
        while (idx > 0 && Character.isDigit(name.charAt(idx))) {
            --idx;
        }
        String base = name.substring(0, idx + 1);
        int n = idx + 1 < name.length() ? Integer.parseInt(name.substring(idx + 1, name.length())) : 1;
        while (this.signalTable.containsKey(base + n)) {
            ++n;
        }
        return base + n;
    }

    public void deleteSignal(String name) {
        if (this.signalTable.containsKey(name)) {
            this.signalTable.remove(name);
        }
    }

    public void deleteSignal(Signal tmp) {
        if (this.signalTable.contains(tmp)) {
            Enumeration e = this.signalTable.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (this.signalTable.get(name) != tmp) continue;
                this.signalTable.remove(name);
                return;
            }
        }
    }

    public Signal getSignal(String name) {
        return (Signal)this.signalTable.get(name);
    }

    public Enumeration getSignals() {
        return this.signalTable.elements();
    }

    public Port[] getPorts() {
        if (this.ports.length == 0) {
            this.buildPorts();
        }
        return super.getPorts();
    }

    public Port getPort(String name) {
        if (this.ports.length == 0) {
            this.buildPorts();
        }
        if (SimObject.debug) {
            this.message("Design.getPort(" + name + "): found " + super.getPort(name));
        }
        return super.getPort(name);
    }

    private void buildPorts() {
        SimObject tmp;
        if (SimObject.debug) {
            this.message("-#- Design.buildPorts()...");
        }
        int n_ports = 0;
        Enumeration e = this.componentTable.elements();
        while (e.hasMoreElements()) {
            tmp = (SimObject)e.nextElement();
            if (tmp instanceof InputConnector) {
                ++n_ports;
                continue;
            }
            if (!(tmp instanceof OutputConnector)) continue;
            ++n_ports;
        }
        if (SimObject.debug) {
            this.message("... found " + n_ports + " Ports.");
        }
        this.ports = new Port[n_ports];
        int index = 0;
        Enumeration e2 = this.componentTable.elements();
        while (e2.hasMoreElements()) {
            tmp = (SimObject)e2.nextElement();
            if (tmp instanceof InputConnector) {
                if (SimObject.debug) {
                    this.message("Design.buildPorts(): found Ipin '" + tmp.getName() + "'");
                }
                this.ports[index] = tmp.getPort(tmp.getName());
                this.ports[index].setParent(this);
                ++index;
                continue;
            }
            if (!(tmp instanceof OutputConnector)) continue;
            if (SimObject.debug) {
                this.message("Design.buildPorts(): found Opin '" + tmp.getName() + "'");
            }
            this.ports[index] = tmp.getPort(tmp.getName());
            this.ports[index].setParent(this);
            ++index;
        }
        if (SimObject.debug) {
            this.message("...status: ");
            int i = 0;
            while (i < this.ports.length) {
                this.message("port[" + i + "]=" + this.ports[i]);
                ++i;
            }
        }
    }

    public void printComponents() {
        StringBuffer sb = new StringBuffer();
        sb.append("Components of Design '" + this.name + "':");
        Enumeration e = this.componentTable.elements();
        while (e.hasMoreElements()) {
            sb.append("\n   " + (SimObject)e.nextElement());
        }
        sb.append("\n");
        this.message(sb.toString());
    }

    public void printAllComponents(String indent) {
        StringBuffer sb = new StringBuffer();
        sb = this.toStringComponents(sb, "");
        sb.append("\n");
        this.message(sb.toString());
    }

    public StringBuffer toStringComponents(StringBuffer sb, String indent) {
        sb.append(indent + this.toString() + " with components:");
        indent = indent + "   ";
        Enumeration e = this.componentTable.elements();
        while (e.hasMoreElements()) {
            SimObject tmp = (SimObject)e.nextElement();
            if (tmp instanceof Design) {
                sb.append("\n");
                ((Design)tmp).toStringComponents(sb, indent);
                continue;
            }
            sb.append("\n" + indent + tmp);
        }
        return sb;
    }

    public void printToplevelSignals(String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent + "Signals of Design '" + this.name + "':");
        indent = indent + "   ";
        Enumeration e = this.signalTable.elements();
        while (e.hasMoreElements()) {
            sb.append("\n" + indent + ((Signal)e.nextElement()).toStringVerbose());
        }
        sb.append("\n");
        this.message(sb.toString());
    }

    public void printAllSignals(String indent) {
        this.printToplevelSignals(indent);
        Enumeration e = this.componentTable.elements();
        while (e.hasMoreElements()) {
            Object tmp = e.nextElement();
            if (!(tmp instanceof Design)) continue;
            ((Design)tmp).printAllSignals(indent + "   ");
        }
    }

    public int checkDesign(boolean highlightErrors) {
        int n_errors = 0;
        Console console = Console.createNewConsole();
        console.getFrame().setTitle("Check Design '" + this.name + "' messages");
        console.show();
        console.message("Checking design '" + this.name + "' ... ");
        console.message(" ");
        Enumeration e = this.componentTable.elements();
        while (e.hasMoreElements()) {
            SimObject tmp = (SimObject)e.nextElement();
            console.message("...component " + tmp.getName());
            Port[] ports = tmp.getPorts();
            int i = 0;
            while (i < ports.length) {
                if (ports[i].isInputPort() && ports[i].getSignal() == null) {
                    console.message("-E- open input port " + ports[i]);
                    ++n_errors;
                    if (highlightErrors) {
                        this.highlightComponent(tmp);
                    }
                } else if (ports[i].isPowerPort() && ports[i].getSignal() == null) {
                    console.message("-E- open Vcc/Gnd port " + ports[i]);
                    ++n_errors;
                }
                ++i;
            }
        }
        console.message("");
        Enumeration e2 = this.signalTable.elements();
        while (e2.hasMoreElements()) {
            Signal signal = (Signal)e2.nextElement();
            console.message("...signal " + signal.getName());
            int n_drivers = signal.numberOfDrivers();
            if (n_drivers < 1) {
                console.message("-E- not driven!");
                ++n_errors;
                if (!highlightErrors) continue;
                this.highlightSignal(signal);
                continue;
            }
            if (n_drivers <= 1) continue;
            console.message("-I- multiple (" + n_drivers + ") drivers.");
        }
        console.message("");
        if (n_errors > 0) {
            console.message("This design has " + n_errors + " errors.");
        } else {
            console.message("The design is ok. No errors found!");
        }
        return n_errors;
    }

    private void highlightComponent(SimObject tmp) {
        if (tmp == null) {
            return;
        }
        if (this.editor == null) {
            return;
        }
        this.editor.highlightComponent(tmp.getName());
    }

    private void highlightSignal(Signal tmp) {
        if (tmp == null) {
            return;
        }
        if (this.editor == null) {
            return;
        }
        this.editor.highlightSignal(tmp.getName());
    }

    public void tearDown() {
        if (SimObject.debug) {
            System.err.println("-#- Design.tearDown: " + this.resourcename);
        }
        Enumeration e = this.componentTable.elements();
        while (e.hasMoreElements()) {
            SimObject obj = (SimObject)e.nextElement();
            obj.tearDown();
        }
        Enumeration s = this.signalTable.elements();
        while (s.hasMoreElements()) {
            Signal signal = (Signal)s.nextElement();
            signal.tearDown();
        }
        this.simulator = null;
        super.tearDown();
    }

    public void read() {
        Thread.dumpStack();
    }

    public void write(PrintWriter ps) {
        SimObject tmp = null;
        Signal stmp = null;
        try {
            ps.println("# hades.models.Design file\n#  ");
            ps.println("[name] " + NameMangler.encodeWithUnicodeEscapes(this.name));
        }
        catch (Exception e) {
            this.message("-E- Exception in Design.write[header]: " + e);
            this.message("    while writing Design named '" + this.name + "'");
            ExceptionTracer.trace(e);
        }
        try {
            ps.println("[components]");
            Symbol symbol = null;
            int xpos = 0;
            int ypos = 0;
            String orientation = null;
            Enumeration e = this.componentTable.elements();
            while (e.hasMoreElements()) {
                Design dtmp;
                tmp = (SimObject)e.nextElement();
                symbol = tmp.getSymbol();
                if (symbol != null) {
                    xpos = symbol.getPos().x;
                    ypos = symbol.getPos().y;
                    orientation = symbol.getOrientationString();
                } else {
                    xpos = 0;
                    ypos = 0;
                    orientation = "@N";
                }
                String classname = tmp.getClass().getName();
                if (classname.startsWith("org.python.proxies.")) {
                    ps.print("hades.jpshell.JPWrapper " + tmp.getName() + " " + xpos + " " + ypos + " " + orientation);
                    if (tmp instanceof Design) {
                        dtmp = (Design)tmp;
                        ps.println(" " + dtmp.getVersionId() + "huhu " + dtmp.getEscapedResourceName());
                        continue;
                    }
                    tmp.write(ps);
                    ps.print(" Muller Muller");
                    ps.println();
                    continue;
                }
                ps.print(classname + " " + NameMangler.encodeWithUnicodeEscapes(tmp.getName()) + " " + xpos + " " + ypos + " " + orientation);
                if (tmp instanceof Design) {
                    dtmp = (Design)tmp;
                    ps.println(" " + dtmp.getVersionId() + " " + dtmp.getEscapedResourceName());
                    continue;
                }
                tmp.write(ps);
                ps.println();
            }
            ps.println("[end components]");
        }
        catch (Exception e) {
            this.message("-E- Exception in Design.write[components]: " + e);
            this.message("    while writing component: " + tmp);
            ExceptionTracer.trace(e);
        }
        try {
            ps.println("[signals]");
            Enumeration e = this.signalTable.elements();
            while (e.hasMoreElements()) {
                stmp = (Signal)e.nextElement();
                stmp.write(ps);
            }
            ps.println("[end signals]");
            ps.println("[end]");
        }
        catch (Exception e) {
            this.message("-E- Exception in Design.write[signals]: " + e);
            this.message("    while writing signal : " + tmp);
            ExceptionTracer.trace(e);
        }
    }

    public SimObject copy() {
        Design tmp = null;
        try {
            tmp = DesignManager.getDesignManager().getDesign(this.getEditor(), this.getResourceName(), false);
        }
        catch (Exception e) {
            this.message("-E- Internal error in hades.models.Design.copy() " + e);
            ExceptionTracer.trace(e);
            return null;
        }
        tmp.parent = this.parent;
        tmp.simulator = this.simulator;
        return tmp;
    }

    public Symbol createSymbol() {
        SimObject tmp;
        int n_inputs = 0;
        int n_outputs = 0;
        int width = SetupManager.getInteger("Hades.Editor.DefaultSymbolWidth", 6000);
        Enumeration e = this.componentTable.elements();
        while (e.hasMoreElements()) {
            tmp = (SimObject)e.nextElement();
            if (tmp instanceof InputConnector) {
                ++n_inputs;
                continue;
            }
            if (!(tmp instanceof OutputConnector)) continue;
            ++n_outputs;
        }
        ExceptionTracer.message("createSymbol: " + n_inputs + " " + n_outputs);
        int height = Math.max(n_inputs, n_outputs) * 600 + 600;
        Symbol symbol = new Symbol();
        symbol.setParent(this);
        BboxRectangle bbr = new BboxRectangle();
        String s = "0 0 " + width + " " + height;
        bbr.initialize(s);
        Rectangle rect = new Rectangle();
        rect.initialize(s);
        ClassLabel clabel = new ClassLabel();
        s = "150 450 " + (this.getName() != null ? this.getName() : "unnamed)");
        clabel.initialize(s);
        InstanceLabel ilabel = new InstanceLabel();
        s = "150 " + (height - 150) + " i0";
        ilabel.initialize(s);
        symbol.fastAddMember(bbr);
        symbol.fastAddMember(rect);
        symbol.fastAddMember(clabel);
        symbol.fastAddMember(ilabel);
        double[] ipin_positions = new double[n_inputs];
        Object[] ipin_array = new Object[n_inputs];
        int index = 0;
        Enumeration e2 = this.componentTable.elements();
        while (e2.hasMoreElements()) {
            tmp = (SimObject)e2.nextElement();
            if (!(tmp instanceof InputConnector)) continue;
            if (tmp.getSymbol() != null) {
                Point ipin_pos = tmp.getSymbol().getPosition();
                ipin_positions[index] = (double)ipin_pos.y * 100000.0 + (double)ipin_pos.x;
            } else {
                ipin_positions[index] = 100000.0 * ((double)index + 13.3);
            }
            ipin_array[index] = tmp;
            this.message("found Ipin: " + tmp + " " + ipin_positions[index]);
            ++index;
        }
        ShellSort.shellSort(ipin_positions, ipin_array);
        int i = 0;
        while (i < ipin_array.length) {
            tmp = (SimObject)ipin_array[i];
            PortSymbol ps = new PortSymbol();
            s = "0 " + (i * 600 + 600) + " " + tmp.getName();
            ps.initialize(s);
            symbol.fastAddMember(ps);
            PortLabel pl = new PortLabel();
            s = "150 " + (i * 600 + 750) + " " + tmp.getName();
            pl.initialize(s);
            symbol.fastAddMember(pl);
            ++i;
        }
        double[] opin_positions = new double[n_outputs];
        Object[] opin_array = new Object[n_outputs];
        index = 0;
        Enumeration e3 = this.componentTable.elements();
        while (e3.hasMoreElements()) {
            tmp = (SimObject)e3.nextElement();
            if (!(tmp instanceof OutputConnector)) continue;
            if (tmp.getSymbol() != null) {
                Point opin_pos = tmp.getSymbol().getPosition();
                opin_positions[index] = (double)opin_pos.y * 100000.0 + (double)opin_pos.x;
            } else {
                opin_positions[index] = 100000.0 * ((double)index + 13.3);
            }
            opin_array[index] = tmp;
            this.message("found opin: " + tmp + " " + opin_positions[index]);
            ++index;
        }
        ShellSort.shellSort(opin_positions, opin_array);
        int i2 = 0;
        while (i2 < opin_array.length) {
            tmp = (SimObject)opin_array[i2];
            PortSymbol ps = new PortSymbol();
            s = "" + width + " " + (i2 * 600 + 600) + " " + tmp.getName();
            ps.initialize(s);
            symbol.fastAddMember(ps);
            PortLabel pl = new PortLabel();
            s = "" + (width - 150) + " " + (i2 * 600 + 750) + " 3 " + tmp.getName();
            pl.initialize(s);
            symbol.fastAddMember(pl);
            ++i2;
        }
        symbol.update_bbox();
        symbol.build_sc_bbox();
        if (SimObject.debug) {
            this.message("-I- CreateSymbol: " + symbol);
        }
        return symbol;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + this.getResourceName();
    }

    public String toString() {
        return "Design: " + this.getFullName();
    }

    public static void usage() {
        ExceptionTracer.message("Usage: java hades.models.Design <n-inverters>");
        ExceptionTracer.message("Example: java hades.models.Design 10");
        System.exit(0);
    }

    public static void main(String[] argv) {
        int n_inverters = 10;
        if (argv.length != 1) {
            Design.usage();
        } else {
            n_inverters = Integer.parseInt(argv[0]);
        }
        if (n_inverters < 2) {
            n_inverters = 2;
        }
        Design.getTestDesign(n_inverters);
    }

    public static Design getTestDesign(int n_inverters) {
        ExceptionTracer.message("Design self test started...");
        SimKernel S = new SimKernel();
        Design D = new Design(null, S, "Inverter chain");
        ExceptionTracer.message("creating components...");
        int i = 0;
        while (i < n_inverters) {
            Inv inv = new Inv();
            D.addComponent(inv, "I000" + i);
            ++i;
        }
        int i2 = 0;
        while (i2 < n_inverters) {
            Ipin ipin = new Ipin();
            D.addComponent(ipin, "in_" + i2);
            Opin opin = new Opin();
            D.addComponent(opin, "out_" + i2);
            ++i2;
        }
        ExceptionTracer.message("creating signals...");
        Signal s = null;
        int i3 = 0;
        while (i3 < n_inverters - 1) {
            s = new Signal("signal" + i3);
            s.addSender(D.getComponent("I000" + i3).getPort("Y"));
            s.addReceiver(D.getComponent("I000" + (i3 + 1)).getPort("A"));
            D.addSignal(s);
            ++i3;
        }
        D.printToplevelSignals("");
        ExceptionTracer.message("starting simulation...");
        return D;
    }
}

