/*
 * Decompiled with CFR 0.152.
 */
package hades.manager.tree;

import hades.gui.ColibriCreateCommand;
import hades.gui.Editor;
import hades.manager.Browser;
import hades.manager.ComponentInfo;
import hades.manager.DesignManager;
import hades.manager.InfoPanel;
import hades.manager.TreeManager;
import hades.manager.tree.SortedTreeNode;
import hades.models.Design;
import hades.simulator.SimObject;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimObjectTreeNode
extends SortedTreeNode {
    static final long serialVersionUID = -8787788237509947205L;
    static ImageIcon _icon = SimObjectTreeNode.loadIcon("/hades/manager/icons/simobj.gif");
    ComponentInfo clb;
    String name;

    public ImageIcon getIcon() {
        return _icon;
    }

    public void loadComponentInfo() {
        SimObjectTreeNode.msg("-#- loading CLB file...");
        try {
            this.clb = new ComponentInfo(TreeManager.getFullPathname(this));
        }
        catch (Exception e) {
            SimObjectTreeNode.msg("-E- could not load ComponentInfo .clb file: " + e);
        }
    }

    public void handleTreeSelection(Browser browser) {
        SimObjectTreeNode.msg("-#- SimObjTN.handleTreeSelection: " + this.toString());
        if (this.clb == null) {
            this.loadComponentInfo();
        }
        String imagepath = this.clb.getImagepath();
        if (debug) {
            SimObjectTreeNode.msg("-#- setting thumbnail from: " + imagepath);
        }
        browser.setComponentThumbnail(DesignManager.getDesignManager().getThumbnail(imagepath));
        InfoPanel ip = browser.getInfoPanel();
        ip.setName(this.toString());
        ip.setAuthor(this.clb.getAuthor());
        ip.setVersion(this.clb.getVersion());
        ip.setInfoText(this.clb.getDescription());
    }

    public void handleDoubleClick(Browser browser) {
        SimObjectTreeNode.msg("-#- SimObjectTN.handleDoubleClick: " + this.toString());
        this.addAsComponentToCurrentDesign();
    }

    public void addAsComponentToCurrentDesign() {
        block9: {
            SimObjectTreeNode.msg("-#- SimObjectTN.addAsComponentToCurrentDesign: " + this.toString());
            SimObject simObject = null;
            try {
                Editor editor;
                if (this.clb == null) {
                    this.loadComponentInfo();
                }
                if ((editor = Editor.getActiveEditor()) == null) {
                    editor = new Editor();
                }
                if (editor.isViewMode()) {
                    JOptionPane.showMessageDialog(editor.getFrame(), "Cannot add component because editor is in view-mode!", "Error", 0);
                    return;
                }
                if ("simobject".equals(this.clb.getType())) {
                    simObject = DesignManager.getDesignManager().getSimObject(this.clb.getStart());
                    simObject.setEditor(editor);
                    if (!editor.isReady()) {
                        editor.doCancel();
                    }
                    editor.setCommand(new ColibriCreateCommand(editor, simObject));
                    break block9;
                }
                if ("design".equals(this.clb.getType())) {
                    String initPath = this.clb.getInit();
                    SimObjectTreeNode.msg("-#- Design: [init]= " + initPath);
                    Design design = new Design();
                    design.setEditor(editor);
                    design.setVisible(true);
                    design.initialize(initPath);
                    if (!editor.isReady()) {
                        editor.doCancel();
                    }
                    editor.setCommand(new ColibriCreateCommand(editor, design));
                    break block9;
                }
                SimObjectTreeNode.msg("-E- internal: unknown CLB type: " + this.clb.getType());
                return;
            }
            catch (Exception ee) {
                SimObjectTreeNode.msg("-E- SimObjectTN.handleDoubleClick: " + ee + ' ');
                ee.printStackTrace();
            }
        }
    }

    public void setUserObject(Object o) {
        super.setUserObject(o);
        if (o instanceof String) {
            String s = (String)o;
            int pos = Math.max(0, s.lastIndexOf(47));
            int end = s.lastIndexOf(46);
            if (end < 0) {
                end = s.length();
            }
            this.name = s.substring(pos, end);
        } else {
            this.name = o.toString();
        }
    }

    public String toString() {
        return this.name;
    }

    private final /* synthetic */ void this() {
        this.clb = null;
        this.name = null;
    }

    public SimObjectTreeNode() {
        this.this();
    }
}

