/*
 * Decompiled with CFR 0.152.
 */
package hades.manager;

import gifencoder.GIFEncoder;
import hades.gui.CreateCommand;
import hades.gui.CreateSubdesignCommand;
import hades.gui.Editor;
import hades.gui.JObjectCanvas;
import hades.gui.ObjectCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.StringTokenizer;
import jfig.gui.ImageHelper;
import jfig.objects.FigBbox;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CreateThumbnail {
    static final int DESIGN_ICON = 2;
    static final int DESIGN_THUMBNAIL = 3;
    static final int DESIGN_SYMBOL_THUMBNAIL = 4;
    static final int SIMOBJ_SYMBOL_THUMBNAIL = 5;
    int width;
    int height;
    Editor editor;

    public void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void createIconForDesign(String filename) throws Exception {
        CreateThumbnail.msg("...creating icon for design file: " + filename);
        String outfilename = filename.substring(0, filename.lastIndexOf(46)) + "-icon.gif";
        CreateThumbnail.msg("...loading the design...");
        this.editor.setGlowMode(false);
        this.editor.doOpenDesign(filename, false);
        try {
            double t_MAX = 0.1;
            double simTime = 0.0;
            this.editor.getSimulator().runForever();
            int i = 0;
            while (i < 10) {
                System.out.println("..." + i);
                Thread.sleep(200L);
                simTime = this.editor.getSimulator().getSimTime();
                if (simTime >= t_MAX) break;
                ++i;
            }
            this.editor.getSimulator().pauseSimulation();
            System.out.println("... simTime= " + simTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.editor.doFullRedraw();
        this.createEncodeThumbnail(outfilename, 1);
    }

    public void createThumbnailForDesign(String filename) throws Exception {
        CreateThumbnail.msg("...creating thumbnail for design file: " + filename);
        String outfilename = filename.substring(0, filename.lastIndexOf(46)) + ".gif";
        CreateThumbnail.msg("...loading the design...");
        this.editor.doOpenDesign(filename, false);
        try {
            double t_MAX = 0.1;
            double simTime = 0.0;
            this.editor.getSimulator().runForever();
            int i = 0;
            while (i < 10) {
                System.out.println("..." + i);
                Thread.sleep(200L);
                simTime = this.editor.getSimulator().getSimTime();
                if (simTime >= t_MAX) break;
                ++i;
            }
            this.editor.getSimulator().pauseSimulation();
            System.out.println("... simTime= " + simTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.editor.doFullRedraw();
        this.createEncodeThumbnail(outfilename, 25);
    }

    public void createThumbnailForSubdesign(String filename) {
        CreateThumbnail.msg("...creating thumbnail for subdesign symbol: " + filename);
        String outfilename = filename.substring(0, filename.lastIndexOf(46)) + ".gif";
        CreateThumbnail.msg("...loading the subdesign...");
        String designName = filename;
        this.editor.doStartNewDesign(false);
        this.editor.setCommand(new CreateSubdesignCommand(this.editor, designName));
        this.editor.getCommand().setPosition(new Point(0, 0), new Point(0, 0));
        this.createEncodeThumbnail(outfilename, 25);
    }

    public void createThumbnailForSimObject(String filename) {
        CreateThumbnail.msg("...creating thumbnail for simobject symbol: " + filename);
        String className = filename.substring(0, filename.lastIndexOf(46)).replace('/', '.');
        CreateThumbnail.msg("...classname is: " + className);
        String outfilename = filename.substring(0, filename.lastIndexOf(46)) + ".gif";
        this.editor.doStartNewDesign(false);
        this.editor.setCommand(new CreateCommand(this.editor, className));
        this.editor.getCommand().setPosition(new Point(0, 0), new Point(0, 0));
        this.createEncodeThumbnail(outfilename, 25);
    }

    private final void createEncodeThumbnail(String outfilename, int border) {
        try {
            CreateThumbnail.msg("...drawing with zoom fit...");
            Image im = this.createThumbnail(this.width, this.height, border);
            CreateThumbnail.msg("...encoding GIF...");
            GIFEncoder encoder = new GIFEncoder(im);
            CreateThumbnail.msg("...writing GIF to file: " + outfilename);
            FileOutputStream giffile = new FileOutputStream(outfilename);
            BufferedOutputStream of = new BufferedOutputStream(giffile);
            encoder.Write((OutputStream)of);
            giffile.close();
            CreateThumbnail.msg("...ok.");
        }
        catch (Exception e) {
            CreateThumbnail.msg("-E- internal: " + e);
        }
    }

    public Image createThumbnail(int width, int height, int border) {
        Image image = null;
        Graphics gr = null;
        try {
            image = ImageHelper.createImage(width, height);
            gr = image.getGraphics();
            ObjectCanvas objectCanvas = this.editor.getObjectCanvas();
            CreateThumbnail.msg(">>> antialiasing requested again ...");
            FigBbox bbox = BoundingBoxCalculator.getBoundingBox(objectCanvas.getObjectEnumerator().getDrawableObjects());
            int xl = bbox.getXl();
            int yt = bbox.getYt();
            int xr = bbox.getXr();
            int yb = bbox.getYb();
            boolean extra_border = true;
            ((JObjectCanvas)objectCanvas).setZoomFitBorderWidth(border + 1);
            objectCanvas.getComponent().setSize(width, height);
            Dimension d = objectCanvas.getComponent().getSize();
            int sxl = border;
            int sxr = d.width - border;
            int syt = border;
            int syb = d.height - border;
            int sdx = Math.abs(sxr - sxl);
            int sdy = Math.abs(syb - syt);
            int wdx = bbox.getXr() - bbox.getXl();
            int wdy = bbox.getYb() - bbox.getYt();
            double zoom_x = 32.0 * (double)sdx / (double)wdx;
            double zoom_y = 32.0 * (double)sdy / (double)wdy;
            double zoom = Math.min(zoom_x, zoom_y);
            int scx = (sxr + sxl) / 2;
            int scy = (syt + syb) / 2;
            int wcx = (bbox.getXl() + bbox.getXr()) / 2;
            int wcy = (bbox.getYt() + bbox.getYb()) / 2;
            int ax = (int)((double)wcx - (double)scx * 32.0 / zoom);
            int ay = (int)((double)wcy - (double)scy * 32.0 / zoom);
            objectCanvas.getTrafo().setAnchor(new Point(ax, ay));
            objectCanvas.getTrafo().set_zoom(zoom);
            gr.setColor(Color.white);
            gr.fillRect(0, 0, width, height);
            objectCanvas.drawAllObjects(gr);
            objectCanvas.doFullRedraw();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public static void usage() {
        CreateThumbnail.msg("Usage: java hades.manager.CreateThumbnail [mode] [options] [files]\nwhere mode is one of:\n-file <filename>      load 'width height type name' from filename\n-hds                  load design, generate image for it\n-icon                 load design, generate 80x80 icon for it\n-sym                  create thumbnail for subdesign\n-obj                  create thumbnail from simobject symbol\n                      (use full simobject classname as argument)\nwhere options include:\n-width pixels         default: 300\n-height pixels        default: 225\nand files is a list of .hds files\nExample(s):\njava hades.manager.CreateThumbnail -hds -width 400 examples/foo.hds \njava hades.manager.CreateThumbnail -sym -width 400 -height 300 bar.hds\njava hades.manager.CreateThumbnail -obj hades/models/gates/Inv.class \njava hades.manager.CreateThumbnail -file appletlist.txt \n");
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    private static final void parse_file(String filename) {
        try {
            ExceptionTracer.setEnabled(false);
            SetupManager.loadGlobalProperties("hades/.hadesrc");
            SetupManager.loadUserProperties(".hadesrc");
            Editor editor = new Editor();
            CreateThumbnail cifd = new CreateThumbnail(editor);
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            while ((line = br.readLine()) != null) {
                CreateThumbnail.msg(">>> processing: " + line);
                StringTokenizer st = new StringTokenizer(line);
                try {
                    int width = Integer.parseInt(st.nextToken());
                    int height = Integer.parseInt(st.nextToken());
                    String type = st.nextToken();
                    String name = st.nextToken();
                    cifd.setDimension(width, height);
                    if ("-hds".equals(type)) {
                        cifd.createThumbnailForDesign(name);
                    }
                    if ("-icon".equals(type)) {
                        cifd.createIconForDesign(name);
                    }
                    if ("-sym".equals(type)) {
                        cifd.createThumbnailForSubdesign(name);
                    }
                    if (!"-obj".equals(type)) continue;
                    cifd.createThumbnailForSimObject(name);
                }
                catch (Throwable t) {
                    CreateThumbnail.msg("     error: " + t);
                }
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        int width = 300;
        int height = 225;
        int mode = 3;
        try {
            if ("-file".equals(argv[0])) {
                CreateThumbnail.parse_file(argv[1]);
                return;
            }
            if ("-icon".equals(argv[0])) {
                mode = 2;
                width = 80;
                height = 80;
            } else if ("-hds".equals(argv[0])) {
                mode = 3;
            } else if ("-sym".equals(argv[0])) {
                mode = 4;
            } else if ("-obj".equals(argv[0])) {
                mode = 5;
            } else {
                throw new Exception("invalide mode argument: " + argv[0]);
            }
            int i = 1;
            if ("-width".equals(argv[i])) {
                width = Integer.parseInt(argv[i + 1]);
                i += 2;
            }
            if ("-height".equals(argv[i])) {
                height = Integer.parseInt(argv[i + 1]);
                i += 2;
            }
            ExceptionTracer.setEnabled(false);
            SetupManager.loadGlobalProperties("hades/.hadesrc");
            SetupManager.loadUserProperties(".hadesrc");
            Editor editor = new Editor();
            CreateThumbnail cifd = new CreateThumbnail(editor);
            cifd.setDimension(width, height);
            while (i < argv.length) {
                try {
                    switch (mode) {
                        case 2: {
                            cifd.createIconForDesign(argv[i]);
                            break;
                        }
                        case 3: {
                            cifd.createThumbnailForDesign(argv[i]);
                            break;
                        }
                        case 4: {
                            cifd.createThumbnailForSubdesign(argv[i]);
                            break;
                        }
                        case 5: {
                            cifd.createThumbnailForSimObject(argv[i]);
                        }
                    }
                }
                catch (Exception e) {
                    CreateThumbnail.msg("-W- failed for " + argv[i]);
                    CreateThumbnail.msg("-W- exception is: " + e);
                }
                ++i;
            }
            System.exit(0);
        }
        catch (Exception e) {
            CreateThumbnail.usage();
        }
    }

    private final /* synthetic */ void this() {
        this.width = 300;
        this.height = 225;
    }

    public CreateThumbnail(Editor editor) {
        this.this();
        this.editor = editor;
    }
}

