/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;

public class ZoomRegionCommand
extends Command {
    Point P1;
    Point P2;
    ObjectCanvas canvas;

    public ZoomRegionCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
        this.P1 = null;
        this.P2 = null;
        this.statusMessage("Click on the first corner of the region to zoom into");
    }

    public void execute() {
        this.editor.doZoomRegion(this.P1.x, this.P1.y, this.P2.x, this.P2.y);
    }

    public void undo() {
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        if (this.P1 == null) {
            this.P1 = new Point(WP);
            Point sc0 = new Point(0, 0);
            sc0 = this.canvas.getTrafo().wc_to_screen(WP, sc0);
            this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
            this.canvas.changeRubberbandMode(4);
            this.canvas.doSimpleRedraw();
            this.statusMessage("Click on the opposite corner of the region to zoom into");
        } else {
            this.P2 = new Point(WP);
            this.canvas.changeRubberbandMode(1);
            this.statusMessage("Zoom ready... select a command");
            this.ready = true;
            this.execute();
        }
    }

    public String toString() {
        return "ZoomRegionCommand into: " + this.P1 + " , " + this.P2;
    }

    public String getDescription() {
        return "zoom region";
    }

    static {
        Command.versionString = "HADES ZoomRegionCommand 0.01 (06.06.97)";
    }
}

