/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Stack;

public class UndoStack {
    private Stack undoStack = new Stack();
    private Stack redoStack = new Stack();
    private Object undoMI;
    private Object redoMI;
    static /* synthetic */ Class class$java$lang$String;

    public boolean hasChanges() {
        return !this.undoStack.empty();
    }

    public void push(Command cmd) {
        this.undoStack.push(cmd);
        this.updateMenuItems();
    }

    public void undo() {
        if (this.undoStack.empty()) {
            return;
        }
        Command cmd = (Command)this.undoStack.pop();
        this.redoStack.push(cmd);
        cmd.undo();
        this.updateMenuItems();
    }

    public void redo() {
        if (this.redoStack.empty()) {
            return;
        }
        Command cmd = (Command)this.redoStack.pop();
        cmd.execute();
        this.updateMenuItems();
    }

    public void setMenuItems(Object undoMI, Object redoMI) {
        this.undoMI = undoMI;
        this.redoMI = redoMI;
        this.updateMenuItems();
    }

    private void updateMenuItems() {
        String s;
        if (this.undoMI != null) {
            if (this.undoStack.empty()) {
                s = "Undo";
                this.setEnabled(this.undoMI, false);
            } else {
                s = "Undo [" + ((Command)this.undoStack.peek()).getDescription() + "]";
                this.setEnabled(this.undoMI, true);
            }
            this.setLabel(this.undoMI, s);
        }
        if (this.redoMI != null) {
            if (this.redoStack.empty()) {
                s = "Redo";
                this.setEnabled(this.redoMI, false);
            } else {
                s = "Redo [" + ((Command)this.redoStack.peek()).getDescription() + "]";
                this.setEnabled(this.redoMI, true);
            }
            this.setLabel(this.redoMI, s);
        }
    }

    private void setLabel(Object o, String s) {
        try {
            Class[] formals = new Class[]{class$java$lang$String == null ? (class$java$lang$String = UndoStack.class$("java.lang.String")) : class$java$lang$String};
            Method method = o.getClass().getMethod("setLabel", formals);
            if (method == null) {
                return;
            }
            Object[] args = new Object[]{s};
            method.invoke(o, args);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private void setEnabled(Object o, boolean b) {
        try {
            Class[] formals = new Class[]{Boolean.TYPE};
            Method method = o.getClass().getMethod("setEnabled", formals);
            if (method == null) {
                return;
            }
            Object[] args = new Object[]{b};
            method.invoke(o, args);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public String toString() {
        String s = "UndoStack contents:\n";
        Enumeration e = this.undoStack.elements();
        while (e.hasMoreElements()) {
            s = s + "  " + e.nextElement().toString() + "\n";
        }
        s = s + "RedoStack contents:\n";
        Enumeration e2 = this.redoStack.elements();
        while (e2.hasMoreElements()) {
            s = s + "  " + e2.nextElement().toString() + "\n";
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

