/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Editor;
import hades.manager.DesignManager;
import hades.models.Design;
import hades.models.register.LFSRAnalyzer;
import hades.simulator.SimObject;
import hades.simulator.VhdlBatchSimKernel;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class T1Editor
extends Editor {
    static /* synthetic */ Class class$hades$simulator$SimObject;

    public void doLoadTemplate(String arg) {
        Editor.msg("-#- doLoadTemplate: " + arg);
        try {
            String aufgabe = arg;
            String resourcename = "resource:///hades/examples/t1/aufgabe_" + aufgabe + ".hds";
            this.doOpenDesign(resourcename, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doBIST(String arg) {
        String status = this.doBIST(arg, null);
        JOptionPane.showMessageDialog(this.getFrame(), status);
    }

    public String doBIST(String arg, double[] dummy) {
        String status;
        block18: {
            Editor.msg("-E- doBIST: " + arg);
            status = "";
            try {
                String vname = "aufgabe_" + arg + ".hds";
                String tbname = "resource:///hades/examples/t1/testbench_" + arg + ".hds";
                if (Editor.getDebug()) {
                    Editor.msg("-#- vname  = '" + vname + "'");
                }
                if (Editor.getDebug()) {
                    Editor.msg("-#- tbname = '" + tbname + "'");
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DesignManager dm = this.getDesignManager();
                this.doSave(baos);
                dm.saveAsVirtualFile(vname, baos.toString());
                VhdlBatchSimKernel simulator = new VhdlBatchSimKernel();
                Design testbench = dm.getDesign(null, tbname, false);
                if (testbench == null) {
                    return "Interner Fehler: Testbench '" + tbname + "' nicht gefunden.";
                }
                testbench.setSimulator(simulator);
                simulator.setDesign(testbench);
                if (Editor.getDebug()) {
                    Editor.msg("-#- testbench is '" + testbench + "'");
                }
                SimObject[] generators = this.findSimObjects(testbench, Class.forName("hades.models.register.LFSRGenerator"));
                SimObject[] analyzers = this.findSimObjects(testbench, Class.forName("hades.models.register.LFSRAnalyzer"));
                if (analyzers == null || analyzers.length == 0) {
                    return "Interner Fehler: Testbench enth\ufffdlt keine LFSR-Register.";
                }
                if (Editor.getDebug()) {
                    Editor.msg("-#- generators: ");
                    int i = 0;
                    while (i < generators.length) {
                        Editor.msg("" + generators[i]);
                        ++i;
                    }
                    Editor.msg("-#- analyzers: ");
                    int i2 = 0;
                    while (i2 < analyzers.length) {
                        Editor.msg("" + analyzers[i2]);
                        ++i2;
                    }
                }
                double maxSimTime = 10.0;
                simulator.runFor(maxSimTime);
                int kmax = (int)(maxSimTime * 100.0);
                int k = 0;
                while (k < kmax) {
                    Thread.sleep(100L);
                    if (simulator.getSimTime() >= maxSimTime) break;
                    ++k;
                }
                simulator.stopSimulation();
                int[] signatures = new int[analyzers.length];
                int[] expected = new int[analyzers.length];
                int[] uxz = new int[analyzers.length];
                boolean ok = true;
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < signatures.length) {
                    expected[i] = ((LFSRAnalyzer)analyzers[i]).getExpectedValue();
                    signatures[i] = ((LFSRAnalyzer)analyzers[i]).getValue();
                    uxz[i] = ((LFSRAnalyzer)analyzers[i]).getUXZMask();
                    if (Editor.getDebug()) {
                        Editor.msg("-#- exp/sig/uxz= '" + expected[i] + " " + signatures[i] + " " + uxz[i]);
                    }
                    if (uxz[i] != 0) {
                        ok = false;
                        sb.append("Ausgang " + i + " liefert undefinierte Werte (U,X,Z)\n");
                    } else if (expected[i] != signatures[i]) {
                        ok = false;
                        sb.append("Ausgang " + i + " funktioniert noch nicht korrekt\n");
                        sb.append("(berechnete Signatur: " + this._hex(signatures[i]));
                        sb.append(" erwartete Signatur: " + this._hex(expected[i]) + "\n");
                    } else {
                        sb.append("Ausgang " + i + " funktioniert korrekt\n");
                    }
                    ++i;
                }
                if (ok) {
                    status = "Die Schaltung ist korrekt!";
                    break block18;
                }
                status = "Die Schaltung ist noch nicht korrekt. Details:\n" + sb.toString();
            }
            catch (Exception e) {
                Editor.msg("-E- doBIST: " + e);
                status = "Interner Fehler: " + e;
                e.printStackTrace();
            }
        }
        return status;
    }

    public String _hex(int signature) {
        String raw = Integer.toHexString(signature);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 8 - raw.length()) {
            sb.append(" ");
            ++i;
        }
        Editor.msg("'" + sb.toString() + "'" + raw + "'");
        return sb.toString() + raw;
    }

    public SimObject[] findSimObjects(Design design, Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (!(class$hades$simulator$SimObject == null ? (class$hades$simulator$SimObject = T1Editor.class$("hades.simulator.SimObject")) : class$hades$simulator$SimObject).isAssignableFrom(clazz)) {
            return null;
        }
        if (design == null) {
            return null;
        }
        Vector<SimObject> vector = new Vector<SimObject>();
        Enumeration e = design.getComponents();
        while (e.hasMoreElements()) {
            SimObject tmp = (SimObject)e.nextElement();
            if (!clazz.isInstance(tmp)) continue;
            vector.addElement(tmp);
        }
        SimObject[] result = new SimObject[vector.size()];
        int i = 0;
        while (i < vector.size()) {
            result[i] = (SimObject)vector.elementAt(i);
            ++i;
        }
        return result;
    }

    public JMenuItem _cmi(String label, String callback, String arg) {
        JMenuItem tmp = new JMenuItem(label);
        this.addCallback(label, callback, arg);
        tmp.addActionListener(this);
        return tmp;
    }

    public void createCheckMenu(JFrame frame, Editor editor) {
        JMenu t1Menu = new JMenu("T1");
        t1Menu.add(this._cmi("T1_4_3 Vorlage", "doLoadTemplate", "T1_4_3"));
        t1Menu.add(this._cmi("T1_4_3 \ufffdberpr\ufffdfen", "doBIST", "T1_4_3"));
        t1Menu.addSeparator();
        t1Menu.add(this._cmi("T1_4_6_a (Vorlage)", "doLoadTemplate", "T1_4_6_a"));
        t1Menu.add(this._cmi("T1_4_6_a \ufffdberpr\ufffdfen", "doBIST", "T1_4_6_a"));
        t1Menu.addSeparator();
        t1Menu.add(this._cmi("T1_4_6_b (Vorlage)", "doLoadTemplate", "T1_4_6_b"));
        t1Menu.add(this._cmi("T1_4_6_b \ufffdberpr\ufffdfen", "doBIST", "T1_4_6_b"));
        t1Menu.addSeparator();
        t1Menu.add(this._cmi("T1_4_6_c (Vorlage)", "doLoadTemplate", "T1_4_6_c"));
        t1Menu.add(this._cmi("T1_4_6_c \ufffdberpr\ufffdfen", "doBIST", "T1_4_6_c"));
        t1Menu.addSeparator();
        t1Menu.add(this._cmi("T1_5_5 (Vorlage)", "doLoadTemplate", "T1_5_5"));
        t1Menu.add(this._cmi("T1_5_5 \ufffdberpr\ufffdfen", "doBIST", "T1_5_5"));
        t1Menu.addSeparator();
        t1Menu.add(this._cmi("T1_3_4a", "doLoadTemplate", "t1_3_4a.hds"));
        JMenuBar jmb = frame.getJMenuBar();
        jmb.add(t1Menu);
    }

    public static void main(String[] argv) {
        Editor.msg("-I- T1Editor: Hades-Version f\ufffdr die T1-Vorlesung und \ufffdbungen.");
        ExceptionTracer.setEnabled(false);
        SetupManager.setProperty("Hades.UseSwingGUI", "true");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadGlobalProperties("hades/.hadesrc.ws2004");
        SetupManager.loadUserProperties(".hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        Editor.parseArgs(argv);
        T1Editor editor = new T1Editor();
        JFrame frame = (JFrame)editor.getFrame();
        DesignManager.getDesignManager().setDialogWindowsParentFrame(frame);
        editor.createCheckMenu(frame, editor);
        editor.checkAllCallbacks();
        String filename = SetupManager.getProperty("Hades.Editor.StartupFilename", null);
        if (filename != null) {
            editor.doOpenDesign(filename, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

