/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.ObjectCanvas;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SyncRedrawTimer
extends Thread {
    private ObjectCanvas canvas;
    private long t_period;
    private int n_repaints;
    private int n_requests;
    private int n_iterations;
    private boolean stopped;
    private boolean changeRate;

    public void getSetupDefaults() {
        this.t_period = SetupManager.getInteger("Hades.SyncRedrawTimer.UpdateInterval", 50);
    }

    public void setFramerate(double framerate) {
        if (framerate == 0.0) {
            this.setPeriod(60L);
        } else if (framerate == -1.0) {
            this.getSetupDefaults();
        } else {
            this.setPeriod((long)(1000.0 / framerate));
        }
        this.changeRate = true;
        this.interrupt();
    }

    public void setPeriod(long millis) {
        this.t_period = millis;
    }

    public long getPeriod() {
        return this.t_period;
    }

    public void run() {
        while (!this.stopped) {
            try {
                while (!this.stopped) {
                    ++this.n_iterations;
                    this.oneRepaint();
                    Thread.sleep(this.t_period);
                    if (!SetupManager.getBoolean("Hades.SyncRedrawTimer.VerboseRedraw", false)) continue;
                    System.out.println("SyncRedrawTimer: redraw at t=" + System.currentTimeMillis() + " memory= " + Runtime.getRuntime().freeMemory());
                }
            }
            catch (OutOfMemoryError ome) {
                ExceptionTracer.message("-E- SyncRedrawTimer: out of memory during repaint...");
                System.gc();
            }
            catch (InterruptedException ie) {
                if (this.changeRate) {
                    this.changeRate = false;
                    continue;
                }
                this.stopped = true;
            }
            catch (Exception ee) {
                ExceptionTracer.message("-E- SyncRedrawTimer: " + ee);
                ExceptionTracer.trace(ee);
            }
        }
    }

    public void oneRepaint() {
        if (this.canvas == null) {
            return;
        }
        ++this.n_requests;
        int n_done = this.canvas.countExecutedSyncRepaints();
        if (this.n_repaints - n_done < 1) {
            this.canvas.doSyncRedraw();
            ++this.n_repaints;
        } else {
            AntiDeadlock.sleep(50L);
        }
    }

    public String toString() {
        return "SyncRedrawTimer[period=" + this.t_period + ",iterations=" + this.n_repaints + ']';
    }

    public static void main(String[] argv) {
        SyncRedrawTimer srt = new SyncRedrawTimer(null);
        srt.setPeriod(250L);
        srt.start();
    }

    private final /* synthetic */ void this() {
        this.canvas = null;
        this.t_period = 100L;
        this.n_repaints = 0;
        this.n_requests = 0;
        this.n_iterations = 0;
        this.stopped = false;
        this.changeRate = false;
    }

    public SyncRedrawTimer(ObjectCanvas canvas) {
        super("SyncRedrawTimer");
        this.this();
        this.canvas = canvas;
        this.getSetupDefaults();
    }
}

