/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;

public class SignalMovePointCommand
extends Command {
    Point oldPos;
    Point newPos;
    Signal signal;
    ObjectCanvas canvas;

    public SignalMovePointCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
        this.oldPos = null;
        this.newPos = null;
    }

    public void execute() {
        if (this.oldPos.equals(this.newPos)) {
            return;
        }
        this.editor.deleteFromObjectList(this.signal);
        Port p = this.editor.findPort(this.oldPos);
        if (p != null) {
            this.signal.disconnect(p);
        }
        if ((p = this.editor.findPort(this.newPos)) != null) {
            this.signal.connect(p);
        }
        WireSegment[] segments = (WireSegment[])this.signal.getSegments();
        int i = 0;
        while (i < segments.length) {
            Point[] points = segments[i].getPoints();
            int j = 0;
            while (j < points.length) {
                if (this.oldPos.equals(points[j])) {
                    points[j] = new Point(this.newPos);
                }
                ++j;
            }
            segments[i].setPoints(points);
            ++i;
        }
        this.signal.createVertexTable();
        this.signal.rebuildSolderDots();
        this.editor.insertIntoObjectList(this.signal);
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        WireSegment[] segments = (WireSegment[])this.signal.getSegments();
        this.editor.deleteFromObjectList(this.signal);
        int i = 0;
        while (i < segments.length) {
            Point[] points = segments[i].getPoints();
            int j = 0;
            while (j < points.length) {
                if (this.newPos.equals(points[j])) {
                    points[j] = new Point(this.oldPos);
                }
                ++j;
            }
            segments[i].setPoints(points);
            ++i;
        }
        this.signal.createVertexTable();
        this.signal.rebuildSolderDots();
        this.editor.insertIntoObjectList(this.signal);
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        if (this.oldPos == null) {
            this.oldPos = new Point(WP);
            FigObject tmp = this.editor.findSymbolOrSignal(this.oldPos);
            if (tmp == null) {
                this.statusMessage("No signal point at that position. Must click directly on a signal edge/corner");
                this.oldPos = null;
                this.ready = true;
                return;
            }
            if (!(tmp instanceof WireSegment)) {
                this.statusMessage("Not a signal. Please click directly on a signal edge/corner");
                this.oldPos = null;
                return;
            }
            this.signal = ((WireSegment)tmp).getSignal();
            Point sc0 = new Point(0, 0);
            sc0 = this.canvas.getTrafo().wc_to_screen(WP, sc0);
            Point[] wcp = new Point[]{WP};
            WireSegment ws = new WireSegment(this.signal);
            ws.setPoints(wcp);
            ws.setTrafo(this.canvas.getTrafo());
            this.editor.setTmpObject(ws);
            this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
            this.canvas.changeRubberbandMode(2, this.canvas.getTrafo(), this.editor.getTmpObject().getBbox());
            this.canvas.doSimpleRedraw();
            this.statusMessage("Click on the new position for the signal!");
        } else {
            this.newPos = new Point(WP);
            Port p = this.editor.findPort(this.newPos);
            if (p != null && p.getSignal() != null) {
                this.statusMessage("Cannot connect: port already in use!");
                return;
            }
            this.canvas.changeRubberbandMode(1);
            this.editor.setTmpObject(null);
            this.statusMessage("Move point ready... select a command");
            this.ready = true;
            this.execute();
        }
    }

    public String toString() {
        return "SignalMovePointCommand from: " + this.oldPos + " to: " + this.newPos + " signal: " + this.signal;
    }

    public String getDescription() {
        return "move signal point";
    }

    static {
        Command.versionString = "HADES SignalMovePointCommand 0.1 (04.09.97)";
    }
}

