/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.symbols.SolderDot;
import hades.symbols.WireSegment;
import hades.utils.Selection;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;

public class SelectObjectCommand
extends Command {
    ObjectCanvas canvas;
    FigObject target;
    boolean isSelected;

    public SelectObjectCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.target = null;
        this.isSelected = false;
        this.ready = false;
    }

    public void execute() {
        boolean select;
        if (this.target == null) {
            return;
        }
        boolean bl = select = !this.target.isSelected();
        if (this.target instanceof WireSegment) {
            Signal signal = ((WireSegment)this.target).getSignal();
            this.handleSignalSelection(signal, select);
        } else if (this.target instanceof SolderDot) {
            Signal signal = ((SolderDot)this.target).getSignal();
            this.handleSignalSelection(signal, select);
        } else if (select) {
            this.target.select();
            this.editor.getSelection().add(this.target);
        } else {
            this.target.deselect();
            this.editor.getSelection().remove(this.target);
        }
        this.statusMessage("Select object ready. Please select a command.");
        this.canvas.doFullRedraw();
    }

    private void handleSignalSelection(Signal signal, boolean select) {
        Selection selection = this.editor.getSelection();
        FigObject[] segments = signal.getSegments();
        int i = 0;
        while (i < segments.length) {
            if (select) {
                segments[i].select();
                selection.add(segments[i]);
            } else {
                segments[i].deselect();
                selection.remove(segments[i]);
            }
            ++i;
        }
        FigObject[] solders = signal.getSolderDots();
        int i2 = 0;
        while (i2 < solders.length) {
            if (select) {
                solders[i2].select();
                selection.add(solders[i2]);
            } else {
                solders[i2].deselect();
                selection.remove(solders[i2]);
            }
            ++i2;
        }
    }

    public void undo() {
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.target = this.editor.findObjectAt(WP);
        if (this.target == null) {
            this.statusMessage("No object at that position. Must click on the object to select!");
            this.ready = true;
            return;
        }
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "SelectObjectCommand target= " + this.target;
    }

    public String getDescription() {
        return "select object";
    }
}

