/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Editor;
import hades.gui.GUIFactory;
import hades.simulator.SimObject;
import java.awt.Component;
import java.awt.Frame;
import java.util.Hashtable;

public abstract class PropertySheet
extends Component {
    protected static Hashtable _objectTable;
    protected static boolean debug;

    public static PropertySheet getPropertySheet(SimObject obj, String[] fields) {
        Editor editor = obj.getEditor();
        Frame frame = null;
        frame = editor != null ? editor.getFrame() : new Frame("PropertySheet dummy");
        return PropertySheet.getPropertySheet(obj, frame, fields);
    }

    public static PropertySheet getInstanceNamePropertySheet(SimObject obj) {
        String[] fields = new String[]{"instance name:", "name"};
        return PropertySheet.getPropertySheet(obj, fields);
    }

    public static PropertySheet getPropertySheet(SimObject obj, Frame frame, String[] fields) {
        if (_objectTable == null) {
            _objectTable = new Hashtable();
        }
        if (_objectTable.containsKey(obj)) {
            return (PropertySheet)_objectTable.get(obj);
        }
        GUIFactory factory = GUIFactory.getGUIFactory();
        PropertySheet ps = factory.getPropertySheet(obj, frame, fields);
        _objectTable.put(obj, ps);
        return ps;
    }

    public String buildTitle(SimObject obj) {
        return obj.getClass().getName() + " '" + obj.getName() + "'";
    }

    public abstract void pack();

    public abstract void setHelpText(String var1);

    public abstract void enableUpdateButton(boolean var1);

    public abstract void dispose();

    public abstract void tearDown();

    public static void msg(String s) {
        System.out.println(s);
    }

    static {
        debug = false;
    }
}

