/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.SolderDot;
import hades.symbols.WireSegment;
import java.awt.Point;
import java.util.Vector;
import jfig.canvas.FigCanvasEvent;
import jfig.utils.MouseMapper;

public class MoveCommand
extends Command {
    Point oldPos;
    Point newPos;
    SimObject target;
    ObjectCanvas canvas;

    public MoveCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
        this.oldPos = null;
        this.newPos = null;
    }

    public void execute() {
        this.moveSignals(this.target, this.newPos, this.oldPos);
        this.target.getSymbol().move(this.newPos.x - this.oldPos.x, this.newPos.y - this.oldPos.y);
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void cancel() {
        this.editor.setTmpObject(null);
        this.canvas.changeRubberbandMode(1);
        this.canvas.setEnablePopup(true);
        this.editor.doFullRedraw();
        this.statusMessage("MoveCommand canceled... Please select a command");
        this.ready = true;
    }

    private void moveSignals(SimObject target, Point newPos, Point oldPos) {
        Vector<Point> old_points = new Vector<Point>();
        Vector<Point> new_points = new Vector<Point>();
        Vector<WireSegment> segmentsV = new Vector<WireSegment>();
        Vector<Point> distanceP = new Vector<Point>();
        Vector<SolderDot> soldersV = new Vector<SolderDot>();
        Port[] ports = target.getPorts();
        int i = 0;
        while (i < ports.length) {
            if (ports[i] == null) {
                this.message("-W- Internal: port[" + i + "] is null on " + target);
            } else {
                Signal signal = ports[i].getSignal();
                if (signal != null) {
                    Point wpold = target.getSymbol().getPortPosition(ports[i].getName());
                    Point wpnew = new Point(wpold.x + newPos.x - oldPos.x, wpold.y + newPos.y - oldPos.y);
                    WireSegment[] segments = (WireSegment[])signal.getSegments();
                    int j = 0;
                    while (j < segments.length) {
                        if (segments[j].minDistance(wpold) == 0.0) {
                            old_points.addElement(wpold);
                            new_points.addElement(wpnew);
                            segmentsV.addElement(segments[j]);
                        }
                        ++j;
                    }
                    SolderDot[] solderDots = (SolderDot[])signal.getSolderDots();
                    int j2 = 0;
                    while (j2 < solderDots.length) {
                        if (solderDots[j2].getCenterPoint().equals(wpold)) {
                            distanceP.addElement(new Point(newPos.x - oldPos.x, newPos.y - oldPos.y));
                            soldersV.addElement(solderDots[j2]);
                        }
                        ++j2;
                    }
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < segmentsV.size()) {
            WireSegment tmp = (WireSegment)segmentsV.elementAt(i2);
            tmp.movePoint((Point)old_points.elementAt(i2), (Point)new_points.elementAt(i2));
            ++i2;
        }
        int i3 = 0;
        while (i3 < soldersV.size()) {
            SolderDot stmp = (SolderDot)soldersV.elementAt(i3);
            Point d = (Point)distanceP.elementAt(i3);
            stmp.move(d.x, d.y);
            ++i3;
        }
    }

    public void undo() {
        this.moveSignals(this.target, this.oldPos, this.newPos);
        this.target.getSymbol().move(this.oldPos.x - this.newPos.x, this.oldPos.y - this.newPos.y);
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        if (MouseMapper.isMiddleClick(ME)) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else if (MouseMapper.isRightClick(ME)) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else {
            this.setPosition(SP, WP);
        }
    }

    public void setPosition(Point SP, Point WP) {
        if (this.oldPos == null) {
            this.oldPos = new Point(WP);
            this.canvas.setEnablePopup(false);
            this.target = this.editor.findSimObject(this.oldPos);
            if (this.target == null) {
                this.statusMessage("No object at that position. Please click on the object to move. L: select object R: cancel ");
                this.oldPos = null;
                return;
            }
            Point sc0 = new Point(0, 0);
            sc0 = this.canvas.getTrafo().wc_to_screen(WP, sc0);
            this.canvas.setRubberbandBasePoint(sc0.x, sc0.y);
            this.canvas.changeRubberbandMode(5, this.canvas.getTrafo(), this.target.getSymbol().getBbox());
            this.canvas.doSimpleRedraw();
            this.statusMessage("Click on the new position for the object! L: place object R: cancel ");
        } else {
            this.newPos = new Point(WP);
            this.canvas.changeRubberbandMode(1);
            this.editor.setTmpObject(null);
            this.statusMessage("Move ready... select a command");
            this.execute();
            this.canvas.setEnablePopup(true);
            this.ready = true;
        }
    }

    public String toString() {
        return "MoveCommand from: " + this.oldPos + " to: " + this.newPos + " target: " + this.target;
    }

    public String getDescription() {
        return "move object";
    }

    static {
        Command.versionString = "HADES MoveCommand 0.01 (01.06.97)";
    }
}

