/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.models.memory.Memory;
import hades.utils.HexFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import jfig.gui.ImageHelper;
import jfig.utils.SetupManager;

public class MemoryHexEditorField
extends JComponent
implements Scrollable,
KeyListener,
MouseListener,
MouseMotionListener {
    public static final boolean debug = false;
    protected int n_words;
    protected int n_bits_per_word;
    protected Hashtable actionListenerTable;
    protected Font textFont;
    protected Color backgroundColor;
    protected Color dataColor;
    protected Color addrColor;
    protected Color readHighlightColor;
    protected Color writeHighlightColor;
    protected int n_columns;
    protected int n_rows;
    protected int n_words_per_row;
    protected int visibleWordsPerRow;
    protected int n_chars_per_addr;
    protected int n_chars_per_word;
    protected int char_width;
    protected int char_height;
    protected int baseline;
    protected int x0_addr;
    protected int x0_data;
    protected int y0_addr;
    protected int y0_data;
    protected int dx_data;
    protected int border_width;
    protected int border_height;
    protected int width;
    protected int height;
    protected int cursor_x;
    protected int cursor_y;
    protected boolean shiftMode;
    protected boolean insertMode = false;
    protected boolean modified = false;
    protected int readHighlightAddress = -1;
    protected int writeHighlightAddress = -1;
    protected Memory memoryObject;
    protected boolean initialized = false;
    protected boolean cursorDataColor = true;
    private Timer timer = new Timer();
    private TimerTask swicur = new TimerTask(){

        @Override
        public void run() {
            MemoryHexEditorField.this.cursorDataColor = !MemoryHexEditorField.this.cursorDataColor;
            MemoryHexEditorField.this.repaint();
        }
    };
    private static final long[] digit_masks = new long[]{0L, 1L, 16L, 256L, 4096L, 65536L, 0x100000L, 0x1000000L, 0x10000000L, 0x100000000L, 0x1000000000L, 0x10000000000L, 0x100000000000L, 0x1000000000000L, 0x10000000000000L, 0x100000000000000L, 0x1000000000000000L};
    private static final long[] bit_masks = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};

    public MemoryHexEditorField(Memory memoryObject, int n_words_per_row) {
        this.timer.schedule(this.swicur, 0L, 500L);
        MemoryHexEditorField.msg("-I- MemoryHexEditorField.<init>... ");
        this.memoryObject = memoryObject;
        this.n_words_per_row = n_words_per_row;
        this.actionListenerTable = new Hashtable(7);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public void init() {
        this.n_words = this.memoryObject.getSize();
        this.n_bits_per_word = this.memoryObject.getBitsPerWord();
        this.n_rows = this.n_words / this.n_words_per_row;
        this.visibleWordsPerRow = this.n_words_per_row;
        this.n_chars_per_addr = this.getAddrFieldWidth(this.n_words);
        this.n_chars_per_word = this.getDataFieldWidth(this.n_bits_per_word);
        this.n_columns = this.n_chars_per_addr + 2 + this.n_chars_per_word * this.visibleWordsPerRow + this.visibleWordsPerRow - 1;
        this.prepareGUI();
        this.initialized = true;
    }

    @Override
    public void setBackground(Color c) {
        this.backgroundColor = c;
        this.repaint();
    }

    public void setDataColor(Color c) {
        this.dataColor = c;
        this.repaint();
    }

    public void setAddrColor(Color c) {
        this.addrColor = c;
        this.repaint();
    }

    public void setReadHighlightColor(Color c) {
        this.readHighlightColor = c;
        this.repaint();
    }

    public void setWriteHighlightColor(Color c) {
        this.writeHighlightColor = c;
        this.repaint();
    }

    @Override
    public Color getBackground() {
        return this.backgroundColor;
    }

    public Color getDataColor() {
        return this.dataColor;
    }

    public Color getAddrColor() {
        return this.addrColor;
    }

    public Color getReadHightlightColor() {
        return this.readHighlightColor;
    }

    public Color getWriteHightlightColor() {
        return this.writeHighlightColor;
    }

    public int getReadHightlightAddress() {
        return this.readHighlightAddress;
    }

    public int getWriteHightlightAddress() {
        return this.writeHighlightAddress;
    }

    public void setReadHighlightAddress(int addr) {
        this.readHighlightAddress = addr;
    }

    public void setWriteHighlightAddress(int addr) {
        this.writeHighlightAddress = addr;
    }

    public int getAddrFieldWidth(int n_words) {
        if (this.memoryObject.getAddrOffset() != 0) {
            int max_addr = this.memoryObject.getAddrOffset() + n_words - 1;
            return Integer.toHexString(max_addr).length();
        }
        if (n_words > 0x10000000) {
            return 8;
        }
        if (n_words > 0x1000000) {
            return 7;
        }
        if (n_words > 0x100000) {
            return 6;
        }
        if (n_words > 65536) {
            return 5;
        }
        if (n_words > 4096) {
            return 4;
        }
        if (n_words > 256) {
            return 3;
        }
        if (n_words > 16) {
            return 2;
        }
        return 1;
    }

    public int getDataFieldWidth(int n_bits_per_word) {
        return (int)Math.ceil((double)n_bits_per_word / 4.0);
    }

    public long getData(int addr) {
        addr = this.clip(addr, 0, this.n_words - 1);
        return this.memoryObject.getDataAt(addr);
    }

    public void setData(int addr, long value) {
        addr = this.clip(addr, 0, this.n_words - 1);
        this.memoryObject.setDataAt(addr, value);
        this.modified = true;
        this.notifyListeners(addr, value);
    }

    public void insertNewWordAtMousePosition() {
        int addr = this.getAddrFromCursorPosition();
        int size = this.memoryObject.getSize();
        for (int i = size - 1; i > addr; --i) {
            this.setData(i, this.getData(i - 1));
        }
        this.setData(addr, 0L);
    }

    public void notifyListeners(int addr, long value) {
        if (this.actionListenerTable == null) {
            return;
        }
        if (this.actionListenerTable.size() == 0) {
            return;
        }
        ActionEvent ie = new ActionEvent(this, 1001, "" + addr + " " + value);
        Enumeration E = this.actionListenerTable.keys();
        while (E.hasMoreElements()) {
            ((ActionListener)E.nextElement()).actionPerformed(ie);
        }
    }

    public void addActionListener(ActionListener AL) {
        if (AL == null) {
            return;
        }
        this.actionListenerTable.put(AL, AL);
    }

    public void removeActionListener(ActionListener AL) {
        if (AL == null) {
            return;
        }
        this.actionListenerTable.remove(AL);
    }

    public void prepareGUI() {
        this.backgroundColor = SetupManager.getColor("Hades.MemoryHexEditorField.BackgroundColor", Color.white);
        this.dataColor = SetupManager.getColor("Hades.MemoryHexEditorField.DataColor", Color.blue);
        this.addrColor = SetupManager.getColor("Hades.MemoryHexEditorField.AddrColor", Color.black);
        this.readHighlightColor = SetupManager.getColor("Hades.MemoryHexEditorField.ReadHighlightColor", Color.green);
        this.writeHighlightColor = SetupManager.getColor("Hades.MemoryHexEditorField.WriteHighlightColor", Color.red);
        this.setBackground(this.backgroundColor);
        String fontname = SetupManager.getProperty("Hades.MemoryHexEditorField.FontName", "Monospaced");
        int fontsize = SetupManager.getInteger("Hades.MemoryHexEditorField.FontSize", 12);
        int fontstyle = SetupManager.getInteger("Hades.MemoryHexEditorField.FontStyle", 0);
        this.setTextFont(new Font(fontname, fontstyle, fontsize));
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font f) {
        this.textFont = f;
        FontMetrics fm = this.getFontMetrics(this.textFont);
        this.char_width = fm.charWidth('M');
        this.char_height = fm.getMaxDescent() + fm.getMaxAscent();
        this.baseline = fm.getMaxAscent();
        this.border_width = 5;
        this.border_height = 5;
        this.width = this.n_columns * this.char_width + 2 * this.border_width;
        this.height = this.n_rows * this.char_height + 2 * this.border_height;
        this.x0_addr = this.border_width;
        this.x0_data = this.x0_addr + (this.n_chars_per_addr + 2) * this.char_width;
        this.y0_data = this.y0_addr = this.border_height + this.baseline;
        this.dx_data = (this.n_chars_per_word + 1) * this.char_width;
    }

    public void paintBackgroundAndBorder(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int x = clip.x;
        int y = clip.y;
        int w = clip.width;
        int h = clip.height;
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        if (this.isEnabled()) {
            g.setColor(this.backgroundColor);
        } else {
            g.setColor(Color.lightGray);
        }
        g.fillRect(x, y, w, h);
        if (x + w > width) {
            g.setColor(super.getBackground());
            g.fillRect(width, y, x + w - width + 1, h);
        }
        if (y + h > height) {
            g.setColor(super.getBackground());
            g.fillRect(x, height, x + w, y + h - height + 1);
        }
        g.setColor(Color.gray);
        g.draw3DRect(0, 0, width - 1, height - 1, false);
        g.draw3DRect(1, 1, width - 3, height - 3, false);
    }

    public void paintAllAddresses(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int cx = clip.x;
        int cy = clip.y;
        int ch = clip.height;
        if (cx > this.x0_data) {
            return;
        }
        int row_min = (cy - this.border_height) / (this.char_height * this.n_words_per_row) * this.n_words_per_row;
        int row_max = row_min + ch / this.char_height + this.char_height;
        int addr_min = row_min * this.n_words_per_row;
        int addr_max = row_max * this.n_words_per_row;
        int x = this.x0_addr;
        int y = this.y0_addr + row_min * this.char_height;
        int offset = this.memoryObject.getAddrOffset();
        g.setColor(this.addrColor);
        g.setFont(this.textFont);
        for (int addr = addr_min; addr <= addr_max && addr < this.n_words; addr += this.n_words_per_row) {
            String s = HexFormat.getHexStringOrX(offset + addr, this.n_chars_per_addr);
            g.drawString(s, x, y);
            y += this.char_height;
        }
    }

    public void paintAllData(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int cy = clip.y;
        int ch = clip.height;
        int row_min = (cy - this.border_height) / (this.char_height * this.n_words_per_row) * this.n_words_per_row;
        int row_max = row_min + ch / this.char_height + this.char_height;
        int addr_min = row_min * this.n_words_per_row;
        int x = this.x0_addr;
        int y = this.y0_addr + row_min * this.char_height;
        g.setColor(this.dataColor);
        g.setFont(this.textFont);
        int addr = addr_min;
        for (int i = row_min; i < row_max; ++i) {
            x = this.x0_data;
            for (int j = 0; j < this.visibleWordsPerRow && addr < this.n_words; ++j) {
                String t = HexFormat.getHexStringOrX(this.getData(addr), this.n_chars_per_word);
                g.drawString(t, x, y);
                ++addr;
                x += this.dx_data;
            }
            y += this.char_height;
        }
    }

    public void paintBackgroundAndBorderNoClip(Graphics g) {
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.gray);
        g.draw3DRect(0, 0, width - 1, height - 1, false);
        g.draw3DRect(1, 1, width - 3, height - 3, false);
    }

    public void paintAllAddressesNoClip(Graphics g) {
        int addr = 0;
        int x = this.x0_addr;
        int y = this.y0_addr;
        int offset = this.memoryObject.getAddrOffset();
        g.setColor(this.addrColor);
        g.setFont(this.textFont);
        for (int i = 0; i < this.n_rows && addr < this.n_words; ++i) {
            String s = HexFormat.getHexStringOrX(offset + addr, this.n_chars_per_addr);
            g.drawString(s, x, y);
            addr += this.n_words_per_row;
            y += this.char_height;
        }
    }

    public void paintAllDataNoClip(Graphics g) {
        int addr = 0;
        int x = this.x0_data;
        int y = this.y0_data;
        g.setColor(this.dataColor);
        g.setFont(this.textFont);
        for (int i = 0; i < this.n_rows; ++i) {
            x = this.x0_data;
            for (int j = 0; j < this.visibleWordsPerRow && addr < this.n_words; ++j) {
                String t = HexFormat.getHexStringOrX(this.getData(addr), this.n_chars_per_word);
                g.drawString(t, x, y);
                ++addr;
                x += this.dx_data;
            }
            y += this.char_height;
        }
    }

    public void paintStringAtAddr(Graphics g, int addr, String s) {
        int c_y = addr / this.n_words_per_row;
        int delta_addr = (addr - c_y * this.getWordsPerRow()) / 1;
        int c_x = delta_addr * (this.n_chars_per_word + 1);
        g.drawString(s, this.x0_data + c_x * this.char_width, this.y0_data + c_y * this.char_height);
    }

    public void paintHighlighting(Graphics g) {
        String t;
        g.setFont(this.textFont);
        if (this.readHighlightAddress >= 0) {
            t = HexFormat.getHexStringOrX(this.getData(this.readHighlightAddress), this.n_chars_per_word);
            g.setColor(this.readHighlightColor);
            this.paintStringAtAddr(g, this.readHighlightAddress, t);
        }
        if (this.writeHighlightAddress >= 0) {
            t = HexFormat.getHexStringOrX(this.getData(this.writeHighlightAddress), this.n_chars_per_word);
            g.setColor(this.writeHighlightColor);
            this.paintStringAtAddr(g, this.writeHighlightAddress, t);
        }
    }

    public void paintCursor(Graphics g) {
        int x0 = this.border_width;
        int y0 = this.border_height + this.baseline;
        if (this.cursorDataColor) {
            g.setColor(this.dataColor);
        } else {
            g.setColor(this.backgroundColor);
        }
        g.setFont(this.textFont);
        g.drawString("_", x0 + this.cursor_x * this.char_width, y0 + this.cursor_y * this.char_height);
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.checkInit();
        if (this.n_words > 1) {
            this.paintBackgroundAndBorder(g);
            this.paintAllAddresses(g);
            this.paintAllData(g);
            this.paintHighlighting(g);
            this.paintCursor(g);
        } else {
            this.paintBackgroundAndBorder(g);
            this.paintAllData(g);
            this.paintHighlighting(g);
        }
    }

    public Dimension getMinimumSize(int rows) {
        this.checkInit();
        int minHeight = rows * this.char_height + 2 * this.border_height;
        if (this.height < minHeight) {
            return this.getPreferredSize();
        }
        return new Dimension(this.width, minHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        this.checkInit();
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void checkInit() {
        if (!this.initialized) {
            this.init();
        }
    }

    public void setCursorFromMousePosition(MouseEvent me) {
        this.cursor_x = (me.getX() - this.border_width) / this.char_width;
        this.cursor_y = (me.getY() - this.border_height) / this.char_height;
        this.cursor_x = this.clip(this.cursor_x, 0, this.getColumns() - 1);
        this.cursor_y = this.clip(this.cursor_y, 0, this.getRows() - 1);
        this.shiftMode = false;
    }

    public boolean isCursorInDataArea() {
        return this.cursor_x >= this.getDataAreaBegin();
    }

    public boolean isCursorInAddrArea() {
        return this.cursor_x < this.getAddrAreaEnd();
    }

    public int getDataAreaBegin() {
        return this.n_chars_per_addr + 2;
    }

    public int getAddrAreaEnd() {
        return this.n_chars_per_addr;
    }

    public int getWordsPerRow() {
        return this.n_words_per_row;
    }

    public int getWordsPerInstruction() {
        return 1;
    }

    public int getRelativeDataCursor() {
        if (!this.isCursorInDataArea()) {
            MemoryHexEditorField.msg("-E- Internal in getRelativeDataCursor: cursor is in addr!");
            return 0;
        }
        int tmp = (this.cursor_x - this.getDataAreaBegin()) % (this.n_chars_per_word + 1);
        return this.clip(tmp, 0, this.n_chars_per_word - 1);
    }

    public int getAddrFromCursorPosition() {
        if (!this.isCursorInDataArea()) {
            System.out.println("-E- Internal in get cursor is in addr!");
            return 0;
        }
        int tmp = (this.cursor_x - this.getDataAreaBegin()) / (this.n_chars_per_word + 1) * 1;
        tmp = this.clip(tmp, 0, this.n_words_per_row - 1);
        return this.cursor_y * this.getWordsPerRow() + tmp;
    }

    public int getCursorAddrIndex() {
        if (!this.isCursorInAddrArea()) {
            MemoryHexEditorField.msg("-E- Internal in getCursorAddrIndex: cursor isn't in addr!");
            return 0;
        }
        return this.cursor_y * this.getWordsPerRow();
    }

    public int clip(int currentValue, int minValue, int maxValue) {
        if (currentValue < minValue) {
            return minValue;
        }
        if (currentValue > maxValue) {
            return maxValue;
        }
        return currentValue;
    }

    public void moveCursorTo(int x, int y) {
        this.cursor_x = x;
        this.cursor_y = y;
        this.shiftMode = false;
    }

    public void moveCursorRight() {
        ++this.cursor_x;
        this.cursor_x = this.clip(this.cursor_x, 0, this.getColumns() - 1);
        this.shiftMode = false;
        this.checkCursorIsVisibleOrScrollDown();
    }

    public void moveCursorLeft() {
        --this.cursor_x;
        this.cursor_x = this.clip(this.cursor_x, 0, this.getColumns() - 1);
        this.shiftMode = false;
        this.checkCursorIsVisibleOrScrollUp();
    }

    public void moveCursorUp() {
        --this.cursor_y;
        this.cursor_y = this.clip(this.cursor_y, 0, this.getRows() - 1);
        this.shiftMode = false;
        this.checkCursorIsVisibleOrScrollUp();
    }

    public void moveCursorDown() {
        ++this.cursor_y;
        this.cursor_y = this.clip(this.cursor_y, 0, this.getRows() - 1);
        this.shiftMode = false;
        this.checkCursorIsVisibleOrScrollDown();
    }

    public void moveHome() {
        this.moveCursorToDataAtAddr(0);
    }

    public void moveEnd() {
        this.moveCursorToDataAtAddr(this.n_words - 1);
    }

    public void moveCursorToDataAtAddr(int addr) {
        this.cursor_y = addr / this.getWordsPerRow();
        int delta_addr = (addr - this.cursor_y * this.getWordsPerRow()) / 1;
        this.cursor_x = this.getDataAreaBegin() + delta_addr * (this.n_chars_per_word + 1);
        this.checkCursorIsVisibleOrScroll();
    }

    protected void moveTabNextOLD() {
        int addr = this.getAddrFromCursorPosition();
        addr = this.clip(addr + 1, 0, this.n_words - 1);
        this.moveCursorToDataAtAddr(addr);
        this.shiftMode = false;
    }

    protected void moveTabPrevOLD() {
        int addr = this.getAddrFromCursorPosition();
        addr = this.clip(addr - 1, 0, this.n_words - 1);
        this.moveCursorToDataAtAddr(addr);
        this.shiftMode = false;
    }

    public void moveTabNext() {
        int addr = this.getAddrFromCursorPosition();
        addr = this.clip(addr + 1, 0, this.n_words - 1);
        this.moveCursorToDataAtAddr(addr);
        this.shiftMode = false;
        this.checkCursorIsVisibleOrScrollDown();
    }

    public void moveTabPrev() {
        int addr = this.getAddrFromCursorPosition();
        addr = this.clip(addr - 1, 0, this.n_words - 1);
        this.moveCursorToDataAtAddr(addr);
        this.shiftMode = false;
        this.checkCursorIsVisibleOrScrollUp();
    }

    public void checkCursorIsVisibleOrScrollDown() {
        if (!this.isCursorVisible() && this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            Rectangle oldRec = parent.getViewRect();
            int oldX = (int)oldRec.getX();
            int oldY = (int)oldRec.getY();
            int newX = this.getCursorXPixel();
            int newY = this.getCursorYPixel();
            newX = newX < oldX ? 0 : ((double)newX > (double)oldX + oldRec.getWidth() ? oldX + (this.getDataFieldWidth(this.n_bits_per_word) + 1) * this.char_width : oldX);
            newY = (double)newY > (double)oldY + oldRec.getHeight() ? oldY + this.char_height : oldY;
            Point newP = new Point(newX, newY);
            parent.setViewPosition(newP);
        }
    }

    public void checkCursorIsVisibleOrScrollUp() {
        if (!this.isCursorVisible() && this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            Rectangle oldRec = parent.getViewRect();
            int oldX = (int)oldRec.getX();
            int oldY = (int)oldRec.getY();
            int newX = this.getCursorXPixel();
            int newY = this.getCursorYPixel();
            newX = newX < oldX ? 0 : ((double)newX > (double)oldX + oldRec.getWidth() ? (int)this.getPreferredSize().getWidth() : oldX);
            newY = newY + this.char_height > oldY ? oldY - this.char_height : oldY;
            Point newP = new Point(newX, newY);
            parent.setViewPosition(newP);
        }
    }

    public void checkCursorIsVisibleOrScroll() {
        if (!this.isCursorVisible() && this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            Rectangle oldRec = parent.getViewRect();
            int oldX = (int)oldRec.getX();
            int oldY = (int)oldRec.getY();
            int newX = 0;
            int newY = this.clip(this.getCursorYPixel() - this.baseline, 0, (int)((double)this.getHeight() - oldRec.getHeight()));
            Point newP = new Point(newX, newY);
            parent.setViewPosition(newP);
        }
    }

    public boolean isCursorVisible() {
        int x = this.getCursorXPixel();
        int y = this.getCursorYPixel();
        if (this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            Rectangle origRec = parent.getViewRect();
            Rectangle newRec = new Rectangle((int)origRec.getX(), (int)origRec.getY() + this.char_height, (int)origRec.getWidth(), (int)origRec.getHeight() - this.char_height);
            return newRec.contains(x, y);
        }
        return true;
    }

    public int getCursorYPixel() {
        return this.border_height + this.baseline + this.cursor_y * this.char_height;
    }

    public int getCursorXPixel() {
        return this.border_width + this.cursor_x * this.char_width;
    }

    public void incrementValue() {
        if (!this.isCursorInDataArea()) {
            MemoryHexEditorField.msg("-E- Internal in decrementValue: not in data area!");
            return;
        }
        int addr = this.getAddrFromCursorPosition();
        int offset = this.getRelativeDataCursor();
        long value = this.getData(addr) + digit_masks[this.n_chars_per_word - offset];
        MemoryHexEditorField.msg("-D- incremen: addr= " + addr + " offset= " + offset);
        this.setData(addr, value &= bit_masks[this.n_bits_per_word]);
        this.modified = true;
    }

    public void decrementValue() {
        if (!this.isCursorInDataArea()) {
            MemoryHexEditorField.msg("-E- Internal in decrementValue: not in data area!");
            return;
        }
        int addr = this.getAddrFromCursorPosition();
        int offset = this.getRelativeDataCursor();
        long value = this.getData(addr) - digit_masks[this.n_chars_per_word - offset];
        MemoryHexEditorField.msg("-D- incremen: addr= " + addr + " offset= " + offset);
        this.setData(addr, value &= bit_masks[this.n_bits_per_word]);
        this.modified = true;
    }

    public void editStartAddress(char c) {
    }

    public void setShiftMode(boolean mode) {
        this.shiftMode = mode;
    }

    public void insertDigitAtMousePosition(char c) {
        if (!MemoryHexEditorField.isHexDigit(c)) {
            return;
        }
        if (this.isCursorInAddrArea()) {
            this.editStartAddress(c);
            return;
        }
        if (!this.isCursorInDataArea()) {
            MemoryHexEditorField.msg("-E- Internal in insertDigitAtMousePosition: not in data area!");
            return;
        }
        int addr = this.getAddrFromCursorPosition();
        int offset = this.getRelativeDataCursor();
        long value = this.getData(addr);
        String source = HexFormat.getHexStringOrX(value, this.n_chars_per_word);
        StringBuffer buffer = new StringBuffer(source);
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.charAt(i) != 'X') continue;
            buffer.setCharAt(i, '0');
        }
        buffer.setCharAt(offset, c);
        if (offset == this.n_chars_per_word - 1) {
            this.shiftMode = true;
        } else {
            this.moveCursorRight();
        }
        try {
            value = Long.parseLong(buffer.toString(), 16);
        }
        catch (Exception e) {
            value = 0L;
        }
        this.setData(addr, value &= bit_masks[this.n_bits_per_word]);
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.requestFocus();
        this.setCursorFromMousePosition(me);
        if (me.isAltDown()) {
            this.incrementValue();
        } else if (me.isMetaDown()) {
            this.decrementValue();
        }
        if (this.isCursorInDataArea()) {
            int index = this.getAddrFromCursorPosition();
            int offset = this.getRelativeDataCursor();
            MemoryHexEditorField.msg("-D- in data area, addr= " + index + " offset= " + offset);
        } else {
            int addr = this.getCursorAddrIndex();
            MemoryHexEditorField.msg("-A- in addr area, addr= " + addr);
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (SetupManager.getBoolean("Hades.Editor.FocusOnMouseEnter", false)) {
            this.requestFocus();
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.setCursorFromMousePosition(me);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        char c = ke.getKeyChar();
        int code = ke.getKeyCode();
        if (ke.isActionKey()) {
            if (code == 39) {
                this.moveCursorRight();
            } else if (code == 37) {
                this.moveCursorLeft();
            } else if (code == 38) {
                if (ke.isShiftDown()) {
                    this.incrementValue();
                } else {
                    this.moveCursorUp();
                }
            } else if (code == 40) {
                if (ke.isShiftDown()) {
                    this.decrementValue();
                } else {
                    this.moveCursorDown();
                }
            } else if (code == 36) {
                this.moveHome();
            } else if (code == 35) {
                this.moveEnd();
            } else if (code == 155) {
                this.insertMode = !this.insertMode;
            }
        } else if (c == '\t') {
            if (ke.isShiftDown()) {
                this.moveTabPrev();
            } else {
                this.moveTabNext();
            }
        } else if (c == ' ') {
            if (ke.isShiftDown()) {
                this.moveTabPrev();
            } else {
                this.moveTabNext();
            }
        } else if (c == 'I') {
            this.insertNewWordAtMousePosition();
        } else {
            this.insertDigitAtMousePosition(c);
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    public static void msg(String msg) {
    }

    public static void main(String[] argv) {
        MemoryHexEditorField.msg("MemoryHexEditorField selftest...");
        SetupManager.loadLocalProperties(".hadesrc");
        long[] data = new long[65536];
        for (int i = 0; i < data.length; ++i) {
            data[i] = i;
        }
        long[] data2 = new long[2048];
        for (int i = 0; i < data2.length; ++i) {
            data2[i] = i & 0xFF;
        }
        JFrame f = new JFrame("MemoryHexEditorField Demo");
        f.setSize(new Dimension(100, 100));
        f.setVisible(true);
        ImageHelper.setVisibleParent(f);
        f.pack();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return 16 * this.char_height;
        }
        return 4 * this.char_width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.char_height;
        }
        return this.char_width;
    }

    public int getColumns() {
        return this.n_columns;
    }

    public int getRows() {
        return this.n_rows;
    }

    public int getCursor_x() {
        return this.cursor_x;
    }

    public int getCursor_y() {
        return this.cursor_y;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modi) {
        this.modified = modi;
    }
}

