/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import java.util.Enumeration;
import java.util.Hashtable;
import jfig.objects.FigObject;
import jfig.utils.SetupManager;

public class LayerTable {
    Hashtable layerTable;
    public final String[][] names = new String[][]{{"Hades.LayerTable.DisplayInstanceBorder", "hades.symbols.InstanceBorder"}, {"Hades.LayerTable.DisplayClassLabels", "hades.symbols.ClassLabel"}, {"Hades.LayerTable.DisplayInstanceLabels", "hades.symbols.InstanceLabel"}, {"Hades.LayerTable.DisplayPortLabels", "hades.symbols.PortLabel"}, {"Hades.LayerTable.DisplayPortSymbols", "hades.symbols.PortSymbol"}, {"Hades.LayerTable.DisplayRtlibAnimation", "hades.symbols.RtlibAnimation"}};

    public LayerTable() {
        this.layerTable = new Hashtable();
        this.initialize();
    }

    private void initialize() {
        int i = 0;
        while (i < this.names.length) {
            boolean b = SetupManager.getBoolean(this.names[i][0], true);
            this.layerTable.put(this.names[i][1], b);
            ++i;
        }
    }

    public void setVisibility(FigObject tmp, boolean visible) {
        String classname = tmp.getClass().getName();
        this.layerTable.put(classname, visible);
    }

    public void setVisibility(String classname, boolean visible) {
        this.layerTable.put(classname, visible);
    }

    public boolean getVisibility(String classname) {
        if (classname == null) {
            return false;
        }
        Object result = this.layerTable.get(classname);
        if (result == null) {
            return false;
        }
        return (Boolean)result;
    }

    public boolean isVisible(FigObject tmp) {
        String classname = tmp.getClass().getName();
        if (this.layerTable.containsKey(classname)) {
            return (Boolean)this.layerTable.get(classname);
        }
        this.layerTable.put(classname, true);
        return true;
    }

    public String toString() {
        String s = "LayerTable:\n";
        Enumeration e = this.layerTable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            s = s + "   " + key + " " + this.layerTable.get(key) + "\n";
        }
        return s;
    }
}

