/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.JImageButton;
import hades.gui.JTrafficLight;
import hades.gui.SimControlPanel;
import hades.simulator.BatchModeSimKernel;
import hades.simulator.InteractiveSimKernel;
import hades.simulator.RealTimeSimKernel;
import hades.simulator.SimKernel;
import hades.simulator.VhdlBatchSimKernel;
import hades.simulator.VhdlSimKernel;
import hades.styx.TimeFormatter;
import hades.utils.ToolTipManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import jfig.gui.ImageHelper;
import jfig.gui.JStatusCanvas;
import jfig.gui.StatusMessage;
import jfig.utils.SetupManager;

public class JSimControlPanel
extends JPanel
implements SimControlPanel,
ActionListener,
ItemListener {
    private SimKernel simulator;
    private JImageButton pauseButton;
    private JImageButton resetButton;
    private JImageButton singleStepButton;
    private JImageButton runForButton;
    private JImageButton runForeverButton;
    private JImageButton statusButton;
    private JTextField deltatTextField;
    private JComboBox unitsJComboBox;
    private JComboBox batchOrInteractiveJComboBox;
    private JTrafficLight trafficLight;
    private SimTimePanel simTimePanel;
    private StatusMessage helper;
    private Frame parent;
    private static boolean debug = false;

    public JSimControlPanel(SimKernel sim, Frame parent) {
        this.simulator = sim;
        this.parent = parent;
        this.helper = null;
        this.buildGUI();
        this.simulator.setControlPanel(this);
    }

    public Component getComponent() {
        return this;
    }

    public void setStatusMessage(StatusMessage helper) {
        this.helper = helper;
        this.resetButton.setStatusMessage(helper);
        this.pauseButton.setStatusMessage(helper);
        this.singleStepButton.setStatusMessage(helper);
        this.runForeverButton.setStatusMessage(helper);
        this.runForButton.setStatusMessage(helper);
        this.statusButton.setStatusMessage(helper);
    }

    public void setSimulator(SimKernel simulator) {
        this.simulator = simulator;
        this.simulator.setControlPanel(this);
        this.updateVisual();
    }

    private void buildGUI() {
        Image icons = null;
        Image[] crop_black = new Image[10];
        Image[] crop_gray = new Image[10];
        try {
            icons = ImageHelper.loadResourceImage("/hades/gui/images/simcontrol.gif");
        }
        catch (Throwable e) {
            System.err.println(e.toString());
        }
        try {
            if (icons != null) {
                int i = 0;
                while (i < 8) {
                    if (this.parent != null) {
                        crop_black[i] = new BufferedImage(20, 20, 2);
                        Graphics cg = crop_black[i].getGraphics();
                        cg.translate(-20 * i, 0);
                        cg.drawImage(icons, 0, 0, this);
                        crop_gray[i] = new BufferedImage(20, 20, 2);
                        cg = crop_gray[i].getGraphics();
                        cg.translate(-20 * i, -20);
                        cg.drawImage(icons, 0, 0, this);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            System.err.println("-E- JSimControlPanel.buildGUI: : " + e);
            e.printStackTrace();
        }
        this.batchOrInteractiveJComboBox = new JComboBox();
        this.batchOrInteractiveJComboBox.addItem("Batch mode");
        this.batchOrInteractiveJComboBox.addItem("Real time");
        this.batchOrInteractiveJComboBox.addItem("VHDL");
        this.batchOrInteractiveJComboBox.addItem("VHDL (batch)");
        this.batchOrInteractiveJComboBox.setToolTipText("select simulation algorithm");
        String defaultName = SetupManager.getProperty("Hades.Editor.DefaultSimKernel", "VHDL");
        this.batchOrInteractiveJComboBox.setSelectedItem(defaultName);
        this.statusButton = new JImageButton("Status", this.helper, "print simulator status", crop_gray[7], crop_black[7]);
        this.statusButton.setActive(true);
        this.resetButton = new JImageButton("Reset", this.helper, "reset to time t=0", crop_gray[1], crop_black[1]);
        this.pauseButton = new JImageButton("Stop", this.helper, "pause the simulator immediately", crop_gray[3], crop_black[3]);
        this.singleStepButton = new JImageButton("Step", this.helper, "single step (next event)", crop_gray[4], crop_black[4]);
        this.runForButton = new JImageButton("Run For:", this.helper, "run for specified time interval", crop_gray[5], crop_black[5]);
        this.runForButton.setEnabled(SetupManager.getBoolean("Hades.Simulator.EnableRunFor", false));
        this.runForeverButton = new JImageButton("Run", this.helper, "run forever (interactive simulation) ", crop_gray[6], crop_black[6]);
        this.deltatTextField = new JTextField("100", 5);
        this.deltatTextField.setBackground(this.getBackground());
        this.unitsJComboBox = new JComboBox();
        this.unitsJComboBox.addItem("days");
        this.unitsJComboBox.addItem("hours");
        this.unitsJComboBox.addItem("min");
        this.unitsJComboBox.addItem("s");
        this.unitsJComboBox.addItem("ms");
        this.unitsJComboBox.addItem("us");
        this.unitsJComboBox.addItem("ns");
        this.unitsJComboBox.addItem("ps");
        this.unitsJComboBox.addItem("fs");
        this.unitsJComboBox.setSelectedItem("ns");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0, 5, 0));
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttonPanel.add(this.statusButton);
        buttonPanel.add(this.resetButton);
        buttonPanel.add(this.pauseButton);
        buttonPanel.add(this.runForeverButton);
        JPanel runForPanel = new JPanel();
        runForPanel.setLayout(new FlowLayout(0, 5, 0));
        runForPanel.setBorder(new EmptyBorder(4, 5, 4, 5));
        runForPanel.add(this.runForButton);
        runForPanel.add(this.deltatTextField);
        runForPanel.add(this.unitsJComboBox);
        JPanel trafficLightPanel = new JPanel();
        trafficLightPanel.setLayout(new FlowLayout(0, 0, 0));
        this.trafficLight = new JTrafficLight();
        trafficLightPanel.add(this.trafficLight);
        this.simTimePanel = new SimTimePanel();
        this.statusButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.pauseButton.addActionListener(this);
        this.singleStepButton.addActionListener(this);
        this.runForButton.addActionListener(this);
        this.runForeverButton.addActionListener(this);
        this.runForeverButton.setActive(true);
        this.setLayout(new FlowLayout(0, 5, 0));
        this.add(this.batchOrInteractiveJComboBox);
        this.add(buttonPanel);
        this.add(runForPanel);
        this.add(trafficLightPanel);
        this.add(this.simTimePanel);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    public void initToolTip() {
        new ToolTipManager((Component)this.statusButton, this.simulator, 2000L);
    }

    public void updateVisual() {
        if (debug) {
            System.out.println("updateVisual()...");
        }
        if (this.simulator.isRunning()) {
            this.pauseButton.setActive(true);
            this.resetButton.setActive(true);
            this.singleStepButton.setActive(false);
            this.runForButton.setActive(false);
            this.runForeverButton.setActive(false);
            this.trafficLight.setState(2);
        } else if (this.simulator.isPaused()) {
            this.pauseButton.setActive(false);
            this.resetButton.setActive(true);
            this.singleStepButton.setActive(true);
            this.runForButton.setActive(true);
            this.runForeverButton.setActive(true);
            this.trafficLight.setState(1);
        } else if (this.simulator.isSingleStep()) {
            this.pauseButton.setActive(false);
            this.resetButton.setActive(true);
            this.singleStepButton.setActive(true);
            this.runForButton.setActive(true);
            this.runForeverButton.setActive(true);
            this.trafficLight.setState(1);
        } else {
            this.pauseButton.setActive(false);
            this.resetButton.setActive(true);
            this.singleStepButton.setActive(this.simulator.hasEvents());
            this.runForButton.setActive(true);
            this.runForeverButton.setActive(true);
            this.trafficLight.setState(0);
        }
        this.simTimePanel.updateTime();
        this.repaint();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.resetButton) {
            this.simulator.stopSimulation();
        } else if (source == this.pauseButton) {
            this.simulator.pauseSimulation();
        } else if (source == this.singleStepButton) {
            this.simulator.singleStep();
        } else if (source == this.runForeverButton) {
            this.simulator.runForever();
        } else if (source == this.runForButton) {
            double dt = 0.0;
            try {
                dt = Double.valueOf(this.deltatTextField.getText().trim());
                if (dt < 0.0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                if (this.helper != null) {
                    this.helper.setStatusMessage("Illegal time interval: Must be a positive floating point value");
                }
                return;
            }
            String s = (String)this.unitsJComboBox.getSelectedItem();
            if (s.equals("fs")) {
                dt *= 1.0E-15;
            } else if (s.equals("ps")) {
                dt *= 1.0E-12;
            } else if (s.equals("ns")) {
                dt *= 1.0E-9;
            } else if (s.equals("us")) {
                dt *= 1.0E-6;
            } else if (s.equals("ms")) {
                dt *= 0.001;
            } else if (s.equals("s")) {
                dt *= 1.0;
            } else if (s.equals("min")) {
                dt *= 60.0;
            } else if (s.equals("hours")) {
                dt *= 3600.0;
            } else if (s.equals("days")) {
                dt *= 86400.0;
            } else {
                System.err.println("-E- internal: unknown time unit: " + s);
                return;
            }
            this.simulator.runFor(dt);
        } else if (source == this.statusButton) {
            this.simulator.printStatus();
        } else {
            System.err.println("JSimControlPanel: unknown action event " + evt);
        }
        this.updateVisual();
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.batchOrInteractiveJComboBox) {
            System.err.println("#### no function defined yet for " + e);
        } else {
            System.err.println("JSimControlPanel: unknown Item event: " + e);
        }
    }

    public void addItemListener(ItemListener IL) {
        this.batchOrInteractiveJComboBox.addItemListener(IL);
    }

    public JComboBox getSimulatorJComboBox() {
        return this.batchOrInteractiveJComboBox;
    }

    public void setShowSimulatorChoice(boolean b) {
        this.batchOrInteractiveJComboBox.setVisible(b);
    }

    public SimKernel createSelectedSimKernel() {
        String choice = (String)this.batchOrInteractiveJComboBox.getSelectedItem();
        SimKernel tmp = null;
        if (choice.equals("Real time")) {
            tmp = new RealTimeSimKernel();
        } else if (choice.equals("Interactive")) {
            tmp = new InteractiveSimKernel();
        } else if (choice.equals("Batch mode")) {
            tmp = new BatchModeSimKernel();
        } else if (choice.equals("VHDL")) {
            tmp = new VhdlSimKernel();
        } else if (choice.equals("VHDL (batch)")) {
            tmp = new VhdlBatchSimKernel();
        } else {
            System.err.println("Illegal simulator choice: " + choice);
        }
        if (tmp == null) {
            tmp = new RealTimeSimKernel();
        }
        return tmp;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void stopSimTimeUpdate() {
        this.simTimePanel.setAlive(false);
    }

    public static void main(String[] argv) {
        System.out.println("hades.simulator.JSimControlPanel self test...");
        JFrame f = new JFrame("HADES Simulation Control Panel");
        f.setSize(new Dimension(400, 200));
        JStatusCanvas statusCanvas = new JStatusCanvas();
        SimKernel sim = new SimKernel();
        JSimControlPanel scp = new JSimControlPanel(sim, f);
        scp.setStatusMessage(statusCanvas);
        f.getContentPane().add("North", scp);
        f.getContentPane().add("South", statusCanvas);
        f.pack();
        f.setVisible(true);
    }

    static /* synthetic */ SimKernel access$100(JSimControlPanel x0) {
        return x0.simulator;
    }

    class SimTimePanel
    extends JPanel
    implements Runnable {
        JLabel timeLabel = new JLabel("t= " + TimeFormatter.format(0.0) + "  ");
        Thread updater = null;
        boolean alive = true;

        public SimTimePanel() {
            this.setLayout(new GridLayout(1, 1, 0, 0));
            this.add(this.timeLabel);
            this.doLayout();
            this.updater = new Thread(this);
            this.updater.setDaemon(true);
            this.updater.start();
            this.setToolTipText("current simulation time");
        }

        public void updateTime() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SimTimePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (JSimControlPanel.access$100(SimTimePanel.access$000(this.this$1)) != null) {
                        double t = JSimControlPanel.access$100(SimTimePanel.access$000(this.this$1)).getSimTime();
                        this.this$1.timeLabel.setText("t= " + TimeFormatter.format(t) + "  ");
                    }
                }
            });
        }

        public void run() {
            while (this.alive) {
                try {
                    this.updateTime();
                    this.repaint();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }

        public void paint(Graphics g) {
            super.paint(g);
        }

        public void setAlive(boolean b) {
            this.alive = b;
        }

        static /* synthetic */ JSimControlPanel access$000(SimTimePanel x0) {
            return x0.JSimControlPanel.this;
        }
    }
}

