/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Editor;
import hades.gui.EditorMenuInteraction;
import hades.gui.JCanvasScroller;
import hades.gui.JObjectCanvas;
import hades.gui.JSimControlPanel;
import hades.gui.LayerTable;
import hades.simulator.SimKernel;
import java.awt.BorderLayout;
import java.awt.Image;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import jfig.gui.ImageHelper;
import jfig.objects.FigAttribs;
import jfig.utils.JRecentFileManager;
import jfig.utils.SetupManager;

public class JEditFrame
extends JFrame
implements EditorMenuInteraction {
    private Image icon;
    private Editor editor;
    private JRecentFileManager recentFileManager;
    private JMenuBar menuBar;
    private JMenuItem closeWindowMI;
    private JMenuItem undoMI;
    private JMenuItem redoMI;
    private JMenuItem layerDisplayAllMI;
    private JMenuItem layerDisplayNoneMI;
    private JCheckBoxMenuItem viewModeMI;
    private JCheckBoxMenuItem rtlibAnimationMI;
    private JCheckBoxMenuItem glowModeMI;
    private JCheckBoxMenuItem inverseCanvasMI;
    private JCheckBoxMenuItem renderQualityMI;
    private JCheckBoxMenuItem antiAliasMI;
    private JCheckBoxMenuItem enableToolTipsMI;
    private JCheckBoxMenuItem enableSplitSignalsMI;
    private JCheckBoxMenuItem enableCreateSignalsMI;
    private JCheckBoxMenuItem layerInstanceLabelsMI;
    private JCheckBoxMenuItem layerClassLabelsMI;
    private JCheckBoxMenuItem layerPortLabelsMI;
    private JCheckBoxMenuItem layerPortSymbolsMI;
    private JCheckBoxMenuItem layerBusPortSymbolsMI;
    private JCheckBoxMenuItem layerInstanceBorderMI;
    private static String __demosRoot = "resource:///hades/examples/appetizers/";
    private static String[][] __demos = new String[][]{{"std_logic_1164", "std_logic_1164.hds"}, {"switches", "switches.hds"}, {"clockgen", "clockgen.hds"}, {"separator", ""}, {"basic gates", "basic.hds"}, {"12-input AND function", "and12.hds"}, {"2-bit multiplier", "mult2x2.hds"}, {"seven-segment decoder", "sevensegment.hds"}, {"multiplexer demultiplexer", "mux-demux.hds"}, {"4-bit Hamming code", "hamming.hds"}, {"separator", ""}, {"hazards", "hazard.hds"}, {"ring-oscillator", "ringoscillator.hds"}, {"separator", ""}, {"1-bit full adder", "adder1.hds"}, {"8-bit ripple-carry adder", "ripple.hds"}, {"74181 ALU", "demo-74181.hds"}, {"separator", ""}, {"SR-type latch", "srff.hds"}, {"D-type latch", "dlatch.hds"}, {"D-type flipflop", "dff.hds"}, {"JK-type flipflop", "jkff.hds"}, {"flipflop overview", "flipflopdemo.hds"}, {"synchronous counter", "sync-counter.hds"}, {"749x counters", "demo-749x.hds"}, {"74219 16x4 bit RAM", "demo-74219.hds"}, {"separator", ""}, {"DIN gate symbols", "komparator.hds"}, {"FSM editor", "traffic-light.hds"}, {"rtlib counter", "rtlib-counter.hds"}, {"rtlib ALU", "rtlib-alu.hds"}, {"separator", ""}, {"PIC 16C84 stopwatch", "swatch.hds"}};

    public JEditFrame(Editor editor, String name) {
        super(name);
        this.editor = editor;
        this.buildMenu();
        this.getIcon();
        this.createRecentFileManager();
        this.getContentPane().setLayout(new BorderLayout());
    }

    public Object getUndoMenuItem() {
        return this.undoMI;
    }

    public Object getRedoMenuItem() {
        return this.redoMI;
    }

    public void setEnableCloseWindowMenuItem(boolean b) {
        this.closeWindowMI.setEnabled(b);
    }

    public boolean isViewModeSelected() {
        return this.viewModeMI.isSelected();
    }

    public boolean isGlowModeSelected() {
        return this.glowModeMI.isSelected();
    }

    public boolean isRtlibAnimationSelected() {
        return this.rtlibAnimationMI.isSelected();
    }

    public boolean isInverseCanvasSelected() {
        return this.inverseCanvasMI.isSelected();
    }

    public boolean isEnableAntialiasSelected() {
        return this.antiAliasMI.isSelected();
    }

    public boolean isEnableToolTipsSelected() {
        return this.enableToolTipsMI.isSelected();
    }

    public boolean isRenderQualitySelected() {
        return this.renderQualityMI.isSelected();
    }

    public boolean isEnableSplitSignalsSelected() {
        return this.enableSplitSignalsMI.isSelected();
    }

    public boolean isEnableCreateSignalsSelected() {
        return this.enableCreateSignalsMI.isSelected();
    }

    public void setViewModeSelected(boolean b) {
        this._update(this.viewModeMI, b);
    }

    public void setGlowModeSelected(boolean b) {
        this._update(this.glowModeMI, b);
    }

    public void setRtlibAnimationSelected(boolean b) {
        this._update(this.rtlibAnimationMI, b);
    }

    public void setInverseCanvasSelected(boolean b) {
        this._update(this.inverseCanvasMI, b);
    }

    public void setEnableAntialiasSelected(boolean b) {
        this._update(this.antiAliasMI, b);
    }

    public void setRenderQualitySelected(boolean b) {
        this._update(this.renderQualityMI, b);
    }

    public void setEnableToolTipsSelected(boolean b) {
        this._update(this.enableToolTipsMI, b);
    }

    public void setEnableSplitSignalsSelected(boolean b) {
        this._update(this.enableSplitSignalsMI, b);
    }

    public void setEnableCreateSignalsSelected(boolean b) {
        this._update(this.enableCreateSignalsMI, b);
    }

    public void updateLayerMenuItems(Object arg) {
        if (arg instanceof LayerTable) {
            LayerTable lt = (LayerTable)arg;
            this._update(this.layerInstanceLabelsMI, lt.getVisibility("hades.symbols.InstanceLabel"));
            this._update(this.layerClassLabelsMI, lt.getVisibility("hades.symbols.ClassLabel"));
            this._update(this.layerPortLabelsMI, lt.getVisibility("hades.symbols.PortLabel"));
            this._update(this.layerPortSymbolsMI, lt.getVisibility("hades.symbols.PortSymbol"));
            this._update(this.layerBusPortSymbolsMI, lt.getVisibility("hades.symbols.BusPortSymbol"));
            this._update(this.layerInstanceBorderMI, lt.getVisibility("hades.symbols.BboxRectangle"));
        } else {
            this.msg("-E- JEditFrame.updateLayerMenuItems: unknown argument: " + arg);
        }
    }

    private void _update(JCheckBoxMenuItem cbmi, boolean state) {
        cbmi.removeItemListener(this.editor);
        cbmi.setSelected(state);
        cbmi.addItemListener(this.editor);
    }

    public void createRecentFileManager() {
        try {
            this.recentFileManager = new JRecentFileManager(4);
            if (this.menuBar == null) {
                return;
            }
            JMenu fileMenu = this.menuBar.getMenu(0);
            JMenuItem[] items = this.recentFileManager.createMenuItems(this.editor);
            fileMenu.addSeparator();
            int i = 0;
            while (i < items.length) {
                fileMenu.add(items[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.recentFileManager.getSize()) {
                this.editor.addCallback("RecentFile" + i2, "doOpenRecentFile", "" + i2);
                ++i2;
            }
            String name = System.getProperty("user.home") + File.separator + ".hades" + File.separator + "recent-files.txt";
            this.recentFileManager.loadFromFile(name);
        }
        catch (SecurityException se) {
        }
        catch (Exception ee) {}
    }

    public void msg(String msg) {
        System.err.println(msg);
    }

    public JMenuItem CMI(String label, String callback) {
        return this.CMI(label, callback, "");
    }

    public JMenuItem CMI(String label, String callback, String arg) {
        JMenuItem tmp = new JMenuItem(label);
        if (this.editor != null) {
            this.editor.addCallback(label, callback, arg);
            tmp.addActionListener(this.editor);
        }
        return tmp;
    }

    private JMenuItem XCMI(String label, String callback) {
        JMenuItem tmp = this.CMI(label, callback, "");
        tmp.setEnabled(false);
        return tmp;
    }

    private JCheckBoxMenuItem CBM(String label, String callback, boolean b) {
        JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem(label);
        jcbmi.setSelected(b);
        if (this.editor != null) {
            jcbmi.addItemListener(this.editor);
            this.editor.addCallback(jcbmi, callback, jcbmi);
        }
        return jcbmi;
    }

    private void SC(JMenuItem menuitem, String s) {
        try {
            menuitem.setAccelerator(KeyStroke.getKeyStroke(s));
        }
        catch (Throwable e) {}
    }

    private void addCallback(JMenuItem menuitem, String methodname, String arg) {
        if (this.editor != null) {
            this.editor.addCallback(menuitem, methodname, arg);
        }
    }

    public void buildMenu() {
        JMenuItem tmp = null;
        JMenu fileMenu = new JMenu("File");
        tmp = this.CMI("New", "doStartNewDesign");
        fileMenu.add(tmp);
        this.SC(tmp, "control N");
        tmp = this.CMI("Open...", "doOpenFile");
        fileMenu.add(tmp);
        this.SC(tmp, "control O");
        tmp = this.CMI("Open URL...", "doOpenURL");
        fileMenu.add(tmp);
        tmp = this.CMI("Save", "doSaveFile");
        fileMenu.add(tmp);
        this.SC(tmp, "control S");
        tmp = this.CMI("SaveAs...", "doSaveFileAs");
        fileMenu.add(tmp);
        tmp = this.CMI("Save configuration...", "doSaveConfiguration");
        fileMenu.add(tmp);
        fileMenu.addSeparator();
        tmp = this.XCMI("Print setup...", "dummyCallback");
        fileMenu.add(tmp);
        tmp = this.CMI("Print", "doPrintDesign");
        fileMenu.add(tmp);
        this.SC(tmp, "control P");
        fileMenu.addSeparator();
        tmp = this.CMI("Create new window", "doCreateNewEmptyEditor");
        fileMenu.add(tmp);
        fileMenu.addSeparator();
        this.closeWindowMI = this.CMI("Close", "doClose");
        fileMenu.add(this.closeWindowMI);
        this.SC(this.closeWindowMI, "control W");
        tmp = this.CMI("Exit", "doExit");
        fileMenu.add(tmp);
        this.SC(tmp, "control Q");
        JMenu editMenu = new JMenu("Edit");
        tmp = this.CMI("Cancel", "doCancel");
        editMenu.add(tmp);
        this.SC(tmp, "ESCAPE");
        this.undoMI = this.CMI("Undo", "doUndo");
        editMenu.add(this.undoMI);
        this.SC(this.undoMI, "control Z");
        this.redoMI = this.CMI("Redo", "doRedo");
        editMenu.add(this.redoMI);
        this.SC(this.redoMI, "control R");
        this.addCallback(this.undoMI, "doUndo", "");
        this.addCallback(this.redoMI, "doRedo", "");
        editMenu.addSeparator();
        tmp = this.CMI("Open component browser", "doOpenBrowser");
        editMenu.add(tmp);
        editMenu.addSeparator();
        if (SetupManager.getBoolean("Hades.Editor.EnableSelectionMenu", false)) {
            tmp = this.CMI("Select all objects", "doSelectAllObjects");
            editMenu.add(tmp);
            tmp = this.CMI("Select object (toggle)", "doSelectObject");
            editMenu.add(tmp);
            tmp = this.CMI("Select region", "doSelectRegion");
            editMenu.add(tmp);
            tmp = this.CMI("Deselect all objects", "doDeselectAllObjects");
            editMenu.add(tmp);
            tmp = this.CMI("Delete selection", "doDeleteSelection");
            editMenu.add(tmp);
            tmp = this.CMI("Move selection", "doMoveSelection");
            editMenu.add(tmp);
            tmp = this.CMI("Copy selection", "doCopySelection");
            editMenu.add(tmp);
            editMenu.addSeparator();
        }
        tmp = this.CMI("Set design name...", "doSetDesignName");
        editMenu.add(tmp);
        tmp = this.CMI("Create symbol", "doCreateSymbol");
        editMenu.add(tmp);
        tmp = this.XCMI("Edit symbol", "doEditSymbol");
        editMenu.add(tmp);
        editMenu.addSeparator();
        tmp = this.CMI("Autoconnect object...", "doAutoconnect");
        editMenu.add(tmp);
        tmp = this.CMI("Disconnect object...", "doDisconnect");
        editMenu.add(tmp);
        tmp = this.CMI("Mirror object (x-axis)", "doMirrorXObject");
        editMenu.add(tmp);
        tmp = this.CMI("Mirror object (y-axis)", "doMirrorYObject");
        editMenu.add(tmp);
        editMenu.addSeparator();
        tmp = this.CMI("Delete All", "doDeleteAll");
        editMenu.add(tmp);
        tmp = this.CMI("Move/fit design to positive quadrant", "doFitPositive");
        editMenu.add(tmp);
        tmp = this.CMI("Rebuild object list", "doRebuildObjectList");
        editMenu.add(tmp);
        tmp = this.CMI("Redraw [all]", "doRedraw");
        editMenu.add(tmp);
        this.SC(tmp, "F5");
        JMenu windowMenu = new JMenu("View");
        tmp = this.CMI("Zoom Fit ", "doZoomFit");
        windowMenu.add(tmp);
        this.SC(tmp, "control F");
        tmp = this.CMI("Zoom Region ", "doZoomRegion");
        windowMenu.add(tmp);
        tmp = this.CMI("Zoom In   1.4", "doZoomIn14");
        windowMenu.add(tmp);
        tmp = this.CMI("Zoom In   1.1", "doZoomIn11");
        windowMenu.add(tmp);
        tmp = this.CMI("Zoom Out  0.9", "doZoomOut09");
        windowMenu.add(tmp);
        tmp = this.CMI("Zoom Out  0.7", "doZoomOut07");
        windowMenu.add(tmp);
        tmp = this.CMI("Zoom 1:1 ", "doZoom11");
        windowMenu.add(tmp);
        this.SC(tmp, "control 1");
        tmp = this.CMI("Zoom A4 paper", "doZoomLandscapeA4");
        windowMenu.add(tmp);
        JMenu selectSnapMenu = new JMenu("Magnetic grid...");
        tmp = this.CMI("1/2 inch", "doSetCoarseSnap");
        selectSnapMenu.add(tmp);
        this.SC(tmp, "control 2");
        tmp = this.CMI("1/4 inch", "doSetMediumSnap");
        selectSnapMenu.add(tmp);
        this.SC(tmp, "control 4");
        tmp = this.CMI("1/8 inch", "doSetFineSnap");
        selectSnapMenu.add(tmp);
        this.SC(tmp, "control 8");
        tmp = this.CMI("1/16 inch", "doSetTinySnap");
        selectSnapMenu.add(tmp);
        this.SC(tmp, "control 6");
        tmp = this.CMI("any position", "doSetNoSnap");
        selectSnapMenu.add(tmp);
        this.SC(tmp, "control 0");
        JMenu selectGridMenu = new JMenu("Select Grid...");
        tmp = this.CMI("no grid", "doSetNoGrid");
        selectGridMenu.add(tmp);
        this.SC(tmp, "control J");
        tmp = this.CMI("coarse grid", "doSetCoarseGrid");
        selectGridMenu.add(tmp);
        tmp = this.CMI("medium grid", "doSetMediumGrid");
        selectGridMenu.add(tmp);
        this.SC(tmp, "control H");
        tmp = this.CMI("fine grid", "doSetFineGrid");
        selectGridMenu.add(tmp);
        JMenu selectUnitsMenu = new JMenu("Select Units...");
        selectUnitsMenu.add(this.XCMI("inches", "doNothing"));
        selectUnitsMenu.add(this.XCMI("mm", "doNothing"));
        selectUnitsMenu.add(this.XCMI("xmm", "doNothing"));
        JMenu fpsMenu = new JMenu("Select repaint frequency...");
        fpsMenu.add(this.CMI("configuration default", "doSetFramerate", "-1"));
        fpsMenu.addSeparator();
        fpsMenu.add(this.CMI(" 40 frames/sec.", "doSetFramerate", "40"));
        fpsMenu.add(this.CMI(" 20 frames/sec.", "doSetFramerate", "20"));
        fpsMenu.add(this.CMI(" 10 frames/sec.", "doSetFramerate", "10"));
        fpsMenu.add(this.CMI("  3 frames/sec.", "doSetFramerate", "3"));
        fpsMenu.add(this.CMI("  1 frame/sec.", "doSetFramerate", "1"));
        fpsMenu.add(this.CMI("0.1 frame/sec.", "doSetFramerate", "0.1"));
        fpsMenu.addSeparator();
        fpsMenu.add(this.CMI("stop sync. redraw", "doSetFramerate", "0"));
        windowMenu.addSeparator();
        windowMenu.add(selectSnapMenu);
        windowMenu.add(selectGridMenu);
        windowMenu.add(selectUnitsMenu);
        windowMenu.addSeparator();
        windowMenu.add(fpsMenu);
        JMenu layersMenu = this.createLayersMenu();
        JMenu initSignalsMenu = new JMenu("Initialize all Signals...");
        initSignalsMenu.add(this.CMI("value '0'", "doInitSignals", "0"));
        initSignalsMenu.add(this.CMI("value '1'", "doInitSignals", "1"));
        initSignalsMenu.add(this.CMI("value 'U'", "doInitSignals", "2"));
        initSignalsMenu.add(this.CMI("random '0/1' values", "doInitSignals", "-1"));
        initSignalsMenu.setEnabled(SetupManager.getBoolean("Hades.Editor.EnableInitializeSignalsMenu", false));
        JMenu apMenu = new JMenu("Add probes...");
        apMenu.add(this.CMI("all signals ", "addProbesToAllSignals"));
        apMenu.add(this.CMI("toplevel signals ", "addProbesToToplevelSignals"));
        apMenu.add(this.CMI("toplevel I/O ", "addProbesToToplevelIO"));
        JMenu rpMenu = new JMenu("Remove probes...");
        rpMenu.add(this.CMI("all signals", "removeProbesFromAllSignals"));
        rpMenu.add(this.CMI("toplevel signals", "removeProbesFromToplevelSignals"));
        rpMenu.add(this.CMI("toplevel I/O", "removeProbesFromToplevelIO"));
        JMenu signalsMenu = new JMenu("Signals");
        signalsMenu.add(initSignalsMenu);
        signalsMenu.addSeparator();
        signalsMenu.add(apMenu);
        signalsMenu.add(rpMenu);
        signalsMenu.addSeparator();
        signalsMenu.add(this.CMI("Show Waves...", "doShowWaves"));
        signalsMenu.add(this.CMI("Clear Waves...", "doClearWaveData"));
        JMenu exportMenu = new JMenu("Export");
        exportMenu.add(this.CMI("Settings...", "doShowExportOptions"));
        exportMenu.addSeparator();
        exportMenu.add(this.CMI("Postscript...", "doExportPostscript"));
        exportMenu.add(this.CMI("Fig2dev...", "doExportFig2dev"));
        exportMenu.add(this.CMI("PPM...", "doExportPPM"));
        exportMenu.add(this.CMI("GIF...", "doExportGIF"));
        JMenu vhdlMenu = new JMenu("VHDL");
        vhdlMenu.add(this.CMI("VHDL Options...", "doSelectVHDLOptions"));
        vhdlMenu.add(this.CMI("Export VHDL...", "doExportVHDL"));
        JMenu optionsMenu = new JMenu("Options");
        tmp = this.CMI("Show messages... ", "doShowMessages");
        optionsMenu.add(tmp);
        this.SC(tmp, "control M");
        optionsMenu.add(this.CMI("Show properties...", "doShowProperties"));
        tmp = this.CMI("Open Jython Console...", "doCreateJythonConsole");
        optionsMenu.add(tmp);
        try {
            if (SetupManager.getBoolean("Hades.Applet.EnablePyObjectLookup", true)) {
                Class.forName("org.python.core.PyObject");
            }
            tmp.setEnabled(true);
        }
        catch (ClassNotFoundException cnfe) {
            tmp.setEnabled(false);
        }
        optionsMenu.add(this.CMI("Call a method...", "doCallMethod"));
        optionsMenu.addSeparator();
        optionsMenu.add(this.CMI("Check design", "doCheckDesign"));
        optionsMenu.add(this.CMI("Check design and highlight errors", "doCheckDesignAndHighlightErrors"));
        optionsMenu.add(this.CMI("Remove highlight markers", "removeHighlightMarkers"));
        optionsMenu.addSeparator();
        optionsMenu.add(this.CMI("Flush symbol cache", "doFlushSymbolCache"));
        optionsMenu.add(this.CMI("Garbage collect now", "doGarbageCollect"));
        optionsMenu.add(this.CMI("Memory usage...", "doShowMemoryInfo"));
        optionsMenu.add(this.CMI("Performance statistics...", "doTestTiming"));
        this.enableSplitSignalsMI = this.CBM("Allow Split Signals", "doEnableSplitSignals", false);
        this.enableSplitSignalsMI.setEnabled(false);
        this.enableCreateSignalsMI = this.CBM("Enable Create Signals", "doEnableCreateSignals", true);
        optionsMenu.add(this.enableCreateSignalsMI);
        optionsMenu.addSeparator();
        optionsMenu.add(this.enableSplitSignalsMI);
        JMenu debugMenu = new JMenu("Debug");
        debugMenu.add(this.CMI("Print toplevel objects...", "doPrintObjects"));
        debugMenu.add(this.CMI("Print all objects...", "doPrintAllObjects"));
        debugMenu.add(this.CMI("Print toplevel signals...", "doPrintToplevelSignals"));
        debugMenu.add(this.CMI("Print all signals...", "doPrintAllSignals"));
        debugMenu.add(this.CMI("Print symbols...", "doPrintSymbols"));
        debugMenu.add(this.CMI("Print undoStack...", "doPrintUndoStack"));
        debugMenu.add(this.CMI("Print EventList...", "doPrintEventList"));
        debugMenu.add(this.CMI("Print editorTable...", "doPrintEditorTable"));
        debugMenu.add(this.CMI("Print redraw timing...", "doPrintRedrawStats"));
        debugMenu.add(this.CMI("Print Selection...", "printSelection"));
        debugMenu.addSeparator();
        debugMenu.add(this.CBM("Trace Events...", "doTraceEvents", false));
        debugMenu.add(this.CBM("Trace Signals...", "doTraceSignals", false));
        debugMenu.add(this.CBM("Trace SimObjects...", "doTraceSimObjects", false));
        debugMenu.add(this.CBM("Trace MouseClicks...", "doTraceMouseClicks", false));
        debugMenu.add(this.CBM("Trace Sim.Kernel...", "doTraceSimKernel", false));
        debugMenu.addSeparator();
        debugMenu.add(this.CBM("Trace Canvas...", "doTraceCanvas", false));
        debugMenu.add(this.CBM("Editor Debug...", "doToggleEditorDebug", false));
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(this.CMI("About...", "doShowAbout"));
        helpMenu.addSeparator();
        helpMenu.add(this.CMI("Changes...", "doShowChanges"));
        helpMenu.add(this.CMI("FAQ...", "doShowFAQ"));
        helpMenu.add(this.CMI("Show messages...", "doShowMessages"));
        helpMenu.addSeparator();
        helpMenu.add(this.createDemoDesignsMenu());
        this.menuBar = new JMenuBar();
        this.menuBar.add(fileMenu);
        this.menuBar.add(editMenu);
        this.menuBar.add(windowMenu);
        this.menuBar.add(layersMenu);
        this.menuBar.add(signalsMenu);
        this.menuBar.add(exportMenu);
        this.menuBar.add(optionsMenu);
        if (SetupManager.getBoolean("Hades.Editor.EnableVHDLMenu", false)) {
            this.menuBar.add(vhdlMenu);
        }
        if (SetupManager.getBoolean("Hades.Editor.EnableDebugMenu", false)) {
            this.menuBar.add(debugMenu);
        }
        this.menuBar.add(helpMenu);
        if (this.editor == null || !this.editor.isViewMode()) {
            this.setJMenuBar(this.menuBar);
        }
    }

    private boolean _smgb(String key) {
        return SetupManager.getBoolean("Hades.LayerTable.Display" + key, false);
    }

    public JMenu createLayersMenu() {
        String base = "Hades.LayerTable.Display";
        this.layerInstanceLabelsMI = this.CBM("instance labels", "doShowInstanceLabels", this._smgb("InstanceLabels"));
        this.layerClassLabelsMI = this.CBM("class labels", "doShowClassLabels", this._smgb("ClassLabels"));
        this.layerPortLabelsMI = this.CBM("port labels", "doShowPortLabels", this._smgb("PortLabels"));
        this.layerPortSymbolsMI = this.CBM("port symbols", "doShowPortSymbols", this._smgb("PortSymbols"));
        this.layerBusPortSymbolsMI = this.CBM("bus port symbols", "doShowBusPortSymbols", this._smgb("BusPortSymbols"));
        this.layerInstanceBorderMI = this.CBM("instance border", "doShowInstanceBorder", this._smgb("InstanceBorder"));
        this.layerDisplayAllMI = this.CMI("all of the above layers", "doShowAllLayers");
        this.layerDisplayNoneMI = this.CMI("none of the above layers", "doShowNoLayers");
        this.viewModeMI = this.CBM("view mode", "doShowViewMode", false);
        this.glowModeMI = this.CBM("glow mode", "doShowGlowMode", this._b("Hades.Editor.GlowMode", true));
        this.SC(this.glowModeMI, "control G");
        this.rtlibAnimationMI = this.CBM("RTLIB animation", "doShowRtlibAnimation", true);
        this.inverseCanvasMI = this.CBM("inverse canvas", "doShowInverseCanvas", false);
        this.antiAliasMI = this.CBM("Java2D antialiasing", "doEnableJava2DAntiAliasing", this._b("Hades.Editor.AntiAlias", false));
        this.SC(this.antiAliasMI, "control A");
        this.renderQualityMI = this.CBM("Java2D render quality", "doEnableJava2DRenderQuality", this._b("Hades.Editor.RenderQuality", false));
        this.enableToolTipsMI = this.CBM("enable tool-tips", "doShowToolTips", this._b("Hades.Editor.EnableToolTips", true));
        this.SC(this.layerDisplayAllMI, "F6");
        this.SC(this.layerDisplayNoneMI, "F7");
        this.SC(this.enableToolTipsMI, "control T");
        this.antiAliasMI.setEnabled(FigAttribs.enableJava2D);
        this.renderQualityMI.setEnabled(FigAttribs.enableJava2D);
        JMenu lm = new JMenu("Layers");
        lm.add(this.layerInstanceLabelsMI);
        lm.add(this.layerClassLabelsMI);
        lm.add(this.layerPortLabelsMI);
        lm.add(this.layerPortSymbolsMI);
        lm.add(this.layerBusPortSymbolsMI);
        lm.add(this.layerInstanceBorderMI);
        lm.addSeparator();
        lm.add(this.layerDisplayAllMI);
        lm.add(this.layerDisplayNoneMI);
        lm.addSeparator();
        lm.add(this.viewModeMI);
        lm.add(this.glowModeMI);
        lm.add(this.rtlibAnimationMI);
        lm.add(this.inverseCanvasMI);
        lm.add(this.antiAliasMI);
        lm.add(this.renderQualityMI);
        lm.addSeparator();
        lm.add(this.enableToolTipsMI);
        return lm;
    }

    private boolean _b(String s, boolean _default) {
        return SetupManager.getBoolean(s, _default);
    }

    public JMenu createDemoDesignsMenu() {
        JMenu demoDesignsMenu = new JMenu("demos...");
        int i = 0;
        while (i < __demos.length) {
            if ("separator".equals(__demos[i][0])) {
                demoDesignsMenu.addSeparator();
            } else {
                JMenuItem mi = this.CMI(__demos[i][0], "doOpenDesign", __demosRoot + __demos[i][1]);
                demoDesignsMenu.add(mi);
            }
            ++i;
        }
        return demoDesignsMenu;
    }

    public void getIcon() {
        try {
            String filename = SetupManager.getProperty("Hades.Editor.Icon", "hades/gui/images/hades.gif");
            this.icon = ImageHelper.loadResourceImage(filename);
        }
        catch (Exception e) {
            this.msg("-E- JEditFrame.getIcon(): got Exception " + e);
            this.msg("... could not set the HADES editor icon.");
        }
    }

    public void saveRecentFilesList(String filename) {
        this.msg("-I- EditFrame: saveRecentFilesList...");
        try {
            String home = System.getProperty("user.home");
            String dothades = home + File.separator + ".hades";
            File dir = new File(dothades);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.recentFileManager.saveToFile(dothades + File.separator + filename);
        }
        catch (SecurityException se) {
        }
        catch (Exception ee) {}
    }

    public void addRecentFile(String filename) {
        this.recentFileManager.add(filename);
    }

    public String getRecentFile(int i) {
        return this.recentFileManager.get(i);
    }

    public static void main(String[] argv) {
        JEditFrame jef = new JEditFrame(null, "Hades Editor demo");
        JSimControlPanel control = new JSimControlPanel(new SimKernel(), jef);
        JObjectCanvas canvas = new JObjectCanvas(null);
        JCanvasScroller scroller = new JCanvasScroller(canvas);
        jef.getContentPane().add("Center", scroller);
        jef.getContentPane().add("South", control);
        jef.setSize(800, 600);
        jef.setVisible(true);
    }
}

