/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Console;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jfig.gui.ConsoleMessage;
import jfig.gui.ImageHelper;
import jfig.utils.AntiDeadlock;
import jfig.utils.SetupManager;

public class JConsole
extends Console
implements ActionListener,
ConsoleMessage {
    private JFrame frame;
    private JTextArea ta;
    private JScrollPane textScroller;
    private JButton okButton;
    private JButton clearButton;
    private JCheckBox logtofileCB;
    private JTextField logfileNameTF;
    private Font consoleFont;
    private Font buttonFont;
    private int n_lines;
    private int max_lines;
    private boolean logfileEnable;
    private String logfileName;
    private PrintWriter logStream = null;
    private LinkedList fifo = new LinkedList();
    private Timer timer;
    private static JConsole _console = null;

    public static JConsole getJConsole() {
        if (_console == null) {
            _console = new JConsole();
        }
        return _console;
    }

    public JConsole() {
        this("HADES messages");
    }

    public JConsole(String title) {
        super("dummy", "superclass", "constructor");
        this.createGUI(title);
        this.timer = new Timer();
        this.timer.start();
    }

    public void destroy() {
        _console = null;
        this.timer.finished();
        super.destroy();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void show() {
        if (this.frame != null) {
            this.frame.setVisible(true);
        }
    }

    private void createGUI(String title) {
        if (!SwingUtilities.isEventDispatchThread()) {
            // empty if block
        }
        this.frame = new JFrame(title);
        this.frame.setBackground(Color.lightGray);
        this.ta = new JTextArea(20, 60);
        this.textScroller = new JScrollPane(this.ta);
        this.setDefaultLogFileNameAndEnable();
        this.getDefaultFonts();
        this.frame.setFont(this.buttonFont);
        this.ta.setFont(this.consoleFont);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1, 2, 0));
        this.okButton = new JButton("Clear");
        p.add(this.okButton);
        this.clearButton = new JButton("OK");
        p.add(this.clearButton);
        p.add(new JLabel(" "));
        this.logtofileCB = new JCheckBox("Log to file: ");
        p.add(this.logtofileCB);
        this.logfileNameTF = new JTextField(this.logfileName, 15);
        p.add(this.logfileNameTF);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add("Center", this.textScroller);
        this.frame.getContentPane().add("South", p);
        this.okButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.frame.setDefaultCloseOperation(1);
        this.n_lines = 0;
        this.max_lines = SetupManager.getInteger("Hades.JConsole.SaveLines", 500);
        this.getJIcon();
        this.frame.pack();
    }

    public void getJIcon() {
        try {
            String filename = SetupManager.getProperty("Hades.Console.Icon", "/hades/gui/images/hades.gif");
            Image image = ImageHelper.loadResourceImage(filename);
        }
        catch (Exception e) {
            System.err.println("-E- JConsole.getIcon: " + e);
        }
    }

    public void initialize(String s) {
        if (this.frame == null) {
            return;
        }
        try {
            StringTokenizer st = new StringTokenizer(s);
            int x = Integer.parseInt(st.nextToken());
            int y = Integer.parseInt(st.nextToken());
            int w = Integer.parseInt(st.nextToken());
            int h = Integer.parseInt(st.nextToken());
            if (SwingUtilities.isEventDispatchThread()) {
                this.frame.setLocation(x, y);
                this.frame.setSize(w, h);
                this.frame.invalidate();
                this.frame.validate();
                this.frame.setVisible(true);
            }
        }
        catch (Exception e) {}
    }

    public void enableFileLoggingGUI(boolean b) {
        if (this.frame != null) {
            this.logfileNameTF.setVisible(b);
            this.logtofileCB.setVisible(b);
            this.logtofileCB.setSelected(this.logfileEnable);
        }
    }

    public void setMaxLines(int m) {
        this.max_lines = m;
    }

    public int getMaxLines() {
        return this.max_lines;
    }

    public String getLogFileName() {
        return this.logfileName;
    }

    public void setDefaultLogFileNameAndEnable() {
        this.logfileName = SetupManager.getProperty("Hades.JConsole.LogFileName", "/tmp/hades.log");
        this.logfileEnable = SetupManager.getBoolean("Hades.JConsole.LogEnable", false);
    }

    public void setLogFileName(String name) {
        this.logfileName = name;
        this.logfileNameTF.setText(name);
    }

    public void setLogFileEnable(boolean b) {
        this.logfileEnable = b;
    }

    private void getDefaultFonts() {
        String name = SetupManager.getProperty("Hades.JConsole.JConsoleFontName", "MonoSpaced");
        int size = SetupManager.getInteger("Hades.JConsole.JConsoleFontSize", 12);
        int style = 0;
        this.consoleFont = new Font(name, style, size);
        name = SetupManager.getProperty("Hades.JConsole.ButtonFontName", "SansSerif");
        size = SetupManager.getInteger("Hades.JConsole.ButtonFontSize", 12);
        style = 0;
        this.buttonFont = new Font(name, style, size);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            String s = e.getActionCommand();
            if (s.equals("Clear")) {
                this.ta.setText("");
                this.n_lines = 0;
            } else if (s.equals("OK")) {
                this.frame.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) {
        if (this.logStream != null) {
            this.logStream.println(s);
        }
        if (this.frame == null) {
            System.out.println(s);
        } else {
            LinkedList linkedList = this.fifo;
            synchronized (linkedList) {
                this.fifo.addLast(s);
            }
            this.timer.interrupt();
        }
    }

    public void consoleMessage(String msg) {
        this.println(msg);
    }

    public void message(String s) {
        this.println(s);
    }

    public void checkShouldSetVisible(String s) {
        int level;
        if (this.frame == null) {
            return;
        }
        if (this.messagePopupLevel == -1 && !this.frame.isShowing()) {
            this.frame.setVisible(true);
            AntiDeadlock.sleep(100L);
            this.frame.toFront();
        } else if (this.messagePopupLevel != 5 && (level = s.startsWith("-I-") ? 1 : (s.startsWith("-W-") ? 2 : (s.startsWith("-E-") ? 3 : (s.startsWith("-F-") ? 4 : 0)))) >= this.messagePopupLevel && !this.frame.isVisible()) {
            this.frame.setVisible(true);
            AntiDeadlock.sleep(100L);
            this.frame.toFront();
        }
    }

    public void setMessagePopupLevel(int i) {
        this.messagePopupLevel = i;
    }

    public void setText(String s) {
        if (this.frame != null) {
            this.ta.setText(s);
            this.n_lines = this.countLines();
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
        }
    }

    public void addLine(String s) {
        ++this.n_lines;
        if (this.n_lines >= this.max_lines + this.max_lines) {
            this.cleanup();
        }
        if (this.ta != null) {
            this.ta.append(s + '\n');
        }
    }

    public void cleanup() {
        String s = this.ta.getText();
        int n = 0;
        int i = s.length() - 1;
        while (i >= 0) {
            if (s.charAt(i) == '\n') {
                ++n;
            }
            if (n >= this.max_lines) {
                this.ta.setText(s.substring(i + 1, s.length()));
                this.n_lines = n;
                return;
            }
            --i;
        }
        this.n_lines = n;
    }

    public int countLines() {
        String s = this.ta.getText();
        int n = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n') {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static void main(String[] argv) {
        JConsole con = new JConsole();
        con.enableFileLoggingGUI(true);
        con.getFrame().setVisible(true);
        con.getFrame().pack();
        con.println("Hades JConsole...");
        int i = 0;
        while (i < 500) {
            con.println("i " + i + "  i*i " + i * i);
            ++i;
        }
        System.out.println("Number of lines is " + con.countLines());
        System.out.println("Now limiting to 10 lines...");
        con.setMaxLines(60);
        con.println("Hades JConsole...");
        int i2 = 0;
        while (i2 < 500) {
            con.println("i " + i2 + "  i*i " + i2 * i2);
            ++i2;
        }
        System.out.println("Number of lines is " + con.countLines());
    }

    public class Timer
    extends Thread {
        private boolean alive;

        public Timer() {
            this.setDaemon(true);
            this.alive = true;
        }

        public void run() {
            while (this.alive) {
                try {
                    if (JConsole.this.fifo.size() > 0) {
                        SwingUtilities.invokeLater(new Updater());
                    }
                    Thread.sleep(10000L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }

        public void finished() {
            this.alive = false;
        }
    }

    public class Updater
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StringBuffer sb = new StringBuffer();
            LinkedList linkedList = JConsole.this.fifo;
            synchronized (linkedList) {
                while (JConsole.this.fifo.size() > 0) {
                    String s = (String)JConsole.this.fifo.getFirst();
                    sb.append(s);
                    sb.append("\n");
                    JConsole.this.fifo.removeFirst();
                }
            }
            if (JConsole.this.ta != null) {
                JConsole.this.ta.append(sb.toString());
            }
        }
    }
}

