/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.JObjectCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigDrawable;
import jfig.canvas.FigDrawableEnumerator;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.ZoomListener;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigText;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.Format;

public class JCanvasScroller
extends JPanel
implements AdjustmentListener,
ComponentListener,
MouseMotionListener,
ZoomListener {
    private static boolean debug = false;
    protected FigCanvas editorCanvas;
    protected JPanel bottomPanel;
    protected JPanel labelPanel;
    protected JScrollBar scrollbarX;
    protected JScrollBar scrollbarY;
    protected JLabel coordLabel;
    protected JLabel zoomLabel;
    protected Filler filler;
    protected InfoLabel infoLabel;
    protected FigBbox objectBBox;
    protected FigBbox visibleRegionBBox;
    protected FigBbox totalBBox;
    protected boolean clipToObjectBoundingBox;
    private boolean funny_swing_ignore_track_event = false;
    private static boolean funny_swing_first_time = true;

    public JCanvasScroller(FigCanvas _canvas) {
        this.editorCanvas = _canvas;
        _canvas.addZoomListener(this);
        this.buildGUI();
        this.clipToObjectBoundingBox = true;
        this.rebuildBoundingBoxes();
    }

    public void setCanvas(FigCanvas _canvas) {
        this.editorCanvas = _canvas;
        this.add("Center", this.editorCanvas.getComponent());
        this.rebuildBoundingBoxes();
    }

    void buildGUI() {
        this.scrollbarY = new JScrollBar(1);
        this.bottomPanel = new JPanel();
        this.scrollbarX = new JScrollBar(0);
        this.filler = new Filler();
        this.infoLabel = new InfoLabel();
        this.infoLabel.setWidth(this.infoLabel.measure());
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add("West", this.infoLabel);
        this.bottomPanel.add("Center", this.scrollbarX);
        this.bottomPanel.add("East", this.filler);
        this.setLayout(new BorderLayout());
        this.add("Center", this.editorCanvas.getComponent());
        this.add("East", this.scrollbarY);
        this.add("South", this.bottomPanel);
        this.scrollbarX.addAdjustmentListener(this);
        this.scrollbarY.addAdjustmentListener(this);
        this.editorCanvas.getComponent().addMouseMotionListener(this);
        this.editorCanvas.getComponent().addComponentListener(this);
    }

    public int getScrollbarWidth() {
        return this.scrollbarY.getSize().width;
    }

    public void doLayout() {
        int width;
        if (this.getScrollbarWidth() == 0) {
            super.doLayout();
        }
        if ((width = this.getScrollbarWidth()) != 0) {
            width = this.scrollbarY.getPreferredSize().width;
        }
        if (width != 0) {
            this.filler.setWidth(width);
            this.filler.setHeight(width);
            this.infoLabel.setHeight(width);
            this.rebuildScrollbars();
        }
        super.doLayout();
    }

    public void rebuildBoundingBoxes() {
        try {
            this.objectBBox = BoundingBoxCalculator.getBoundingBox(this.editorCanvas.getObjectEnumerator().getDrawableObjects());
        }
        catch (Exception e) {
            this.objectBBox = new FigBbox(0, 0, 9600, 9600);
        }
        this.visibleRegionBBox = this.editorCanvas.getVisibleRegionBoundingBox();
        FigBbox tmpBBox = new FigBbox(this.objectBBox.getXl() - 2400, this.objectBBox.getYt() - 2400, this.objectBBox.getXr() + 2400, this.objectBBox.getYb() + 2400);
        this.totalBBox = this.visibleRegionBBox.union(tmpBBox);
        if (debug) {
            JCanvasScroller.msg("-I- rebuildBoundingBoxes:\nobjects: " + this.objectBBox + "\nvisib: " + this.visibleRegionBBox + "\ntotal: " + this.totalBBox);
        }
    }

    public void setObjectBoundingBox(int xl, int yt, int xr, int yb) {
        this.objectBBox = new FigBbox(xl, yt, xr, yb);
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
    }

    public void setClipToObjectBoundingBox(boolean b) {
        this.clipToObjectBoundingBox = b;
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
    }

    public void rebuildScrollbars() {
        int dx_visible = this.visibleRegionBBox.getXr() - this.visibleRegionBBox.getXl();
        int dy_visible = this.visibleRegionBBox.getYb() - this.visibleRegionBBox.getYt();
        int dx_total = this.totalBBox.getXr() - this.totalBBox.getXl();
        int dy_total = this.totalBBox.getYb() - this.totalBBox.getYt();
        int amount_x = this.clip((int)(1000.0 * (double)dx_visible / (double)dx_total), 0, 1000);
        int amount_y = this.clip((int)(1000.0 * (double)dy_visible / (double)dy_total), 0, 1000);
        double tmp_x = this.visibleRegionBBox.getXl() - this.totalBBox.getXl();
        double max_x = dx_total - dx_visible;
        double new_x = (double)(1000 - amount_x) * (tmp_x / max_x);
        int value_x = this.clip((int)new_x, 0, 1000 - amount_x);
        double tmp_y = this.visibleRegionBBox.getYt() - this.totalBBox.getYt();
        double max_y = dy_total - dy_visible;
        double new_y = (double)(1000 - amount_y) * (tmp_y / max_y);
        int value_y = this.clip((int)new_y, 0, 1000 - amount_y);
        if (debug) {
            JCanvasScroller.msg("-#- CS.rebuildScrollbars:  X: " + tmp_x + "," + max_x + "," + value_x + "," + amount_x + " Y: " + tmp_y + "," + max_y + "," + value_y + "," + amount_y);
        }
        this.funny_swing_ignore_track_event = true;
        this.scrollbarX.setValues(value_x, amount_x, 0, 1000);
        this.scrollbarY.setValues(value_y, amount_y, 0, 1000);
        this.funny_swing_ignore_track_event = false;
    }

    public int clip(int value, int min_value, int max_value) {
        if (value > max_value) {
            return max_value;
        }
        if (value < min_value) {
            return min_value;
        }
        return value;
    }

    public void componentHidden(ComponentEvent evt) {
    }

    public void componentMoved(ComponentEvent evt) {
    }

    public void componentShown(ComponentEvent evt) {
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
    }

    public void componentResized(ComponentEvent evt) {
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (this.funny_swing_ignore_track_event) {
            if (funny_swing_first_time && debug) {
                System.err.println("-I- JCanvasScroller: Swing is still broken. First AdjustmentEvent ignored.");
            }
            funny_swing_first_time = false;
            return;
        }
        if (evt.getSource() == this.scrollbarX) {
            switch (evt.getAdjustmentType()) {
                case 5: {
                    this.trackScrollbarX();
                    break;
                }
                default: {
                    if (debug) {
                        JCanvasScroller.msg("-I- event ignored: " + evt);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (evt.getSource() == this.scrollbarY) {
            switch (evt.getAdjustmentType()) {
                case 5: {
                    this.trackScrollbarY();
                    break;
                }
                default: {
                    if (debug) {
                        JCanvasScroller.msg("-I- event ignored: " + evt);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            JCanvasScroller.msg("-E- unknown event source: " + evt);
        }
    }

    public void trackScrollbarX() {
        if (debug) {
            JCanvasScroller.msg("-X- JCS.trackScrollbarX...");
        }
        int x_scroll = this.scrollbarX.getValue();
        int x_max_scroll = this.scrollbarX.getMaximum();
        int x_amount = this.scrollbarX.getVisibleAmount();
        int x_left = this.totalBBox.getXl();
        int x_size = this.totalBBox.getXr() - this.totalBBox.getXl();
        if (debug) {
            System.out.println("-#- CS.trackScrollbarX value=" + x_scroll + " max=" + x_max_scroll + " amount=" + x_amount);
        }
        int wx = x_left + x_scroll * x_size / x_max_scroll;
        Point anchor = this.editorCanvas.getTrafo().getAnchor();
        anchor.x = wx;
        this.editorCanvas.getTrafo().setAnchor(anchor);
        this.editorCanvas.doFullRedraw(200L);
    }

    public void trackScrollbarY() {
        if (debug) {
            JCanvasScroller.msg("-X- JCS.trackScrollbarY...");
        }
        int y_scroll = this.scrollbarY.getValue();
        int y_max_scroll = this.scrollbarY.getMaximum();
        int y_top = this.totalBBox.getYt();
        int y_size = this.totalBBox.getYb() - this.totalBBox.getYt();
        int wy = y_top + y_scroll * y_size / y_max_scroll;
        Point anchor = this.editorCanvas.getTrafo().getAnchor();
        anchor.y = wy;
        this.editorCanvas.getTrafo().setAnchor(anchor);
        this.editorCanvas.doFullRedraw(200L);
    }

    public void mouseMoved(MouseEvent evt) {
        Point P = this.editorCanvas.getTrafo().getWorldCoordsSnapped(evt.getX(), evt.getY());
        this.infoLabel.setX(P.x);
        this.infoLabel.setY(P.y);
        this.infoLabel.repaint(100L);
    }

    public void mouseDragged(MouseEvent evt) {
        Point P = this.editorCanvas.getTrafo().getWorldCoordsSnapped(evt.getX(), evt.getY());
        this.infoLabel.setX(P.x);
        this.infoLabel.setY(P.y);
        this.infoLabel.repaint(100L);
    }

    public void zoomChanged(Object arg) {
        if (debug) {
            JCanvasScroller.msg("-#- JCanvasScroller.zoomChanged: " + arg);
        }
        this.rebuildBoundingBoxes();
        this.rebuildScrollbars();
        this.infoLabel.setZoom(this.editorCanvas.getTrafo().getZoomFactor());
        this.infoLabel.repaint(100L);
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        JCanvasScroller SEC;
        JCanvasScroller.msg("JCanvasScroller selftest, please wait...");
        JObjectCanvas editorCanvas = new JObjectCanvas(null);
        editorCanvas.setBackground(Color.white);
        editorCanvas.setGrid(240);
        JCanvasScroller jCanvasScroller = SEC = new JCanvasScroller(editorCanvas);
        jCanvasScroller.getClass();
        DummyObjectEnumerator doe = jCanvasScroller.new DummyObjectEnumerator(editorCanvas);
        SEC.editorCanvas.setObjectEnumerator(doe);
        JFrame frame = new JFrame("JCanvasScroller Demo...");
        frame.getContentPane().add("Center", SEC);
        frame.setSize(new Dimension(400, 300));
        frame.setVisible(true);
    }

    class DummyObjectEnumerator
    implements FigDrawableEnumerator {
        Vector vector = new Vector();

        DummyObjectEnumerator(FigCanvas canvas) {
            FigAttribs attribs = new FigAttribs();
            FigTrafo2D trafo = canvas.getTrafo();
            this.vector.addElement(new FigText(new Point(5000, 5000), "Hugo!", attribs, trafo));
            this.vector.addElement(new FigText(new Point(15000, 5000), "Gabi", attribs, trafo));
            this.vector.addElement(new FigText(new Point(5000, 15000), "Claudia", attribs, trafo));
        }

        public Enumeration getDrawableObjects() {
            return this.vector.elements();
        }

        public FigDrawable getTmpObject() {
            return null;
        }
    }

    class InfoLabel
    extends JComponent {
        private Dimension dimension;
        private Font textFont = new Font("MonoSpaced", 0, 12);
        private FontMetrics fm;
        private Format XF = new Format("%05d");
        private Format ZF = new Format("%7.2f");
        int xoffset = 10;
        int baseline;
        int font_height = 40;
        int x;
        int y;
        double zoomFactor;

        public InfoLabel() {
            this.setFont(this.textFont);
            this.setOpaque(true);
            this.dimension = new Dimension(100, 50);
            this.x = 0;
            this.y = 0;
            this.zoomFactor = 1.0;
        }

        public int measure() {
            this.fm = FontCache.getFontCache().getFontMetrics(this.textFont);
            this.baseline = this.fm.getMaxAscent() + (this.dimension.height - this.fm.getHeight()) / 2 + 1;
            this.font_height = this.fm.getMaxAscent() + this.fm.getDescent();
            if (debug) {
                JCanvasScroller.msg("-I- JCanvasScroller.measure: height=" + this.dimension.height + " baseline= " + this.baseline + " fmMaxAscent= " + this.fm.getMaxAscent() + " fmAscent= " + this.fm.getAscent());
            }
            return this.xoffset + this.fm.stringWidth(this.getInfoLabel()) + this.xoffset;
        }

        public void setWidth(int w) {
            this.dimension.width = w;
        }

        public void setHeight(int h) {
            this.dimension.height = Math.max(h, this.font_height);
            this.baseline = this.fm.getMaxAscent() + (this.dimension.height - this.fm.getHeight()) / 2 + 1;
        }

        public void setX(int _x) {
            this.x = _x;
        }

        public void setY(int _y) {
            this.y = _y;
        }

        public void setZoom(double _z) {
            this.zoomFactor = _z;
        }

        public String getInfoLabel() {
            return "(" + this.XF.form(this.x) + "," + this.XF.form(this.y) + ") " + this.ZF.form(100.0 * this.zoomFactor) + "% ";
        }

        public Dimension getPreferredSize() {
            return this.dimension;
        }

        public Dimension getMinimumSize() {
            return this.dimension;
        }

        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
            g.drawString(this.getInfoLabel(), this.xoffset, this.baseline);
        }
    }

    class Filler
    extends JComponent {
        private Dimension dimension;

        public Filler() {
            this.setBackground(Color.lightGray);
            this.setOpaque(true);
            this.dimension = new Dimension(20, 20);
        }

        public void setWidth(int w) {
            this.dimension.width = w;
        }

        public void setHeight(int h) {
            this.dimension.height = h;
        }

        public Dimension getPreferredSize() {
            return this.dimension;
        }

        public Dimension getMinimumSize() {
            return this.dimension;
        }
    }
}

