/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.ColibriCreateCommand;
import hades.gui.ColibriCreateSubdesignCommand;
import hades.gui.Command;
import hades.gui.Console;
import hades.gui.CreateByNameCommand;
import hades.gui.CreateSignalCommand;
import hades.gui.DeleteCommand;
import hades.gui.EditorMenuInteraction;
import hades.gui.ExportOptionsDialog;
import hades.gui.GUIFactory;
import hades.gui.KeyHandler;
import hades.gui.LayerTable;
import hades.gui.LogManager;
import hades.gui.OKtoQuit;
import hades.gui.ObjectCanvas;
import hades.gui.SaveChangesDialog;
import hades.gui.SetDesignNameCommand;
import hades.gui.SignalMovePointCommand;
import hades.gui.SignalSetValueCommand;
import hades.gui.SimControlPanel;
import hades.gui.StatusPanel;
import hades.gui.StringDialog;
import hades.gui.UndoStack;
import hades.manager.Browser;
import hades.manager.CreateThumbnail;
import hades.manager.DesignManager;
import hades.models.Design;
import hades.models.InputConnector;
import hades.models.OutputConnector;
import hades.models.StdLogic1164;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.RealTimeSimKernel;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.styx.Waveform;
import hades.styx.WaveformViewer;
import hades.symbols.BboxRectangle;
import hades.symbols.Color_DIN_IEC_62;
import hades.symbols.ErrorMarker;
import hades.symbols.HighlightWireSegment;
import hades.symbols.Label;
import hades.symbols.PortSymbol;
import hades.symbols.ProbeSymbol;
import hades.symbols.Symbol;
import hades.symbols.SymbolManager;
import hades.symbols.WireSegment;
import hades.utils.ContextToolTip;
import hades.utils.RedrawStressTest;
import hades.utils.Selection;
import hades.utils.ShellSort;
import hades.utils.SignalEnumerator;
import hades.utils.StringTokenizer;
import hades.utils.ToolTipManager;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigCanvasListener;
import jfig.canvas.FigDrawable;
import jfig.canvas.FigDrawableEnumerator;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ImageHelper;
import jfig.gui.PrintManager;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.utils.AntiDeadlock;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class Editor
implements ActionListener,
MouseListener,
KeyListener,
ItemListener,
WindowListener,
FigCanvasListener,
FigDrawableEnumerator,
ContextToolTip {
    public static final String versionString = "HADES Editor 0.98g (RSB-Prak)";
    private static boolean debug = false;
    private boolean viewMode = false;
    private boolean traceMouseClicks = false;
    private boolean autoCreateSignalsEnableFlag = true;
    private static int n_editors = 0;
    private static Hashtable _editorTable;
    private static Editor _activeEditor;
    private static boolean exitOnLastWindowClose;
    private GUIFactory guiFactory;
    private Console console;
    private Frame editFrame;
    private Frame dummyFrame;
    private ObjectCanvas objectCanvas;
    private StatusPanel statusPanel;
    private SimControlPanel simControlPanel;
    private KeyHandler keyHandler;
    private EditorMenuInteraction menuInteraction;
    private ExportOptionsDialog exportOptionsDialog;
    private ToolTipManager toolTipManager;
    private Browser browser;
    private WaveformViewer waveformViewer;
    private int snapGrid = 1;
    private Frame jythonConsole;
    private Applet parentApplet;
    private Design design;
    private String filename;
    private boolean hasFileAccess = true;
    private UndoStack undoStack;
    private Command currentCommand;
    private Selection selection;
    private LayerTable layerTable;
    private Hashtable highlightTable;
    private LogManager logManager;
    private long lastEventTime;
    private SimKernel simKernel;
    private boolean autoStartSimulation;
    private FigObjectList objectList;
    private FigDrawable tmpObject = null;
    protected Hashtable __callbackMethodTable;
    protected Hashtable __callbackArgTable;

    public Editor() {
        this(true);
    }

    public Editor(boolean createAndShowWindow) {
        if (debug) {
            Editor.msg("-I- Editor <<init>> started...");
        }
        if (SetupManager.getBoolean("Hades.Editor.ViewMode", false)) {
            this.autoCreateSignalsEnableFlag = false;
            this.viewMode = true;
        }
        try {
            Class.forName("java.util.LinkedList");
            Class.forName("javax.swing.JComponent");
        }
        catch (Throwable t) {
            SetupManager.setProperty("Hades.UseSwingGUI", "false");
            Editor.msg("-W- Swing classes not found, disabling Swing...");
        }
        this.logManager = new LogManager(this);
        this.logManager.writeLogComment("" + this);
        this.createObjectList();
        this.layerTable = new LayerTable();
        this.createNewSimulator();
        this.initCallbackTables();
        this.createGUIFactory();
        this.createConsole();
        this.createEditFrame();
        this.createStatusPanel();
        this.createObjectCanvas();
        this.createSimControlPanel();
        this.createNewSimulator();
        this.simKernel.setSyncPainter(this.objectCanvas);
        this.createEditFrameLayout();
        if (createAndShowWindow) {
            this.editFrame.setVisible(true);
        }
        ImageHelper.setVisibleParent(this.getDialogParentFrame());
        this.design = DesignManager.getDesignManager().getNewDesign(this);
        this.design.setSimulator(this.getSimulator());
        this.simKernel.setDesign(this.design);
        this.filename = "unnamed.hds";
        this.updateWindowTitle();
        this.setCommand(new Command(this));
        this.selection = new Selection();
        this.undoStack = new UndoStack();
        this.undoStack.setMenuItems(this.menuInteraction.getUndoMenuItem(), this.menuInteraction.getRedoMenuItem());
        this.keyHandler = new KeyHandler(this);
        this.waveformViewer = null;
        Editor.registerNewEditor(this);
        this.initToolTips();
        this.setGlowMode(this.menuInteraction.isGlowModeSelected());
        this.autoStartSimulation = SetupManager.getBoolean("Hades.Editor.AutoStartSimulation", true);
        this.checkAutoStartSimulation();
        this.checkAllCallbacks();
        this.statusMessage("...ready! Please select a command.");
    }

    public Editor(Design design) {
        this();
        this.setDesign(design);
    }

    public void createGUIFactory() {
        this.guiFactory = GUIFactory.getGUIFactory();
    }

    public void createConsole() {
        if (debug) {
            Editor.msg("-I- Editor.createConsole...");
        }
        try {
            this.console = Console.getConsole();
            this.console.enableFileLoggingGUI(true);
        }
        catch (Throwable t) {
            Editor.msg("-E- Internal error: could not create the message console!" + t);
            t.printStackTrace();
        }
    }

    public void createEditFrame() {
        if (debug) {
            Editor.msg("-I- Editor.createEditFrame (and menus)...");
        }
        this.editFrame = this.guiFactory.createEditFrame(this, versionString);
        this.menuInteraction = (EditorMenuInteraction)((Object)this.editFrame);
        this.editFrame.addWindowListener(this);
    }

    public void createObjectCanvas() {
        if (debug) {
            Editor.msg("-I- Editor.createObjectCanvas...");
        }
        this.objectCanvas = this.guiFactory.createObjectCanvas(this);
        this.objectCanvas.addCanvasListener(this);
        this.objectCanvas.getComponent().addKeyListener(this);
        this.objectCanvas.setObjectEnumerator(this);
        this.objectCanvas.setConsole(this.console);
        this.objectCanvas.doZoom11();
        this.objectCanvas.setDebug(SetupManager.getBoolean("Hades.Editor.CanvasDebug", false));
        this.objectCanvas.requestAntiAliasing(this.menuInteraction.isEnableAntialiasSelected());
        String tmp = SetupManager.getProperty("Hades.Editor.MagneticGrid", "1/8");
        if ("1/16".equals(tmp)) {
            this.doSetTinySnap();
        } else if ("1/8".equals(tmp)) {
            this.doSetFineSnap();
        } else if ("1/4".equals(tmp)) {
            this.doSetMediumSnap();
        } else if ("1/2".equals(tmp)) {
            this.doSetCoarseSnap();
        } else {
            this.doSetFineSnap();
        }
        this.simKernel.setSyncPainter(this.objectCanvas);
    }

    public void createStatusPanel() {
        if (debug) {
            Editor.msg("-I- Editor.createStatusPanel...");
        }
        this.statusPanel = this.guiFactory.createStatusPanel();
    }

    public void createSimControlPanel() {
        if (debug) {
            Editor.msg("-I- Editor.createSimControlPanel...");
        }
        this.simControlPanel = this.guiFactory.createSimControlPanel(this.simKernel, this.getDialogParentFrame());
        this.simControlPanel.setStatusMessage(this.statusPanel);
        this.simControlPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (debug) {
                    Editor.msg("-#- Editor.SimContolPanel.itemStateChanged...");
                }
                Editor.this.createNewSimulator();
            }
        });
        if (this.viewMode) {
            this.simControlPanel.setShowSimulatorChoice(SetupManager.getBoolean("Hades.Editor.ViewModeSimulatorChoice", true));
        }
    }

    public Container createEditFrameLayout() {
        if (debug) {
            Editor.msg("-I- Editor.createEditFrameLayout...");
        }
        Container container = null;
        container = this.guiFactory.createEditFrameLayout(this.editFrame, this.statusPanel.getComponent(), this.objectCanvas);
        container.add("South", this.simControlPanel.getComponent());
        if (this.isViewMode()) {
            this.simControlPanel.getComponent().setVisible(SetupManager.getBoolean("Hades.Editor.ShowSimControlPanel", true));
        }
        this.setInitialWindowPosAndSize();
        container.validate();
        return container;
    }

    public void updateWindowTitle() {
        String designname = "unnamed";
        String tmpfilename = "unnamed.hds";
        if (this.design != null) {
            designname = this.design.getName();
            tmpfilename = this.design.getResourceName();
            if (designname.equals("")) {
                designname = "unnamed";
                this.message("-W- design name is empty, changing to 'unnamed'!");
                this.design.setName(designname);
            }
        }
        this.statusPanel.setFilename(tmpfilename);
        if (this.editFrame != null) {
            this.editFrame.setTitle("HADES Editor 0.98g (RSB-Prak)   " + designname);
        }
    }

    public void doToggleSimControlPanel() {
        this.simControlPanel.getComponent().setVisible(!this.simControlPanel.getComponent().isVisible());
        if (this.editFrame != null) {
            this.editFrame.invalidate();
        }
    }

    public void setParentApplet(Applet a) {
        this.parentApplet = a;
    }

    public void doOpenExternalAppletWindow() {
        try {
            Class<?> c = this.parentApplet.getClass();
            Method m = c.getMethod("doOpenExternalWindow", null);
            m.invoke((Object)this.parentApplet, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void doCloseExternalAppletWindow() {
        try {
            Class<?> c = this.parentApplet.getClass();
            Method m = c.getMethod("doCloseExternalWindow", null);
            m.invoke((Object)this.parentApplet, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Design getDesign() {
        return this.design;
    }

    public void setDesign(Design d) {
        this.design = d;
        this.rebuildObjectList(this.design);
    }

    public DesignManager getDesignManager() {
        return DesignManager.getDesignManager();
    }

    public SimKernel getSimulator() {
        return this.simKernel;
    }

    public void doStopSimulation() {
        this.getSimulator().stopSimulation();
    }

    public void doPauseSimulation() {
        this.getSimulator().pauseSimulation();
    }

    public void doRunSimulation() {
        this.getSimulator().runForever();
    }

    public void setSimulator(SimKernel simKernel) {
        this.simKernel = simKernel;
        simKernel.setConsole(this.console);
        simKernel.setSyncPainter(this.objectCanvas);
        if (this.simControlPanel != null) {
            this.simControlPanel.setSimulator(simKernel);
        }
        if (this.design != null) {
            this.design.setSimulator(simKernel);
            simKernel.setDesign(this.design);
        }
    }

    public void createNewSimulator() {
        SimKernel tmp = this.simControlPanel != null ? this.simControlPanel.createSelectedSimKernel() : new RealTimeSimKernel();
        if (this.simKernel != null) {
            this.simKernel.stopSimulation();
            this.simKernel = null;
        }
        this.doClearWaveData();
        this.setSimulator(tmp);
    }

    public void checkAutoStartSimulation() {
        if (this.autoStartSimulation) {
            this.getSimulator().runForever();
        }
    }

    public void setAutoStartSimulation(boolean b) {
        this.autoStartSimulation = b;
    }

    public boolean isViewMode() {
        return this.viewMode;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public ObjectCanvas getObjectCanvas() {
        return this.objectCanvas;
    }

    public Frame getFrame() {
        return this.editFrame;
    }

    public SimControlPanel getSimControlPanel() {
        return this.simControlPanel;
    }

    public Frame getDialogParentFrame() {
        if (this.editFrame != null) {
            return this.editFrame;
        }
        this.dummyFrame = new Frame("dummy");
        this.dummyFrame.pack();
        return this.dummyFrame;
    }

    public UndoStack getUndoStack() {
        return this.undoStack;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void setSelection(Selection s) {
        this.selection = s;
    }

    public static void setDebug(boolean d) {
        debug = d;
    }

    public static boolean getDebug() {
        return debug;
    }

    public void setTraceMouseClicks(boolean d) {
        this.traceMouseClicks = d;
    }

    public void setCanvasDebug(boolean b) {
        this.objectCanvas.setDebug(b);
    }

    public WaveformViewer getWaveformViewer() {
        return this.waveformViewer;
    }

    public void setWaveformViewer(WaveformViewer wv) {
        this.waveformViewer = wv;
    }

    public boolean HasFileAccess() {
        return this.hasFileAccess;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isReady() {
        if (this.currentCommand == null) {
            return true;
        }
        if (this.currentCommand.isReady()) {
            return true;
        }
        this.statusMessage("Please finish the current operation first: " + this.currentCommand.getDescription());
        return false;
    }

    public void setCommand(Command c) {
        if (debug) {
            this.message("setCommand: " + c);
        }
        this.currentCommand = c;
    }

    public Command getCommand() {
        return this.currentCommand;
    }

    public void doCancel() {
        this.statusMessage("Canceled! Please select a command.");
        if (this.currentCommand != null) {
            this.currentCommand.cancel();
        }
        this.setCommand(new Command(this));
        this.setTmpObject(null);
        this.objectCanvas.setEnablePopup(true);
    }

    public void doCancelAndEnablePopupOnNextMouseRelease() {
        this.statusMessage("Canceled! Please select a command.");
        if (this.currentCommand != null) {
            this.currentCommand.cancel();
        }
        this.logManager.writeDoCancelAndEnablePopupOnNextMouseRelease();
        this.setCommand(new Command(this));
        this.setTmpObject(null);
        this.objectCanvas.setEnablePopupOnNextMouseRelease();
    }

    @Override
    public Enumeration getDrawableObjects() {
        if (this.objectList != null) {
            return this.objectList.elements();
        }
        return null;
    }

    @Override
    public FigDrawable getTmpObject() {
        return this.tmpObject;
    }

    public void setTmpObject(FigDrawable obj) {
        this.tmpObject = obj;
    }

    private void createObjectList() {
        this.objectList = new FigObjectList();
    }

    public FigObjectList getObjectList() {
        return this.objectList;
    }

    public void rebuildObjectList(Design design) {
        Symbol symbol = null;
        if (debug) {
            Editor.msg("rebuildOL started...");
        }
        try {
            FigObjectList newObjectList = new FigObjectList();
            Enumeration E = design.getComponents();
            while (E.hasMoreElements()) {
                symbol = ((SimObject)E.nextElement()).getSymbol();
                this.insertIntoObjectList(symbol, newObjectList);
            }
            if (debug) {
                Editor.msg("rebuildOL components ok...");
            }
            Signal signal = null;
            Enumeration E2 = design.getSignals();
            while (E2.hasMoreElements()) {
                signal = (Signal)E2.nextElement();
                this.insertIntoObjectList(signal, newObjectList);
            }
            if (debug) {
                Editor.msg("rebuildOL signals ok...");
            }
            if (debug) {
                Editor.msg("rebuildOL setting Simulator (hierarchical)...");
            }
            this.objectList = newObjectList;
            this.setGlowMode(this.menuInteraction.isGlowModeSelected());
            design.setSimulator(this.getSimulator());
            if (debug) {
                Editor.msg("rebuildOL redraw...");
            }
            this.objectCanvas.doFullRedraw();
        }
        catch (Exception e) {
            this.message("-E- Internal error in rebuildObjectList: " + e);
            ExceptionTracer.trace(e);
        }
        if (debug) {
            Editor.msg("rebuildOL ready...");
        }
    }

    public void insertIntoObjectList(Symbol symbol, FigObjectList OL) {
        if (symbol == null) {
            this.message("-W- called insertIntoObjectList() with a null Symbol...");
            return;
        }
        symbol.setTrafo(this.objectCanvas.getTrafo());
        symbol.update_bbox();
        symbol.build_sc_bbox();
        symbol.setVisibility(this.layerTable);
        symbol.setObjectPainter(this.objectCanvas);
        symbol.getParent().setSimulator(this.simKernel);
        if (debug) {
            this.message("*** insertIntoObjectList: symbol on layer: " + symbol.getAttributes().currentLayer);
        }
        OL.insert(symbol);
    }

    public void insertIntoObjectList(Symbol symbol) {
        this.insertIntoObjectList(symbol, this.objectList);
    }

    public void insertIntoObjectList(Signal signal) {
        this.insertIntoObjectList(signal, this.objectList);
    }

    public void insertIntoObjectList(WireSegment ws) {
        this.insertIntoObjectList(ws, this.objectList);
    }

    public void insertIntoObjectList(FigObject obj) {
        this.insertIntoObjectList(obj, this.objectList);
    }

    public void insertIntoObjectList(Signal signal, FigObjectList OL) {
        Label label;
        if (signal == null) {
            this.message("-W- called insertIntoObjectList() with a null Signal...");
            return;
        }
        signal.setTrafo(this.objectCanvas.getTrafo());
        FigObject[] segments = signal.getSegments();
        for (int i = 0; i < segments.length; ++i) {
            OL.insert(segments[i]);
            segments[i].setObjectPainter(this.objectCanvas);
            segments[i].setTrafo(this.objectCanvas.getTrafo());
        }
        FigObject[] solders = signal.getSolderDots();
        if (solders != null) {
            for (int i = 0; i < solders.length; ++i) {
                OL.insert(solders[i]);
                solders[i].setTrafo(this.objectCanvas.getTrafo());
            }
        }
        if ((label = signal.getLabel()) != null) {
            OL.insert(label);
        }
        signal.setSimulator(this.simKernel);
        signal.setGlowMode(this.menuInteraction.isGlowModeSelected());
    }

    public void insertIntoObjectList(WireSegment ws, FigObjectList OL) {
        if (ws == null || ws.getSignal() == null) {
            this.message("-E- insertIntoObjectList: cannot handle a WireSegment that is null or doesn't belong to a Signal!");
            return;
        }
        OL.insert(ws);
        ws.setTrafo(this.objectCanvas.getTrafo());
        ws.setObjectPainter(this.objectCanvas);
    }

    public void insertIntoObjectList(FigObject obj, FigObjectList OL) {
        if (debug) {
            this.message("-I- Editor.insertIntoObjectList( " + obj + ")");
        }
        if (obj != null) {
            obj.setTrafo(this.objectCanvas.getTrafo());
            obj.setObjectPainter(this.objectCanvas);
            OL.insert(obj);
        }
    }

    public void deleteFromObjectList(Signal signal) {
        if (signal == null) {
            this.message("-W- called deleteFromObjectList() with a null Signal...");
            return;
        }
        FigObject[] segments = signal.getSegments();
        for (int i = 0; i < segments.length; ++i) {
            this.objectList.delete(segments[i]);
        }
        FigObject[] solders = signal.getSolderDots();
        if (solders != null) {
            for (int i = 0; i < solders.length; ++i) {
                this.objectList.delete(solders[i]);
            }
        }
    }

    public void doInitSignals(String choice) {
        if ("0".equals(choice)) {
            this.initSignals(0);
        } else if ("1".equals(choice)) {
            this.initSignals(1);
        } else if ("2".equals(choice)) {
            this.initSignals(2);
        } else {
            this.initSignals(-1);
        }
    }

    public void initSignals(int choice) {
        String valueString;
        if (debug) {
            this.message("initSignals..." + choice);
        }
        if (choice > 2 || choice < -1) {
            this.message("-E- illegal choice in initSignals, must be 0, 1, 2(U), or -1 for random.");
            return;
        }
        switch (choice) {
            case -1: {
                valueString = "random";
                break;
            }
            case 0: {
                valueString = "0";
                break;
            }
            case 1: {
                valueString = "1";
                break;
            }
            default: {
                valueString = "U";
            }
        }
        StdLogic1164 value_0 = new StdLogic1164(2);
        StdLogic1164 value_1 = new StdLogic1164(3);
        StdLogic1164 value_U = new StdLogic1164(0);
        StdLogic1164 value_tmp = value_0;
        SimEvent event_0 = null;
        double time = this.getDesign().getSimulator().getSimTime();
        Signal signal = null;
        SignalEnumerator E = new SignalEnumerator(this.design);
        while (E.hasMoreElements()) {
            signal = (Signal)E.nextElement();
            if (signal instanceof SignalStdLogic1164) {
                if (choice == 0) {
                    value_tmp = value_0;
                } else if (choice == 1) {
                    value_tmp = value_1;
                } else if (choice == 2) {
                    value_tmp = value_U;
                } else if (choice == -1) {
                    value_tmp = Math.random() >= 0.5 ? value_1 : value_0;
                }
                event_0 = new SimEvent(signal, time, value_tmp);
                signal.evaluate(event_0);
                continue;
            }
            signal.setValue(valueString);
        }
        this.setGlowMode(this.menuInteraction.isGlowModeSelected());
    }

    public void renameToplevelSignalsAfterDrivers() {
        Editor.dbg("-#- renameToplevelSignalsAfterDrivers...");
        Enumeration E = this.design.getSignals();
        while (E.hasMoreElements()) {
            Signal tmp = (Signal)E.nextElement();
            if (!this.isDefaultSignalName(tmp.getName())) continue;
            tmp.renameAfterDriver();
        }
        this.doFullRedraw();
    }

    private boolean isDefaultSignalName(String s) {
        if (s == null) {
            return false;
        }
        if (!s.startsWith("n")) {
            return false;
        }
        try {
            Integer.parseInt(s.substring(1));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void addProbes(int mode) {
        if (debug) {
            this.message("Editor.addProbes(), mode= " + mode);
        }
        Signal tmp = null;
        Enumeration E = this.design.getSignals();
        while (E.hasMoreElements()) {
            tmp = (Signal)E.nextElement();
            if (!debug) continue;
            this.message("found Signal '" + tmp.getFullName() + "' ");
        }
    }

    public void createWaveformViewer() {
        if (this.waveformViewer == null) {
            this.message("-I- ...creating Waveform Viewer, please wait...");
            this.waveformViewer = new WaveformViewer();
            this.waveformViewer.setEditor(this);
            this.setWaveformViewer(this.waveformViewer);
        }
    }

    public void addProbeToSignal(Signal signal) {
        if (signal == null) {
            this.message("-W- addProbeToSignal: signal is null");
            return;
        }
        if (signal.getProbe() != null) {
            this.message("-W- Signal already probed: " + signal);
            return;
        }
        this.createWaveformViewer();
        Waveform wf = this.waveformViewer.addSignal(signal);
        signal.setProbe(wf);
        if (signal.isVisible()) {
            ProbeSymbol probeSymbol = new ProbeSymbol();
            probeSymbol.setSignal(signal);
            FigObject[] segments = signal.getSegments();
            if (segments != null && segments.length > 0) {
                Point[] points = segments[0].getPoints();
                probeSymbol.move(points[0].x, points[0].y);
            }
            signal.setProbeSymbol(probeSymbol);
            this.insertIntoObjectList(probeSymbol);
        }
    }

    public void addProbeToSignal(String name) {
        this.addProbeToSignal(this.getDesign().getSignal(name));
    }

    public void addProbesToAllSignals() {
        Editor.dbg("-#- addProbesToAllSignals...");
        SignalEnumerator SE = new SignalEnumerator(this.design);
        while (SE.hasMoreElements()) {
            this.addProbeToSignal((Signal)SE.nextElement());
        }
        this.doFullRedraw();
    }

    public void addProbesToToplevelSignals() {
        Editor.dbg("-#- addProbesToToplevelSignals...");
        Enumeration E = this.design.getSignals();
        while (E.hasMoreElements()) {
            this.addProbeToSignal((Signal)E.nextElement());
        }
        this.doFullRedraw();
    }

    public void addProbesToToplevelIO() {
        Editor.dbg("-#- addProbesToToplevelIO...");
        Enumeration E = this.design.getComponents();
        while (E.hasMoreElements()) {
            SimObject component = (SimObject)E.nextElement();
            if (component instanceof InputConnector) {
                this.addProbeToSignal(component.getPort("Y").getSignal());
            }
            if (!(component instanceof OutputConnector)) continue;
            this.addProbeToSignal(component.getPort("A").getSignal());
        }
        this.doFullRedraw();
    }

    public void removeProbeFromSignal(Signal signal) {
        if (signal == null) {
            this.message("-W- addProbeToSignal: signal is null");
            return;
        }
        if (signal.getProbe() == null) {
            if (debug) {
                this.message("-I- Signal has no probe: " + signal + ", ignored.");
            }
            return;
        }
        Waveform waveform = signal.getProbe();
        ProbeSymbol probeSymbol = signal.getProbeSymbol();
        WaveformViewer sw = this.getWaveformViewer();
        if (sw == null) {
            return;
        }
        sw.delWaveform(waveform);
        signal.removeProbe();
        signal.setProbeSymbol(null);
        if (probeSymbol != null) {
            this.getObjectList().delete(probeSymbol);
        }
    }

    public void removeProbesFromAllSignals() {
        Editor.dbg("-#- removeProbesFromAllSignals...");
        if (this.design == null) {
            return;
        }
        SignalEnumerator SE = new SignalEnumerator(this.design);
        while (SE.hasMoreElements()) {
            this.removeProbeFromSignal((Signal)SE.nextElement());
        }
        this.doFullRedraw();
    }

    public void removeProbesFromToplevelSignals() {
        Editor.dbg("-#- removeProbesFromToplevelSignals...");
        Enumeration E = this.design.getSignals();
        while (E.hasMoreElements()) {
            this.removeProbeFromSignal((Signal)E.nextElement());
        }
        this.doFullRedraw();
    }

    public void removeProbesFromToplevelIO() {
        Editor.dbg("-#- removeProbesFromToplevelIO...");
        if (this.design == null) {
            return;
        }
        Enumeration E = this.design.getComponents();
        while (E.hasMoreElements()) {
            SimObject component = (SimObject)E.nextElement();
            if (component instanceof InputConnector) {
                this.removeProbeFromSignal(component.getPort("Y").getSignal());
            }
            if (!(component instanceof OutputConnector)) continue;
            this.removeProbeFromSignal(component.getPort("A").getSignal());
        }
        this.doFullRedraw();
    }

    public void doShowWaves() {
        if (this.waveformViewer == null) {
            this.createWaveformViewer();
        }
        if (this.waveformViewer != null) {
            this.waveformViewer.setVisible(true);
        }
    }

    public void doClearWaveData() {
        if (this.waveformViewer != null) {
            this.waveformViewer.clearWaveData();
        }
    }

    public void doSelectObject() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.SelectObjectCommand"));
    }

    public void doSelectRegion() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.SelectRegionCommand"));
    }

    public void doSelectAllObjects() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.SelectAllCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doDeselectAllObjects() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.DeselectAllCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doDeleteSelection() {
        System.out.println("doDeleteSelection...");
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.DeleteSelectionCommand"));
    }

    public void doMoveSelection() {
        System.out.println("doMoveSelection...");
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.MoveSelectionCommand"));
    }

    public void doCopySelection() {
        System.out.println("doCopySelection...");
    }

    public void doDeleteAll() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.DeleteAllCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doFitPositive() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.MoveToPositiveQuadrantCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doAutoconnect() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.AutoconnectCommand"));
    }

    public void doDisconnect() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.DisconnectCommand"));
    }

    public void doMirrorXObject() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.MirrorXCommand"));
    }

    public void doMirrorYObject() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.MirrorYCommand"));
    }

    public void doMalloc(int size) {
        this.message("-W- allocating (and freeing) " + size + " bytes...");
        int[] dummy = new int[size / 4];
        for (int i = 0; i < 257; ++i) {
            dummy[i] = i;
        }
        dummy = null;
        this.doShowMemoryInfo();
    }

    public void doShowMemoryInfo() {
        this.message("-I- memory usage: " + Runtime.getRuntime().freeMemory() + " bytes free, " + Runtime.getRuntime().totalMemory() + " bytes total.");
    }

    public void doGarbageCollect() {
        long time = System.currentTimeMillis();
        this.message("-W- starting a garbage collection...");
        this.doShowMemoryInfo();
        Runtime.getRuntime().gc();
        this.message("-I- garbage collection took " + (System.currentTimeMillis() - time) + " msecs.");
        this.doShowMemoryInfo();
    }

    public void doTestTiming() {
        int i;
        Symbol tmp;
        int i2;
        int i3;
        this.message("doTestTiming()... ");
        this.message("...creating 1000 AND gates (without symbols)...");
        Design dtmp = new Design(this.design, this.getSimulator(), "demo");
        SimObject[] target = new SimObject[1000];
        long t1 = System.currentTimeMillis();
        try {
            for (i3 = 0; i3 < 1000; ++i3) {
                target[i3] = DesignManager.getDesignManager().getSimObject("hades.models.gates.And2");
                target[i3].setEditor(this);
            }
        }
        catch (Exception e) {
            this.message("in testTiming(): " + e);
        }
        long t2 = System.currentTimeMillis();
        this.message("...in " + (t2 - t1) + " milliseconds...");
        this.message("...adding them to the Design...");
        for (i3 = 0; i3 < 1000; ++i3) {
            dtmp.addComponent(target[i3]);
        }
        long t3 = System.currentTimeMillis();
        this.message("...in " + (t3 - t2) + " milliseconds...");
        this.message("...creating 1000 INV gates (without symbols)...");
        SimObject[] invs = new SimObject[1000];
        t2 = System.currentTimeMillis();
        try {
            for (i2 = 0; i2 < 1000; ++i2) {
                invs[i2] = DesignManager.getDesignManager().getSimObject("hades.models.gates.Inv");
                target[i2].setEditor(this);
            }
        }
        catch (Exception e) {
            this.message("in testTiming(): " + e);
        }
        t3 = System.currentTimeMillis();
        this.message("...in " + (t3 - t2) + " milliseconds...");
        this.message("...adding them to the Design...(with good names)");
        for (i2 = 0; i2 < 1000; ++i2) {
            invs[i2].setName("inverter_" + i2);
            dtmp.addComponent(invs[i2]);
        }
        t2 = System.currentTimeMillis();
        this.message("...in " + (t2 - t3) + " milliseconds...");
        this.message("...creating 1000 AND gates (with symbols)...");
        t3 = System.currentTimeMillis();
        try {
            for (i2 = 0; i2 < 1000; ++i2) {
                target[i2] = DesignManager.getDesignManager().getSimObject("hades.models.gates.And2");
                target[i2].setEditor(this);
                target[i2].setVisible(true);
                tmp = SymbolManager.getSymbolManager().getSymbol(target[i2]);
                target[i2].setSymbol(tmp);
            }
        }
        catch (Exception e) {
            this.message("in testTiming(): " + e);
        }
        long t4 = System.currentTimeMillis();
        this.message("...in " + (t4 - t3) + " milliseconds...");
        this.message("...copying 1000 AND symbols...");
        for (i = 0; i < 1000; ++i) {
            SymbolManager.getSymbolManager().getSymbol(target[0]);
        }
        long t5 = System.currentTimeMillis();
        this.message("...in " + (t5 - t4) + " milliseconds...");
        this.message("...creating 1000 INV gates (with symbols)...");
        t3 = System.currentTimeMillis();
        try {
            for (i = 0; i < 1000; ++i) {
                target[i] = DesignManager.getDesignManager().getSimObject("hades.models.gates.Inv");
                target[i].setEditor(this);
                target[i].setVisible(true);
                tmp = SymbolManager.getSymbolManager().getSymbol(target[i]);
                target[i].setSymbol(tmp);
            }
        }
        catch (Exception e) {
            this.message("in testTiming(): " + e);
        }
        t4 = System.currentTimeMillis();
        this.message("...in " + (t4 - t3) + " milliseconds...");
        t3 = System.currentTimeMillis();
        this.message("...creating 1000 Labels...");
        Label[] labels = new Label[1000];
        for (int i4 = 0; i4 < 1000; ++i4) {
            labels[i4] = new Label();
            labels[i4].initialize(" 500 3000 HugoDerGrosse" + i4);
        }
        t4 = System.currentTimeMillis();
        this.message("...in " + (t4 - t3) + " milliseconds...");
    }

    public FigObject findSymbolOrSignal(Point WP) {
        FigObject tmpobj = null;
        FigObject nearest = null;
        double cost = 1.0E10;
        double min_cost = 1.0E10;
        double snapDistance = this.objectCanvas.getTrafo().getSnapRelative() / 3;
        if (debug) {
            this.message("***findSymbolOrSignal started...");
        }
        Enumeration e = this.objectList.reverseElements();
        while (e.hasMoreElements()) {
            tmpobj = (FigObject)e.nextElement();
            cost = tmpobj.minDistance(WP);
            if (debug) {
                this.message("*** found: " + tmpobj + "\n*** distance= " + cost);
            }
            if (!(cost < min_cost)) continue;
            nearest = tmpobj;
            min_cost = cost;
        }
        if (min_cost < snapDistance) {
            if (debug) {
                this.message("findSymbolOrSignal() found: " + tmpobj);
            }
            return nearest;
        }
        if (debug) {
            this.message("No object or signal found at (near) that position!");
        }
        return null;
    }

    public FigObject findObjectAt(Point wp) {
        FigObject tmpobj = null;
        FigObject nearest = null;
        double cost = 1.0E10;
        double min_cost = 1.0E10;
        double snapDistance = this.objectCanvas.getTrafo().getSnapRelative();
        Enumeration e = this.objectList.reverseElements();
        while (e.hasMoreElements()) {
            tmpobj = (FigObject)e.nextElement();
            cost = tmpobj.minDistanceEuclid(wp);
            if (!(cost < min_cost)) continue;
            nearest = tmpobj;
            min_cost = cost;
        }
        if (min_cost <= snapDistance) {
            if (debug) {
                this.message("findSymbolOrSignal() found: " + tmpobj);
            }
            return nearest;
        }
        if (debug) {
            this.message("No object or signal found at (near) that position!");
        }
        return null;
    }

    public FigObject findNearestWireSegment(Point WP) {
        FigObject tmpobj = null;
        FigObject nearest = null;
        double cost = 1.0E10;
        double min_cost = 1.0E10;
        if (debug) {
            this.message("***findNearestSignal started...");
        }
        Enumeration e = this.objectList.reverseElements();
        while (e.hasMoreElements()) {
            double cornerDistance;
            tmpobj = (FigObject)e.nextElement();
            if (!(tmpobj instanceof WireSegment) || !((cornerDistance = tmpobj.getBbox().minDistanceInsideZero(WP)) < 1200.0)) continue;
            cost = ((WireSegment)tmpobj).getEuclideanDistance(WP);
            if (debug) {
                this.message("*** testing: " + tmpobj + "\n*** distance= " + cost);
            }
            if (!(cost < min_cost)) continue;
            nearest = tmpobj;
            min_cost = cost;
        }
        if (debug) {
            this.message("*** found: " + nearest + " distance= " + cost);
        }
        return nearest;
    }

    public FigObject findNearestWireSegment(Point WP, int radius) {
        FigObject tmpobj = null;
        FigObject nearest = null;
        double cost = 1.0E10;
        double min_cost = 1.0E10;
        Editor.dbg("-#- findNearestSignal started...");
        Enumeration e = this.objectList.reverseElements();
        while (e.hasMoreElements()) {
            double cornerDistance;
            tmpobj = (FigObject)e.nextElement();
            if (!(tmpobj instanceof WireSegment) || !((cornerDistance = tmpobj.getBbox().minDistanceInsideZero(WP)) < 600.0)) continue;
            cost = ((WireSegment)tmpobj).getMinPerpendicularDistance(WP);
            if (debug) {
                this.message("*** testing: " + tmpobj + "\n*** distance= " + cost);
            }
            if (!(cost < min_cost)) continue;
            nearest = tmpobj;
            min_cost = cost;
        }
        Editor.dbg("fNWS: " + nearest + " distance = " + cost + " radius=" + radius);
        if (min_cost < (double)radius) {
            return nearest;
        }
        return null;
    }

    public SimObject lookupSimObject(Symbol symbol) {
        return symbol.getParent();
    }

    public Symbol findSymbol(Point WP) {
        FigObject tmpobj = null;
        FigObject target = null;
        double snapDistance = this.objectCanvas.getTrafo().getSnapRelative() / 3;
        Enumeration e = this.objectList.reverseElements();
        while (e.hasMoreElements()) {
            tmpobj = (FigObject)e.nextElement();
            double cost = tmpobj.getBbox().minDistanceInsideZero(WP);
            if (!(cost < snapDistance) || !(tmpobj instanceof Symbol)) continue;
            target = tmpobj;
            break;
        }
        if (target == null) {
            if (debug) {
                this.message("no SimObject found at that position.");
            }
            return null;
        }
        if (debug && target != null) {
            this.message("findSymbol: found object " + target);
        }
        return (Symbol)target;
    }

    public SimObject findSimObject(Point WP) {
        Symbol symbol = this.findSymbol(WP);
        if (symbol != null) {
            return this.lookupSimObject(symbol);
        }
        return null;
    }

    public boolean isInsideObject(Point WP) {
        Symbol tmp = this.findSymbol(WP);
        if (tmp == null) {
            return false;
        }
        FigBbox bbox = tmp.getBbox();
        int size = 110;
        return WP.x > bbox.getXl() + size && WP.x < bbox.getXr() - size && WP.y > bbox.getYt() + size && WP.y < bbox.getYb() - size;
    }

    public boolean isOnBorder(FigDrawable obj, Point WP) {
        return obj.getBbox().isOnBorder(WP, this.objectCanvas.getTrafo().getSnapRelative());
    }

    public boolean isOnPort(Point WP) {
        int i;
        PortSymbol tmp = null;
        double snapDistance = this.objectCanvas.getTrafo().getSnapRelative() / 3;
        Symbol symbol = this.findSymbol(WP);
        if (symbol == null) {
            return false;
        }
        String[] portnames = symbol.getPortNames();
        if (this.traceMouseClicks) {
            this.message("\n-I- This object has the following ports: ");
            for (i = 0; i < portnames.length; ++i) {
                this.message("   " + portnames[i] + " " + symbol.getPortPosition(portnames[i]));
            }
        }
        for (i = 0; i < portnames.length; ++i) {
            tmp = symbol.getPortSymbol(portnames[i]);
            if (tmp.getBbox().minDistanceInsideZero(WP) < snapDistance) {
                return true;
            }
            if (!debug) continue;
            this.message("...distances= " + tmp.getBbox().minDistanceInsideZero(WP) + " snap=" + snapDistance);
        }
        return false;
    }

    public Port findPort(Point WP) {
        PortSymbol tmp = null;
        PortSymbol portSymbol = null;
        double snapDistance = this.objectCanvas.getTrafo().getSnapRelative() / 3;
        Symbol symbol = this.findSymbol(WP);
        if (symbol == null) {
            if (debug) {
                this.message("findPort(): no Symbol at that position!");
            }
            return null;
        }
        String[] portnames = symbol.getPortNames();
        for (int i = 0; i < portnames.length; ++i) {
            tmp = symbol.getPortSymbol(portnames[i]);
            if (!(tmp.getBbox().minDistanceInsideZero(WP) < snapDistance)) continue;
            portSymbol = tmp;
            break;
        }
        if (debug) {
            this.message("findPort(): found portSymbol " + portSymbol);
        }
        if (portSymbol == null) {
            return null;
        }
        return symbol.getParent().getPort(portSymbol.getName());
    }

    public FigBbox getDesignBoundingBox() {
        FigBbox bbox = BoundingBoxCalculator.getBoundingBox(this.getObjectList().elements());
        if (debug) {
            this.message("getDesignBoundingBox(): " + bbox);
        }
        return bbox;
    }

    @Override
    public void mousePressed(FigCanvasEvent ME) {
        Point SP = ME.getScreenCoordinatePoint();
        Point WP = ME.getWorldCoordinatePoint();
        this.lastEventTime = ME.getWhen();
        try {
            if (this.traceMouseClicks) {
                this.message("Editor.mousePressed at: " + SP + " WC: " + WP);
            }
            if (this.currentCommand == null) {
                return;
            }
            if (!this.currentCommand.isReady()) {
                this.currentCommand.mousePressed(ME);
            } else if (ME.isAltDown() || ME.isMetaDown()) {
                if (debug) {
                    this.message("-I- Editor.mousePressed(): modifiers=" + ME.getModifiers() + ", ignoring...");
                }
            } else if (this.autoCreateSignalsEnableFlag && this.isOnPort(WP)) {
                if (debug) {
                    this.message("mousePressed(): isOnPort!");
                }
                this.setCommand(this.createCommandByName("hades.gui.CreateSignalCommand"));
                ((CreateSignalCommand)this.currentCommand).setPosition(SP, WP);
            } else if (this.isInsideObject(WP)) {
                if (this.traceMouseClicks) {
                    this.message("mousePressed(): isInsideObject! clickCount=" + ME.getClickCount());
                }
                SimObject tmp = this.findSimObject(WP);
                tmp.mousePressed(ME);
            } else {
                this.statusMessage("Please select a command.");
                this.logManager.writeLogMessage("");
            }
        }
        catch (Exception e) {
            this.statusMessage("Internal error: please check the log messages!");
            this.message("-E- internal error: " + e);
            e.printStackTrace();
            ExceptionTracer.trace(e);
        }
    }

    public void mouseClicked(FigCanvasEvent ME) {
        this.message("Editor.mouseClicked: clickCount=" + ME.getClickCount());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void keyPressed(KeyEvent evt) {
        char key = evt.getKeyChar();
        if (debug) {
            this.message("-I- Editor.keyPressed: " + evt);
        }
        this.lastEventTime = evt.getWhen();
        this.logManager.writeMouseMoved();
        this.logManager.writeKeyPressed(evt);
        try {
            if (key == '\u001b') {
                if (debug) {
                    this.message("-I- Editor.keyPressed: got an ESCAPE key...");
                }
                this.doCancel();
                return;
            }
            if (!evt.isActionKey()) return;
            if (debug) {
                this.message("this is an ACTION key: " + evt.getKeyCode());
            }
            boolean shift = evt.isShiftDown();
            int code = evt.getKeyCode();
            switch (code) {
                case 27: {
                    this.doCancel();
                    return;
                }
                case 40: {
                    this.objectCanvas.doPanning(4, shift);
                    return;
                }
                case 38: {
                    this.objectCanvas.doPanning(3, shift);
                    return;
                }
                case 37: {
                    this.objectCanvas.doPanning(1, shift);
                    return;
                }
                case 39: {
                    this.objectCanvas.doPanning(2, shift);
                    return;
                }
                case 36: {
                    this.objectCanvas.doPanning(0, shift);
                    return;
                }
                default: {
                    if (this.keyHandler == null) return;
                    this.keyHandler.keyTyped(evt);
                }
            }
            return;
        }
        catch (Exception e) {
            this.statusMessage("Internal error: please check the log messages!");
            this.message("-E- internal error: " + e);
            ExceptionTracer.trace(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (debug) {
            this.message("-I- Editor.keyTyped: " + evt);
        }
        this.lastEventTime = evt.getWhen();
        if (this.keyHandler != null) {
            this.keyHandler.keyTyped(evt);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent ME) {
        this.lastEventTime = ME.getWhen();
        Editor.setActiveEditor(this);
    }

    @Override
    public void mouseExited(MouseEvent ME) {
    }

    @Override
    public void mouseClicked(MouseEvent ME) {
    }

    @Override
    public void mousePressed(MouseEvent ME) {
    }

    @Override
    public void mouseReleased(MouseEvent ME) {
    }

    private void initCallbackTables() {
        this.__callbackMethodTable = new Hashtable();
        this.__callbackArgTable = new Hashtable();
    }

    public Hashtable getCallbackTable() {
        return this.__callbackMethodTable;
    }

    public void addCallback(Object key, String methodname, Object argument) {
        Object victim = this.__callbackMethodTable.get(key);
        if (victim != null) {
            Editor.msg("-W- Editor.addCallback: overwriting existing callback, key='" + key + "' callback='" + victim + "'");
        }
        this.__callbackMethodTable.put(key, methodname);
        this.__callbackArgTable.put(key, argument);
    }

    public void checkAllCallbacks() {
        Editor.dbg("-#- checkAllCallbacks...");
        Method method = null;
        Enumeration E = this.__callbackMethodTable.keys();
        while (E.hasMoreElements()) {
            Object key = E.nextElement();
            String callback = (String)this.__callbackMethodTable.get(key);
            Object argument = this.__callbackArgTable.get(key);
            try {
                Class[] formals;
                if ("".equals(argument) || "null".equals(argument)) {
                    method = this.getClass().getMethod(callback, new Class[0]);
                } else if (argument instanceof String) {
                    formals = new Class[]{String.class};
                    method = this.getClass().getMethod(callback, formals);
                } else {
                    formals = new Class[]{Object.class};
                    method = this.getClass().getMethod(callback, formals);
                }
                Editor.dbg("-#- method is: " + method);
            }
            catch (NoSuchMethodException nsme) {
                Editor.msg("-E- Missing Callback: '" + key + "' '" + callback + "' '" + argument + "'\n");
            }
            catch (Throwable t) {
                Editor.msg("-E- Internal Error for callback: " + key);
            }
        }
    }

    public void __call(String methodname, Object argument) {
        this.logManager.writeMethodCall(methodname, argument);
        Method method = null;
        try {
            if ("".equals(argument)) {
                method = this.getClass().getMethod(methodname, new Class[0]);
                method.invoke((Object)this, new Object[0]);
            } else if ("null".equals(argument)) {
                method = this.getClass().getMethod(methodname, new Class[0]);
                method.invoke((Object)this, new Object[0]);
            } else if (argument != null && argument instanceof String) {
                Class[] formals = new Class[]{String.class};
                method = this.getClass().getMethod(methodname, formals);
                Object[] args = new Object[]{argument};
                method.invoke((Object)this, args);
            } else {
                Class[] formals = new Class[]{Object.class};
                method = this.getClass().getMethod(methodname, formals);
                Object[] args = new Object[]{argument};
                method.invoke((Object)this, args);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            this.message("-E- __call: " + t);
            t.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            this.message("-E- __call: " + e + ":" + methodname);
        }
        catch (Exception e) {
            this.message("-E- __call: " + e + " for command: " + methodname);
            e.printStackTrace();
        }
    }

    public Command createCommandByName(String className) {
        Command command = null;
        try {
            Class<?> clazz = Class.forName(className);
            Class[] formals = new Class[]{Editor.class};
            Object[] actuals = new Object[]{this};
            Constructor<?> cstr = clazz.getConstructor(formals);
            command = (Command)cstr.newInstance(actuals);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return command;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source;
        String s;
        String value;
        if (debug) {
            Editor.msg("-#- Editor.actionPerformed: " + e + " from: " + e.getSource());
        }
        if ((value = (String)this.__callbackMethodTable.get(e.getSource())) != null) {
            try {
                Object key = e.getSource();
                String methodname = (String)this.__callbackMethodTable.get(key);
                String argument = (String)this.__callbackArgTable.get(key);
                this.__call(methodname, argument);
                return;
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        }
        if ((s = e.getActionCommand()) == null && (source = e.getSource()) instanceof MenuItem) {
            s = ((MenuItem)source).getLabel();
        }
        if (s != null) {
            try {
                String key = s;
                String methodname = (String)this.__callbackMethodTable.get(key);
                String argument = (String)this.__callbackArgTable.get(key);
                if (methodname != null) {
                    this.__call(methodname, argument);
                    return;
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        }
        this.message("Editor: unknown ActionEvent: " + e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source;
        String methodname;
        if (debug) {
            Editor.msg("-#- Editor.itemStateChanged: " + e.getStateChange() + "   " + e.getItem());
        }
        if ((methodname = (String)this.__callbackMethodTable.get(source = e.getSource())) != null) {
            this.__call(methodname, e);
        } else {
            Editor.msg("-E- Unknown item event: " + e);
        }
    }

    @Override
    public void windowActivated(WindowEvent we) {
    }

    @Override
    public void windowClosed(WindowEvent we) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
        this.message("-I-: got WindowEvent.windowClosing()...");
        this.doClose();
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    public void dummyCallback() {
        Editor.msg("-E- Editor.dummyCallback: this method should not be called!");
        Thread.dumpStack();
    }

    public void doEnableJava2DRenderQuality(Object arg) {
        boolean b = this.menuInteraction.isRenderQualitySelected();
        if (FigAttribs.enableJava2D) {
            this.objectCanvas.requestRenderQuality(b);
        } else {
            this.objectCanvas.requestRenderQuality(b);
        }
    }

    public void doEnableJava2DAntiAliasing(Object arg) {
        boolean b = this.menuInteraction.isEnableAntialiasSelected();
        if (FigAttribs.enableJava2D) {
            this.objectCanvas.requestAntiAliasing(b);
        }
    }

    public void doShowViewMode(Object arg) {
        this.setViewMode(this.menuInteraction.isViewModeSelected());
    }

    public void doShowGlowMode(Object arg) {
        this.setGlowMode(this.menuInteraction.isGlowModeSelected());
    }

    public void doShowRtlibAnimation(Object arg) {
        this.setRtlibAnimationStatus(this.menuInteraction.isRtlibAnimationSelected());
    }

    public void doShowInverseCanvas(Object arg) {
        this.setInverseCanvasMode(this.menuInteraction.isInverseCanvasSelected());
    }

    public void doShowToolTips(Object arg) {
        this.setEnableToolTips(this.menuInteraction.isEnableToolTipsSelected());
    }

    public void doEnableCreateSignals(Object arg) {
        boolean state;
        this.autoCreateSignalsEnableFlag = state = this.menuInteraction.isEnableCreateSignalsSelected();
        this.message("-I- Editor: auto create signals = " + this.autoCreateSignalsEnableFlag);
    }

    public void doEnableSplitSignals(Object arg) {
        Thread.dumpStack();
    }

    private boolean decodeItemStateChange(Object arg) {
        boolean b = false;
        try {
            ItemEvent evt = (ItemEvent)arg;
            b = evt.getStateChange() == 1;
        }
        catch (Throwable t) {
            Editor.msg("-E- internal in Editor.decodeItemStateChange: " + t);
            t.printStackTrace();
        }
        return b;
    }

    public void doTraceSimKernel(Object arg) {
        if (debug) {
            Editor.msg("-#- Editor.doTraceSimKernel: " + arg);
        }
        this.simKernel.setDebug(this.decodeItemStateChange(arg));
    }

    public void doTraceEvents(Object arg) {
        if (debug) {
            Editor.msg("-#- Editor.doTraceEvents: " + arg);
        }
        SimEvent.setDebug(this.decodeItemStateChange(arg));
    }

    public void doTraceSimObjects(Object arg) {
        if (debug) {
            Editor.msg("-#- Editor.doTraceSimObjects: " + arg);
        }
        if (this.design != null) {
            this.design.setDebug(this.decodeItemStateChange(arg));
        } else {
            new SimObject().setDebug(this.decodeItemStateChange(arg));
        }
    }

    public void doTraceSignals(Object arg) {
        if (debug) {
            Editor.msg("-#- Editor.doTraceSignals: " + arg);
        }
        Signal.setDebug(this.decodeItemStateChange(arg));
    }

    public void doTraceMouseClicks(Object arg) {
        if (debug) {
            Editor.msg("-#- Editor.doTraceMouseClicks: " + arg);
        }
        this.setTraceMouseClicks(this.decodeItemStateChange(arg));
    }

    public void doTraceCanvas(Object arg) {
        if (debug) {
            Editor.msg("-#- Editor.doTraceCanvas: " + arg);
        }
        this.objectCanvas.setDebug(this.decodeItemStateChange(arg));
    }

    public void doToggleEditorDebug(Object arg) {
        if (debug) {
            Editor.msg("-#- Editor.doToggleEditorDebug: " + arg);
        }
        Editor.setDebug(this.decodeItemStateChange(arg));
    }

    public void doShowDefaultLayers() {
        this.layerTable.setVisibility("hades.symbols.InstanceLabel", false);
        this.layerTable.setVisibility("hades.symbols.ClassLabel", false);
        this.layerTable.setVisibility("hades.symbols.PortLabel", true);
        this.layerTable.setVisibility("hades.symbols.PortSymbol", true);
        this.layerTable.setVisibility("hades.symbols.BusPortSymbol", true);
        this.layerTable.setVisibility("hades.symbols.BboxRectangle", true);
        this.layerTable.setVisibility("hades.symbols.RtlibAnimation", true);
        this.rebuildObjectList(this.design);
        this.menuInteraction.updateLayerMenuItems(this.layerTable);
    }

    public void doShowAllLayers() {
        this.layerTable.setVisibility("hades.symbols.InstanceLabel", true);
        this.layerTable.setVisibility("hades.symbols.ClassLabel", true);
        this.layerTable.setVisibility("hades.symbols.PortLabel", true);
        this.layerTable.setVisibility("hades.symbols.PortSymbol", true);
        this.layerTable.setVisibility("hades.symbols.BusPortSymbol", true);
        this.layerTable.setVisibility("hades.symbols.BboxRectangle", true);
        this.layerTable.setVisibility("hades.symbols.RtlibAnimation", true);
        this.rebuildObjectList(this.design);
        this.menuInteraction.updateLayerMenuItems(this.layerTable);
    }

    public void doShowNoLayers() {
        this.layerTable.setVisibility("hades.symbols.InstanceLabel", false);
        this.layerTable.setVisibility("hades.symbols.ClassLabel", false);
        this.layerTable.setVisibility("hades.symbols.PortLabel", false);
        this.layerTable.setVisibility("hades.symbols.PortSymbol", false);
        this.layerTable.setVisibility("hades.symbols.BusPortSymbol", false);
        this.layerTable.setVisibility("hades.symbols.BboxRectangle", false);
        this.layerTable.setVisibility("hades.symbols.RtlibAnimation", false);
        this.rebuildObjectList(this.design);
        this.menuInteraction.updateLayerMenuItems(this.layerTable);
    }

    public void doShowInstanceLabels(Object arg) {
        boolean enable = this.decodeItemStateChange(arg);
        this.layerTable.setVisibility("hades.symbols.InstanceLabel", enable);
        this.rebuildObjectList(this.design);
        this.menuInteraction.updateLayerMenuItems(this.layerTable);
    }

    public void doShowClassLabels(Object arg) {
        boolean enable = this.decodeItemStateChange(arg);
        this.layerTable.setVisibility("hades.symbols.ClassLabel", enable);
        this.rebuildObjectList(this.design);
        this.menuInteraction.updateLayerMenuItems(this.layerTable);
    }

    public void doShowPortLabels(Object arg) {
        boolean enable = this.decodeItemStateChange(arg);
        this.layerTable.setVisibility("hades.symbols.PortLabel", enable);
        this.rebuildObjectList(this.design);
        this.menuInteraction.updateLayerMenuItems(this.layerTable);
    }

    public void doShowPortSymbols(Object arg) {
        boolean enable = this.decodeItemStateChange(arg);
        this.layerTable.setVisibility("hades.symbols.PortSymbol", enable);
        this.rebuildObjectList(this.design);
        this.menuInteraction.updateLayerMenuItems(this.layerTable);
    }

    public void doShowBusPortSymbols(Object arg) {
        boolean enable = this.decodeItemStateChange(arg);
        this.layerTable.setVisibility("hades.symbols.BusPortSymbol", enable);
        this.rebuildObjectList(this.design);
        this.menuInteraction.updateLayerMenuItems(this.layerTable);
    }

    public void doShowInstanceBorder(Object arg) {
        boolean enable = this.decodeItemStateChange(arg);
        this.layerTable.setVisibility("hades.symbols.BboxRectangle", enable);
        this.rebuildObjectList(this.design);
        this.menuInteraction.updateLayerMenuItems(this.layerTable);
    }

    private void checkCreateExportOptionsDialog() {
        if (this.exportOptionsDialog == null) {
            this.exportOptionsDialog = this.guiFactory.createExportOptionsDialog(this);
            Editor.dbg("-#- cCEOD: created: " + this.exportOptionsDialog);
        }
    }

    public void doShowExportOptions() {
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.show();
    }

    public void doExportFig2dev() {
        this.checkCreateExportOptionsDialog();
    }

    public void doExportPPM() {
        if (this.undoStack.hasChanges()) {
            this.doSaveFile();
        }
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.updateFigObjectsBoundingBox();
        this.exportOptionsDialog.updateOutFilenameFromFigFilename();
        this.exportOptionsDialog.doExportNativePPM();
    }

    public void doExportGIF() {
        if (this.undoStack.hasChanges()) {
            this.doSaveFile();
        }
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.updateFigObjectsBoundingBox();
        this.exportOptionsDialog.updateOutFilenameFromFigFilename();
        this.exportOptionsDialog.doExportNativeGIF();
    }

    public void doExportPostscript() {
        if (this.undoStack.hasChanges()) {
            this.doSaveFile();
        }
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.updateFigObjectsBoundingBox();
        this.exportOptionsDialog.updateOutFilenameFromFigFilename();
        this.exportOptionsDialog.doExportPS();
    }

    public void doSelectVHDLOptions() {
        Editor.msg("-E- Editor.doSelectVHDLOptions: NOT YET IMPLEMENTED, SORRY!");
    }

    public void doExportVHDL() {
        Editor.msg("-E- Editor.doExportVHDL: NOT YET IMPLEMENTED, SORRY!");
    }

    public void doEditSymbol() {
        Editor.msg("-E- Editor.doEditSymbol: NOT YET IMPLEMENTED, SORRY!");
    }

    public boolean hasUnsavedChanges() {
        return this.undoStack.hasChanges();
    }

    public void doNothing() {
        System.err.println("-W- doNothing called...");
    }

    public void doCallMethod() {
        if (debug) {
            Editor.msg("-#- doCallMethod...");
        }
        StringDialog stringDialog = StringDialog.createStringDialog(this.getFrame(), "Enter method name and argument:", "");
        DoCallMethodListener methodListener = new DoCallMethodListener();
        methodListener.setStringDialog(stringDialog);
        stringDialog.addActionListener(methodListener);
        stringDialog.setText("methodname null");
        stringDialog.selectText(true);
        stringDialog.getDialog().setModal(true);
        stringDialog.getDialog().setVisible(true);
    }

    public boolean doClose() {
        if (debug) {
            this.message("doClose()...");
        }
        this.simKernel.stopSimulation();
        if (!this.isViewMode()) {
            OKtoQuit dialog = new OKtoQuit();
            int answer = dialog.saveChanges(this);
            if (answer == 3) {
                return false;
            }
            if (answer == 2) {
                this.doSaveFile();
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doCloseDesign();
        this.simKernel = null;
        this.design = null;
        if (this.editFrame != null) {
            this.editFrame.setVisible(false);
            this.editFrame.dispose();
        }
        this.logManager.closeLogStream();
        Editor.removeEditor(this);
        if (n_editors == 0) {
            this.menuInteraction.saveRecentFilesList("recent-files.txt");
            System.out.println("last editor closed, exiting...");
            Editor._exit(0);
        }
        return true;
    }

    public void doExit() {
        boolean canceled = false;
        if (n_editors > 1) {
            Editor tmp;
            this.message("-W- about to close all Editors...");
            Enumeration E = Editor.getEditors();
            while (E.hasMoreElements() && !(canceled = !(tmp = (Editor)E.nextElement()).doClose())) {
            }
        } else {
            this.doClose();
        }
    }

    private static void _exit(int status) {
        try {
            SecurityManager SM = System.getSecurityManager();
            if (SM != null) {
                SM.checkExit(status);
            }
            if (exitOnLastWindowClose) {
                System.exit(status);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void setExitOnLastWindowClose(boolean b) {
        exitOnLastWindowClose = b;
    }

    public void doStartNewDesign() {
        if (debug) {
            this.message("doStartNewDesign()");
        }
        this.doStartNewDesign(true);
    }

    public void doStartNewDesign(boolean checkUnsavedChanges) {
        this.simKernel.stopSimulation();
        if (checkUnsavedChanges) {
            int answer = new SaveChangesDialog().saveChanges(this);
            if (answer == 3) {
                return;
            }
            if (answer == 2) {
                this.doSaveFile();
            } else if (answer == 1) {
                // empty if block
            }
        }
        this.doCloseDesign();
        this.design = DesignManager.getDesignManager().getNewDesign(this);
        this.createObjectList();
        this.setTmpObject(null);
        this.undoStack = new UndoStack();
        this.undoStack.setMenuItems(this.menuInteraction.getUndoMenuItem(), this.menuInteraction.getRedoMenuItem());
        this.setCommand(new Command(this));
        this.createNewSimulator();
        this.filename = "unnamed.hds";
        this.updateWindowTitle();
        this.doFullRedraw();
        this.checkAutoStartSimulation();
        this.statusMessage("...ready! Please select a command.");
    }

    public void tearDown() {
        if (debug) {
            System.out.println("-#- Editor.tearDown...");
        }
        if (this.design != null) {
            this.design.tearDown();
            this.design = null;
        }
        if (this.simKernel != null) {
            this.simKernel.stopSimulation();
            this.simKernel = null;
        }
        this.createObjectList();
        this.setTmpObject(null);
        this.undoStack = new UndoStack();
        this.setCommand(new Command(this));
        this.simControlPanel.stopSimTimeUpdate();
        if (debug) {
            System.out.println("-#- Editor.tearDown ok.");
        }
    }

    public void closeAllPropertySheets() {
        if (this.design == null) {
            return;
        }
        Enumeration E = this.design.getComponents();
        while (E.hasMoreElements()) {
            try {
                Component sheet = ((SimObject)E.nextElement()).getPropertySheet();
                if (sheet == null) continue;
                sheet.setVisible(false);
            }
            catch (Exception e) {
                this.message("-E- internal in closeAllPropertySheets: " + e);
                ExceptionTracer.trace(e);
            }
        }
    }

    public void doOpenURL() {
        int answer = new SaveChangesDialog().saveChanges(this);
        if (answer == 3) {
            return;
        }
        if (answer == 2) {
            this.doSaveFile();
        } else if (answer == 1) {
            // empty if block
        }
        String fname = DesignManager.getDesignManager().selectURLName("Select design URL... (*.hds)", "http://tams-www.informatik.uni-hamburg.de/applets/hades/demo.hds");
        this._doOpenFileOrURL(fname);
    }

    public void doOpenFile() {
        int answer = new SaveChangesDialog().saveChanges(this);
        if (answer == 3) {
            return;
        }
        if (answer == 2) {
            this.doSaveFile();
        } else if (answer == 1) {
            // empty if block
        }
        String fname = DesignManager.getDesignManager().selectFileOrURLName("Select design... (*.hds)", "", ".hds", 0);
        this._doOpenFileOrURL(fname);
    }

    public void _doOpenFileOrURL(String filename) {
        Design tmp = null;
        try {
            tmp = DesignManager.getDesignManager().getDesign(this, filename, true);
            tmp.setVisible(true);
        }
        catch (Exception e) {
            if (debug) {
                this.message("-I- Editor: Error in doOpenFile(): " + e);
            }
            if (debug) {
                ExceptionTracer.trace(e);
            }
            return;
        }
        this.doCloseDesign();
        this.design = tmp;
        this.rebuildObjectList(this.design);
        this.updateWindowTitle();
        this.menuInteraction.addRecentFile(filename);
        this.logManager.writeMethodCall("_doOpenFileOrURL", filename);
        this.undoStack = new UndoStack();
        this.undoStack.setMenuItems(this.menuInteraction.getUndoMenuItem(), this.menuInteraction.getRedoMenuItem());
        this.setCommand(new Command(this));
        if (SetupManager.getBoolean("Hades.Editor.AutoZoomFit", false)) {
            this.doZoomFit();
        }
        this.createNewSimulator();
        this.checkAutoStartSimulation();
    }

    public void doOpenDesign(String resourcename) {
        this.doOpenDesign(resourcename, true);
    }

    public void doOpenDesign(String resourcename, boolean checkUnsavedChanges) {
        try {
            Design tmp = DesignManager.getDesignManager().getDesign(this, resourcename, true);
            if (tmp != null) {
                this.doOpenDesign(tmp, checkUnsavedChanges);
            }
        }
        catch (Exception e) {
            Editor.msg("-E- Could not find/open design: " + resourcename);
        }
    }

    public void doOpenDesign(Design tmp, boolean checkUnsavedChanges) {
        if (tmp == null) {
            return;
        }
        if (checkUnsavedChanges) {
            int answer = new SaveChangesDialog().saveChanges(this);
            if (answer == 3) {
                return;
            }
            if (answer == 2) {
                this.doSaveFile();
            } else if (answer == 1) {
                // empty if block
            }
        }
        tmp.setVisible(true);
        this.doCloseDesign();
        this.design = tmp;
        this.rebuildObjectList(this.design);
        this.updateWindowTitle();
        this.undoStack = new UndoStack();
        this.undoStack.setMenuItems(this.menuInteraction.getUndoMenuItem(), this.menuInteraction.getRedoMenuItem());
        this.setCommand(new Command(this));
        this.createNewSimulator();
        if (SetupManager.getBoolean("Hades.Editor.AutoZoomFit", false)) {
            this.doZoomFit();
            AntiDeadlock.sleep(200L);
            this.doFullRedraw();
        }
        this.checkAutoStartSimulation();
    }

    public void doOpenRecentFile(String arg) {
        Editor.dbg("-#- doOpenRecentFile: " + arg);
        int answer = new SaveChangesDialog().saveChanges(this);
        if (answer == 3) {
            return;
        }
        if (answer == 2) {
            this.doSaveFile();
        } else if (answer == 1) {
            // empty if block
        }
        String filename = null;
        try {
            int index = Integer.parseInt(arg);
            filename = this.menuInteraction.getRecentFile(index);
            this._doOpenFileOrURL(filename);
        }
        catch (Throwable e) {
            Editor.dbg("-E- internal error: " + e + " " + arg + " " + filename);
            return;
        }
    }

    public void doCloseDesign() {
        this.simKernel.stopSimulation();
        this.closeAllPropertySheets();
        this.removeProbesFromAllSignals();
        SymbolManager.getSymbolManager().flushSymbolCache();
        this.objectCanvas.clearRepaintArray();
        this.design.tearDown();
        this.design = null;
    }

    public void doSave(OutputStream fs) {
        if (this.design == null) {
            return;
        }
        if (fs == null) {
            return;
        }
        PrintWriter ps = null;
        try {
            ps = new PrintWriter(fs);
            this.design.write(ps);
        }
        catch (Exception e) {
            this.message("-E- Exception while trying to write a design: " + e);
            if (fs != null) {
                this.message("-E- filename is '" + fs);
            }
            ExceptionTracer.trace(e);
        }
        try {
            if (ps != null) {
                ps.flush();
            }
            fs.flush();
            fs.close();
            this.undoStack = new UndoStack();
            this.undoStack.setMenuItems(this.menuInteraction.getUndoMenuItem(), this.menuInteraction.getRedoMenuItem());
        }
        catch (Exception e) {
            this.message("-E- Exception while trying to write (flush) a design: " + e);
            if (fs != null) {
                this.message("-E- filename is '" + fs);
            }
            ExceptionTracer.trace(e);
        }
    }

    public void doSaveFile() {
        DesignManager DM = DesignManager.getDesignManager();
        String resourcename = this.design.getResourceName();
        System.out.println("-0- doSaveFile: " + resourcename);
        if (resourcename == null && (resourcename = DM.selectFileOrURLName("Select design file... (*.hds)", "unnamed.hds", ".hds", 1)) == null) {
            return;
        }
        DM.checkExistsMakeBackup(resourcename);
        this.doSave(DM.getOutputStream(this, resourcename));
        this.design.setResourceName(resourcename);
        this.logManager.writeMethodCall("doSaveFile", resourcename);
    }

    public void doSaveFileAs() {
        String filename;
        DesignManager DM = DesignManager.getDesignManager();
        String defaultName = this.design.getResourceName();
        boolean b = SetupManager.getBoolean("Hades.DesignManager.VorboseMessages", false);
        if (b) {
            Editor.msg("-0- doSaveFileAs: " + defaultName);
        }
        if ((filename = DM.selectFileOrURLName("Select file... (*.hds)", defaultName, ".hds", 1)) == null) {
            return;
        }
        if (b) {
            Editor.msg("-1- got the filename: " + filename);
        }
        filename = DM.checkAndAddFilenameExtension(filename, ".hds");
        if (b) {
            Editor.msg("-2- checked the extension: " + filename);
        }
        this.design.setResourceName(filename);
        DM.checkExistsMakeBackup(filename);
        if (b) {
            Editor.msg("-3- checked exists make backup: " + filename);
        }
        this.doSave(DM.getOutputStream(this, filename));
        if (b) {
            Editor.msg("-4- saved ok.");
        }
        this.logManager.writeMethodCall("doSaveFileAs", filename);
    }

    public void doSaveConfiguration() {
        PrintStream FS = null;
        try {
            DesignManager DM = DesignManager.getDesignManager();
            String filename = DM.selectFileOrURLName("Select the configuration file:", ".hadesrc", ".hadesrc", 1);
            if (filename == null) {
                return;
            }
            FS = new PrintStream(DM.getOutputStream(this, filename));
            Properties p = SetupManager.getProperties();
            String[] keys = new String[p.size()];
            int i = 0;
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                keys[i++] = (String)e.nextElement();
            }
            ShellSort.shellSort(keys);
            FS.println("# Hades property dump on " + new Date());
            for (i = 0; i < keys.length; ++i) {
                FS.println(keys[i] + " " + p.getProperty(keys[i]));
            }
        }
        catch (Exception e) {
            this.message("-E- Exception while trying to save the configuration: " + e);
            ExceptionTracer.trace(e);
        }
    }

    public void doPrintDesign() {
        if (debug) {
            this.message("-#- doPrintDesign started, please wait...");
        }
        if (SetupManager.getBoolean("Hades.Exporter.PrintFitToA4", false)) {
            this.message("-#- Hades.Exporter.PrintFitToA4 is set, fitting...");
            this.doZoomLandscapeA4();
        }
        PrintManager printManager = new PrintManager(this.getDialogParentFrame(), this.objectCanvas);
        printManager.setBannerString("HADES: " + this.design.getName());
        printManager.doPrint();
    }

    public void doStartMove() {
    }

    public void doStartCopy() {
    }

    public void doStartEdit() {
    }

    public void doUndo() {
        this.undoStack.undo();
        this.logManager.writeLogMessage("U: Undo");
    }

    public void doRedo() {
        this.undoStack.redo();
        this.logManager.writeLogMessage("U: Redo");
    }

    public void doRebuildObjectList() {
        this.rebuildObjectList(this.getDesign());
    }

    public void showHelp(String resourcename) {
        this.doCreateNewEditorWithDesign(resourcename);
    }

    public Editor doCreateNewEditorWithDesign(String resourcename) {
        this.message("...constructing new Editor, please wait...");
        try {
            Editor editor = new Editor();
            Design newDesign = DesignManager.getDesignManager().getDesign(editor, resourcename, true);
            newDesign.setVisible(true);
            editor.setDesign(newDesign);
            editor.rebuildObjectList(newDesign);
            editor.updateWindowTitle();
            this.menuInteraction.addRecentFile(resourcename);
            editor.createNewSimulator();
            editor.doFullRedraw();
            editor.checkAutoStartSimulation();
            editor.statusMessage("...ready! Please select a command.");
            return editor;
        }
        catch (Exception e) {
            this.message("-E- Design.configure(): " + e);
            ExceptionTracer.trace(e);
            return null;
        }
    }

    public Editor doCreateNewEmptyEditor() {
        this.message("...constructing new Editor, please wait...");
        try {
            return new Editor();
        }
        catch (Throwable e) {
            this.message("-E- Design.configure(): " + e);
            ExceptionTracer.trace(e);
            return null;
        }
    }

    public void doPopupMove() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.MoveCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupCopy() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.CopyCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupEdit() {
        if (!this.isReady()) {
            return;
        }
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        SimObject tmp = this.findSimObject(wp);
        if (tmp != null) {
            tmp.configure();
        } else {
            this.statusMessage("No SimObject to edit/configure at that position!");
        }
    }

    public void doPopupName() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.ChangeNameCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupDelete() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.DeleteCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        ((DeleteCommand)this.currentCommand).setPosition(sp, wp);
    }

    public void doOpenBrowser() {
        this._open_browser();
    }

    public void doPopupOpenBrowser() {
        this._open_browser();
    }

    private void _open_browser() {
        if (this.browser != null) {
            this.browser.getFrame().setVisible(true);
            return;
        }
        try {
            Class<?> c = Class.forName("hades.manager.Colibri");
            Method m = c.getMethod("getBrowser", new Class[0]);
            this.browser = (Browser)m.invoke((Object)m, new Object[0]);
            this.browser.getFrame().setVisible(true);
        }
        catch (Exception e) {
            Editor.msg("-E- doPopupOpenBrowser: internal error: " + e);
            e.printStackTrace();
        }
    }

    public void doPopupCreate(String s) {
        this.create(s);
    }

    public void doPopupCreateIpin() {
        this.create("hades.models.io.Ipin");
    }

    public void doPopupCreatePulseSwitch() {
        this.create("hades.models.io.PulseSwitch");
    }

    public void doPopupCreateHexSwitch() {
        this.create("hades.models.io.HexSwitch");
    }

    public void doPopupCreateSevenSegment() {
        this.create("hades.models.io.SevenSegment");
    }

    public void doPopupCreateHexDisplay() {
        this.create("hades.models.io.HexDisplay");
    }

    public void doPopupCreateAsciiDisplay() {
        this.create("hades.models.io.AsciiDisplay");
    }

    public void doPopupCreateClock() {
        this.create("hades.models.io.ClockGen");
    }

    public void doPopupCreatePowerOnReset() {
        this.create("hades.models.io.PowerOnReset");
    }

    public void doPopupCreateLED() {
        this.create("hades.models.io.LED");
    }

    public void doPopupCreateOpin() {
        this.create("hades.models.io.Opin");
    }

    public void doPopupCreateVcc() {
        this.create("hades.models.io.Vcc");
    }

    public void doPopupCreateGnd() {
        this.create("hades.models.io.Gnd");
    }

    public void doPopupCreatePullup() {
        this.create("hades.models.io.Pullup");
    }

    public void doPopupCreateBuffer() {
        this.create("hades.models.gates.Buffer");
    }

    public void doPopupCreateAnd2() {
        this.create("hades.models.gates.And2");
    }

    public void doPopupCreateAnd3() {
        this.create("hades.models.gates.And3");
    }

    public void doPopupCreateAnd4() {
        this.create("hades.models.gates.And4");
    }

    public void doPopupCreateDemux14() {
        this.create("hades.models.gates.Demux14");
    }

    public void doPopupCreateInv() {
        this.create("hades.models.gates.Inv");
    }

    public void doPopupCreateSmallInv() {
        this.create("hades.models.gates.InvSmall");
    }

    public void doPopupCreateTri() {
        this.create("hades.models.gates.Tri");
    }

    public void doPopupCreateOr2() {
        this.create("hades.models.gates.Or2");
    }

    public void doPopupCreateOr3() {
        this.create("hades.models.gates.Or3");
    }

    public void doPopupCreateOr4() {
        this.create("hades.models.gates.Or4");
    }

    public void doPopupCreateMux21() {
        this.create("hades.models.gates.Mux21");
    }

    public void doPopupCreateMux41() {
        this.create("hades.models.gates.Mux41");
    }

    public void doPopupCreateNand2() {
        this.create("hades.models.gates.Nand2");
    }

    public void doPopupCreateNand3() {
        this.create("hades.models.gates.Nand3");
    }

    public void doPopupCreateNand4() {
        this.create("hades.models.gates.Nand4");
    }

    public void doPopupCreateNor2() {
        this.create("hades.models.gates.Nor2");
    }

    public void doPopupCreateNor3() {
        this.create("hades.models.gates.Nor3");
    }

    public void doPopupCreateNor4() {
        this.create("hades.models.gates.Nor4");
    }

    public void doPopupCreateXor2() {
        this.create("hades.models.gates.Xor2");
    }

    public void doPopupCreateXnor2() {
        this.create("hades.models.gates.Xnor2");
    }

    void doPopupCreateAOI21() {
        this.create("hades.models.complexgates.AOI21");
    }

    void doPopupCreateAOI22() {
        this.create("hades.models.complexgates.AOI22");
    }

    void doPopupCreateAOI31() {
        this.create("hades.models.complexgates.AOI31");
    }

    void doPopupCreateAOI32() {
        this.create("hades.models.complexgates.AOI32");
    }

    void doPopupCreateAOI33() {
        this.create("hades.models.complexgates.AOI33");
    }

    void doPopupCreateOAI21() {
        this.create("hades.models.complexgates.OAI21");
    }

    void doPopupCreateOAI22() {
        this.create("hades.models.complexgates.OAI22");
    }

    void doPopupCreateOAI31() {
        this.create("hades.models.complexgates.OAI31");
    }

    void doPopupCreateOAI32() {
        this.create("hades.models.complexgates.OAI32");
    }

    void doPopupCreateOAI33() {
        this.create("hades.models.complexgates.OAI33");
    }

    public void doPopupCreateLatch() {
        this.create("hades.models.flipflops.Latch");
    }

    public void doPopupCreateLatchr() {
        this.create("hades.models.flipflops.Latchr");
    }

    public void doPopupCreateDff() {
        this.create("hades.models.flipflops.Dff");
    }

    public void doPopupCreateDffr() {
        this.create("hades.models.flipflops.Dffr");
    }

    public void doPopupCreateDffre() {
        this.create("hades.models.flipflops.Dffre");
    }

    public void doPopupCreateDffrs() {
        this.create("hades.models.flipflops.Dffrs");
    }

    public void doPopupCreateLatchMetastable() {
        this.create("hades.models.flipflops.LatchMetastable");
    }

    public void doPopupCreateDffMetastable() {
        this.create("hades.models.flipflops.DffMetastable");
    }

    public void doPopupCreateJkff() {
        this.create("hades.models.flipflops.Jkff");
    }

    public void doPopupCreate7400() {
        this.create("hades.models.ttl74.SN7400");
    }

    public void doPopupCreate7408() {
        this.create("hades.models.ttl74.SN7408");
    }

    public void doPopupCreate7449() {
        this.create("hades.models.ttl74.SN7449");
    }

    public void doPopupCreate7400pinout() {
        this.create("hades.models.ttl74.SN7400_pinout");
    }

    public void doPopupCreate7405pinout() {
        this.create("hades.models.ttl74.SN7405_pinout");
    }

    public void doPopupCreate7408pinout() {
        this.create("hades.models.ttl74.SN7408_pinout");
    }

    public void doPopupCreate7432pinout() {
        this.create("hades.models.ttl74.SN7432_pinout");
    }

    public void doPopupCreate7449pinout() {
        this.create("hades.models.ttl74.SN7449_pinout");
    }

    public void doPopupCreate7483pinout() {
        this.createSubDesign("/hades/models/ttl74/SN7483_pinout.hds");
    }

    public void doPopupCreate7486pinout() {
        this.create("hades.models.ttl74.SN7486_pinout");
    }

    public void doPopupCreate74107pinout() {
        this.createSubDesign("/hades/models/ttl74/SN74107A_pinout.hds");
    }

    public void doPopupCreate74138pinout() {
        this.createSubDesign("/hades/models/ttl74/SN74138_pinout.hds");
    }

    public void doPopupCreate74375pinout() {
        this.createSubDesign("/hades/models/ttl74/SN74375_pinout.hds");
    }

    public void doPopupCreate7483() {
        this.createSubDesign("/hades/models/ttl74/SN7483.hds");
    }

    public void doPopupCreateReg4() {
        this.createSubDesign("/hades/models/rtl/Reg4.hds");
    }

    public void doPopupCreateReg8() {
        this.createSubDesign("/hades/models/rtl/Reg8.hds");
    }

    public void doPopupCreateMux81() {
        this.createSubDesign("/hades/models/rtl/Mux8_1.hds");
    }

    public void doPopupCreateMux161() {
        this.createSubDesign("/hades/models/rtl/Mux16_1.hds");
    }

    public void doPopupCreateROM() {
        this.create("hades.models.rtl.ROM_1Kx8");
    }

    public void doPopupCreateRAM() {
        this.create("hades.models.rtl.RAM_256x8");
    }

    public void doPopupCreateSwatch() {
        this.create("hades.models.io.Swatch");
    }

    public void doPopupCreateDcf77Clock() {
        this.create("hades.models.dcf77.Dcf77Clock");
    }

    public void doPopupCreateDcf77Sender() {
        this.create("hades.models.dcf77.Dcf77Sender");
    }

    public void createSubDesign(String designname) {
        if (debug) {
            this.message("doPopupCreateSubDesign()");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(new ColibriCreateSubdesignCommand(this, designname));
    }

    public void doPopupCreateSubDesign(String designname) {
        this.createSubDesign(designname);
    }

    public void doPopupCreateSubDesign() {
        this.createSubDesign(null);
    }

    public void doPopupCreateByName() {
        if (debug) {
            this.message("doPopupCreateByName()");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(new CreateByNameCommand(this, ""));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupCreateFsm() {
        if (debug) {
            this.message("doPopupCreateFsm()");
        }
        this.create("hades.models.fsm.FsmWrapper");
    }

    public void doPopupCreateKvd() {
        if (debug) {
            this.message("doPopupCreateKvd()");
        }
        this.create("hades.models.meta.KvdWrapper");
    }

    public void doPopupCreateFigObject() {
        this.message("-W- doPopupCreateFigObject() not yet implemented...");
    }

    private void create(String className) {
        if (!this.isReady()) {
            return;
        }
        SimObject target = null;
        try {
            target = DesignManager.getDesignManager().getSimObject(className);
            this.setCommand(new ColibriCreateCommand(this, target));
        }
        catch (Exception e) {
            this.message("-E- Couldn't instantiate class " + className);
            ExceptionTracer.trace(e);
        }
    }

    public void doPopupSelectObject() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.SelectObjectCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupSelectRegion() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.SelectRegionCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupSelectAll() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.SelectAllCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupDeselectAll() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.DeselectAllCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupCreateSignal() {
        if (debug) {
            this.message("doPopupCreateSignal!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.CreateSignalCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupSignalMovePoint() {
        if (debug) {
            this.message("doPopupSignalMovePoint!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.SignalMovePointCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        ((SignalMovePointCommand)this.currentCommand).setPosition(sp, wp);
    }

    public void doPopupSignalAddSegment() {
        if (debug) {
            this.message("doPopupSignalAddSegment!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.AddSegmentToSignalCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupSignalInsertVertex() {
        if (debug) {
            this.message("doPopupSignalInsertVertex!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.InsertVertexIntoSignalCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupSignalDeleteSegment() {
        if (debug) {
            this.message("doPopupSignalDeleteSegment!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.DeleteSegmentFromSignalCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupSignalChangeName() {
        if (debug) {
            this.message("doPopupSignalAddSegment!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.ChangeSignalNameCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupAutoconnect() {
        if (debug) {
            this.message("doPopupAutoconnect!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.AutoconnectCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupDisconnect() {
        if (debug) {
            this.message("doPopupDisconnect!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.DisconnectCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupDisconnectPort() {
        if (debug) {
            this.message("doPopupDisconnectPort!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.DisconnectPortCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupSignalAddProbe() {
        if (debug) {
            this.message("doPopupSignalAddProbe!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.AddProbeToSignalCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doPopupSignalDeleteProbe() {
        if (debug) {
            this.message("doPopupSignalDeleteProbe!");
        }
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.DeleteProbeFromSignalCommand"));
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        this.currentCommand.setPosition(sp, wp);
    }

    public void doSignalSetZero() {
        if (debug) {
            this.message("doSignalSetZero()...");
        }
        if (!this.isReady()) {
            return;
        }
        SignalSetValueCommand tmp = (SignalSetValueCommand)this.createCommandByName("hades.gui.SignalSetValueCommand");
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        tmp.setValue(2);
        tmp.setPosition(sp, wp);
        this.setCommand(tmp);
    }

    public void doSignalSetOne() {
        if (debug) {
            this.message("doSignalSetOne()...");
        }
        if (!this.isReady()) {
            return;
        }
        SignalSetValueCommand tmp = (SignalSetValueCommand)this.createCommandByName("hades.gui.SignalSetValueCommand");
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        tmp.setValue(3);
        tmp.setPosition(sp, wp);
        this.setCommand(tmp);
    }

    public void doSignalSetX() {
        if (debug) {
            this.message("doSignalSetOne()...");
        }
        if (!this.isReady()) {
            return;
        }
        SignalSetValueCommand tmp = (SignalSetValueCommand)this.createCommandByName("hades.gui.SignalSetValueCommand");
        Point sp = this.objectCanvas.getPopupPosition();
        Point wp = this.objectCanvas.getPopupPositionWCsnapped();
        tmp.setValue(1);
        tmp.setPosition(sp, wp);
        this.setCommand(tmp);
    }

    public void doSetNoGrid() {
        this.objectCanvas.setGrid(0);
    }

    public void doSetCoarseGrid() {
        this.objectCanvas.setGrid(960);
    }

    public void doSetMediumGrid() {
        this.objectCanvas.setGrid(480);
    }

    public void doSetFineGrid() {
        this.objectCanvas.setGrid(240);
    }

    public void doSetNoSnap() {
        this.snapGrid = 1;
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doSetCoarseSnap() {
        this.snapGrid = 1200;
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doSetMediumSnap() {
        this.snapGrid = 600;
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doSetFineSnap() {
        this.snapGrid = 300;
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doSetTinySnap() {
        this.snapGrid = 150;
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doSetFramerate(double framerate) {
        this.objectCanvas.getSyncRedrawTimer().setFramerate(framerate);
    }

    public void doSetFramerate(String s) {
        try {
            this.doSetFramerate(Double.valueOf(s.trim()));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void doFullRedraw() {
        this.objectCanvas.doFullRedraw();
    }

    public void doZoomRegion() {
        if (!this.isReady()) {
            return;
        }
        this.setCommand(this.createCommandByName("hades.gui.ZoomRegionCommand"));
    }

    public void doZoomRegion(int wx, int wy, int wx2, int wy2) {
        this.objectCanvas.doZoomRegion(wx, wy, wx2, wy2);
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doZoomIn() {
        this.doZoomFactor(2.0);
    }

    public void doZoomIn14() {
        this.doZoomFactor(1.414);
    }

    public void doZoomOut() {
        this.doZoomFactor(0.5);
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doZoomOut07() {
        this.doZoomFactor(0.707);
    }

    public void doZoomIn11() {
        this.doZoomFactor(1.1);
    }

    public void doZoomOut09() {
        this.doZoomFactor(0.9090909090909091);
    }

    public void doZoomFactor(double factor) {
        FigTrafo2D trafo = this.objectCanvas.getTrafo();
        Dimension size = this.objectCanvas.getSize();
        int dx = trafo.screen_to_wc(size.width);
        int dy = trafo.screen_to_wc(size.height);
        double zoom = trafo.getZoom();
        Point anchor = trafo.getAnchor();
        trafo.set_zoom(factor * zoom);
        trafo.setAnchor(new Point(anchor.x + (int)(0.5 * (1.0 - 1.0 / factor) * (double)dx), anchor.y + (int)(0.5 * (1.0 - 1.0 / factor) * (double)dy)));
        this.doFullRedraw();
        this.objectCanvas.notifyZoomListeners();
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doZoomFit() {
        if (debug) {
            this.message("doZoomFit()...");
        }
        this.objectCanvas.doZoomFit();
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doZoom11() {
        this.objectCanvas.doZoom11();
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doZoomLandscapeA4() {
        this.objectCanvas.doZoomLandscapeA4(this.getDesignBoundingBox());
        this.objectCanvas.getTrafo().setSnapAbsolute(this.snapGrid);
    }

    public void doRedraw() {
        this.objectCanvas.doFullRedraw();
    }

    public void doRedrawStressTest() {
        RedrawStressTest RST = new RedrawStressTest(this.objectCanvas);
        RST.setIterations(1000);
        RST.start();
    }

    public void doFlushSymbolCache() {
        if (debug) {
            this.message("doFlushSymbolCache()...");
        }
        SymbolManager.getSymbolManager().flushSymbolCache();
    }

    public void doSetDesignName() {
        SetDesignNameCommand sdnc = new SetDesignNameCommand(this);
        sdnc.setPosition(new Point(0, 0), new Point(0, 0));
    }

    public void doCheckDesign() {
        if (this.design != null) {
            this.design.checkDesign(false);
        } else {
            this.message("-E- No design to check.");
        }
    }

    public void doCheckDesignAndHighlightErrors() {
        if (this.design != null) {
            this.design.checkDesign(true);
        } else {
            this.message("-E- No design to check.");
        }
    }

    public void doCreateSymbol() {
        DesignManager DM = DesignManager.getDesignManager();
        if (debug) {
            this.message("doCreateSymbol()...");
        }
        if (this.design != null) {
            String designName = this.design.getResourceName();
            if (designName == null) {
                designName = "unnamed.hds";
            }
            String symbolName = DesignManager.changeExtension(designName, ".sym");
            try {
                Symbol tmp = this.design.createSymbol();
                this.design.setSymbol(tmp);
                DM.checkExistsMakeBackup(symbolName);
                OutputStream fout = DM.getOutputStream(this, symbolName);
                PrintWriter ps = new PrintWriter(new BufferedOutputStream(fout));
                tmp.writeAsResource(ps);
                ps.flush();
                fout.close();
            }
            catch (Exception e) {
                this.message("-W- Design.createSymbol: caught an Exception " + e);
                ExceptionTracer.trace(e);
            }
        }
    }

    public Image doCreateThumbnail(int width, int height) {
        CreateThumbnail hmct = new CreateThumbnail(this);
        return hmct.createThumbnail(300, 225, 15);
    }

    public Image doCreateThumbnail() {
        return this.doCreateThumbnail(300, 225);
    }

    public void setViewMode(boolean b) {
        System.err.println("-#- setViewMode..." + b);
        this.viewMode = b;
    }

    public boolean getGlowMode() {
        return this.menuInteraction.isGlowModeSelected();
    }

    public void setGlowMode(boolean b) {
        if (debug) {
            System.err.println("-#- Editor.setGlowMode: " + b);
        }
        Color_DIN_IEC_62.setGlowMode(b);
        try {
            boolean cb = this.menuInteraction.isGlowModeSelected();
            if (cb != b) {
                this.menuInteraction.setGlowModeSelected(b);
            }
        }
        catch (Exception cb) {
            // empty catch block
        }
        Enumeration e = this.design.getSignals();
        while (e.hasMoreElements()) {
            Signal tmp = (Signal)e.nextElement();
            if (debug) {
                this.message("setting glow mode for Signal " + tmp);
            }
            tmp.setGlowMode(b);
        }
    }

    public void doToggleGlowMode() {
        this.setGlowMode(!this.getGlowMode());
    }

    public void toggleGlowModeForOneSignal() {
        System.out.println("toggle glow mode for one signal...");
        Point sp = this.objectCanvas.getMousePosition();
        Point wp = new Point(0, 0);
        wp = this.objectCanvas.getTrafo().screen_to_wc_snapped(sp, wp);
        WireSegment ws = (WireSegment)this.findNearestWireSegment(wp);
        if (ws != null) {
            Signal target;
            target.setGlowMode(!(target = ws.getSignal()).getGlowMode());
        } else {
            this.statusMessage("Cannot toggle glow mode: no signal at that position!");
        }
    }

    public void doShowGreenStdLogic1164_0() {
        StdLogic1164.setColor(2, new Color(0x70FF70));
    }

    public void highlightComponent(String name) {
        this.checkCreateHighlightTable();
        SimObject target = this.getDesign().getComponent(name);
        if (target == null) {
            this.statusMessage("highlightComponent: object not found: " + name);
            return;
        }
        Symbol symbol = target.getSymbol();
        if (symbol == null || !symbol.isVisible()) {
            this.statusMessage("highlightComponent: object not visible: " + name);
            return;
        }
        ErrorMarker marker = new ErrorMarker();
        marker.setPointsFromBoundingBox(symbol.getBbox());
        this.highlightTable.put(marker, symbol);
        this.insertIntoObjectList(marker);
        this.doFullRedraw();
    }

    public void highlightSignal(String name) {
        this.checkCreateHighlightTable();
        Signal target = this.getDesign().getSignal(name);
        if (target == null) {
            this.statusMessage("highlightSignal: signal not found: " + name);
            return;
        }
        if (!target.isVisible()) {
            this.statusMessage("highlightSignal: signal not visible: " + name);
            return;
        }
        FigObject[] segments = target.getSegments();
        for (int i = 0; i < segments.length; ++i) {
            HighlightWireSegment marker = new HighlightWireSegment();
            marker.setPoints(segments[i].getPoints());
            this.highlightTable.put(marker, target);
            this.insertIntoObjectList(marker);
        }
        this.doFullRedraw();
    }

    public void removeHighlightMarkers() {
        this.checkCreateHighlightTable();
        Enumeration E = this.highlightTable.keys();
        while (E.hasMoreElements()) {
            FigObject marker = (FigObject)E.nextElement();
            this.objectList.delete(marker);
        }
        this.highlightTable.clear();
        this.statusMessage("removed all highlight-markers...");
        this.doFullRedraw();
    }

    protected void checkCreateHighlightTable() {
        if (this.highlightTable == null) {
            this.highlightTable = new Hashtable();
        }
    }

    public void setRtlibAnimationStatus(boolean b) {
        if (debug) {
            this.message("setRtlibAnimationMode: " + b);
        }
        Enumeration e = this.design.getComponents();
        while (e.hasMoreElements()) {
            Object tmp = e.nextElement();
            if (!(tmp instanceof GenericRtlibObject)) continue;
            ((GenericRtlibObject)tmp).setEnableAnimationFlag(b);
        }
        SetupManager.setProperty("Hades.LayerTable.RtlibAnimation", b ? "true" : "false");
    }

    public void initToolTips() {
        boolean enable = false;
        enable = this.menuInteraction.isEnableToolTipsSelected();
        this.getObjectCanvas().setToolTipsEnabled(enable);
        if (!SetupManager.getBoolean("Hades.UseSwingGUI", true)) {
            long delay = SetupManager.getInteger("Hades.Editor.ToolTipsDelay", 2000);
            Component canvas = this.getObjectCanvas().getComponent();
            this.toolTipManager = new ToolTipManager(canvas, this, delay);
            this.toolTipManager.setEnabled(enable);
        }
    }

    public void setEnableToolTips(boolean enable) {
        Editor.msg("-#- setEnableToolTips: " + enable);
        this.getObjectCanvas().setToolTipsEnabled(enable);
        if (this.toolTipManager != null) {
            this.toolTipManager.setEnabled(enable);
        }
        this.menuInteraction.setEnableToolTipsSelected(enable);
    }

    public void doToggleToolTips() {
        boolean toggled = !this.getObjectCanvas().isToolTipsEnabled();
        this.getObjectCanvas().setToolTipsEnabled(toggled);
        if (this.toolTipManager != null) {
            this.toolTipManager.setEnabled(toggled);
        }
        this.menuInteraction.setEnableToolTipsSelected(toggled);
    }

    public void doToggleAntiAliasing() {
        boolean b = !this.menuInteraction.isEnableAntialiasSelected();
        this.menuInteraction.setEnableAntialiasSelected(b);
        Editor.msg("-#- Editor.doToggleAntiAliasing: " + b);
        if (FigAttribs.enableJava2D) {
            this.objectCanvas.requestAntiAliasing(b);
        }
    }

    public void setInverseCanvasMode(boolean invert) {
        if (debug) {
            this.message("setInverseCanvasMode: " + invert);
        }
        if (invert) {
            this.objectCanvas.setBackground(Color.black);
            this.objectCanvas.setGridColor(new Color(0, 100, 240));
        } else {
            this.objectCanvas.setBackground(Color.white);
            this.objectCanvas.setGridColor(Color.black);
        }
        Color background = this.objectCanvas.getBackground();
        Enumeration e = this.design.getComponents();
        while (e.hasMoreElements()) {
            Symbol sym = ((SimObject)e.nextElement()).getSymbol();
            if (sym == null) continue;
            Enumeration f = sym.getMembers().elements();
            while (f.hasMoreElements()) {
                FigObject o = (FigObject)f.nextElement();
                if (!(o instanceof BboxRectangle)) continue;
                FigAttribs attr = o.getAttributes();
                attr.fillColor = background;
                attr.lineColor = invert ? new Color(50, 50, 50) : new Color(240, 240, 240);
                o.setAttributes(attr);
            }
        }
        this.objectCanvas.doFullRedraw();
    }

    public void doPrintObjects() {
        if (this.design != null) {
            this.design.printComponents();
        }
    }

    public void doPrintAllObjects() {
        if (this.design != null) {
            this.design.printAllComponents("");
        }
    }

    public void doPrintToplevelSignals() {
        if (this.design != null) {
            this.design.printToplevelSignals("");
        }
    }

    public void doPrintAllSignals() {
        if (this.design != null) {
            String s = SignalEnumerator.printAllSignals(this.design);
            this.message(s + "\n");
        }
    }

    public void doPrintSymbols() {
        this.objectList.print();
    }

    public void doPrintWireSegmentInfo() {
        Editor.msg("-I- doPrintWireSegmentInfo...");
        Editor.msg("trafo timestamp: " + this.objectCanvas.getTrafo().getTimestamp());
        Enumeration E = this.objectList.elements();
        while (E.hasMoreElements()) {
            WireSegment ws;
            Object o = E.nextElement();
            if (!(o instanceof WireSegment) || (ws = (WireSegment)o) == null) continue;
            Point[] wp = ws.getPoints();
            Editor.msg(ws.getSignal().getName() + " ((" + wp[0].x + "," + wp[0].y + "),(" + wp[1].x + "," + wp[1].y + "))");
        }
    }

    public void doPrintUndoStack() {
        this.message(this.undoStack.toString());
    }

    public void doPrintEventList() {
        this.message("doPrintEventList()... ");
        this.message(this.simKernel.getEventList().toString());
    }

    public void doPrintEditorTable() {
        StringBuffer sb = new StringBuffer();
        sb.append("-I- currently the following editors are active:\n");
        Enumeration E = Editor.getEditors();
        while (E.hasMoreElements()) {
            Editor tmp = (Editor)E.nextElement();
            sb.append("" + (tmp.equals(Editor.getActiveEditor()) ? "+ " : "- ") + tmp.toString() + "\n");
        }
        this.message(sb.toString());
    }

    public void doPrintRedrawStats() {
        this.objectCanvas.printTimingStats();
    }

    public void doPrintSimulatorStats() {
        this.simKernel.printStatus();
    }

    public void doShowMessages() {
        if (this.console != null) {
            this.console.setVisible(true);
        }
        AntiDeadlock.sleep(200L);
    }

    public void doShowProperties() {
        this.guiFactory.doShowProperties();
    }

    public void doShowBindkeys() {
        Editor.msg("-#- doShowBindkeys...");
        try {
            HashMap<String, SimObject> map = new HashMap<String, SimObject>();
            Enumeration e = this.design.getComponents();
            while (e.hasMoreElements()) {
                SimObject tmp = (SimObject)e.nextElement();
                String bindkey = tmp.getBindkey();
                if (bindkey == null || bindkey.length() <= 0) continue;
                map.put(bindkey, tmp);
            }
            Object[] keys = map.keySet().toArray();
            Arrays.sort(keys);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < keys.length; ++i) {
                sb.append("" + keys[i]);
                sb.append("   ");
                SimObject tmp = (SimObject)map.get(keys[i]);
                sb.append(tmp.getName());
                sb.append("  ");
                sb.append(tmp.getClass().getName());
                sb.append("\n");
            }
            if (keys.length == 0) {
                sb.append("No bindkeys defined.");
            }
            JOptionPane.showMessageDialog(this.getFrame(), sb.toString(), "Current design bindkeys:", -1);
        }
        catch (Throwable t) {
            Editor.msg("-E- internal error: " + t);
            t.printStackTrace();
        }
    }

    public void doShowChanges() {
        this.statusMessage("loading CHANGES (text) file, please wait...");
        this.createAndShowTextViewer("CHANGES", 20, 70, "/hades/doc/CHANGES");
    }

    public void doShowFAQ() {
        this.statusMessage("loading FAQ (text) file, please wait...");
        this.createAndShowTextViewer("FAQ", 20, 70, "/hades/doc/FAQ");
    }

    public Component createAndShowTextViewer(String title, int rows, int cols, String resource) {
        try {
            return this.guiFactory.createAndShowTextViewer(title, rows, cols, resource);
        }
        catch (Exception e) {
            Editor.msg("-E- createAndShowTextViewer: " + e);
            Editor.msg("-E- for resource '" + resource + "'");
            return null;
        }
    }

    public void doShowAbout() {
        this.guiFactory.doShowAbout(this.getDialogParentFrame(), versionString);
    }

    public void message(String msg) {
        if (this.console != null) {
            this.console.println(msg);
        } else {
            Editor.msg(msg);
        }
    }

    public static void msg(String msg) {
        System.err.println(msg);
    }

    public static void dbg(String msg) {
        if (debug) {
            Editor.msg(msg);
        }
    }

    public void statusMessage(String msg) {
        this.statusPanel.setStatusMessage(msg);
    }

    public void printSelection() {
        String s = this.selection.print();
        this.message(s);
    }

    public void doShowTipOfTheDay() {
        System.out.println("-E- doShowTipOfTheDay: DISABLED!");
    }

    @Override
    public String getToolTip(Point mouse_pos, long millis) {
        Point WP = new Point(0, 0);
        WP = this.getObjectCanvas().getTrafo().screen_to_wc_snapped(mouse_pos.x, mouse_pos.y, WP);
        if (this.isOnPort(WP)) {
            Port p = this.findPort(WP);
            if (p != null) {
                return p.getToolTip(mouse_pos, millis);
            }
            return "Internal error: No port found at that position!";
        }
        SimObject obj = this.findSimObject(WP);
        if (obj != null) {
            return obj.getToolTip(mouse_pos, millis);
        }
        WireSegment segment = (WireSegment)this.findNearestWireSegment(WP);
        if (segment != null) {
            return segment.getSignal().getToolTip(mouse_pos, millis);
        }
        return null;
    }

    public String toString() {
        String s = this.design != null ? this.design.getName() : "[no design]";
        return super.toString() + " " + s;
    }

    public static void registerNewEditor(Editor ed) {
        if (_editorTable == null) {
            Editor.createEditorTable();
        }
        _editorTable.put(ed, ed);
        Editor.setActiveEditor(ed);
        ++n_editors;
        Editor.updateEditorCloseMenuItems();
    }

    public static void removeEditor(Editor ed) {
        if (_editorTable == null) {
            Editor.createEditorTable();
        }
        if (_editorTable.containsKey(ed)) {
            _editorTable.remove(ed);
            --n_editors;
        }
        Editor.updateEditorCloseMenuItems();
        if (_activeEditor == ed) {
            _activeEditor = null;
        }
    }

    public static void updateEditorCloseMenuItems() {
        if (_editorTable == null) {
            Editor.createEditorTable();
        }
        boolean b = _editorTable.size() > 1;
        Enumeration E = _editorTable.keys();
        while (E.hasMoreElements()) {
            Editor tmp = (Editor)E.nextElement();
            tmp.menuInteraction.setEnableCloseWindowMenuItem(b);
        }
    }

    public long getLastEventTime() {
        return this.lastEventTime;
    }

    private static void createEditorTable() {
        _editorTable = new Hashtable();
    }

    public static void setActiveEditor(Editor ed) {
        _activeEditor = ed;
    }

    public static Editor getActiveEditor() {
        if (_activeEditor != null) {
            return _activeEditor;
        }
        long t = 0L;
        Enumeration e = Editor.getEditors();
        while (e.hasMoreElements()) {
            Editor ed = (Editor)e.nextElement();
            long when = ed.getLastEventTime();
            if (when < t) continue;
            t = when;
            _activeEditor = ed;
        }
        return _activeEditor;
    }

    public static Enumeration getEditors() {
        if (_editorTable == null) {
            Editor.createEditorTable();
        }
        return _editorTable.keys();
    }

    private void setInitialWindowPosAndSize() {
        int x = SetupManager.getInteger("Hades.Editor.WindowX", 100);
        int y = SetupManager.getInteger("Hades.Editor.WindowY", 100);
        int w = SetupManager.getInteger("Hades.Editor.WindowWidth", 800);
        int h = SetupManager.getInteger("Hades.Editor.WindowHeight", 500);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (x < 0) {
            x = dim.width - w + x;
        }
        if (y < 0) {
            y = dim.height - h + y;
        }
        if (this.editFrame != null) {
            this.editFrame.setLocation(new Point(x, y));
            this.editFrame.setSize(new Dimension(w, h));
        }
    }

    public void doFullScreen() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.editFrame == null) {
            Editor.msg("-E- doFullScreen: editFrame is null, ignored!");
            return;
        }
        this.editFrame.setBounds(0, 0, dim.width, dim.height);
        this.editFrame.invalidate();
        AntiDeadlock.sleep(200L);
        this.editFrame.validate();
        this.doFullRedraw();
    }

    public void doWindow640x480() {
        if (this.editFrame == null) {
            Editor.msg("-E- doFullScreen: editFrame is null, ignored!");
            return;
        }
        this.editFrame.setBounds(0, 0, 640, 480);
        this.editFrame.invalidate();
        AntiDeadlock.sleep(200L);
        this.editFrame.validate();
        this.doFullRedraw();
    }

    public void doCreateJythonConsole() {
        if (this.jythonConsole == null) {
            try {
                Class<?> cl = Class.forName("hades.gui.JythonConsole");
                Constructor<?> co = cl.getConstructor(this.getClass());
                Object ob = co.newInstance(this);
                this.jythonConsole = (Frame)ob;
                this.jythonConsole.setVisible(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Could not construct the JythonConsole:\nprobably no jython.jar on Classpath.\nJython scripting and GUI disabled.\n", "Error", 0);
                this.jythonConsole = new Frame("JythonConsole failed");
            }
        } else {
            this.jythonConsole.setVisible(true);
        }
    }

    public Frame getJythonConsole() {
        if (this.jythonConsole == null) {
            this.doCreateJythonConsole();
        }
        return this.jythonConsole;
    }

    public static void parseArgs(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            try {
                if (argv[i].equals("-h")) {
                    Editor.usage();
                    continue;
                }
                if (argv[i].equals("-help")) {
                    Editor.usage();
                    continue;
                }
                if (argv[i].equals("-?")) {
                    Editor.usage();
                    continue;
                }
                if (argv[i].equals("-xsize")) {
                    SetupManager.setProperty("Hades.Editor.WindowWidth", argv[++i]);
                    continue;
                }
                if (argv[i].equals("-ysize")) {
                    ++i;
                    SetupManager.setProperty("Hades.Editor.WindowHeight", argv[++i]);
                    continue;
                }
                if (argv[i].equals("-xywh")) {
                    SetupManager.setProperty("Hades.Editor.WindowX", argv[++i]);
                    SetupManager.setProperty("Hades.Editor.WindowY", argv[++i]);
                    SetupManager.setProperty("Hades.Editor.WindowWidth", argv[++i]);
                    SetupManager.setProperty("Hades.Editor.WindowHeight", argv[++i]);
                    continue;
                }
                if (argv[i].equals("-cxywh")) {
                    String initConsoleString = argv[++i] + " ";
                    initConsoleString = initConsoleString + argv[++i] + " ";
                    initConsoleString = initConsoleString + argv[++i] + " ";
                    initConsoleString = initConsoleString + argv[++i] + " ";
                    SetupManager.setProperty("Hades.Console.WindowInit", initConsoleString);
                    continue;
                }
                if (argv[i].equals("-vredraw")) {
                    SetupManager.setProperty("Hades.Editor.CanvasDebug", "true");
                    continue;
                }
                if (argv[i].equals("-vv")) {
                    debug = true;
                    ExceptionTracer.setEnabled(true);
                    continue;
                }
                if (argv[i].equals("-noautostart")) {
                    SetupManager.setProperty("Hades.Editor.AutoStartSimulation", "false");
                    continue;
                }
                if (argv[i].equals("-notips")) {
                    SetupManager.setProperty("Hades.EnableTips", "false");
                    continue;
                }
                if (argv[i].equals("-awt")) {
                    SetupManager.setProperty("Hades.UseSwingGUI", "false");
                    continue;
                }
                if (argv[i].equals("-noswing")) {
                    SetupManager.setProperty("Hades.UseSwingGUI", "false");
                    continue;
                }
                if (argv[i].equals("-file")) {
                    SetupManager.setProperty("Hades.Editor.StartupFilename", argv[++i]);
                    continue;
                }
                if (argv[i].equals("-zoomfit")) {
                    SetupManager.setProperty("Hades.Editor.AutoZoomFit", "true");
                    continue;
                }
                if (argv[i].equals("-fit")) {
                    SetupManager.setProperty("Hades.Editor.AutoZoomFit", "true");
                    continue;
                }
                if (argv[i].equals("-viewmode")) {
                    SetupManager.setProperty("Hades.Editor.ViewMode", "true");
                    SetupManager.setProperty("Hades.Editor.PopupMenuResource", "/hades/gui/ViewModePopupMenu.txt");
                    continue;
                }
                Editor.usage();
                continue;
            }
            catch (Exception e) {
                System.err.println("Illegal or missing command line argument: " + e);
            }
        }
    }

    public static void usage() {
        System.out.println("HADES Editor 0.98g (RSB-Prak)\nUsage: java <-mxMemory> hades.gui.Editor <options> \n\nwhere <-mxMemory> sets the JVM memory limit, e.g. -mx32M \nand options include: \n  -h  -help          print this message and exit\n  -viewmode          disable edit operations\n  -vv                verbose: enable Exception traces\n  -vredraw           verbose: redraw message\n  -xsize <int>       initial window width\n  -ysize <int>       initial window height\n  -xywh <int> <int> <int> <int> initial window position and size\n  -cxywh <int> <int> <int> <int> initial console position and size\n  -noautostart       don't start the simulation automatically\n  -notips            don't show the 'did you know' tips\n  -fit               zoom to fit after loading a design\n  -zoomfit           zoom to fit after loading a design\n  -awt               use AWT instead of Swing\n  -swing             use Swing GUI (default) \n  -file <name>       load design <name> \n\nexample: \n  java -mx64M hades.gui.Editor -xywh 100 20 900 700");
        Editor._exit(0);
    }

    public static void dumpSystemProperties() {
        String[] list = new String[]{"java.version", "java.vendor", "os.name", "os.arch", "os.version", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.vm.specification.version", "java.specification.version", "java.class.version", "java.class.path"};
        for (int i = 0; i < list.length; ++i) {
            System.out.println(list[i] + " " + System.getProperty(list[i]));
        }
    }

    public static void main(String[] argv) {
        ExceptionTracer.setEnabled(false);
        SetupManager.setProperty("Hades.UseSwingGUI", "true");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadUserProperties(".hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        Editor.parseArgs(argv);
        if (SetupManager.getBoolean("Hades.Editor.DumpSystemProperties", false)) {
            Editor.dumpSystemProperties();
        }
        Editor editor = new Editor();
        DesignManager.getDesignManager().setDialogWindowsParentFrame(editor.getFrame());
        String initialFilename = null;
        try {
            initialFilename = System.getProperty("jnlp.Hades.Editor.StartupFilename");
            if (initialFilename == null) {
                initialFilename = SetupManager.getProperty("Hades.Editor.StartupFilename", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (initialFilename != null) {
            editor.doOpenDesign(initialFilename, false);
        }
        if (SetupManager.getBoolean("Hades.Editor.EnableTipOfTheDay", false)) {
            editor.doShowTipOfTheDay();
        }
    }

    static {
        exitOnLastWindowClose = true;
    }

    class DoCallMethodListener
    implements ActionListener {
        StringDialog dialog = null;

        DoCallMethodListener() {
        }

        public void setStringDialog(StringDialog _dialog) {
            this.dialog = _dialog;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!evt.getActionCommand().equals("Cancel") && (evt.getActionCommand().equals("OK") || evt.getSource() == this.dialog.getTextComponent())) {
                StringTokenizer st;
                if (debug) {
                    Editor.msg("-#- DoCallMethodListener: " + this.dialog.getText());
                }
                if ((st = new StringTokenizer(this.dialog.getText())).countTokens() == 1) {
                    Editor.this.__call(st.nextToken(), null);
                }
                if (st.countTokens() >= 2) {
                    Editor.this.__call(st.nextToken(), st.nextToken());
                }
            }
            this.dialog.getDialog().setVisible(false);
            this.dialog.getDialog().dispose();
        }
    }
}

