/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Editor;
import hades.gui.EditorMenuInteraction;
import hades.gui.LayerTable;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import jfig.gui.ImageHelper;
import jfig.objects.FigAttribs;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class EditFrame
extends Frame
implements EditorMenuInteraction {
    private Editor editor = null;
    private Menu fileMenu;
    private Menu editMenu;
    private Menu windowMenu;
    private Menu signalsMenu;
    private Menu exportMenu;
    private Menu vhdlMenu;
    private Menu layersMenu;
    private Menu selectSnapMenu;
    private Menu selectGridMenu;
    private Menu selectUnitsMenu;
    private Menu selectRepaintFpsMenu;
    private Menu specialMenu;
    private Menu debugMenu;
    private Menu helpMenu;
    private Menu demoDesignsMenu;
    private MenuItem fileNewMI;
    private MenuItem fileOpenMI;
    private MenuItem fileSaveMI;
    private MenuItem fileSaveAsMI;
    private MenuItem fileCloseMI;
    private MenuItem fileExitMI;
    private MenuItem filePrintMI;
    private MenuItem fileSaveConfigMI;
    private MenuItem fileCloneMI;
    private MenuItem cancelMI;
    private MenuItem undoMI;
    private MenuItem redoMI;
    private MenuItem deleteAllMI;
    private MenuItem setDesignNameMI;
    private MenuItem createSymbolMI;
    private MenuItem createThumbnailMI;
    private MenuItem moveToPositiveQuadrantMI;
    private MenuItem autoconnectMI;
    private MenuItem disconnectMI;
    private MenuItem mirrorXMI;
    private MenuItem mirrorYMI;
    private MenuItem rebuildObjectListMI;
    private MenuItem redrawMI;
    private MenuItem flushSymbolCacheMI;
    private MenuItem selectMI;
    private MenuItem selectAllMI;
    private MenuItem selectRegionMI;
    private MenuItem deselectAllMI;
    private MenuItem deleteSelectionMI;
    private MenuItem moveSelectionMI;
    private MenuItem copySelectionMI;
    private MenuItem zoomRegionMI;
    private MenuItem zoomInMI;
    private MenuItem zoomOutMI;
    private MenuItem zoomFitMI;
    private MenuItem zoom11MI;
    private MenuItem zoomOut09MI;
    private MenuItem zoomIn11MI;
    private MenuItem zoomA4MI;
    private MenuItem noGridMI;
    private MenuItem coarseGridMI;
    private MenuItem mediumGridMI;
    private MenuItem fineGridMI;
    private MenuItem unitsInchMI;
    private MenuItem unitsMmMI;
    private MenuItem unitsXmmMI;
    private MenuItem noSnapMI;
    private MenuItem coarseSnapMI;
    private MenuItem mediumSnapMI;
    private MenuItem fineSnapMI;
    private MenuItem tinySnapMI;
    private MenuItem redraw40fpsMI;
    private MenuItem redraw20fpsMI;
    private MenuItem redraw10fpsMI;
    private MenuItem redraw3fpsMI;
    private MenuItem redraw1fpsMI;
    private MenuItem redraw01fpsMI;
    private MenuItem redrawDefaultMI;
    private MenuItem redrawNoneMI;
    private MenuItem displayAllMI;
    private MenuItem displayNoneMI;
    private MenuItem initSignalsWithZeroMI;
    private MenuItem initSignalsWithOneMI;
    private MenuItem initSignalsWithUMI;
    private MenuItem initSignalsRandomlyMI;
    private MenuItem addProbesToAllSignalsMI;
    private MenuItem addProbesToToplevelIOMI;
    private MenuItem addProbesToToplevelSignalsMI;
    private MenuItem removeProbesAllSignalsMI;
    private MenuItem removeProbesToplevelMI;
    private MenuItem removeProbesToplevelIOMI;
    private MenuItem showWavesMI;
    private MenuItem clearWavesMI;
    private MenuItem exportPSMenuItem;
    private MenuItem exportFig2devMenuItem;
    private MenuItem exportGIFMenuItem;
    private MenuItem exportSettingsMenuItem;
    private MenuItem exportFileNameMenuItem;
    private MenuItem vhdlOptionsMI;
    private MenuItem vhdlExportMI;
    private MenuItem checkDesignMI;
    private MenuItem checkDesignAndHighlightErrorsMI;
    private MenuItem removeHighlightMarkersMI;
    private MenuItem memoryInfoMI;
    private MenuItem gcNowMI;
    private MenuItem jvmMemoryMI;
    private MenuItem testTimingMI;
    private CheckboxMenuItem traceEventsMI;
    private CheckboxMenuItem traceSignalsMI;
    private CheckboxMenuItem traceMouseClickMI;
    private CheckboxMenuItem traceSimulatorMI;
    private CheckboxMenuItem traceSimObjectsMI;
    private CheckboxMenuItem editorDebugMI;
    private CheckboxMenuItem traceCanvasMI;
    private CheckboxMenuItem displayInstanceLabelMI;
    private CheckboxMenuItem displayPortLabelMI;
    private CheckboxMenuItem displayInstanceBorderMI;
    private CheckboxMenuItem displayClassLabelMI;
    private CheckboxMenuItem displayPortSymbolsMI;
    private CheckboxMenuItem displayBusPortSymbolsMI;
    private CheckboxMenuItem displayRtlibAnimationMI;
    private CheckboxMenuItem viewModeMI;
    private CheckboxMenuItem glowModeMI;
    private CheckboxMenuItem canvasInverseModeMI;
    private CheckboxMenuItem enableToolTipsMI;
    private CheckboxMenuItem enableAntiAliasMI;
    private CheckboxMenuItem enableRenderQualityMI;
    private CheckboxMenuItem allowSplitSignalsMI;
    private CheckboxMenuItem enableCreateSignalsMI;
    private MenuItem printObjectsMI;
    private MenuItem printAllObjectsMI;
    private MenuItem printSymbolsMI;
    private MenuItem printToplevelSignalsMI;
    private MenuItem printAllSignalsMI;
    private MenuItem showMessagesMI;
    private MenuItem showPropertiesMI;
    private MenuItem jpythonMI;
    private MenuItem callMethodMI;
    private MenuItem printUndoStackMI;
    private MenuItem printEventListMI;
    private MenuItem printEditorTableMI;
    private MenuItem printRedrawStatsMI;
    private MenuItem printSelectionMI;
    private MenuItem helpAboutMI;
    private MenuItem helpWelcomeMI;
    private MenuItem helpContentsMI;
    private MenuItem helpPopupMI;
    private MenuItem helpShortcutsMI;
    private MenuItem helpSimKernelMI;
    private MenuItem helpColors1164MI;
    private MenuItem helpShowChangesMI;
    private MenuItem helpShowMessagesMI;
    private MenuItem helpTipOfTheDayMI;
    private MenuItem helpShowFaqMI;
    static String[][] __demos = new String[0][];

    public EditFrame(Editor parentEditor, String name) {
        super(name);
        this.editor = parentEditor;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.setDefaultFont();
        this.buildMenu();
        this.createMenuShortcuts();
        this.getIcon();
    }

    public Object getUndoMenuItem() {
        return this.undoMI;
    }

    public Object getRedoMenuItem() {
        return this.redoMI;
    }

    public void setEnableCloseWindowMenuItem(boolean b) {
        this.fileCloseMI.setEnabled(b);
    }

    public boolean isViewModeSelected() {
        return this.viewModeMI.getState();
    }

    public boolean isGlowModeSelected() {
        return this.glowModeMI.getState();
    }

    public boolean isRtlibAnimationSelected() {
        return this.displayRtlibAnimationMI.getState();
    }

    public boolean isInverseCanvasSelected() {
        return this.canvasInverseModeMI.getState();
    }

    public boolean isEnableAntialiasSelected() {
        return this.enableAntiAliasMI.getState();
    }

    public boolean isEnableToolTipsSelected() {
        return this.enableToolTipsMI.getState();
    }

    public boolean isRenderQualitySelected() {
        return this.enableRenderQualityMI.getState();
    }

    public boolean isEnableSplitSignalsSelected() {
        return this.allowSplitSignalsMI.getState();
    }

    public boolean isEnableCreateSignalsSelected() {
        return this.enableCreateSignalsMI.getState();
    }

    public void setViewModeSelected(boolean b) {
        this.viewModeMI.setState(b);
    }

    public void setGlowModeSelected(boolean b) {
        this.glowModeMI.setState(b);
    }

    public void setRtlibAnimationSelected(boolean b) {
        this.displayRtlibAnimationMI.setState(b);
    }

    public void setInverseCanvasSelected(boolean b) {
        this.canvasInverseModeMI.setState(b);
    }

    public void setEnableAntialiasSelected(boolean b) {
        this.enableAntiAliasMI.setState(b);
    }

    public void setRenderQualitySelected(boolean b) {
        this.enableRenderQualityMI.setState(b);
    }

    public void setEnableToolTipsSelected(boolean b) {
        this.enableToolTipsMI.setState(b);
    }

    public void setEnableSplitSignalsSelected(boolean b) {
        this.allowSplitSignalsMI.setState(b);
    }

    public void setEnableCreateSignalsSelected(boolean b) {
        this.enableCreateSignalsMI.setState(b);
    }

    public void updateLayerMenuItems(Object arg) {
        if (arg instanceof LayerTable) {
            LayerTable lt = (LayerTable)arg;
            this._update(this.displayInstanceLabelMI, lt.getVisibility("hades.symbols.InstanceLabel"));
            this._update(this.displayClassLabelMI, lt.getVisibility("hades.symbols.ClassLabel"));
            this._update(this.displayPortLabelMI, lt.getVisibility("hades.symbols.PortLabel"));
            this._update(this.displayPortSymbolsMI, lt.getVisibility("hades.symbols.PortSymbol"));
            this._update(this.displayBusPortSymbolsMI, lt.getVisibility("hades.symbols.BusPortSymbol"));
            this._update(this.displayInstanceBorderMI, lt.getVisibility("hades.symbols.BboxRectangle"));
        } else {
            this.message("-E- EditFrame.updateLayerMenuItems: unknown argument: " + arg);
        }
    }

    private void _update(CheckboxMenuItem cbmi, boolean state) {
        cbmi.removeItemListener(this.editor);
        cbmi.setState(state);
        cbmi.addItemListener(this.editor);
    }

    public void saveRecentFilesList(String filename) {
        if (Editor.getDebug()) {
            Editor.msg("-W- EditFrame: saveRecentFilesList not implemented!");
        }
    }

    public void addRecentFile(String filename) {
        if (Editor.getDebug()) {
            Editor.msg("-W- EditFrame: addRecentFile not implemented!");
        }
    }

    public String getRecentFile(int i) {
        if (Editor.getDebug()) {
            Editor.msg("-W- EditFrame: getRecentFile not implemented!");
        }
        return null;
    }

    private void setDefaultFont() {
        String name = SetupManager.getProperty("Hades.Editor.MenuFontName", "SansSerif");
        int size = SetupManager.getInteger("Hades.Editor.MenuFontSize", 12);
        int style = 0;
        this.setFont(new Font(name, style, size));
    }

    public void message(String msg) {
        System.err.println(msg);
    }

    public MenuItem CMI(String label, String callback) {
        return this.CMI(label, callback, "");
    }

    public MenuItem CMI(String label, String callback, String arg) {
        MenuItem tmp = new MenuItem(label);
        tmp.addActionListener(this.editor);
        this.editor.addCallback(label, callback, arg);
        return tmp;
    }

    public CheckboxMenuItem CBM(String label, String callback, boolean b) {
        CheckboxMenuItem cbmi = new CheckboxMenuItem(label);
        cbmi.setState(b);
        if (this.editor != null) {
            cbmi.addItemListener(this.editor);
            this.editor.addCallback(cbmi, callback, cbmi);
        }
        return cbmi;
    }

    public void buildMenu() {
        this.fileMenu = new Menu("File");
        this.fileNewMI = this.CMI("New", "doStartNewDesign");
        this.fileOpenMI = this.CMI("Open...", "doOpenFile");
        this.fileSaveMI = this.CMI("Save", "doSaveFile");
        this.fileSaveAsMI = this.CMI("SaveAs...", "doSaveFileAs");
        this.fileSaveConfigMI = this.CMI("Save configuration...", "doSaveConfiguration");
        this.filePrintMI = this.CMI("Print", "doPrintDesign");
        this.fileCloneMI = this.CMI("Create new window", "doCreateNewEmptyEditor");
        this.fileCloseMI = this.CMI("Close", "doClose");
        this.fileExitMI = this.CMI("Exit", "doExit");
        this.filePrintMI.setEnabled(true);
        this.fileMenu.add(this.fileNewMI);
        this.fileMenu.add(this.fileOpenMI);
        this.fileMenu.add(this.fileSaveMI);
        this.fileMenu.add(this.fileSaveAsMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.fileSaveConfigMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.filePrintMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.fileCloneMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.fileCloseMI);
        this.fileMenu.add(this.fileExitMI);
        this.editMenu = new Menu("Edit");
        this.cancelMI = this.CMI("Cancel", "doCancel");
        this.undoMI = new MenuItem("Undo");
        this.redoMI = new MenuItem("Redo");
        this.editor.addCallback(this.undoMI, "doUndo", "");
        this.editor.addCallback(this.redoMI, "doRedo", "");
        this.undoMI.addActionListener(this.editor);
        this.redoMI.addActionListener(this.editor);
        this.selectMI = this.CMI("Select object (toggle)", "doSelectObject");
        this.selectAllMI = this.CMI("Select all objects", "doSelectAllObjects");
        this.selectRegionMI = this.CMI("Select region", "doSelectRegion");
        this.deselectAllMI = this.CMI("Deselect all objects", "doDeselectAllObjects");
        this.deleteSelectionMI = this.CMI("Delete selection", "doDeleteSelection");
        this.moveSelectionMI = this.CMI("Move selection", "doMoveSelection");
        this.copySelectionMI = this.CMI("Copy selection", "doCopySelection");
        this.redrawMI = this.CMI("Redraw [all]", "doRedraw");
        this.setDesignNameMI = this.CMI("Set design name...", "doSetDesignName");
        this.createSymbolMI = this.CMI("Create symbol", "doCreateSymbol");
        this.createThumbnailMI = this.CMI("Create thumbnail", "doCreateShowThumbnail");
        this.autoconnectMI = this.CMI("Autoconnect object...", "doAutoconnect");
        this.disconnectMI = this.CMI("Disconnect object...", "doDisconnect");
        this.mirrorXMI = this.CMI("Mirror object (x-axis)", "doMirrorXObject");
        this.mirrorYMI = this.CMI("Mirror object (y-axis)", "doMirrorYObject");
        this.showWavesMI = this.CMI("Show Waves...", "doShowWaves");
        this.clearWavesMI = this.CMI("Clear Waves...", "doClearWaveData");
        this.deleteAllMI = this.CMI("Delete All", "doDeleteAll");
        this.rebuildObjectListMI = this.CMI("Rebuild object list", "doRebuildObjectList");
        this.moveToPositiveQuadrantMI = this.CMI("Move/fit design to positive quadrant", "doFitPositive");
        this.editMenu.add(this.cancelMI);
        this.editMenu.add(this.undoMI);
        this.editMenu.add(this.redoMI);
        this.editMenu.addSeparator();
        if (SetupManager.getBoolean("Hades.Editor.EnableSelectionMenu", false)) {
            this.editMenu.add(this.selectMI);
            this.editMenu.add(this.selectRegionMI);
            this.editMenu.add(this.selectAllMI);
            this.editMenu.add(this.deselectAllMI);
            this.editMenu.addSeparator();
            this.editMenu.add(this.moveSelectionMI);
            this.editMenu.add(this.copySelectionMI);
            this.editMenu.add(this.deleteSelectionMI);
            this.editMenu.addSeparator();
        }
        this.editMenu.add(this.setDesignNameMI);
        this.editMenu.add(this.createSymbolMI);
        this.editMenu.add(this.createThumbnailMI);
        this.editMenu.addSeparator();
        this.editMenu.add(this.autoconnectMI);
        this.editMenu.add(this.disconnectMI);
        this.editMenu.add(this.mirrorXMI);
        this.editMenu.add(this.mirrorYMI);
        this.editMenu.addSeparator();
        this.editMenu.add(this.moveToPositiveQuadrantMI);
        this.editMenu.add(this.rebuildObjectListMI);
        this.editMenu.add(this.redrawMI);
        this.editMenu.addSeparator();
        this.editMenu.add(this.deleteAllMI);
        this.windowMenu = new Menu("Window");
        this.zoomRegionMI = this.CMI("Zoom Region ", "doZoomRegion");
        this.zoomInMI = this.CMI("Zoom In   1.4", "doZoomIn14");
        this.zoomIn11MI = this.CMI("Zoom In   1.1", "doZoomIn11");
        this.zoomOut09MI = this.CMI("Zoom Out  0.9", "doZoomOut09");
        this.zoomOutMI = this.CMI("Zoom Out  0.7", "doZoomOut07");
        this.zoomFitMI = this.CMI("Zoom Fit ", "doZoomFit");
        this.zoom11MI = this.CMI("Zoom 1:1 ", "doZoom11");
        this.zoomA4MI = this.CMI("Zoom A4 paper", "doZoomLandscapeA4");
        this.selectSnapMenu = new Menu("Magnetic grid...");
        this.coarseSnapMI = this.CMI("1/2 inch", "doSetCoarseSnap");
        this.mediumSnapMI = this.CMI("1/4 inch", "doSetMediumSnap");
        this.fineSnapMI = this.CMI("1/8 inch", "doSetFineSnap");
        this.tinySnapMI = this.CMI("1/16 inch", "doSetTinySnap");
        this.noSnapMI = this.CMI("any position", "doSetNoSnap");
        this.selectSnapMenu.add(this.coarseSnapMI);
        this.selectSnapMenu.add(this.mediumSnapMI);
        this.selectSnapMenu.add(this.fineSnapMI);
        this.selectSnapMenu.add(this.tinySnapMI);
        this.selectSnapMenu.add(this.noSnapMI);
        this.selectGridMenu = new Menu("Select Grid...");
        this.noGridMI = this.CMI("no grid", "doSetNoGrid");
        this.coarseGridMI = this.CMI("coarse grid", "doSetCoarseGrid");
        this.mediumGridMI = this.CMI("medium grid", "doSetMediumGrid");
        this.fineGridMI = this.CMI("fine grid", "doSetFineGrid");
        this.selectGridMenu.add(this.noGridMI);
        this.selectGridMenu.add(this.coarseGridMI);
        this.selectGridMenu.add(this.mediumGridMI);
        this.selectGridMenu.add(this.fineGridMI);
        this.selectUnitsMenu = new Menu("Select Units...");
        this.unitsInchMI = this.CMI("inches", "doNothing");
        this.unitsMmMI = this.CMI("mm", "doNothing");
        this.unitsXmmMI = this.CMI("xmm", "doNothing");
        this.selectUnitsMenu.add(this.unitsInchMI);
        this.selectUnitsMenu.add(this.unitsMmMI);
        this.selectUnitsMenu.add(this.unitsXmmMI);
        this.unitsMmMI.setEnabled(false);
        this.unitsXmmMI.setEnabled(false);
        this.selectRepaintFpsMenu = new Menu("Select Repaint frequency...");
        this.redrawDefaultMI = this.CMI("configuration default", "doSetFramerate", "-1");
        this.redraw40fpsMI = this.CMI(" 40 frames/sec.", "doSetFramerate", "40");
        this.redraw20fpsMI = this.CMI(" 20 frames/sec.", "doSetFramerate", "20");
        this.redraw10fpsMI = this.CMI(" 10 frames/sec.", "doSetFramerate", "10");
        this.redraw3fpsMI = this.CMI("  3 frames/sec.", "doSetFramerate", "3");
        this.redraw1fpsMI = this.CMI("  1 frame/sec.", "doSetFramerate", "1");
        this.redraw01fpsMI = this.CMI("0.1 frame/sec.", "doSetFramerate", "0.1");
        this.redrawNoneMI = this.CMI("stop sync. redraw", "doSetFramerate", "0");
        this.selectRepaintFpsMenu.add(this.redrawDefaultMI);
        this.selectRepaintFpsMenu.addSeparator();
        this.selectRepaintFpsMenu.add(this.redraw40fpsMI);
        this.selectRepaintFpsMenu.add(this.redraw20fpsMI);
        this.selectRepaintFpsMenu.add(this.redraw10fpsMI);
        this.selectRepaintFpsMenu.add(this.redraw3fpsMI);
        this.selectRepaintFpsMenu.add(this.redraw1fpsMI);
        this.selectRepaintFpsMenu.add(this.redraw01fpsMI);
        this.selectRepaintFpsMenu.addSeparator();
        this.selectRepaintFpsMenu.add(this.redrawNoneMI);
        this.windowMenu.add(this.zoomRegionMI);
        this.windowMenu.add(this.zoomInMI);
        this.windowMenu.add(this.zoomIn11MI);
        this.windowMenu.add(this.zoomOut09MI);
        this.windowMenu.add(this.zoomOutMI);
        this.windowMenu.add(this.zoomFitMI);
        this.windowMenu.add(this.zoom11MI);
        this.windowMenu.add(this.zoomA4MI);
        this.windowMenu.addSeparator();
        this.windowMenu.add(this.selectSnapMenu);
        this.windowMenu.add(this.selectGridMenu);
        this.windowMenu.add(this.selectUnitsMenu);
        this.windowMenu.addSeparator();
        this.windowMenu.add(this.selectRepaintFpsMenu);
        this.signalsMenu = new Menu("Signals");
        Menu initSignalsMenu = new Menu("Initialize all Signals...");
        this.initSignalsWithZeroMI = this.CMI("value '0'", "doInitSignals", "0");
        this.initSignalsWithOneMI = this.CMI("value '1'", "doInitSignals", "1");
        this.initSignalsWithUMI = this.CMI("value 'U'", "doInitSignals", "2");
        this.initSignalsRandomlyMI = this.CMI("random '0/1' values", "doInitSignals", "-1");
        initSignalsMenu.add(this.initSignalsWithZeroMI);
        initSignalsMenu.add(this.initSignalsWithOneMI);
        initSignalsMenu.add(this.initSignalsWithUMI);
        initSignalsMenu.add(this.initSignalsRandomlyMI);
        initSignalsMenu.setEnabled(SetupManager.getBoolean("Hades.Editor.EnableInitializeSignalsMenu", false));
        Menu addProbesMenu = new Menu("Add probes...");
        this.addProbesToAllSignalsMI = this.CMI("all signals ", "addProbesToAllSignals");
        this.addProbesToToplevelSignalsMI = this.CMI("toplevel signals ", "addProbesToToplevelSignals");
        this.addProbesToToplevelIOMI = this.CMI("toplevel I/O ", "addProbesToToplevelIO");
        addProbesMenu.add(this.addProbesToAllSignalsMI);
        addProbesMenu.add(this.addProbesToToplevelSignalsMI);
        addProbesMenu.add(this.addProbesToToplevelIOMI);
        Menu removeProbesMenu = new Menu("Remove probes...");
        this.removeProbesAllSignalsMI = this.CMI("all signals", "removeProbesFromAllSignals");
        this.removeProbesToplevelMI = this.CMI("toplevel signals", "removeProbesFromToplevelSignals");
        this.removeProbesToplevelIOMI = this.CMI("toplevel I/O", "removeProbesFromToplevelIO");
        removeProbesMenu.add(this.removeProbesAllSignalsMI);
        removeProbesMenu.add(this.removeProbesToplevelMI);
        removeProbesMenu.add(this.removeProbesToplevelIOMI);
        this.signalsMenu.add(initSignalsMenu);
        this.signalsMenu.addSeparator();
        this.signalsMenu.add(addProbesMenu);
        this.signalsMenu.add(removeProbesMenu);
        this.signalsMenu.addSeparator();
        this.signalsMenu.add(this.showWavesMI);
        this.signalsMenu.add(this.clearWavesMI);
        this.exportMenu = new Menu("Export");
        this.exportPSMenuItem = this.CMI("Postscript...", "doExportPostscript");
        this.exportFig2devMenuItem = this.CMI("Fig2dev...", "doExportFig2dev");
        this.exportGIFMenuItem = this.CMI("GIF...", "doExportGIF");
        this.exportSettingsMenuItem = this.CMI("Settings...", "doShowExportOptions");
        this.exportFileNameMenuItem = this.CMI("Select filename...", "doSelectExportFilename");
        this.exportMenu.add(this.exportPSMenuItem);
        this.exportMenu.add(this.exportFig2devMenuItem);
        this.exportMenu.add(this.exportGIFMenuItem);
        this.exportMenu.add(new MenuItem("-"));
        this.exportMenu.add(new MenuItem("-"));
        this.exportMenu.add(this.exportSettingsMenuItem);
        this.exportMenu.add(this.exportFileNameMenuItem);
        this.vhdlMenu = new Menu("VHDL");
        this.vhdlOptionsMI = this.CMI("VHDL Options...", "doSelectVHDLOptions");
        this.vhdlExportMI = this.CMI("Export VHDL", "doExportVHDL");
        this.vhdlMenu.add(this.vhdlOptionsMI);
        this.vhdlMenu.add(this.vhdlExportMI);
        this.layersMenu = new Menu("Display");
        this.displayInstanceLabelMI = this.CBM("instance labels", "doShowInstanceLabels", true);
        this.displayClassLabelMI = this.CBM("class labels", "doShowClassLabels", true);
        this.displayPortLabelMI = this.CBM("port labels", "doShowPortLabels", true);
        this.displayPortSymbolsMI = this.CBM("port symbols", "doShowPortSymbols", true);
        this.displayBusPortSymbolsMI = this.CBM("bus port symbols", "doShowBusPortSymbols", true);
        this.displayInstanceBorderMI = this.CBM("instance border", "doShowInstanceBorder", true);
        this.displayRtlibAnimationMI = this.CBM("rtlib animation", "doShowRtlibAnimation", true);
        this.displayAllMI = this.CMI("all of the above layers", "doShowAllLayers", "");
        this.displayNoneMI = this.CMI("none of the above layers", "doShowNoLayers", "");
        this.setMIState(this.displayInstanceLabelMI, "Hades.LayerTable.DisplayInstanceLabels", true);
        this.setMIState(this.displayClassLabelMI, "Hades.LayerTable.DisplayClassLabels", true);
        this.setMIState(this.displayPortLabelMI, "Hades.LayerTable.DisplayPortLabels", true);
        this.setMIState(this.displayPortSymbolsMI, "Hades.LayerTable.DisplayPortSymbols", true);
        this.setMIState(this.displayBusPortSymbolsMI, "Hades.LayerTable.DisplayBusPortSymbols", true);
        this.setMIState(this.displayInstanceBorderMI, "Hades.LayerTable.DisplayInstanceBorder", true);
        this.setMIState(this.displayRtlibAnimationMI, "Hades.LayerTable.RtlibAnimation", false);
        this.viewModeMI = this.CBM("view mode", "doShowViewMode", true);
        this.setMIState(this.viewModeMI, "Hades.Editor.ViewMode", false);
        this.glowModeMI = this.CBM("glow mode", "doShowGlowMode", true);
        this.setMIState(this.glowModeMI, "Hades.Editor.GlowMode", true);
        this.canvasInverseModeMI = this.CBM("inverse canvas", "doShowInverseCanvas", false);
        this.setMIState(this.canvasInverseModeMI, "Hades.Editor.InverseCanvas", false);
        this.enableAntiAliasMI = this.CBM("Java2D antialiasing", "doEnableJava2DAntiAliasing", false);
        this.enableAntiAliasMI.setEnabled(FigAttribs.enableJava2D);
        this.setMIState(this.enableAntiAliasMI, "Hades.Editor.AntiAlias", false);
        this.enableRenderQualityMI = this.CBM("Java2D render quality", "doEnableJava2DRenderQuality", false);
        this.enableRenderQualityMI.setEnabled(FigAttribs.enableJava2D);
        this.setMIState(this.enableRenderQualityMI, "Hades.Editor.RenderQuality", false);
        this.enableToolTipsMI = this.CBM("enable tool-tips", "doShowToolTips", true);
        this.setMIState(this.enableToolTipsMI, "Hades.Editor.EnableToolTips", true);
        this.layersMenu.add("Show (layers):");
        this.layersMenu.add(this.displayClassLabelMI);
        this.layersMenu.add(this.displayPortLabelMI);
        this.layersMenu.add(this.displayPortSymbolsMI);
        this.layersMenu.add(this.displayBusPortSymbolsMI);
        this.layersMenu.add(this.displayInstanceLabelMI);
        this.layersMenu.add(this.displayInstanceBorderMI);
        this.layersMenu.addSeparator();
        this.layersMenu.add(this.displayAllMI);
        this.layersMenu.add(this.displayNoneMI);
        this.layersMenu.addSeparator();
        this.layersMenu.add(this.viewModeMI);
        this.layersMenu.add(this.glowModeMI);
        this.layersMenu.add(this.displayRtlibAnimationMI);
        this.layersMenu.add(this.canvasInverseModeMI);
        this.layersMenu.add(this.enableAntiAliasMI);
        this.layersMenu.add(this.enableRenderQualityMI);
        this.layersMenu.addSeparator();
        this.layersMenu.add(this.enableToolTipsMI);
        this.specialMenu = new Menu("Special");
        this.showMessagesMI = this.CMI("Show messages... ", "doShowMessages");
        this.showPropertiesMI = this.CMI("Show properties...", "doShowProperties");
        this.jpythonMI = this.CMI("Open JPython shell...", "doCreateJythonConsole");
        this.callMethodMI = this.CMI("Call a method...", "doCallMethod");
        this.checkDesignMI = this.CMI("Check design", "doCheckDesign");
        this.checkDesignAndHighlightErrorsMI = this.CMI("Check design and highlight errors", "doCheckDesignAndHighlightErrors");
        this.removeHighlightMarkersMI = this.CMI("Remove highlight markers", "removeHighlightMarkers");
        this.flushSymbolCacheMI = this.CMI("Flush symbol cache", "doFlushSymbolCache");
        this.allowSplitSignalsMI = this.CBM("Allow Split Signals", "doEnableSplitSignals", true);
        this.enableCreateSignalsMI = this.CBM("Enable Create Signals", "doEnableCreateSignals", true);
        this.enableCreateSignalsMI.setState(true);
        this.jvmMemoryMI = this.CMI("JVM memory management:", "doNothing");
        this.gcNowMI = this.CMI("Garbage collect now", "doGarbageCollect");
        this.memoryInfoMI = this.CMI("Memory usage...", "doShowMemoryInfo");
        this.testTimingMI = this.CMI("Performance statistics...", "doTestTiming");
        this.specialMenu.add(this.showMessagesMI);
        this.specialMenu.add(this.showPropertiesMI);
        this.specialMenu.add(this.jpythonMI);
        this.specialMenu.add(this.callMethodMI);
        this.specialMenu.addSeparator();
        this.specialMenu.add(this.checkDesignMI);
        this.specialMenu.add(this.checkDesignAndHighlightErrorsMI);
        this.specialMenu.add(this.removeHighlightMarkersMI);
        this.specialMenu.add(this.flushSymbolCacheMI);
        this.specialMenu.addSeparator();
        this.specialMenu.add(this.allowSplitSignalsMI);
        this.specialMenu.add(this.enableCreateSignalsMI);
        this.specialMenu.addSeparator();
        this.specialMenu.add(this.jvmMemoryMI);
        this.specialMenu.add(this.memoryInfoMI);
        this.specialMenu.add(this.gcNowMI);
        this.specialMenu.addSeparator();
        this.specialMenu.add(this.testTimingMI);
        this.debugMenu = new Menu("Debug");
        this.printObjectsMI = this.CMI("Print toplevel objects...", "doPrintObjects");
        this.printAllObjectsMI = this.CMI("Print all objects...", "doPrintAllObjects");
        this.printToplevelSignalsMI = this.CMI("Print toplevel signals...", "doPrintToplevelSignals");
        this.printAllSignalsMI = this.CMI("Print all signals...", "doPrintAllSignals");
        this.printSymbolsMI = this.CMI("Print symbols...", "doPrintSymbols");
        this.printUndoStackMI = this.CMI("Print undoStack...", "doPrintUndoStack");
        this.printEventListMI = this.CMI("Print EventList...", "doPrintEventList");
        this.printEditorTableMI = this.CMI("Print editorTable...", "doPrintEditorTable");
        this.printRedrawStatsMI = this.CMI("Print redraw timing...", "doPrintRedrawStats");
        this.printSelectionMI = this.CMI("Print Selection...", "printSelection");
        this.traceEventsMI = this.CBM("Trace Events...", "doTraceEvents", false);
        this.traceSignalsMI = this.CBM("Trace Signals...", "doTraceSignals", false);
        this.traceSimObjectsMI = this.CBM("Trace SimObjects...", "doTraceSimObjects", false);
        this.traceMouseClickMI = this.CBM("Trace MouseClicks...", "doTraceMouseClicks", false);
        this.traceSimulatorMI = this.CBM("Trace Sim.Kernel...", "doTraceSimKernel", false);
        this.traceCanvasMI = this.CBM("Trace Canvas...", "doTraceCanvas", false);
        this.editorDebugMI = this.CBM("Editor Debug...", "doToggleEditorDebug", false);
        this.debugMenu.add(this.printObjectsMI);
        this.debugMenu.add(this.printAllObjectsMI);
        this.debugMenu.add(this.printToplevelSignalsMI);
        this.debugMenu.add(this.printAllSignalsMI);
        this.debugMenu.add(this.printSymbolsMI);
        this.debugMenu.add(this.printUndoStackMI);
        this.debugMenu.add(this.printEventListMI);
        this.debugMenu.add(this.printEditorTableMI);
        this.debugMenu.add(this.printRedrawStatsMI);
        this.debugMenu.add(this.printSelectionMI);
        this.debugMenu.addSeparator();
        this.debugMenu.add(this.traceEventsMI);
        this.debugMenu.add(this.traceSignalsMI);
        this.debugMenu.add(this.traceSimObjectsMI);
        this.debugMenu.add(this.traceSimulatorMI);
        this.debugMenu.add(this.traceMouseClickMI);
        this.debugMenu.add(this.traceCanvasMI);
        this.debugMenu.addSeparator();
        this.debugMenu.add(this.editorDebugMI);
        this.helpMenu = new Menu("Help");
        this.helpAboutMI = this.CMI("About...", "doShowAbout");
        this.helpShowChangesMI = this.CMI("Changes...", "doShowChanges");
        this.helpShowFaqMI = this.CMI("FAQ...", "doShowFAQ");
        this.helpTipOfTheDayMI = this.CMI("Show tip of the day", "doShowTipOfTheDay");
        this.helpShowMessagesMI = this.CMI("Show messages...", "doShowMessages");
        this.helpWelcomeMI = this.CMI("Tutorial welcome", "showHelp", "/hades/examples/tutorial/welcome.hds");
        this.helpContentsMI = this.CMI("Tutorial contents", "showHelp", "/hades/examples/tutorial/contents.hds");
        this.helpPopupMI = this.CMI("Using the popup-menu", "showHelp", "/hades/examples/tutorial/popup.hds");
        this.helpShortcutsMI = this.CMI("Using shortcut keys", "showHelp", "/hades/examples/tutorial/bindkeys.hds");
        this.helpSimKernelMI = this.CMI("Controlling the simulator", "showHelp", "/hades/examples/tutorial/simcontrol.hds");
        this.helpColors1164MI = this.CMI("Colors (StdLogic1164)", "showHelp", "/hades/examples/tutorial/colors1164.hds");
        this.createDemoDesignsMenu();
        this.helpMenu.add(this.helpAboutMI);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.helpWelcomeMI);
        this.helpMenu.add(this.helpContentsMI);
        this.helpMenu.add(this.helpPopupMI);
        this.helpMenu.add(this.helpSimKernelMI);
        this.helpMenu.add(this.helpShortcutsMI);
        this.helpMenu.add(this.helpColors1164MI);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.demoDesignsMenu);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.helpShowChangesMI);
        this.helpMenu.add(this.helpShowFaqMI);
        this.helpMenu.add(this.helpTipOfTheDayMI);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.helpShowMessagesMI);
        MenuBar mb = new MenuBar();
        mb.add(this.fileMenu);
        mb.add(this.editMenu);
        mb.add(this.windowMenu);
        mb.add(this.layersMenu);
        mb.add(this.signalsMenu);
        mb.add(this.exportMenu);
        if (SetupManager.getBoolean("Hades.Editor.EnableVHDLMenu", false)) {
            mb.add(this.vhdlMenu);
        }
        mb.add(this.specialMenu);
        if (SetupManager.getBoolean("Hades.Editor.EnableDebugMenu", false)) {
            mb.add(this.debugMenu);
        }
        mb.add(this.helpMenu);
        mb.setHelpMenu(this.helpMenu);
        if (!this.editor.isViewMode()) {
            this.setMenuBar(mb);
        }
    }

    public void createDemoDesignsMenu() {
        this.demoDesignsMenu = new Menu("demos...");
        int i = 0;
        while (i < __demos.length) {
            MenuItem mi = this.CMI(__demos[i][0], "doOpenDesign", __demos[i][1]);
            this.demoDesignsMenu.add(mi);
            ++i;
        }
    }

    public void createMenuShortcuts() {
        this.SC(this.fileNewMI, 78, false);
        this.SC(this.fileOpenMI, 70, false);
        this.SC(this.fileSaveMI, 83, false);
        this.SC(this.filePrintMI, 80, false);
        this.SC(this.fileCloseMI, 81, true);
        this.SC(this.fileExitMI, 81, false);
        this.SC(this.redrawMI, 65, false);
        this.SC(this.cancelMI, 27, false);
        this.SC(this.undoMI, 85, false);
        this.SC(this.redoMI, 82, false);
        this.SC(this.showMessagesMI, 77, false);
        this.SC(this.zoomRegionMI, 87, false);
        this.SC(this.zoomInMI, 90, false);
        this.SC(this.zoomOutMI, 89, false);
        this.SC(this.zoomFitMI, 69, false);
        this.SC(this.zoom11MI, 49, false);
        this.SC(this.noGridMI, 84, false);
        this.SC(this.mediumGridMI, 71, false);
        this.SC(this.noSnapMI, 48, false);
        this.SC(this.coarseSnapMI, 50, false);
        this.SC(this.mediumSnapMI, 52, false);
        this.SC(this.fineSnapMI, 56, false);
        this.SC(this.tinySnapMI, 54, false);
    }

    private void SC(MenuItem MI, int value, boolean shifted) {
        MI.setShortcut(new MenuShortcut(value, shifted));
    }

    public void addMenuActionListener(ActionListener AL) {
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                if (fields[i].get(this) instanceof MenuItem) {
                    ((MenuItem)fields[i].get(this)).addActionListener(AL);
                }
                ++i;
            }
            if (AL instanceof Editor) {
                this.displayAllMI.removeActionListener(AL);
                this.displayNoneMI.removeActionListener(AL);
                this.jvmMemoryMI.removeActionListener(AL);
                this.exportSettingsMenuItem.removeActionListener(AL);
                this.exportFileNameMenuItem.removeActionListener(AL);
            }
        }
        catch (Exception e) {
            ExceptionTracer.message("-E- EditFrame: " + e);
            ExceptionTracer.trace(e);
        }
    }

    public void setMIState(CheckboxMenuItem MI, String name, boolean b) {
        MI.setState(SetupManager.getBoolean(name, b));
    }

    public void getIcon() {
        try {
            String filename = SetupManager.getProperty("Hades.Editor.Icon", "/hades/gui/images/hades.gif");
            Image icon = ImageHelper.loadResourceImage(filename);
            this.setIconImage(icon);
        }
        catch (Exception e) {
            System.err.println("-E- EditFrame.getIcon: " + e);
        }
    }
}

