/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.simulator.SimObject;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;

public class EditCommand
extends Command {
    Point oldPos;
    Point newPos;
    SimObject target;
    ObjectCanvas canvas;

    public EditCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
        this.oldPos = null;
        this.newPos = null;
    }

    public void execute() {
        this.target.configure();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        this.canvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.oldPos = new Point(WP);
        this.target = this.editor.findSimObject(this.oldPos);
        if (this.target == null) {
            this.statusMessage("No object at that position. Please click directly at the objects corner");
            this.oldPos = null;
            return;
        }
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "EditCommand with target: " + this.target;
    }

    public String getDescription() {
        return "Edit command";
    }

    static {
        Command.versionString = "HADES EditCommand 0.01 (04.06.97)";
    }
}

