/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;

public class DisconnectCommand
extends Command {
    Point oldPos;
    Symbol symbol;
    SimObject target;
    ObjectCanvas canvas;

    public DisconnectCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.statusMessage("Please click on the SimObject to disconnect:");
        this.ready = false;
        this.oldPos = null;
    }

    public void execute() {
        if (this.target != null) {
            Port[] ports = this.target.getPorts();
            int i = 0;
            while (i < ports.length) {
                Signal signal = ports[i].getSignal();
                if (signal != null) {
                    signal.disconnect(ports[i]);
                }
                ++i;
            }
        }
        this.statusMessage("Ready. Please select a command.");
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    public void undo() {
        this.message("-W- Cannot undo an DisConnect command. Workaround: ");
        this.message("    Copy the object, then delete the original. ");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.symbol = this.editor.findSymbol(WP);
        if (this.symbol == null) {
            this.message("-W- Disconnect: No object at that position! ");
            this.statusMessage("Disconnect: please click directly on the object");
            this.ready = false;
            return;
        }
        this.target = this.symbol.getParent();
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "DisconnectCommand at: " + this.oldPos + " target: " + this.target;
    }

    public String getDescription() {
        return "autoconnect object";
    }

    static {
        Command.versionString = "HADES DisconnectCommand 0.1 (09.07.98)";
    }
}

