/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import java.awt.Point;
import java.util.Enumeration;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;

public class DeselectAllCommand
extends Command {
    ObjectCanvas canvas;

    public DeselectAllCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = false;
    }

    public void execute() {
        this.editor.getSelection().removeAll();
        Enumeration E = this.editor.getObjectList().elements();
        while (E.hasMoreElements()) {
            FigObject tmp = (FigObject)E.nextElement();
            tmp.deselect();
        }
        this.canvas.doFullRedraw();
        this.statusMessage("Deselected all objects... select a command");
    }

    public void undo() {
        this.message("-E- Cannot undo a 'deselect all' command, because");
        this.message("    all previous selections have been lost!");
        this.message("    Simply select the interesting objects again");
        this.canvas.doFullRedraw();
        this.statusMessage("Cannot undo a deselect all... select a command");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        this.execute();
        this.ready = true;
    }

    public String toString() {
        return "DeselectAllCommand ";
    }

    public String getDescription() {
        return "deselect all";
    }
}

