/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;

public class DeleteSignalCommand
extends Command {
    Object target;
    ObjectCanvas canvas;

    public DeleteSignalCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = true;
    }

    public void execute() {
        Signal signal = (Signal)this.target;
        signal.disconnectAll();
        this.editor.getDesign().deleteSignal(signal);
        this.editor.deleteFromObjectList(signal);
        this.canvas.doFullRedraw();
        this.canvas.setEnablePopup(true);
        this.editor.getUndoStack().push(this);
        this.statusMessage("Please select a command.");
        this.ready = true;
    }

    public void undo() {
        this.editor.getDesign().addSignal((Signal)this.target);
        this.editor.rebuildObjectList(this.editor.getDesign());
        this.canvas.doFullRedraw();
        this.canvas.setEnablePopup(true);
        this.statusMessage("Undo ok. Please select a command.");
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        FigObject tmp = this.editor.findSymbolOrSignal(WP);
        if (tmp == null) {
            tmp = (WireSegment)this.editor.findNearestWireSegment(WP, 200);
            if (tmp == null) {
                this.statusMessage("No signal near that position. Please click directly at a signal vertex");
                this.ready = true;
                return;
            }
            this.target = ((WireSegment)tmp).getSignal();
        } else if (tmp instanceof Signal) {
            this.target = (Signal)((Object)tmp);
        } else if (tmp instanceof WireSegment) {
            this.target = ((WireSegment)tmp).getSignal();
        }
        this.execute();
    }

    public String toString() {
        return "DeleteSignalCommand object=" + this.target;
    }

    public String getDescription() {
        return "delete signal";
    }

    static {
        Command.versionString = "HADES DeleteSignalCommand 0.01 (23.06.97)";
    }
}

