/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.symbols.WireSegment;
import java.awt.Point;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigObject;
import jfig.utils.ExceptionTracer;

public class DeleteSegmentFromSignalCommand
extends Command {
    WireSegment segment;
    Signal signal;
    ObjectCanvas canvas;

    public DeleteSegmentFromSignalCommand(Editor editor) {
        super(editor);
        this.canvas = editor.getObjectCanvas();
        this.ready = true;
    }

    public void execute() {
        ExceptionTracer.message("DWSC: building graph for" + this.signal);
        try {
            this.signal.deleteSegment(this.segment);
            this.signal.createVertexTable();
            this.signal.buildVertexArrays();
            this.signal.buildEdgeVectors();
            this.signal.DFS();
            this.checkDisconnectSegment(this.signal, this.segment);
            int n_splitters = this.signal.countSubgraphs();
            ExceptionTracer.message("DWSC: we have " + n_splitters + " subgraphs...");
            if (n_splitters == 1) {
                this.signal.rebuildSolderDots();
                this.editor.rebuildObjectList(this.editor.getDesign());
            } else {
                Signal[] splitters = this.signal.splitIntoSubgraphs();
                this.editor.getDesign().deleteSignal(this.signal);
                int i = 0;
                while (i < n_splitters) {
                    this.editor.getDesign().addSignal(splitters[i]);
                    ExceptionTracer.message("DWSC: inserted splitter: " + splitters[i]);
                    ++i;
                }
                this.editor.rebuildObjectList(this.editor.getDesign());
            }
        }
        catch (Exception e) {
            System.out.println("-E- in DeleteSegment...execute: " + e);
            e.printStackTrace();
        }
        this.canvas.doFullRedraw();
        this.editor.getUndoStack().push(this);
    }

    private void checkDisconnectSegment(Signal signal, WireSegment segment) {
        Point[] pp = segment.getPoints();
        this.checkDisconnectPoint(pp[0]);
        this.checkDisconnectPoint(pp[1]);
    }

    private void checkDisconnectPoint(Point p) {
        if (this.signal.getVertexTable().containsKey(p)) {
            return;
        }
        Port port = this.editor.findPort(p);
        Port[] senders = this.signal.getSenders();
        int i = 0;
        while (i < senders.length) {
            if (port == senders[i]) {
                this.signal.disconnect(port);
                ExceptionTracer.message("DWSC: disconnecting sender: " + p);
            }
            ++i;
        }
        Port[] receivers = this.signal.getReceivers();
        int i2 = 0;
        while (i2 < receivers.length) {
            if (port == receivers[i2]) {
                this.signal.disconnect(port);
                ExceptionTracer.message("DWSC: disconnecting receiver: " + p);
            }
            ++i2;
        }
    }

    public void undo() {
        this.message("-E- Cannot undo a delete wire segment command yet, sorry!");
        this.editor.rebuildObjectList(this.editor.getDesign());
    }

    public void mousePressed(FigCanvasEvent ME) {
        Point WP = ME.getWorldCoordinatePoint();
        Point SP = ME.getScreenCoordinatePoint();
        this.setPosition(SP, WP);
    }

    public void setPosition(Point SP, Point WP) {
        ExceptionTracer.message("DWSC setPosition()...");
        FigObject tmp = this.editor.findNearestWireSegment(WP, 200);
        if (tmp == null) {
            this.statusMessage("No wire segments at or near that position. ");
            return;
        }
        this.segment = (WireSegment)tmp;
        this.signal = this.segment.getSignal();
        this.execute();
    }

    public String toString() {
        return "DeleteSegmentFromSignalCommand object=" + this.signal;
    }

    public String getDescription() {
        return "delete wire segment";
    }

    static {
        Command.versionString = "HADES DeleteSegmentFromSignalCommand 0.2  (10.02.98)";
    }
}

