/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.JConsole;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import jfig.gui.ConsoleMessage;
import jfig.gui.ImageHelper;
import jfig.utils.AntiDeadlock;
import jfig.utils.SetupManager;

public class Console
implements ActionListener,
ConsoleMessage {
    private static Console _console = null;
    public static final int MSG_UNKNOWN = 0;
    public static final int MSG_INFO = 1;
    public static final int MSG_WARNING = 2;
    public static final int MSG_ERROR = 3;
    public static final int MSG_FATAL = 4;
    public static final int POPUP_ALWAYS = -1;
    public static final int POPUP_INFO = 1;
    public static final int POPUP_WARNING = 2;
    public static final int POPUP_ERROR = 3;
    public static final int POPUP_FATAL = 4;
    public static final int POPUP_NEVER = 5;
    protected int messagePopupLevel = 3;
    private Frame frame;
    private TextArea ta;
    private Button okButton;
    private Button clearButton;
    private Checkbox logtofileCB;
    private TextField logfileNameTF;
    private Font consoleFont;
    private Font buttonFont;
    protected int n_lines;
    protected int max_lines;
    protected boolean logfileEnable;
    protected String logfileName;
    protected PrintWriter logStream;
    protected LogManager logManager;
    protected boolean useAWT;

    public static Console getConsole() {
        if (_console == null) {
            _console = SetupManager.getBoolean("Hades.UseSwingGUI", true) ? new JConsole() : new Console();
        }
        return _console;
    }

    public static Console createNewConsole() {
        if (SetupManager.getBoolean("Hades.UseSwingGUI", true)) {
            return new JConsole();
        }
        return new Console();
    }

    public Console() {
        this("HADES messages");
    }

    public Console(String title) {
        this.useAWT = SetupManager.getBoolean("Hades.Console.UseAWT", true);
        this.createGUI(title);
        AntiDeadlock.sleep(200L);
    }

    protected Console(String DONT, String CALL2, String ME) {
    }

    public void destroy() {
        _console = null;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void show() {
        if (this.getFrame() != null) {
            this.getFrame().setVisible(true);
        }
    }

    public void setVisible(boolean b) {
        if (this.getFrame() != null) {
            this.getFrame().setVisible(b);
        }
    }

    private void createGUI(String title) {
        this.frame = new Frame(title);
        this.frame.setLayout(new BorderLayout());
        this.frame.setBackground(Color.lightGray);
        this.ta = new TextArea(20, 60);
        this.ta.setBackground(Color.lightGray);
        this.frame.add("Center", this.ta);
        this.setDefaultLogFileNameAndEnable();
        this.getDefaultFonts();
        this.frame.setFont(this.buttonFont);
        this.ta.setFont(this.consoleFont);
        Panel p = new Panel();
        p.setLayout(new FlowLayout(1));
        this.okButton = new Button("Clear");
        p.add(this.okButton);
        this.clearButton = new Button("OK");
        p.add(this.clearButton);
        p.add(new Label(""));
        this.logtofileCB = new Checkbox("Log to file: ");
        p.add(this.logtofileCB);
        this.logfileNameTF = new TextField(this.logfileName, 15);
        p.add(this.logfileNameTF);
        this.frame.add("South", p);
        this.okButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.frame.addWindowListener(new WindowCloser());
        this.logManager = new LogManager();
        this.logtofileCB.setState(this.logfileEnable);
        this.logfileNameTF.addActionListener(this.logManager);
        this.logtofileCB.addItemListener(this.logManager);
        this.enableFileLoggingGUI(false);
        this.frame.pack();
        this.n_lines = 0;
        this.max_lines = SetupManager.getInteger("Hades.Console.SaveLines", 500);
        this.getIcon();
    }

    public void getIcon() {
        try {
            String filename = SetupManager.getProperty("Hades.Console.Icon", "/hades/gui/images/hades.gif");
            Image icon = ImageHelper.loadResourceImage(filename);
            this.frame.setIconImage(icon);
        }
        catch (Exception e) {
            System.err.println("-E- Console.getIcon(): got Exception " + e);
            System.err.println("... you won't see the HADES editor icon.");
        }
    }

    public void initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            int x = Integer.parseInt(st.nextToken());
            int y = Integer.parseInt(st.nextToken());
            int w = Integer.parseInt(st.nextToken());
            int h = Integer.parseInt(st.nextToken());
            this.frame.setLocation(x, y);
            this.frame.setSize(w, h);
        }
        catch (Exception e) {}
    }

    public void enableFileLoggingGUI(boolean b) {
        if (this.frame != null) {
            this.logfileNameTF.setVisible(b);
            this.logtofileCB.setVisible(b);
            this.frame.repaint();
        }
    }

    public void setMaxLines(int m) {
        this.max_lines = m;
    }

    public int getMaxLines() {
        return this.max_lines;
    }

    public String getLogFileName() {
        return this.logfileName;
    }

    public void setDefaultLogFileNameAndEnable() {
        this.logfileName = SetupManager.getProperty("Hades.Console.LogFileName", "/tmp/hades.log");
        this.logfileEnable = SetupManager.getBoolean("Hades.Console.LogEnable", false);
    }

    public void setLogFileName(String name) {
        this.logfileName = name;
        this.logfileNameTF.setText(name);
    }

    public void setLogFileEnable(boolean b) {
        this.logfileEnable = b;
    }

    private void getDefaultFonts() {
        String name = SetupManager.getProperty("Hades.Console.ConsoleFontName", "MonoSpaced");
        int size = SetupManager.getInteger("Hades.Console.ConsoleFontSize", 12);
        int style = 0;
        this.consoleFont = new Font(name, style, size);
        name = SetupManager.getProperty("Hades.Console.ButtonFontName", "SansSerif");
        size = SetupManager.getInteger("Hades.Console.ButtonFontSize", 12);
        style = 0;
        this.buttonFont = new Font(name, style, size);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Button) {
            String s = e.getActionCommand();
            if (s.equals("Clear")) {
                this.ta.setText("");
                this.n_lines = 0;
            } else if (s.equals("OK")) {
                this.frame.setVisible(false);
            }
        }
    }

    public void openLogStream() {
        if (this.logStream != null) {
            this.closeFlushLogStream();
        }
        this.logfileName = this.logfileNameTF.getText();
        try {
            this.logStream = new PrintWriter(new BufferedWriter(new FileWriter(this.logfileName)));
        }
        catch (Exception e) {
            System.err.println("-E- Console.LogManager.openLogStream: " + e);
            System.err.println("    logfile name is '" + this.logfileName + "'");
            e.printStackTrace(System.err);
        }
    }

    public void closeFlushLogStream() {
        if (this.logStream == null) {
            return;
        }
        try {
            this.logStream.flush();
            this.logStream.close();
        }
        catch (Exception e) {
            System.err.println("-E- Console.LogManager.closeFlushLogStream: " + e);
            e.printStackTrace(System.err);
        }
    }

    public void finalize() {
        this.closeFlushLogStream();
    }

    public synchronized void println(String s) {
        if (this.logStream != null) {
            this.logStream.println(s);
        }
        if (this.frame == null) {
            System.err.println(s);
        } else {
            this.addLine(s);
            this.checkShouldSetVisible(s);
            if (this.frame != null && this.frame.isShowing()) {
                this.frame.repaint(200L);
            }
        }
    }

    public void checkShouldSetVisible(String s) {
        int level;
        if (this.frame == null) {
            return;
        }
        if (this.messagePopupLevel == -1 && !this.frame.isShowing()) {
            this.frame.setVisible(true);
            this.frame.toFront();
        } else if (this.messagePopupLevel != 5 && (level = s.startsWith("-I-") ? 1 : (s.startsWith("-W-") ? 2 : (s.startsWith("-E-") ? 3 : (s.startsWith("-F-") ? 4 : 0)))) >= this.messagePopupLevel && !this.frame.isVisible()) {
            this.frame.setVisible(true);
            this.frame.toFront();
        }
    }

    public void setMessagePopupLevel(int i) {
        this.messagePopupLevel = i;
    }

    public synchronized void consoleMessage(String msg) {
        this.println(msg);
    }

    public void message(String s) {
        this.println(s);
    }

    public synchronized void setText(String s) {
        if (this.frame != null) {
            this.ta.setText(s);
            this.n_lines = this.countLines();
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
        }
    }

    private void addLine(String s) {
        ++this.n_lines;
        if (this.n_lines >= this.max_lines + this.max_lines) {
            this.cleanup();
        }
        if (this.frame != null) {
            this.ta.append(s + '\n');
        }
    }

    public void cleanup() {
        String s = this.ta.getText();
        int n = 0;
        int i = s.length() - 1;
        while (i >= 0) {
            if (s.charAt(i) == '\n') {
                ++n;
            }
            if (n >= this.max_lines) {
                this.ta.setText(s.substring(i + 1, s.length()));
                this.n_lines = n;
                return;
            }
            --i;
        }
        this.n_lines = n;
    }

    public int countLines() {
        String s = this.ta.getText();
        int n = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n') {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static void main(String[] argv) {
        Console con = new Console();
        con.enableFileLoggingGUI(true);
        con.getFrame().setVisible(true);
        con.getFrame().pack();
        con.println("Hades Console...");
        int i = 0;
        while (i < 500) {
            con.println("i " + i + "  i*i " + i * i);
            ++i;
        }
        System.out.println("Number of lines is " + con.countLines());
        System.out.println("Now limiting to 10 lines...");
        con.setMaxLines(10);
        con.println("Hades Console...");
        int i2 = 0;
        while (i2 < 500) {
            con.println("i " + i2 + "  i*i " + i2 * i2);
            ++i2;
        }
        System.out.println("Number of lines is " + con.countLines());
    }

    class LogManager
    implements ActionListener,
    ItemListener {
        LogManager() {
        }

        public void actionPerformed(ActionEvent evt) {
            String newname;
            if (!Console.this.logtofileCB.getState()) {
                return;
            }
            String oldname = Console.this.logfileName;
            Console.this.logfileName = newname = Console.this.logfileNameTF.getText();
            if (Console.this.logStream != null && !oldname.equals(newname)) {
                Console.this.closeFlushLogStream();
                Console.this.openLogStream();
            }
        }

        public void itemStateChanged(ItemEvent evt) {
            if (Console.this.logtofileCB.getState()) {
                Console.this.openLogStream();
            } else {
                Console.this.closeFlushLogStream();
            }
        }
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosed(WindowEvent evt) {
            Console.this.frame.setVisible(false);
        }

        public void windowClosing(WindowEvent evt) {
            Console.this.frame.setVisible(false);
        }
    }
}

