/*
 * Decompiled with CFR 0.152.
 */
package hades.gui;

import hades.gui.JConfirmDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import jfig.utils.SetupManager;

public class ConfirmDialog
extends Dialog {
    Panel buttonPanel;
    Button leftButton;
    Button middleButton;
    Button rightButton;
    String title;
    ActionListener AL;

    public static Dialog createDialog(Frame frame, String title, String msg, String left, String middle, String right, ActionListener listener) {
        if (SetupManager.getBoolean("Hades.UseSwingGUI", true)) {
            JConfirmDialog jdialog = new JConfirmDialog(frame, title, msg);
            jdialog.buildButtons(left, middle, right);
            jdialog.addActionListener(listener);
            return jdialog;
        }
        ConfirmDialog dialog = new ConfirmDialog(frame, title, msg);
        dialog.buildButtons(left, middle, right);
        dialog.setActionListener(listener);
        return dialog;
    }

    private ConfirmDialog(Frame frame, String title, String msg) {
        super(frame, title, true);
        this.title = title;
        this.setLayout(new BorderLayout());
        if (msg != null) {
            this.add("Center", new Label(msg));
        }
        this.AL = null;
    }

    public ConfirmDialog(Frame frame, String title, String msg, String leftLabel, String rightLabel) {
        this(frame, title, msg);
        this.buildButtons(leftLabel, null, rightLabel);
    }

    public ConfirmDialog(Frame frame, String title, String msg, String leftLabel, String middleLabel, String rightLabel) {
        this(frame, title, msg);
        this.buildButtons(leftLabel, middleLabel, rightLabel);
    }

    private void buildButtons(String leftLabel, String middleLabel, String rightLabel) {
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new FlowLayout());
        if (leftLabel != null) {
            this.leftButton = new Button(leftLabel);
            this.buttonPanel.add(this.leftButton);
        }
        if (middleLabel != null) {
            this.middleButton = new Button(middleLabel);
            this.buttonPanel.add(this.middleButton);
        }
        if (rightLabel != null) {
            this.rightButton = new Button(rightLabel);
            this.buttonPanel.add(this.rightButton);
        }
        this.add("South", this.buttonPanel);
    }

    public void setActionListener(ActionListener AL) {
        if (this.leftButton != null) {
            this.leftButton.addActionListener(AL);
        }
        if (this.middleButton != null) {
            this.middleButton.addActionListener(AL);
        }
        if (this.rightButton != null) {
            this.rightButton.addActionListener(AL);
        }
    }
}

